/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.gui.components.completion.AutoCompletion;
import chatty.gui.components.completion.AutoCompletionServer;
import chatty.gui.laf.LaF;
import chatty.util.colors.ColorCorrectionNew;
import java.awt.Color;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;

public class ChannelEditBox
extends JTextArea
implements KeyListener,
DocumentListener {
    private final List<String> history = new ArrayList<String>();
    private int historyPosition = 0;
    private boolean historyTextEdited = false;
    private boolean historyRequireCtrlMultirow = false;
    private boolean completionEnabled = true;
    private final Set<ActionListener> listeners = new HashSet<ActionListener>();
    private final AutoCompletion autoCompletion = new AutoCompletion(this);

    public ChannelEditBox() {
        this.autoCompletion.setFont(this.getFont());
        this.addKeyListener(this);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.getDocument().putProperty("filterNewlines", true);
        this.setFocusTraversalKeysEnabled(false);
        this.getDocument().addDocumentListener(this);
        this.addFocusListener(new FocusListener(){
            private boolean selection;

            @Override
            public void focusGained(FocusEvent e) {
                if (!this.selection) {
                    ChannelEditBox.this.setCaretPosition(ChannelEditBox.this.getCaretPosition());
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.selection = ChannelEditBox.this.getSelectedText() != null;
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (LaF.getInputBorder() != null) {
            this.setBorder(LaF.getInputBorder());
        } else {
            this.setBorder(UIManager.getBorder("TextField.border"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLocationOnScreen() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isShowing()) {
                return super.getLocationOnScreen();
            }
            return new Point(0, 0);
        }
    }

    public void setCompletionEnabled(boolean enabled) {
        this.completionEnabled = enabled;
        this.autoCompletion.setEnabled(enabled);
    }

    public void setCompletionMaxItemsShown(int max) {
        this.autoCompletion.setMaxResultsShown(max);
    }

    public void setCompletionShowPopup(boolean show) {
        this.autoCompletion.setShowPopup(show);
    }

    public void setCompleteToCommonPrefix(boolean value) {
        this.autoCompletion.setCompleteToCommonPrefix(value);
    }

    public boolean getCompleteToCommonPrefix() {
        return this.autoCompletion.getCompleteToCommonPrefix();
    }

    public void setCompletionCellSize(int width, int height) {
        this.autoCompletion.setCellSize(width, height);
    }

    public void setCompletionAppendSpace(boolean append) {
        this.autoCompletion.setAppendSpace(append);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.autoCompletion != null) {
            this.autoCompletion.setFont(font);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.autoCompletion != null) {
            this.autoCompletion.setForegroundColor(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.autoCompletion != null) {
            this.autoCompletion.setBackgroundColor(ColorCorrectionNew.offset(color, 0.9f));
            this.autoCompletion.setHighlightColor(ColorCorrectionNew.offset(color, 0.8f));
        }
    }

    public void setHistoryRequireCtrlMultirow(boolean require) {
        this.historyRequireCtrlMultirow = require;
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.add(actionListener);
        }
    }

    public void insertAtCaret(String text, boolean withSpace) {
        int pos = this.getCaretPosition();
        String current = this.getText();
        String before = current.substring(0, pos);
        String after = current.substring(pos);
        if (withSpace) {
            if (!before.isEmpty() && !before.endsWith(" ")) {
                text = " " + text;
            }
            if (!after.isEmpty() && !after.startsWith(" ")) {
                text = text + " ";
            }
        }
        this.setText(before + text + after);
        this.setCaretPosition(pos + text.length());
    }

    @Override
    public void setCaretPosition(int pos) {
        if (pos > this.getText().length()) {
            pos = this.getText().length();
        }
        super.setCaretPosition(pos);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.historyRequireCtrlMultirow || e.isControlDown() || this.isSingleRow()) {
            if (e.getKeyCode() == 38 && (e.isControlDown() || this.isCaretInFirstRow())) {
                this.historyBack();
                e.consume();
            } else if (e.getKeyCode() == 40 && (e.isControlDown() || this.isCaretInLastRow())) {
                this.historyForward();
                e.consume();
            }
        }
        if (e.getKeyCode() == 9) {
            if (!this.completionEnabled || this.getText().isEmpty()) {
                if (e.getModifiers() == 0) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                } else if (e.getModifiers() == 1) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                }
            }
            e.consume();
        }
        if (e.getKeyCode() == 10) {
            this.submit();
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 9 && this.completionEnabled) {
            if (e.isControlDown() || e.isAltDown() || e.isAltGraphDown()) {
                return;
            }
            if (e.isShiftDown()) {
                if (this.autoCompletion.inCompletion()) {
                    this.autoCompletion.manual(-1, null);
                } else {
                    this.autoCompletion.manual(1, "special");
                }
            } else {
                this.autoCompletion.manual(1, null);
            }
        } else if (e.getKeyCode() == 27) {
            this.autoCompletion.cancel();
        }
    }

    private boolean isCaretInFirstRow() {
        return this.getRow(this.getCaretPosition()) == 0;
    }

    private boolean isCaretInLastRow() {
        return this.getRow(this.getCaretPosition()) == this.getRow(this.getText().length());
    }

    private boolean isSingleRow() {
        return this.getRow(this.getText().length()) == 0;
    }

    private int getRow(int pos) {
        int row = pos == 0 ? 0 : -1;
        try {
            int offset = pos;
            while (offset > 0) {
                offset = Utilities.getRowStart(this, offset) - 1;
                ++row;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return row;
    }

    private void historyBack() {
        if (this.historyPosition > 0 && this.historyPosition <= this.history.size()) {
            --this.historyPosition;
            String text = this.history.get(this.historyPosition);
            if (text != null) {
                this.setText(text);
                this.historyTextEdited = false;
            }
        }
    }

    private void historyForward() {
        String text;
        this.historyAddChanged();
        ++this.historyPosition;
        if (this.historyPosition >= this.history.size()) {
            this.setText("");
            this.historyTextEdited = false;
            this.historyPosition = this.history.size();
        } else if (this.historyPosition >= 0 && (text = this.history.get(this.historyPosition)) != null) {
            this.setText(text);
            this.historyTextEdited = false;
        }
    }

    private void historyAddChanged() {
        if (this.historyTextEdited) {
            this.historyAdd(this.getText());
            this.historyTextEdited = false;
            this.historyPosition = this.history.size();
        }
    }

    private void historyAdd(String text) {
        if (!text.isEmpty()) {
            this.history.remove(text);
            this.history.add(text);
        }
    }

    private void submit() {
        for (ActionListener l : this.listeners) {
            l.actionPerformed(new ActionEvent(this, 1001, this.getText()));
        }
        this.historyAdd(this.getText());
        this.historyPosition = this.history.size();
        this.setText("");
        this.historyTextEdited = false;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.historyTextEdited = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.historyTextEdited = true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void setCompletionServer(AutoCompletionServer server) {
        this.autoCompletion.setCompletionServer(server);
    }

    public void cleanUp() {
        this.autoCompletion.cleanUp();
    }

    public static void main(String[] args) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("joshimuz");
        l.add("joshua");
        l.add("josh");
        l.add("jo");
    }
}

