/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.gui.DockedDialogHelper;
import chatty.gui.DockedDialogManager;
import chatty.gui.GuiUtil;
import chatty.gui.LinkListener;
import chatty.gui.UrlOpener;
import chatty.gui.components.ExtendedTextPane;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.ViewerHistory;
import chatty.gui.components.ViewerHistoryListener;
import chatty.gui.components.menus.ContextMenuAdapter;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.api.StreamInfo;
import chatty.util.api.StreamInfoHistoryItem;
import chatty.util.dnd.DockContent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;

public class ChannelInfoDialog
extends JDialog
implements ViewerHistoryListener {
    private static final String GAME_LABEL_TEXT = Language.getString("channelInfo.playing") + ":";
    private static final String GAME_LABEL_TEXT_VOD = "VOD / " + Language.getString("channelInfo.playing") + ":";
    private final JLabel statusLabel = new JLabel(){

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(1, super.getMinimumSize().height);
        }
    };
    private final ExtendedTextPane title = new ExtendedTextPane();
    private final JLabel onlineSince = new JLabel();
    private boolean historyItemSelected;
    private final JLabel gameLabel = new JLabel(GAME_LABEL_TEXT);
    private final JTextField game = new JTextField();
    private final LinkLabel testLabel = new LinkLabel(null, null);
    private final JLabel historyLabel = new JLabel(Language.getString("channelInfo.viewers") + ":");
    private final ViewerHistory history = new ViewerHistory();
    private StreamInfo currentStreamInfo;
    private String statusText = "";
    private String gameText = "";
    private final DockedDialogHelper helper;
    private long timeStarted = -1L;

    public ChannelInfoDialog(Frame owner, DockedDialogManager dockedDialogs) {
        super(owner);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = this.makeGbc(0, 0, 1, 1);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 0.5;
        mainPanel.add((Component)this.statusLabel, gbc);
        gbc = this.makeGbc(1, 0, 1, 1);
        gbc.anchor = 13;
        mainPanel.add((Component)this.onlineSince, gbc);
        this.title.setEditable(false);
        this.title.setLinkListener(new MyLinkListener());
        JScrollPane scroll = new JScrollPane(this.title);
        scroll.setPreferredSize(new Dimension(300, 70));
        scroll.setMinimumSize(new Dimension(1, 45));
        gbc = this.makeGbc(0, 1, 2, 1);
        gbc.weighty = 0.0;
        gbc.fill = 2;
        mainPanel.add((Component)scroll, gbc);
        gbc = this.makeGbc(0, 2, 1, 1);
        gbc.anchor = 17;
        mainPanel.add((Component)this.gameLabel, gbc);
        this.game.setEditable(false);
        gbc = this.makeGbc(0, 3, 2, 1);
        gbc.fill = 2;
        mainPanel.add((Component)this.game, gbc);
        gbc = this.makeGbc(0, 2, 2, 1);
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.weightx = 0.9;
        gbc = this.makeGbc(0, 4, 1, 1);
        gbc.insets = new Insets(3, 5, 3, 3);
        gbc.anchor = 17;
        mainPanel.add((Component)this.historyLabel, gbc);
        this.history.setListener(this);
        this.history.setForegroundColor(this.game.getForeground());
        this.history.setBaseFont(this.game.getFont());
        this.history.setPreferredSize(new Dimension(300, 150));
        this.history.setMinimumSize(new Dimension(1, 20));
        gbc = this.makeGbc(0, 5, 2, 1);
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        mainPanel.add((Component)this.history, gbc);
        this.add(mainPanel);
        if (dockedDialogs != null) {
            final DockContent content = dockedDialogs.createContent(mainPanel, "Channel Info", "-channelInfo-");
            this.helper = dockedDialogs.createHelper(new DockedDialogHelper.DockedDialog(){

                @Override
                public void setVisible(boolean visible) {
                    ChannelInfoDialog.super.setVisible(visible);
                }

                @Override
                public boolean isVisible() {
                    return ChannelInfoDialog.super.isVisible();
                }

                @Override
                public void addComponent(Component comp) {
                    ChannelInfoDialog.this.add(comp);
                }

                @Override
                public void removeComponent(Component comp) {
                    ChannelInfoDialog.this.remove(comp);
                }

                @Override
                public Window getWindow() {
                    return ChannelInfoDialog.this;
                }

                @Override
                public DockContent getContent() {
                    return content;
                }

                @Override
                public void dockedChanged() {
                    ChannelInfoDialog.this.updateDocked();
                }
            });
            this.helper.installContextMenu(mainPanel);
        } else {
            this.helper = null;
        }
        Timer timer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelInfoDialog.this.updateOnlineTime(ChannelInfoDialog.this.currentStreamInfo);
            }
        });
        timer.setRepeats(true);
        timer.start();
        this.pack();
        this.setMinimumSize(new Dimension(200, 0));
        GuiUtil.installEscapeCloseOperation(this);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.helper != null) {
            this.helper.setVisible(visible, true);
        } else {
            super.setVisible(visible);
        }
    }

    @Override
    public boolean isVisible() {
        if (this.helper != null) {
            return this.helper.isVisible();
        }
        return super.isVisible();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.helper != null) {
            // empty if block
        }
    }

    public void set(StreamInfo streamInfo) {
        String name = streamInfo.getDisplayName();
        if (!streamInfo.hasRegularDisplayName()) {
            name = name + " (" + streamInfo.getCapitalizedName() + ")";
        }
        this.setTitle(Language.getString("channelInfo.title", name) + (streamInfo.getFollowed() ? " (" + Language.getString("channelInfo.title.followed") + ")" : ""));
        if (streamInfo.isValid() && streamInfo.getOnline()) {
            this.statusText = streamInfo.getTitle();
            this.gameText = streamInfo.getGame();
            if (this.gameText.isEmpty()) {
                this.gameText = "No game";
            }
            this.timeStarted = streamInfo.getTimeStarted();
            this.onlineSince.setText(null);
            this.updateStreamType(streamInfo.getStreamType());
        } else if (streamInfo.isValid()) {
            this.statusText = Language.getString("channelInfo.streamOffline");
            this.gameText = "";
            this.timeStarted = -1L;
        } else {
            this.statusText = Language.getString("channelInfo.noInfo");
            this.gameText = "";
            this.timeStarted = -1L;
            this.onlineSince.setText(null);
            this.onlineSince.setToolTipText(null);
        }
        this.title.setText(this.statusText);
        this.game.setText(this.gameText);
        this.updateCommunities();
        this.history.setHistory(streamInfo.getStream(), streamInfo.getHistory());
        this.currentStreamInfo = streamInfo;
        this.updateOnlineTime(streamInfo);
        this.updateStatusLabel();
    }

    public void update(StreamInfo streamInfo) {
        if (streamInfo == this.currentStreamInfo) {
            this.set(streamInfo);
        }
    }

    private void updateCommunities() {
    }

    private void updateStreamType(StreamInfo.StreamType streamType) {
        if (streamType != StreamInfo.StreamType.LIVE) {
            this.gameLabel.setText(GAME_LABEL_TEXT_VOD);
        } else {
            this.gameLabel.setText(GAME_LABEL_TEXT);
        }
    }

    private void updateOnlineTime(StreamInfo info) {
        if (this.historyItemSelected) {
            return;
        }
        if (info == null) {
            this.onlineSince.setText(null);
        } else if (info.isValid() && info.getOnline()) {
            this.updateOnlineTime(info.getTimeStarted(), info.getTimeStartedWithPicnic(), System.currentTimeMillis());
        } else if (info.isValid()) {
            this.onlineSince.setText(Language.getString("channelInfo.offline"));
            if (info.getLastOnlineTime() != -1L) {
                String lastBroadcastTime = ChannelInfoDialog.formatTime(info.getTimeStarted(), info.getLastOnlineTime());
                if (info.getTimeStarted() != info.getTimeStartedWithPicnic()) {
                    String withPicnic = ChannelInfoDialog.formatTime(info.getTimeStartedWithPicnic(), info.getLastOnlineTime());
                    this.onlineSince.setToolTipText(Language.getString("channelInfo.offline.tip.picnic", lastBroadcastTime, withPicnic));
                } else {
                    this.onlineSince.setToolTipText(Language.getString("channelInfo.offline.tip", lastBroadcastTime));
                }
            } else {
                this.onlineSince.setToolTipText(null);
            }
        } else {
            this.onlineSince.setText(null);
        }
    }

    private void updateOnlineTime(StreamInfoHistoryItem item) {
        this.updateOnlineTime(item.getStreamStartTime(), item.getStreamStartTimeWithPicnic(), item.getTime());
    }

    private void updateOnlineTime(long started, long withPicnic, long current) {
        if (started != -1L) {
            if (withPicnic != started) {
                this.onlineSince.setText(Language.getString("channelInfo.uptime.picnic", ChannelInfoDialog.formatTime(started, current), ChannelInfoDialog.formatTime(withPicnic, current)));
                this.onlineSince.setToolTipText(Language.getString("channelInfo.uptime.tip.picnic", DateTime.formatFullDatetime(started), DateTime.formatFullDatetime(withPicnic)));
            } else {
                this.onlineSince.setText(Language.getString("channelInfo.uptime", ChannelInfoDialog.formatTime(started, current)));
                this.onlineSince.setToolTipText(Language.getString("channelInfo.uptime.tip", DateTime.formatFullDatetime(this.timeStarted)));
            }
        }
    }

    private void updateStatusLabel() {
        if (this.helper != null && this.helper.isDocked() && this.currentStreamInfo != null) {
            if (this.historyItemSelected) {
                this.statusLabel.setText(String.format("%s (%s):", Language.getString("channelInfo.history"), this.currentStreamInfo.stream));
            } else {
                this.statusLabel.setText(String.format("%s (%s):", Language.getString("channelInfo.status"), this.currentStreamInfo.stream));
            }
        } else if (this.historyItemSelected) {
            this.statusLabel.setText(String.format("%s:", Language.getString("channelInfo.history")));
        } else {
            this.statusLabel.setText(String.format("%s:", Language.getString("channelInfo.status")));
        }
    }

    private static String formatTime(long time, long time2) {
        return ChannelInfoDialog.formatDuration(time2 - time);
    }

    private static String formatDuration(long time) {
        return DateTime.duration(time, 3, 2, 1, new DateTime.Formatting[0]);
    }

    private GridBagConstraints makeGbc(int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(3, 3, 3, 3);
        return gbc;
    }

    @Override
    public void itemSelected(StreamInfoHistoryItem item) {
        this.historyItemSelected = true;
        this.title.setText(item.getTitle());
        this.game.setText(item.getGame());
        this.updateStatusLabel();
        this.updateStreamType(item.getStreamType());
        this.updateOnlineTime(item);
        this.updateCommunities();
    }

    @Override
    public void noItemSelected() {
        this.historyItemSelected = false;
        this.title.setText(this.statusText);
        this.game.setText(this.gameText);
        this.updateStatusLabel();
        this.updateStreamType(this.currentStreamInfo.getStreamType());
        this.updateOnlineTime(this.currentStreamInfo);
        this.updateCommunities();
    }

    public void setHistoryRange(int minutes) {
        this.history.setRange(minutes);
    }

    public void setHistoryVerticalZoom(boolean verticalZoom) {
        this.history.setVerticalZoom(verticalZoom);
    }

    public void updateDocked() {
        this.history.setDocked(this.helper.isDocked());
        this.updateStatusLabel();
    }

    public void addContextMenuListener(ContextMenuListener listener) {
        this.history.addContextMenuListener(new ContextMenuAdapter(listener){

            @Override
            public void menuItemClicked(ActionEvent e) {
                super.menuItemClicked(e);
                ChannelInfoDialog.this.helper.menuAction(e);
            }
        });
        this.title.setContextMenuListener(listener);
    }

    private class MyLinkListener
    implements LinkListener {
        private MyLinkListener() {
        }

        @Override
        public void linkClicked(String url) {
            UrlOpener.openUrlPrompt(ChannelInfoDialog.this, url);
        }
    }
}

