/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.lang.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ConnectionDialog
extends JDialog {
    private static final Insets SMALL_BUTTON_INSETS = new Insets(-1, 10, -1, 10);
    private final JLabel passwordLabel = new JLabel("Access token:");
    private final JTextField name = new JTextField("");
    private final JTextField password = new JPasswordField(14);
    private final JButton connect = new JButton(Language.getString("connect.button.connect"));
    private final JButton cancel = new JButton(Language.getString("dialog.button.cancel"));
    private final JButton favorites = new JButton(Language.getString("connect.button.favoritesHistory"));
    private final JTextField channel = new JTextField(16);
    private final JButton getToken = new JButton(Language.getString("connect.button.configureLogin"));
    private final JCheckBox rejoinOpenChannels = new JCheckBox(Language.getString("connect.button.rejoin"));
    private final GridBagConstraints passwordGc = this.makeGbc(1, 1, 2, 1, 17);
    private final GridBagConstraints passwordLabelGc = this.makeGbc(0, 1, 1, 1, 17);
    private String currentUsername = "";

    public ConnectionDialog(MainGui owner) {
        super(owner, Language.getString("connect.title"), true);
        this.setResizable(false);
        this.setLayout(new GridBagLayout());
        this.password.setEditable(false);
        this.connect.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "connect");
        this.connect.getActionMap().put("connect", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.connect.doClick();
            }
        });
        JLabel nameLabel = new JLabel(Language.getString("connect.account"));
        nameLabel.setLabelFor(this.name);
        this.add((Component)nameLabel, this.makeGbc(0, 0, 1, 1, 13));
        this.name.setEditable(false);
        GridBagConstraints gbc = this.makeGbc(1, 0, 2, 1, 17);
        gbc.fill = 2;
        this.add((Component)this.name, gbc);
        this.getToken.setMnemonic(76);
        gbc = this.makeGbc(1, 2, 2, 1, 17);
        gbc.insets = new Insets(0, 5, 2, 20);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getToken.setMargin(SMALL_BUTTON_INSETS);
        this.add((Component)this.getToken, gbc);
        this.rejoinOpenChannels.setMargin(SMALL_BUTTON_INSETS);
        gbc = this.makeGbc(1, 3, 2, 1, 17);
        gbc.insets = new Insets(5, -7, 0, 5);
        this.add((Component)this.rejoinOpenChannels, gbc);
        this.rejoinOpenChannels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.updateChannels();
            }
        });
        JLabel channelLabel = new JLabel(Language.getString("connect.channel"));
        channelLabel.setLabelFor(this.channel);
        this.add((Component)channelLabel, this.makeGbc(0, 4, 1, 1, 13));
        GuiUtil.installLengthLimitDocumentFilter(this.channel, 8000, false, new Object[0]);
        gbc = this.makeGbc(1, 4, 2, 1, 17);
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 8);
        this.channel.setToolTipText(Language.getString("connect.channel.tip"));
        this.add((Component)this.channel, gbc);
        this.favorites.setMnemonic(70);
        gbc = this.makeGbc(1, 5, 2, 1, 17);
        gbc.insets = new Insets(0, 5, 10, 8);
        gbc.fill = 2;
        this.favorites.setMargin(SMALL_BUTTON_INSETS);
        this.add((Component)this.favorites, gbc);
        this.connect.setMnemonic(69);
        gbc = this.makeGbc(1, 6, 1, 1, 13);
        gbc.fill = 2;
        gbc.weightx = 0.6;
        this.add((Component)this.connect, gbc);
        gbc = this.makeGbc(2, 6, 1, 1, 17);
        gbc.fill = 2;
        this.cancel.setMnemonic(67);
        this.add((Component)this.cancel, gbc);
        ActionListener actionListener = owner.getActionListener();
        this.connect.addActionListener(actionListener);
        this.cancel.addActionListener(actionListener);
        this.getToken.addActionListener(actionListener);
        this.channel.addActionListener(actionListener);
        this.favorites.addActionListener(actionListener);
        this.pack();
    }

    public JTextField getChannelInput() {
        return this.channel;
    }

    public JButton getConnectButton() {
        return this.connect;
    }

    public JButton getCancelButton() {
        return this.cancel;
    }

    public JButton getGetTokenButton() {
        return this.getToken;
    }

    public JButton getFavoritesButton() {
        return this.favorites;
    }

    public String getUsername() {
        return this.name.getText();
    }

    public String getChannel() {
        return this.channel.getText();
    }

    public String getPassword() {
        return this.password.getText();
    }

    public void setUsername(String username) {
        this.name.setText(username);
        this.currentUsername = username;
    }

    public void setChannel(String channel) {
        this.channel.setText(channel);
    }

    public boolean rejoinOpenChannels() {
        return this.rejoinOpenChannels.isEnabled() && this.rejoinOpenChannels.isSelected();
    }

    public void setAreChannelsOpen(boolean areChannelsOpen) {
        this.rejoinOpenChannels.setEnabled(areChannelsOpen);
        this.updateChannels();
    }

    public void update(String currentPassword, String currentToken, boolean usePasswordInstead) {
        if (usePasswordInstead) {
            this.password.setEditable(true);
            this.passwordLabel.setText("Password:");
            this.password.setText(currentPassword);
            this.add((Component)this.password, this.passwordGc);
            this.add((Component)this.passwordLabel, this.passwordLabelGc);
        } else {
            this.remove(this.password);
            this.remove(this.passwordLabel);
            if (this.currentUsername.isEmpty() || currentToken.isEmpty()) {
                this.name.setText("");
                this.name.setToolTipText(Language.getString("connect.accountEmpty.tip"));
            } else {
                this.name.setText(this.currentUsername);
                this.name.setToolTipText(Language.getString("connect.account.tip"));
            }
        }
        this.pack();
    }

    private void updateChannels() {
        this.channel.setEnabled(!this.rejoinOpenChannels.isEnabled() || !this.rejoinOpenChannels.isSelected());
    }

    private GridBagConstraints makeGbc(int x, int y, int w, int h, int anchor) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = w;
        constraints.gridheight = h;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.anchor = anchor;
        return constraints;
    }
}

