/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.gui.components.textpane.ChannelTextPane;
import chatty.util.DateTime;
import chatty.util.Debugging;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class DebugWindow
extends JFrame {
    private static final int MAX_NUMBER_LINES = 250;
    private final JCheckBox autoscroll = new JCheckBox("Autoscroll", true);
    private final JCheckBox logIrc = new JCheckBox("Irc log", false);
    private final JTextArea text;
    private final JTextArea textIrcLog;
    private final JTextArea textFFZLog;
    private final JTextArea textPubSubLog;
    private final JTextArea textEventSubLog;
    private final JTextArea otherLog;
    private final JTextArea timerLog;

    public DebugWindow(ItemListener listener) {
        this.setTitle("Debug");
        this.text = DebugWindow.createLogArea();
        this.textIrcLog = DebugWindow.createLogArea();
        this.textFFZLog = DebugWindow.createLogArea();
        this.textPubSubLog = DebugWindow.createLogArea();
        this.textEventSubLog = DebugWindow.createLogArea();
        this.otherLog = DebugWindow.createLogArea();
        Debugging.registerForOutput(line -> SwingUtilities.invokeLater(() -> this.printLine(this.otherLog, line)));
        this.timerLog = DebugWindow.createLogArea();
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Log", new JScrollPane(this.text));
        tabs.addTab("Irc log", new JScrollPane(this.textIrcLog));
        tabs.addTab("FFZ-WS", new JScrollPane(this.textFFZLog));
        tabs.addTab("PubSub", new JScrollPane(this.textPubSubLog));
        tabs.addTab("EventSub", new JScrollPane(this.textEventSubLog));
        tabs.addTab("Other", new JScrollPane(this.otherLog));
        tabs.addTab("Timers", new JScrollPane(this.timerLog));
        this.logIrc.setToolTipText("Logging IRC traffic can reduce performance");
        JPanel settingsPanel = new JPanel();
        settingsPanel.add(this.autoscroll);
        settingsPanel.add(this.logIrc);
        this.add((Component)tabs, "Center");
        this.add((Component)settingsPanel, "South");
        this.pack();
        this.logIrc.addItemListener(listener);
        this.setDefaultCloseOperation(1);
        this.setSize(new Dimension(600, 500));
    }

    private static JTextArea createLogArea() {
        DefaultCaret caret = new DefaultCaret();
        caret.setUpdatePolicy(1);
        JTextArea text = new JTextArea();
        text.setEditable(false);
        text.setFont(Font.decode("Monospaced"));
        text.setCaret(caret);
        return text;
    }

    public void printLine(String line) {
        this.printLine(this.text, line);
    }

    public void printLineIrc(String line) {
        this.printLine(this.textIrcLog, line);
    }

    public void printLineFFZ(String line) {
        this.printLine(this.textFFZLog, line);
    }

    public void printLinePubSub(String line) {
        this.printLine(this.textPubSubLog, line);
    }

    public void printLineEventSub(String line) {
        this.printLine(this.textEventSubLog, line);
    }

    public void printTimerLog(String line) {
        this.printLine(this.timerLog, line);
    }

    private void printLine(JTextArea text, String line) {
        try {
            Document doc = text.getDocument();
            doc.insertString(doc.getLength(), "[" + DateTime.currentTimeExact() + "] " + line + "\n", null);
            if (this.autoscroll.isSelected()) {
                text.setCaretPosition(doc.getLength());
            }
            this.clearSomeChat(doc);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void clearSomeChat(Document doc) {
        int count = doc.getDefaultRootElement().getElementCount();
        if (count > 250) {
            this.removeFirstLines(doc, 10);
        }
    }

    public void removeFirstLines(Document doc, int amount) {
        if (amount < 1) {
            amount = 1;
        }
        Element firstToRemove = doc.getDefaultRootElement().getElement(0);
        Element lastToRemove = doc.getDefaultRootElement().getElement(amount - 1);
        int startOffset = firstToRemove.getStartOffset();
        int endOffset = lastToRemove.getEndOffset();
        try {
            doc.remove(startOffset, endOffset);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(ChannelTextPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public JCheckBox getLogIrcCheckBox() {
        return this.logIrc;
    }
}

