/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.Helper;
import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.JListActionHelper;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.WrapLayout;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.EmoteContextMenu;
import chatty.lang.Language;
import chatty.util.Debugging;
import chatty.util.MiscUtil;
import chatty.util.StringUtil;
import chatty.util.TwitchEmotesApi;
import chatty.util.api.CachedImage;
import chatty.util.api.CheerEmoticon;
import chatty.util.api.Emoticon;
import chatty.util.api.EmoticonFavorites;
import chatty.util.api.Emoticons;
import chatty.util.colors.ColorCorrection;
import chatty.util.colors.ColorCorrectionNew;
import chatty.util.colors.HtmlColors;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

public class EmotesDialog
extends JDialog {
    public final int UPDATE_EMOTESET_CHANGED = 1;
    public final int UPDATE_CHANNEL_CHANGED = 2;
    public final int UPDATE_FAVORITES = 4;
    private static final Insets TITLE_INSETS = new Insets(5, 8, 0, 8);
    private static final Insets SUBTITLE_INSETS = new Insets(6, 4, 2, 4);
    private static final Insets SUBTITLE_INSETS_SMALLER_MARGIN = new Insets(1, 2, 0, 2);
    private static final Insets EMOTE_INSETS = new Insets(4, 10, 4, 10);
    private static final String FAVORITE_EMOTES = Language.getString("emotesDialog.tab.favorites");
    private static final String MY_EMOTES = Language.getString("emotesDialog.tab.myEmotes");
    private static final String CHANNEL_EMOTES = Language.getString("emotesDialog.tab.channel");
    private static final String TWITCH_EMOTES = Language.getString("emotesDialog.tab.twitch");
    private static final String OTHER_EMOTES = Language.getString("emotesDialog.tab.other");
    private static final String EMOJI = "Emoji";
    private static final String EMOTE_DETAILS = "Emote Details";
    private static final String BITS = "B";
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel emotesPanel;
    private final List<EmotesPanel> panels = new ArrayList<EmotesPanel>();
    private final Map<JToggleButton, EmotesPanel> buttons = new HashMap<JToggleButton, EmotesPanel>();
    private final ButtonGroup buttonGroup;
    private final EmotesPanel defaultPanel;
    private final Color emotesBackground;
    private final Color emotesForeground;
    private final JButton refreshButton = new JButton(new ImageIcon(EmotesDialog.class.getResource("view-refresh.png")));
    private final JPanel topPanel;
    private final GridBagConstraints gbc;
    private final Emoticons emoteManager;
    private final CachedImage.CachedImageUser emoteUser;
    private final GuiUtil.SimpleMouseListener mouseListener;
    private final ContextMenuListener contextMenuListener;
    private final MainGui main;
    private EmotesPanel currentPanel;
    private Set<String> localUserEmotesets = new HashSet<String>();
    private String currentStream;
    private String tempStream;
    private Emoticon detailsEmote;
    private float scale;
    private CachedImage.ImageType imageType = CachedImage.ImageType.ANIMATED_DARK;
    private boolean closeOnDoubleClick = true;
    private final Set<String> hiddenEmotesets = new HashSet<String>();
    private String search;
    private JPanel searchPanel;
    private final JToggleButton searchButton;
    private static final String SPECIAL_SET_LOCAL = "$ChattyLocalEmotes";
    private static final String SPECIAL_SET_OTHER = "$ChattyOtherEmotes";
    private static final Comparator<String> SORT_EMOTESETS = new SortEmotesets();
    private static final Pattern PREFIX_PATTERN = Pattern.compile("^([A-Za-z][a-z0-9]+)");

    public EmotesDialog(Window owner, Emoticons emotes, final MainGui main, ContextMenuListener contextMenuListener) {
        super(owner);
        this.main = main;
        this.emoteUser = new CachedImage.CachedImageUser(){

            @Override
            public void iconLoaded(Image oldImage, Image newImage, boolean sizeChanged) {
                EmotesDialog.this.repaint();
            }
        };
        this.contextMenuListener = contextMenuListener;
        this.emoteManager = emotes;
        Color bg = HtmlColors.decode(main.getSettings().getString("backgroundColor"));
        this.emotesBackground = ColorCorrection.isLightColor(bg) ? ColorCorrectionNew.makeDarker(bg, 0.982f) : ColorCorrectionNew.makeDarker(bg, 0.96f);
        this.emotesForeground = HtmlColors.decode(main.getSettings().getString("foregroundColor"));
        this.setResizable(true);
        this.panels.add(new FavoritesPanel(FAVORITE_EMOTES, 7));
        this.panels.add(new SubemotesPanel(MY_EMOTES, 1));
        this.panels.add(new ChannelEmotesPanel(CHANNEL_EMOTES, 3));
        this.panels.add(new TwitchEmotesPanel(TWITCH_EMOTES, 0));
        this.panels.add(new OtherEmotesPanel(OTHER_EMOTES, 0));
        this.defaultPanel = this.panels.get(1);
        ActionListener buttonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmotesPanel emotesPanel = (EmotesPanel)EmotesDialog.this.buttons.get(e.getSource());
                if (emotesPanel != null) {
                    EmotesDialog.this.showPanel(emotesPanel);
                }
            }
        };
        this.buttonGroup = new ButtonGroup();
        this.topPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        for (EmotesPanel p : this.panels) {
            JToggleButton button = new JToggleButton(p.label);
            this.buttons.put(button, p);
            this.buttonGroup.add(button);
            GuiUtil.smallButtonInsets(button);
            buttonPanel.add(button);
            button.addActionListener(buttonAction);
        }
        int buttonHeight = this.buttons.keySet().iterator().next().getPreferredSize().height;
        JSeparator sep = new JSeparator(1);
        sep.setPreferredSize(new Dimension(2, (int)((double)buttonHeight * 0.9)));
        this.refreshButton.setMargin(GuiUtil.SMALLER_BUTTON_INSETS);
        this.refreshButton.setPreferredSize(new Dimension(buttonHeight, buttonHeight));
        this.searchButton = new JToggleButton(new ImageIcon(EmotesDialog.class.getResource("search.png")));
        this.searchButton.setMargin(GuiUtil.SMALLER_BUTTON_INSETS);
        this.searchButton.setPreferredSize(new Dimension(buttonHeight, buttonHeight));
        this.searchButton.addActionListener(e -> this.toggleSearch());
        buttonPanel.add(sep);
        buttonPanel.add(this.refreshButton);
        buttonPanel.add(this.searchButton);
        this.topPanel.add((Component)buttonPanel, "North");
        this.add((Component)this.topPanel, "North");
        this.panels.add(new EmoteDetailPanel(EMOTE_DETAILS, 0));
        this.mouseListener = new GuiUtil.SimpleMouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.getClickCount() == 2 && EmotesDialog.this.closeOnDoubleClick && !e.isShiftDown()) {
                        EmotesDialog.this.setVisible(false);
                    } else {
                        EmoteLabel label = (EmoteLabel)e.getSource();
                        if (!label.noInsert) {
                            main.insert(Emoticons.toWriteable(label.code), true, true);
                        }
                    }
                }
            }

            @Override
            public void contextMenu(MouseEvent e) {
                EmotesDialog.this.openContextMenu(e);
            }
        };
        this.refreshButton.addActionListener(e -> {
            if (this.currentPanel != null) {
                if (this.currentPanel.label.equals(MY_EMOTES)) {
                    main.refreshEmotes("user", null);
                } else if (this.currentPanel.label.equals(CHANNEL_EMOTES)) {
                    String stream = this.tempStream != null ? this.tempStream : this.currentStream;
                    main.refreshEmotes("channel", stream);
                } else if (this.currentPanel.label.equals(TWITCH_EMOTES)) {
                    main.refreshEmotes("globaltwitch", null);
                } else if (this.currentPanel.label.equals(OTHER_EMOTES)) {
                    main.refreshEmotes("globalother", null);
                }
                this.refreshButton.setEnabled(false);
                Timer timer = new Timer(1000, evt -> this.refreshButton.setEnabled(true));
                timer.setRepeats(false);
                timer.start();
            }
        });
        this.emotesPanel = new JPanel();
        this.emotesPanel.setLayout(this.cardLayout);
        for (EmotesPanel panel : this.panels) {
            this.emotesPanel.add((Component)this.wrapPanel(panel), panel.label);
        }
        this.add((Component)this.emotesPanel, "Center");
        this.gbc = new GridBagConstraints();
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setSize(320, 300);
    }

    public void setCloseOnDoubleClick(boolean enabled) {
        this.closeOnDoubleClick = enabled;
    }

    private JComponent wrapPanel(JComponent panel) {
        panel.setBackground(this.emotesBackground);
        JPanel outer = new JPanel();
        outer.setLayout(new GridBagLayout());
        outer.setBackground(this.emotesBackground);
        GridBagConstraints gbcTest = new GridBagConstraints();
        gbcTest.fill = 2;
        gbcTest.weightx = 1.0;
        gbcTest.weighty = 1.0;
        gbcTest.anchor = 11;
        outer.add((Component)panel, gbcTest);
        JScrollPane scroll = new JScrollPane(outer);
        scroll.getVerticalScrollBar().setUnitIncrement(20);
        return scroll;
    }

    private void openContextMenu(MouseEvent e) {
        CachedImage<Emoticon> emote = ((EmoteLabel)e.getSource()).emote;
        EmoteContextMenu m = new EmoteContextMenu(emote, this.contextMenuListener);
        m.show(e.getComponent(), e.getX(), e.getY());
    }

    private void toggleSearch() {
        if (this.search != null) {
            this.closeSearch();
            return;
        }
        this.search = "";
        this.searchPanel = new JPanel();
        JLabel label = new JLabel("Search:");
        JTextField searchField = new JTextField(10);
        label.setLabelFor(searchField);
        JButton closeButton = new JButton(Language.getString("dialog.button.close"));
        GuiUtil.smallButtonInsets(closeButton);
        GuiUtil.addChangeListener(searchField.getDocument(), e -> {
            this.search = StringUtil.toLowerCase(searchField.getText());
            this.update();
        });
        closeButton.addActionListener(e -> this.closeSearch());
        this.searchPanel.add(label);
        this.searchPanel.add(searchField);
        this.searchPanel.add(closeButton);
        this.topPanel.add((Component)this.searchPanel, "Center");
        this.revalidate();
        searchField.requestFocusInWindow();
    }

    private void closeSearch() {
        this.search = null;
        this.topPanel.remove(this.searchPanel);
        this.searchButton.setSelected(false);
        this.revalidate();
        this.update();
    }

    public void showDialog(Set<String> localUserEmotesets, String stream) {
        if (stream != null && !stream.equals(this.currentStream)) {
            this.setUpdated(2);
        }
        if (stream != null) {
            this.currentStream = stream;
        }
        if (localUserEmotesets != null && !localUserEmotesets.equals(this.localUserEmotesets)) {
            this.setUpdated(1);
        }
        this.localUserEmotesets = new HashSet<String>(localUserEmotesets);
        this.updateTitle();
        this.showEmotes();
        this.setVisible(true);
    }

    public void setTempStream(String tempStream) {
        if (tempStream != null && !tempStream.equals(this.currentStream)) {
            this.setUpdated(2);
            this.tempStream = tempStream;
        }
    }

    public void showChannelEmotes() {
        this.showPanelByName(CHANNEL_EMOTES);
    }

    public void showEmoteDetails(Emoticon emote) {
        this.detailsEmote = emote;
        this.getPanelByName(EMOTE_DETAILS).updateEmotes();
        this.showPanelByName(EMOTE_DETAILS);
        this.buttonGroup.clearSelection();
    }

    public void update() {
        this.setEmotesUpdated();
        if (this.isVisible()) {
            this.showEmotes();
        }
    }

    public void updateStream(String stream, Set<String> emotesets) {
        if (!this.isVisible()) {
            return;
        }
        if (stream != null && stream.equals(this.currentStream)) {
            return;
        }
        this.currentStream = stream;
        this.updateTitle();
        this.setUpdated(2);
        this.showEmotes();
        this.updateEmotesets(stream, emotesets);
    }

    private void setEmotesUpdated() {
        for (EmotesPanel p : this.panels) {
            p.setUpdated();
        }
    }

    private void setUpdated(int what) {
        for (EmotesPanel p : this.panels) {
            p.setUpdated(what);
        }
    }

    public void updateEmotesets(String stream, Set<String> emotesets) {
        if (!this.isVisible() || emotesets == null || emotesets.equals(this.localUserEmotesets) || this.currentStream == null || !this.currentStream.equals(stream)) {
            return;
        }
        this.localUserEmotesets = new HashSet<String>(emotesets);
        this.setUpdated(1);
        this.showEmotes();
    }

    public void updateEmotesetInfo() {
        this.setUpdated(1);
        if (this.isVisible()) {
            this.showEmotes();
        }
    }

    public void favoritesUpdated() {
        this.setUpdated(4);
        if (this.isVisible()) {
            this.showEmotes();
        }
    }

    public void setEmoteScale(int percentage) {
        float newScale = (float)((double)percentage / 100.0);
        if (newScale != this.scale) {
            this.scale = newScale;
            this.update();
        }
    }

    public void setEmoteImageType(CachedImage.ImageType imageType) {
        if (this.imageType != imageType) {
            this.imageType = imageType;
            this.update();
        }
    }

    public void setHiddenEmotesets(Collection<String> sets) {
        this.hiddenEmotesets.clear();
        this.hiddenEmotesets.addAll(sets);
    }

    public Collection<String> getHiddenEmotesets() {
        return this.hiddenEmotesets;
    }

    private void updateTitle() {
        this.setTitle(Language.getString("emotesDialog.title", this.currentStream == null ? "-" : "#" + this.currentStream));
    }

    private void showPanel(EmotesPanel panel) {
        this.currentPanel = panel;
        panel.update();
        this.cardLayout.show(this.emotesPanel, panel.label);
        for (JToggleButton button : this.buttons.keySet()) {
            if (this.buttons.get(button) != panel) continue;
            button.setSelected(true);
        }
        if (!panel.label.equals(EMOTE_DETAILS)) {
            this.detailsEmote = null;
        }
        this.updateRefreshButton();
    }

    private void updateRefreshButton() {
        if (this.currentPanel == null) {
            return;
        }
        boolean enabled = this.currentPanel.label.equals(MY_EMOTES) || this.currentPanel.label.equals(CHANNEL_EMOTES) || this.currentPanel.label.equals(TWITCH_EMOTES) || this.currentPanel.label.equals(OTHER_EMOTES);
        this.refreshButton.setEnabled(enabled);
        if (enabled) {
            this.refreshButton.setToolTipText(Language.getString("emotesDialog.refresh"));
        } else {
            this.refreshButton.setToolTipText(Language.getString("emotesDialog.refreshInactive"));
        }
    }

    private void showPanelByName(String name) {
        EmotesPanel panel = this.getPanelByName(name);
        if (panel != null) {
            this.showPanel(panel);
        }
    }

    private EmotesPanel getPanelByName(String name) {
        for (EmotesPanel panel : this.panels) {
            if (!panel.label.equals(name)) continue;
            return panel;
        }
        return null;
    }

    private void showEmotes() {
        if (this.detailsEmote != null) {
            return;
        }
        for (JToggleButton button : this.buttons.keySet()) {
            if (!button.isSelected()) continue;
            this.showPanel(this.buttons.get(button));
            return;
        }
        this.showPanel(this.defaultPanel);
    }

    private EmoteLabel createEmoteLabel(Emoticon emote, float scale) {
        return new EmoteLabel(emote, this.mouseListener, scale, this.imageType, this.emoteUser, null);
    }

    private static String getPrefix(String code) {
        Matcher m = PREFIX_PATTERN.matcher(code);
        if (m.find()) {
            return m.group();
        }
        return null;
    }

    private static String getPrefix(Collection<Emoticon> emotes) {
        String commonPrefix = null;
        int count = 0;
        for (Emoticon emote : emotes) {
            String prefix = EmotesDialog.getPrefix(emote.code);
            if (prefix == null) {
                return null;
            }
            if (commonPrefix == null) {
                commonPrefix = prefix;
                count = 1;
            } else if (prefix.equals(commonPrefix)) {
                ++count;
            } else if (prefix.length() < commonPrefix.length() && commonPrefix.startsWith(prefix)) {
                commonPrefix = prefix;
                count = 1;
            }
            if (prefix.startsWith(commonPrefix)) continue;
            return null;
        }
        if ((double)count >= (double)emotes.size() * 0.8) {
            return commonPrefix;
        }
        return null;
    }

    private static class EmoteLabel
    extends JLabel {
        private static final Border BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        public final String code;
        public final CachedImage<Emoticon> emote;
        public final boolean noInsert;

        public EmoteLabel(Emoticon emote, GuiUtil.SimpleMouseListener mouseListener, float scale, CachedImage.ImageType imageType, CachedImage.CachedImageUser emoteUser, Border extraBorder) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            GuiUtil.addSimpleMouseListener(this, mouseListener);
            CachedImage<Emoticon> emoteImage = emote.getIcon(scale, 0, imageType, emoteUser);
            this.code = emote.code;
            this.emote = emoteImage;
            this.setIcon(emoteImage.getImageIcon());
            this.setToolTipText(emote.code);
            if (emote.type == Emoticon.Type.EMOJI) {
                this.setToolTipText(emote.getInfos().toString());
            }
            if (emote.subType == Emoticon.SubType.CHEER) {
                this.setToolTipText(emote.getInfos().toString());
            }
            this.noInsert = emote.subType == Emoticon.SubType.CHEER;
            if (extraBorder != null) {
                this.setBorder(BorderFactory.createCompoundBorder(BORDER, extraBorder));
            } else {
                this.setBorder(BORDER);
            }
        }
    }

    private abstract class EmotesPanel
    extends JPanel {
        private boolean shouldUpdate;
        private final String label;
        private final int updateOn;
        private final List<Emoticon> ignoredEmotes;

        EmotesPanel(String name, int updateOn) {
            super(new GridBagLayout());
            this.ignoredEmotes = new ArrayList<Emoticon>();
            this.label = name;
            this.updateOn = updateOn;
        }

        public void setUpdated(int reason) {
            if ((this.updateOn & reason) == reason) {
                this.shouldUpdate = true;
            }
        }

        public void setUpdated() {
            this.shouldUpdate = true;
        }

        public void update() {
            if (this.shouldUpdate) {
                this.updateEmotes();
            }
            this.shouldUpdate = false;
        }

        protected abstract void updateEmotes();

        void reset() {
            this.removeAll();
            ((EmotesDialog)EmotesDialog.this).gbc.gridy = 0;
            this.ignoredEmotes.clear();
        }

        private boolean isHidden(Collection<String> emotesets) {
            for (String set : emotesets) {
                if (!EmotesDialog.this.hiddenEmotesets.contains(set)) continue;
                return true;
            }
            return false;
        }

        boolean isHidden(String emoteset) {
            return EmotesDialog.this.hiddenEmotesets.contains(emoteset);
        }

        void addEmotesBySet(String emoteset, boolean allowHide) {
            String stream = EmotesDialog.this.emoteManager.getLabelByEmoteset(emoteset);
            if (stream == null) {
                stream = "-";
            }
            Set<Emoticon> emotes = EmotesDialog.this.emoteManager.getEmoticonsBySet(emoteset);
            String title = String.format("%s [%s]", stream, emoteset);
            this.addEmotesSection(emotes, title, emoteset);
        }

        boolean addEmotesBySets(String titlePrefix, Set<TwitchEmotesApi.EmotesetInfo> emotesets, boolean allowHide) {
            ArrayList<String> sets = new ArrayList<String>();
            for (TwitchEmotesApi.EmotesetInfo emotesetInfo : emotesets) {
                sets.add(emotesetInfo.emoteset_id);
            }
            Collections.sort(sets);
            ArrayList<Emoticon> sorted = new ArrayList<Emoticon>();
            for (String set : sets) {
                sorted.addAll(EmotesDialog.this.emoteManager.getEmoticonsBySet(set));
            }
            HashSet<String> hashSet = allowHide ? new HashSet<String>(sets) : null;
            String title = String.format("%s %s", titlePrefix, StringUtil.shortenTo(((Object)sets).toString(), 14));
            return this.addEmotesSection(sorted, title, hashSet);
        }

        void addTitle(String title) {
            this.addTitle(title, null, null);
        }

        void addTitle(String title, String tooltip, final Collection<String> sets) {
            JLabel titleLabel = new JLabel("<html><body style='width:" + (EmotesDialog.this.getWidth() - 80) + "'>" + Helper.htmlspecialchars_encode(title) + "</html>");
            if (tooltip != null) {
                titleLabel.setToolTipText(tooltip);
            }
            titleLabel.setForeground(EmotesDialog.this.emotesForeground);
            titleLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, titleLabel.getForeground()));
            ((EmotesDialog)EmotesDialog.this).gbc.fill = 2;
            ((EmotesDialog)EmotesDialog.this).gbc.insets = TITLE_INSETS;
            ((EmotesDialog)EmotesDialog.this).gbc.anchor = 17;
            ((EmotesDialog)EmotesDialog.this).gbc.weightx = 1.0;
            ((EmotesDialog)EmotesDialog.this).gbc.gridwidth = 0;
            this.add((Component)titleLabel, EmotesDialog.this.gbc);
            ((EmotesDialog)EmotesDialog.this).gbc.gridx = 0;
            ++((EmotesDialog)EmotesDialog.this).gbc.gridy;
            if (sets != null) {
                GuiUtil.addSimpleMouseListener(titleLabel, new GuiUtil.SimpleMouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            if (EmotesPanel.this.isHidden(sets)) {
                                EmotesDialog.this.hiddenEmotesets.removeAll(sets);
                            } else {
                                EmotesDialog.this.hiddenEmotesets.addAll(sets);
                            }
                            EmotesPanel.this.updateEmotes();
                        }
                    }
                });
                titleLabel.setCursor(Cursor.getPredefinedCursor(12));
                if (!(sets.isEmpty() || sets.iterator().next().equals(EmotesDialog.SPECIAL_SET_LOCAL) || sets.iterator().next().equals(EmotesDialog.SPECIAL_SET_OTHER))) {
                    GuiUtil.addSimpleMouseListener(titleLabel, new GuiUtil.SimpleMouseListener(){

                        @Override
                        public void contextMenu(MouseEvent e) {
                            ContextMenu m = new ContextMenu(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    HashSet<Emoticon> all = new HashSet<Emoticon>();
                                    for (String set : sets) {
                                        all.addAll(EmotesDialog.this.emoteManager.getEmoticonsBySet(set));
                                    }
                                    if (e.getActionCommand().equals("add")) {
                                        ((EmotesDialog)EmotesDialog.this).main.localEmotes.add((Set<Emoticon>)all);
                                    } else {
                                        ((EmotesDialog)EmotesDialog.this).main.localEmotes.remove((Set<Emoticon>)all);
                                    }
                                }
                            };
                            m.addItem("add", "Add local emotes");
                            m.addItem("remove", "Remove local emotes");
                            m.show(e.getComponent(), e.getX(), e.getY());
                        }
                    });
                }
            }
        }

        void addSubtitle(String title, boolean smallMargin) {
            this.addSubtitle(title, smallMargin, false);
        }

        void addSubtitle(String title, boolean smallMargin, boolean links) {
            JComponent titleLabel = links ? new LinkLabel(title, EmotesDialog.this.main.getLinkLabelListener()) : new JLabel(title);
            titleLabel.setForeground(ColorCorrection.correctReadability(Color.GRAY, EmotesDialog.this.emotesBackground));
            ((EmotesDialog)EmotesDialog.this).gbc.fill = 0;
            ((EmotesDialog)EmotesDialog.this).gbc.weightx = 0.0;
            ((EmotesDialog)EmotesDialog.this).gbc.insets = smallMargin ? SUBTITLE_INSETS_SMALLER_MARGIN : SUBTITLE_INSETS;
            ((EmotesDialog)EmotesDialog.this).gbc.anchor = 10;
            ((EmotesDialog)EmotesDialog.this).gbc.gridwidth = 0;
            this.add((Component)titleLabel, EmotesDialog.this.gbc);
            ((EmotesDialog)EmotesDialog.this).gbc.gridx = 0;
            ++((EmotesDialog)EmotesDialog.this).gbc.gridy;
        }

        private void addEmotesPanel(Collection<Emoticon> emotes) {
            JPanel panel = new JPanel();
            panel.setBackground(EmotesDialog.this.emotesBackground);
            panel.setLayout(new WrapLayout());
            panel.setSize(this.getParent().getParent().getWidth() - 20, 1);
            String prevEmoteset = null;
            String prevEmotesetInfo = null;
            String prevType = null;
            boolean allSameType = this.isAllSameType(emotes);
            for (Emoticon emote : emotes) {
                boolean separatorAdded = false;
                if (!(Objects.equals(prevEmoteset, emote.emoteset) || prevEmoteset == null || Objects.equals(emote.getEmotesetInfo(), prevEmotesetInfo) && emote.getEmotesetInfo() != null)) {
                    panel.add(this.makeSeparator());
                    this.addSeparatorEmotesetInfo(panel, emote);
                    separatorAdded = true;
                } else if (prevEmoteset == null) {
                    this.addSeparatorEmotesetInfo(panel, emote);
                }
                if (!allSameType && emote.type.category != Emoticon.TypeCategory.OFFICIAL && !Objects.equals(prevType, emote.type.label)) {
                    if (prevType != null && !separatorAdded) {
                        panel.add(this.makeSeparator());
                    }
                    panel.add(this.createLabel(emote.type.label));
                }
                prevEmoteset = emote.emoteset;
                prevEmotesetInfo = emote.getEmotesetInfo();
                prevType = emote.type.label;
                panel.add(EmotesDialog.this.createEmoteLabel(emote, EmotesDialog.this.scale));
            }
            ((EmotesDialog)EmotesDialog.this).gbc.fill = 2;
            ((EmotesDialog)EmotesDialog.this).gbc.insets = EMOTE_INSETS;
            ((EmotesDialog)EmotesDialog.this).gbc.anchor = 17;
            ((EmotesDialog)EmotesDialog.this).gbc.weightx = 1.0;
            ((EmotesDialog)EmotesDialog.this).gbc.gridwidth = 0;
            this.add((Component)panel, EmotesDialog.this.gbc);
            ((EmotesDialog)EmotesDialog.this).gbc.gridx = 0;
            ++((EmotesDialog)EmotesDialog.this).gbc.gridy;
        }

        private boolean isAllSameType(Collection<Emoticon> emotes) {
            Emoticon.Type prevType = null;
            for (Emoticon emote : emotes) {
                if (prevType != null && !Objects.equals((Object)prevType, (Object)emote.type)) {
                    return false;
                }
                prevType = emote.type;
            }
            return true;
        }

        private void addSeparatorEmotesetInfo(JPanel panel, Emoticon emote) {
            if (StringUtil.isNullOrEmpty(emote.getEmotesetInfo())) {
                return;
            }
            if (Arrays.asList("Tier 2", "Tier 3", "Bits", "Follower").contains(emote.getEmotesetInfo())) {
                panel.add(this.createLabel(emote.getEmotesetInfo()));
            }
        }

        private JLabel createLabel(String text) {
            JLabel label = new JLabel(text);
            label.setForeground(EmotesDialog.this.emotesForeground);
            return label;
        }

        private JSeparator makeSeparator() {
            JSeparator separator = new JSeparator(1);
            separator.setPreferredSize(new Dimension(2, 24));
            return separator;
        }

        void addEmotesSection(Collection<Emoticon> emotes, String title) {
            this.addEmotesSection(emotes, title, (String)null);
        }

        void addEmotesSection(Collection<Emoticon> emotes, String title, String hideId) {
            HashSet<String> hideIds = null;
            if (hideId != null) {
                hideIds = new HashSet<String>(Arrays.asList(hideId));
            }
            this.addEmotesSection(emotes, title, hideIds);
        }

        boolean addEmotesSection(Collection<Emoticon> emotes, String title, Set<String> hideIds) {
            List<Emoticon> sorted = this.sortEmotes(emotes);
            sorted.removeIf(emote -> {
                boolean ignored = EmotesDialog.this.emoteManager.isEmoteIgnored((Emoticon)emote, 2);
                if (ignored) {
                    this.ignoredEmotes.add((Emoticon)emote);
                }
                return ignored;
            });
            if (!sorted.isEmpty()) {
                boolean show = hideIds == null || !this.isHidden(hideIds);
                String fullTitle = this.filterEmotesForSearch(sorted, title);
                this.addTitle(fullTitle, null, hideIds);
                if (show && !sorted.isEmpty()) {
                    this.addEmotesPanel(sorted);
                }
                return show;
            }
            return false;
        }

        public void addIgnoredEmotes() {
            if (this.ignoredEmotes.isEmpty()) {
                return;
            }
            ArrayList<Emoticon> emotes = new ArrayList<Emoticon>(this.ignoredEmotes);
            String title = this.filterEmotesForSearch(emotes, "Ignored emotes");
            HashSet<String> hideIds = new HashSet<String>(Arrays.asList("$ignored$"));
            this.addTitle(title, null, hideIds);
            if (this.isHidden(hideIds) && !emotes.isEmpty()) {
                this.addEmotesPanel(emotes);
            }
        }

        private String filterEmotesForSearch(Collection<Emoticon> emotes, String titlePrefix) {
            int numEmotesFiltered;
            int numEmotes = emotes.size();
            if (!StringUtil.isNullOrEmpty(EmotesDialog.this.search)) {
                emotes.removeIf(e -> !e.code.toLowerCase().contains(EmotesDialog.this.search) && (e.type != Emoticon.Type.EMOJI || !e.stringId.contains(EmotesDialog.this.search)));
            }
            String fullTitle = numEmotes == (numEmotesFiltered = emotes.size()) ? String.format("%s (%d emotes)", titlePrefix, numEmotes) : String.format("%s (%d/%d emotes)", titlePrefix, numEmotesFiltered, numEmotes);
            return fullTitle;
        }

        List<Emoticon> sortEmotes(Collection<Emoticon> emotes) {
            ArrayList<Emoticon> sorted = new ArrayList<Emoticon>(emotes);
            Collections.sort(sorted, new SortEmotes());
            return sorted;
        }

        void relayout() {
            this.revalidate();
            this.repaint();
        }
    }

    private class FavoritesPanel
    extends EmotesPanel {
        public FavoritesPanel(String name, int updateOn) {
            super(name, updateOn);
        }

        @Override
        protected void updateEmotes() {
            this.reset();
            ArrayList<Emoticon> favs = new ArrayList<Emoticon>(EmotesDialog.this.emoteManager.getFavorites());
            Collections.sort(favs, new SortEmotes());
            ArrayList<Emoticon> chanSpecificFavs = new ArrayList<Emoticon>(EmotesDialog.this.emoteManager.getUsableEmotesByStream(EmotesDialog.this.currentStream));
            chanSpecificFavs.removeIf(emote -> !EmotesDialog.this.emoteManager.isFavorite((Emoticon)emote));
            if (favs.isEmpty()) {
                this.addTitle(Language.getString("emotesDialog.noFavorites"));
                this.addSubtitle(Language.getString("emotesDialog.noFavorites.hint"), false);
            }
            ArrayList<Emoticon> subEmotesNotSubbedTo = new ArrayList<Emoticon>();
            for (Emoticon emote2 : favs) {
                if (emote2.hasGlobalEmoteset() || EmotesDialog.this.localUserEmotesets.contains(emote2.emoteset)) continue;
                subEmotesNotSubbedTo.add(emote2);
            }
            favs.removeAll(subEmotesNotSubbedTo);
            this.addEmotesSection(favs, Language.getString("emotesDialog.tab.favorites"), "$fav$");
            this.addEmotesSection(subEmotesNotSubbedTo, Language.getString("emotesDialog.subscriptionRequired"), "$favsNoAccess$");
            this.addEmotesSection(chanSpecificFavs, Language.getString("emotesDialog.channelSpecificFavorites", Helper.toChannel(EmotesDialog.this.currentStream)), "$favsChan$");
            this.addNotFoundList(chanSpecificFavs);
            this.addIgnoredEmotes();
            this.relayout();
        }

        private void addNotFoundList(Collection<Emoticon> chanSpecificFavs) {
            Collection<EmoticonFavorites.Favorite> notFoundFavorites = this.getFilteredNotFound(chanSpecificFavs);
            if (!notFoundFavorites.isEmpty()) {
                this.addTitle(Language.getString("emotesDialog.notFoundFavorites") + " (" + notFoundFavorites.size() + ")", null, Arrays.asList("$favsNotFound$"));
                if (this.isHidden("$favsNotFound$")) {
                    JList list = new JList();
                    list.setFixedCellWidth(10);
                    DefaultListModel data = new DefaultListModel();
                    list.setModel(data);
                    notFoundFavorites.forEach(fav -> data.addElement(fav));
                    final Runnable removeAction = () -> {
                        List<EmoticonFavorites.Favorite> toRemove = list.getSelectedValuesList();
                        EmotesDialog.this.emoteManager.removeFavorites(toRemove);
                        toRemove.forEach(fav -> data.removeElement(fav));
                        this.updateEmotes();
                    };
                    list.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "removeFavoriteEmotes");
                    list.getActionMap().put("removeFavoriteEmotes", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            removeAction.run();
                        }
                    });
                    JListActionHelper.install(list, (a, l, s) -> {
                        if (a == JListActionHelper.Action.CONTEXT_MENU) {
                            JPopupMenu menu = new JPopupMenu();
                            JMenuItem item = new JMenuItem(Language.getString("emotesDialog.button.unfavoriteSelected"));
                            item.addActionListener(e2 -> removeAction.run());
                            menu.add(item);
                            menu.show(list, l.x, l.y);
                        }
                    });
                    JButton removeButton = new JButton(Language.getString("emotesDialog.button.unfavoriteSelected"));
                    removeButton.addActionListener(e -> removeAction.run());
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.add((Component)new JScrollPane(list), "Center");
                    panel.add((Component)removeButton, "South");
                    panel.setOpaque(false);
                    ((EmotesDialog)EmotesDialog.this).gbc.fill = 2;
                    ((EmotesDialog)EmotesDialog.this).gbc.insets = TITLE_INSETS;
                    ((EmotesDialog)EmotesDialog.this).gbc.anchor = 10;
                    ((EmotesDialog)EmotesDialog.this).gbc.weightx = 1.0;
                    ((EmotesDialog)EmotesDialog.this).gbc.gridwidth = 0;
                    this.add((Component)panel, EmotesDialog.this.gbc);
                    ((EmotesDialog)EmotesDialog.this).gbc.gridx = 0;
                    ++((EmotesDialog)EmotesDialog.this).gbc.gridy;
                }
            }
        }

        private Collection<EmoticonFavorites.Favorite> getFilteredNotFound(Collection<Emoticon> remove) {
            Collection<EmoticonFavorites.Favorite> result = EmotesDialog.this.emoteManager.getNotFoundFavorites();
            result.removeIf(fav -> {
                for (Emoticon emote : remove) {
                    if (emote.type != fav.type || fav.id == null || !fav.id.equals(emote.stringId)) continue;
                    return true;
                }
                return false;
            });
            return result;
        }
    }

    private class SubemotesPanel
    extends EmotesPanel {
        public SubemotesPanel(String name, int updateOn) {
            super(name, updateOn);
        }

        @Override
        protected void updateEmotes() {
            this.updateEmotes2();
        }

        private void updateEmotes2() {
            this.reset();
            if (EmotesDialog.this.localUserEmotesets.isEmpty() || EmotesDialog.this.localUserEmotesets.size() == 1 && ((String)EmotesDialog.this.localUserEmotesets.iterator().next()).equals("0")) {
                this.addTitle(Language.getString("emotesDialog.noSubemotes"));
                if (EmotesDialog.this.currentStream == null) {
                    this.addSubtitle(Language.getString("emotesDialog.subEmotesJoinChannel"), false);
                }
            } else if (EmotesDialog.this.currentStream == null) {
                this.addSubtitle("Must join a channel for Emotes to show correctly.", false);
            }
            ++((EmotesDialog)EmotesDialog.this).gbc.gridy;
            Set<Emoticon> customLocalEmotes = EmotesDialog.this.emoteManager.getCustomLocalEmotes();
            if (!customLocalEmotes.isEmpty()) {
                this.addEmotesSection(customLocalEmotes, "Local Emotes", EmotesDialog.SPECIAL_SET_LOCAL);
                if (!this.isHidden(EmotesDialog.SPECIAL_SET_LOCAL)) {
                    this.addSubtitle("Learn about [help-settings:EmoticonsLocal Local Emotes]", true, true);
                }
            }
            HashMap perOwnerId = new HashMap();
            for (Object emoteset : EmotesDialog.this.localUserEmotesets) {
                TwitchEmotesApi.EmotesetInfo emotesetInfo = EmotesDialog.this.emoteManager.getInfoBySet((String)emoteset);
                if (emotesetInfo == null || emotesetInfo.stream_id == null) continue;
                Set<Emoticon> emotes = EmotesDialog.this.emoteManager.getEmoticonsBySet((String)emoteset);
                MiscUtil.getSetFromMap(perOwnerId, emotesetInfo.stream_id).addAll(emotes);
            }
            HashMap<String, String> prefixesByOwnerId = new HashMap<String, String>();
            for (Map.Entry entry : perOwnerId.entrySet()) {
                String emotePrefix = EmotesDialog.getPrefix((Collection)entry.getValue());
                if (emotePrefix == null) continue;
                prefixesByOwnerId.put((String)entry.getKey(), emotePrefix);
            }
            HashSet<String> turboEmotes = new HashSet<String>();
            HashMap hashMap = new HashMap();
            HashMap<Object, Set> perInfo = new HashMap<Object, Set>();
            HashMap perPrefix = new HashMap();
            ArrayList<String> unknownEmotesets = new ArrayList<String>();
            HashSet<String> unknownEmotesetsSingle = new HashSet<String>();
            for (String emoteset : EmotesDialog.this.localUserEmotesets) {
                if (Emoticons.isTurboEmoteset(emoteset)) {
                    turboEmotes.add(emoteset);
                    continue;
                }
                if (Emoticon.isGlobalEmoteset(emoteset)) continue;
                Set<Emoticon> emotes = EmotesDialog.this.emoteManager.getEmoticonsBySet(emoteset);
                String emotePrefix = EmotesDialog.getPrefix(emotes);
                TwitchEmotesApi.EmotesetInfo emotesetInfo = EmotesDialog.this.emoteManager.getInfoBySet(emoteset);
                if (emotesetInfo != null && emotesetInfo.stream_id != null && prefixesByOwnerId.containsKey(emotesetInfo.stream_id)) {
                    emotePrefix = (String)prefixesByOwnerId.get(emotesetInfo.stream_id);
                }
                if (emotePrefix == null) {
                    if (emotes.size() == 1) {
                        unknownEmotesetsSingle.add(emoteset);
                        continue;
                    }
                    unknownEmotesets.add(emoteset);
                    continue;
                }
                String key = emotePrefix + " Emotes";
                if (!perPrefix.containsKey(key)) {
                    perPrefix.put(key, new HashSet());
                }
                ((Set)perPrefix.get(key)).add(new TwitchEmotesApi.EmotesetInfo(emoteset, null, null, null));
            }
            for (Map.Entry entry : perPrefix.entrySet()) {
                String key = (String)entry.getKey();
                Set sets = (Set)entry.getValue();
                String string = ((TwitchEmotesApi.EmotesetInfo)sets.iterator().next()).emoteset_id;
                if (sets.size() == 1 && EmotesDialog.this.emoteManager.getEmoticonsBySet(string).size() == 1) {
                    unknownEmotesetsSingle.add(string);
                    continue;
                }
                if (perInfo.containsKey(key)) {
                    ((Set)perInfo.get(key)).addAll(sets);
                    continue;
                }
                perInfo.put(key, sets);
            }
            ArrayList sortedStreams = new ArrayList(hashMap.keySet());
            Collections.sort(sortedStreams, String.CASE_INSENSITIVE_ORDER);
            for (Iterator stream : sortedStreams) {
                this.addEmotesBySets((String)((Object)stream), (Set)hashMap.get(stream), true);
            }
            ArrayList sortedInfos = new ArrayList(perInfo.keySet());
            Collections.sort(sortedInfos, String.CASE_INSENSITIVE_ORDER);
            for (String string : sortedInfos) {
                this.addEmotesBySets(string, (Set)perInfo.get(string), true);
            }
            Collections.sort(unknownEmotesets, SORT_EMOTESETS);
            for (String string : unknownEmotesets) {
                this.addEmotesBySet(string, true);
            }
            HashSet<Emoticon> unknownEmotesGrouped = new HashSet<Emoticon>();
            for (String emoteset : unknownEmotesetsSingle) {
                unknownEmotesGrouped.addAll(EmotesDialog.this.emoteManager.getEmoticonsBySet(emoteset));
            }
            this.addEmotesSection(unknownEmotesGrouped, Language.getString("emotesDialog.otherSubemotes"), EmotesDialog.SPECIAL_SET_OTHER);
            String string = "793";
            String turboSetB = "19194";
            for (String emoteset : turboEmotes) {
                if (emoteset.equals(turboSetB) && turboEmotes.contains(string) && EmotesDialog.this.emoteManager.equalsByCode(string, turboSetB)) continue;
                this.addEmotesBySet(emoteset, true);
            }
            this.addIgnoredEmotes();
            if (sortedStreams.size() + sortedInfos.size() > 2) {
                this.addSubtitle("(Tip: Click headings to show/hide emotes)", false);
            }
            this.relayout();
        }
    }

    private class ChannelEmotesPanel
    extends EmotesPanel {
        public ChannelEmotesPanel(String name, int updateOn) {
            super(name, updateOn);
        }

        @Override
        protected void updateEmotes() {
            this.reset();
            if (EmotesDialog.this.currentStream == null && EmotesDialog.this.tempStream == null) {
                this.addTitle(Language.getString("emotesDialog.noChannel"));
            } else {
                String stream;
                String string = stream = EmotesDialog.this.tempStream != null ? EmotesDialog.this.tempStream : EmotesDialog.this.currentStream;
                if (EmotesDialog.this.tempStream != null && EmotesDialog.this.currentStream != null) {
                    JButton button = new JButton(Language.getString("emotesDialog.backToChannel", EmotesDialog.this.currentStream));
                    button.addActionListener(e -> {
                        EmotesDialog.this.tempStream = null;
                        this.updateEmotes();
                    });
                    this.add((Component)button, GuiUtil.makeGbc(0, 0, 1, 1));
                    ++((EmotesDialog)EmotesDialog.this).gbc.gridy;
                }
                Set<Emoticon> channelEmotes = EmotesDialog.this.emoteManager.getEmoticonsByStream(stream);
                HashSet<Emoticon> regular = new HashSet<Emoticon>();
                HashMap event = new HashMap();
                for (Emoticon emote : channelEmotes) {
                    if (emote.type == Emoticon.Type.FFZ && emote.subType == Emoticon.SubType.EVENT) {
                        for (String info : emote.getInfos()) {
                            if (!event.containsKey(info)) {
                                event.put(info, new HashSet());
                            }
                            ((Set)event.get(info)).add(emote);
                        }
                        continue;
                    }
                    regular.add(emote);
                }
                if (channelEmotes.isEmpty()) {
                    this.addTitle(Language.getString("emotesDialog.noChannelEmotes", stream));
                    this.addSubtitle(Language.getString("emotesDialog.noChannelEmotes2"), false);
                } else {
                    this.addEmotesSection(regular, Language.getString("emotesDialog.channelEmotes", stream), "$channel$");
                    for (String info : event.keySet()) {
                        this.addEmotesSection((Collection)event.get(info), "Featured " + info);
                    }
                }
                Debugging.println("emoteinfo", "UPDATE %s", stream);
                TwitchEmotesApi.api.requestByStream(stream);
                this.addSubemotes(stream, EmotesDialog.this.emoteManager.getSetsByStream(stream));
            }
            this.addIgnoredEmotes();
            this.relayout();
        }

        private void addSubemotes(String stream, Set<TwitchEmotesApi.EmotesetInfo> sets) {
            Debugging.println("emoteinfo", "ADDSUBEMOTES %s", sets);
            if (sets != null && !sets.isEmpty()) {
                boolean streamMatches;
                boolean bl = streamMatches = stream != null && stream.equals(sets.iterator().next().stream_name);
                if (streamMatches) {
                    HashSet<TwitchEmotesApi.EmotesetInfo> withAccess = new HashSet<TwitchEmotesApi.EmotesetInfo>();
                    HashSet<TwitchEmotesApi.EmotesetInfo> noAccess = new HashSet<TwitchEmotesApi.EmotesetInfo>();
                    for (TwitchEmotesApi.EmotesetInfo set : sets) {
                        if (EmotesDialog.this.localUserEmotesets.contains(set.emoteset_id)) {
                            withAccess.add(set);
                            continue;
                        }
                        noAccess.add(set);
                    }
                    if (!withAccess.isEmpty()) {
                        this.addEmotesBySets(Language.getString("emotesDialog.subemotes", stream), withAccess, false);
                    }
                    if (!noAccess.isEmpty() && this.addEmotesBySets(Language.getString("emotesDialog.subemotes", stream), noAccess, false)) {
                        if (withAccess.isEmpty()) {
                            this.addSubtitle(Language.getString("emotesDialog.subscriptionRequired2"), true);
                        } else {
                            this.addSubtitle(Language.getString("emotesDialog.subscriptionRequired3"), true);
                        }
                    }
                    this.relayout();
                }
            }
        }
    }

    private class TwitchEmotesPanel
    extends EmotesPanel {
        public TwitchEmotesPanel(String name, int updateOn) {
            super(name, updateOn);
        }

        @Override
        protected void updateEmotes() {
            this.reset();
            Set<Emoticon> emotes = EmotesDialog.this.emoteManager.getGlobalTwitchEmotes();
            this.addEmotesSection(emotes, Language.getString("emotesDialog.globalTwitch"));
            Set<Emoticon> smilies = EmotesDialog.this.emoteManager.getSmilies();
            if (smilies != null) {
                this.addEmotesSection(smilies, "Smilies");
            }
            this.addIgnoredEmotes();
            this.relayout();
        }
    }

    private class OtherEmotesPanel
    extends EmotesPanel {
        public OtherEmotesPanel(String name, int updateOn) {
            super(name, updateOn);
        }

        @Override
        protected void updateEmotes() {
            this.reset();
            Set<Emoticon> ffz = Emoticons.filterByType(EmotesDialog.this.emoteManager.getOtherGlobalEmotes(), Emoticon.Type.FFZ);
            HashSet<Emoticon> ffzRegular = new HashSet<Emoticon>();
            HashSet<Emoticon> ffzFeatured = new HashSet<Emoticon>();
            for (Emoticon emote : ffz) {
                if (emote.subType == Emoticon.SubType.FEATURE_FRIDAY) {
                    ffzFeatured.add(emote);
                    continue;
                }
                ffzRegular.add(emote);
            }
            Set<Emoticon> bttv = Emoticons.filterByType(EmotesDialog.this.emoteManager.getOtherGlobalEmotes(), Emoticon.Type.BTTV);
            Set<Emoticon> seventv = Emoticons.filterByType(EmotesDialog.this.emoteManager.getOtherGlobalEmotes(), Emoticon.Type.SEVENTV);
            this.addEmotesSection(ffzRegular, Language.getString("emotesDialog.globalFFZ"), "$ffz$");
            this.addEmotesSection(ffzFeatured, Language.getString("emotesDialog.globalFFZ") + " [Featured]", "$ffzFeatured$");
            this.addEmotesSection(bttv, Language.getString("emotesDialog.globalBTTV"), "$bttv$");
            this.addEmotesSection(seventv, Language.getString("emotesDialog.globalSevenTV"), "$seventv$");
            this.addIgnoredEmotes();
            this.relayout();
        }
    }

    private class EmoteDetailPanel
    extends EmotesPanel {
        private GridBagConstraints lgbc;

        public EmoteDetailPanel(String name, int updateOn) {
            super(name, updateOn);
            this.lgbc = new GridBagConstraints();
        }

        @Override
        protected void updateEmotes() {
            this.updateEmotes2();
        }

        private void updateEmotes2() {
            String emoteChannel;
            Debugging.println("emoteinfo", "EmoteDetailsPanel update", new Object[0]);
            this.reset();
            Emoticon emote = EmotesDialog.this.detailsEmote;
            if (emote == null) {
                return;
            }
            this.addTitle(Language.getString("emotesDialog.details.title", emote.code));
            this.lgbc.insets = new Insets(5, 7, 5, 7);
            JPanel panel = new JPanel();
            panel.setBackground(EmotesDialog.this.emotesBackground);
            panel.setLayout(new GridBagLayout());
            this.addScaledEmote(emote, panel, 1.0f, "100%");
            if (emote.getWidth() * 3 + 200 < EmotesDialog.this.getWidth()) {
                this.addScaledEmote(emote, panel, 1.5f, "150%");
            }
            this.addScaledEmote(emote, panel, 2.0f, "200%");
            JPanel panel2 = new JPanel();
            panel2.setLayout(new GridBagLayout());
            this.lgbc.gridy = 2;
            this.lgbc.gridx = 0;
            this.lgbc.insets = new Insets(4, 4, 4, 4);
            if (emote.subType == Emoticon.SubType.CHEER) {
                this.addInfo(panel2, "", "Cheering Emote");
            } else {
                this.addInfo(panel2, Language.getString("emotesDialog.details.code"), emote.code);
            }
            String featured = emote.subType == Emoticon.SubType.EVENT ? " (Featured)" : "";
            this.addInfo(panel2, Language.getString("emotesDialog.details.type"), emote.type.toString() + featured);
            if (emote.type == Emoticon.Type.TWITCH || emote.type == Emoticon.Type.FFZ) {
                this.addInfo(panel2, Language.getString("emotesDialog.details.id"), emote.stringId);
            }
            if (!emote.hasGlobalEmoteset()) {
                String emoteset = emote.emoteset;
                if (!emoteset.equals("")) {
                    String info = String.valueOf(emoteset);
                    if (Emoticons.isTurboEmoteset(emoteset)) {
                        info = info + " (Turbo)";
                    }
                    String orig = TwitchEmotesApi.isModified(emote) ? "Orig. " : "";
                    this.addInfo(panel2, orig + "Emoteset:", info);
                } else {
                    this.addInfo(panel2, "Emoteset:", "unknown");
                }
            }
            if ((emoteChannel = emote.getStream()) != null) {
                this.addInfo(panel2, Language.getString("emotesDialog.details.channel"), emoteChannel);
            }
            this.addInfo(panel2, Language.getString("emotesDialog.details.usableIn"), emote.hasStreamRestrictions() ? Language.getString("emotesDialog.details.usableInChannel") : Language.getString("emotesDialog.details.usableEverywhere"));
            if (emote.hasGlobalEmoteset()) {
                this.addInfo(panel2, Language.getString("emotesDialog.details.access"), Language.getString("emotesDialog.details.everyone"));
            } else {
                this.addInfo(panel2, Language.getString("emotesDialog.details.access"), Language.getString("emotesDialog.details.restricted"));
                if (EmotesDialog.this.localUserEmotesets.contains(emote.emoteset)) {
                    this.addInfo(panel2, "", Language.getString("emotesDialog.details.accessAvailable"));
                }
            }
            this.addInfo(panel2, Language.getString("emotesDialog.details.size"), emote.getWidth() + "x" + emote.getHeight());
            if (emote.creator != null) {
                this.addInfo(panel2, Language.getString("emotesDialog.details.by"), emote.creator);
            }
            if (emote.type == Emoticon.Type.EMOJI && emote.stringId != null) {
                this.addInfo(panel2, emote.stringId);
                if (emote.stringIdAlias != null) {
                    this.addInfo(panel2, "(" + emote.stringIdAlias + ")");
                }
            }
            featured = emote.subType == Emoticon.SubType.EVENT ? "Featured " : "";
            for (String info : emote.getInfos()) {
                this.addInfo(panel2, featured + info);
            }
            ((EmotesDialog)EmotesDialog.this).gbc.fill = 2;
            ((EmotesDialog)EmotesDialog.this).gbc.insets = EMOTE_INSETS;
            ((EmotesDialog)EmotesDialog.this).gbc.anchor = 17;
            ((EmotesDialog)EmotesDialog.this).gbc.weightx = 1.0;
            this.add((Component)panel, EmotesDialog.this.gbc);
            ++((EmotesDialog)EmotesDialog.this).gbc.gridy;
            this.add((Component)panel2, EmotesDialog.this.gbc);
            ++((EmotesDialog)EmotesDialog.this).gbc.gridy;
            ((EmotesDialog)EmotesDialog.this).gbc.fill = 0;
            ((EmotesDialog)EmotesDialog.this).gbc.anchor = 10;
            this.add((Component)new JLabel("<html><body style='width:200px;text-align:center;color:#888888'>" + Language.getString("emotesDialog.details.info")), EmotesDialog.this.gbc);
            this.relayout();
        }

        private void addScaledEmote(Emoticon emote, JPanel panel, float scale, String label) {
            this.lgbc.anchor = 10;
            this.lgbc.gridy = 0;
            panel.add((Component)EmotesDialog.this.createEmoteLabel(emote, scale), this.lgbc);
            this.lgbc.gridy = 1;
            JLabel title = new JLabel(label);
            title.setForeground(EmotesDialog.this.emotesForeground);
            panel.add((Component)title, this.lgbc);
            ++this.lgbc.gridx;
        }

        private void addInfo(JPanel panel, String key, String value) {
            this.lgbc.gridx = 0;
            this.lgbc.anchor = 17;
            panel.add((Component)new JLabel(key), this.lgbc);
            this.lgbc.gridx = 1;
            this.lgbc.anchor = 13;
            panel.add((Component)new JLabel(StringUtil.shortenTo(value, 35, 20)), this.lgbc);
            ++this.lgbc.gridy;
        }

        private void addInfo(JPanel panel, String value) {
            this.lgbc.gridx = 0;
            this.lgbc.gridwidth = 2;
            this.lgbc.anchor = 10;
            panel.add((Component)new JLabel(StringUtil.shortenTo(value, 35, 20)), this.lgbc);
            this.lgbc.gridwidth = 1;
            ++this.lgbc.gridy;
        }
    }

    private static class SortEmotesets
    implements Comparator<String> {
        private SortEmotesets() {
        }

        @Override
        public int compare(String o1, String o2) {
            int compareEmoteset = 0;
            if (o1 != null && o2 != null) {
                compareEmoteset = o1.length() - o2.length();
            }
            if (compareEmoteset != 0) {
                return compareEmoteset;
            }
            return Objects.compare(o1, o2, StringUtil.NULL_COMPARATOR);
        }
    }

    private class EmojiPanel
    extends EmotesPanel {
        public EmojiPanel(String name, int updateOn) {
            super(name, updateOn);
        }

        @Override
        protected void updateEmotes() {
            this.reset();
            HashMap categories = new HashMap();
            Set<Emoticon> emotes = EmotesDialog.this.emoteManager.getEmoji();
            for (Emoticon emote : emotes) {
                for (String info : emote.getInfos()) {
                    if (!info.startsWith("Category: ")) continue;
                    if (!categories.containsKey(info)) {
                        categories.put(info, new HashSet());
                    }
                    ((Set)categories.get(info)).add(emote);
                }
            }
            for (String category : categories.keySet()) {
                this.addEmotesSection((Collection)categories.get(category), category);
            }
            this.relayout();
        }
    }

    private class BitsPanel
    extends EmotesPanel {
        public BitsPanel(String name, int updateOn) {
            super(name, updateOn);
        }

        @Override
        protected void updateEmotes() {
            this.reset();
            Set<CheerEmoticon> cheerEmotes = EmotesDialog.this.emoteManager.getCheerEmotes();
            ArrayList<CheerEmoticon> emotes = new ArrayList<CheerEmoticon>();
            for (CheerEmoticon emote : cheerEmotes) {
                emotes.add(emote);
            }
            this.relayout();
        }
    }

    private static class SortEmotes
    implements Comparator<Emoticon> {
        private SortEmotes() {
        }

        @Override
        public int compare(Emoticon o1, Emoticon o2) {
            int compareType = o1.type.compareTo(o2.type);
            if (compareType != 0) {
                return compareType;
            }
            int compareEmoteset = SORT_EMOTESETS.compare(o1.emoteset, o2.emoteset);
            if (compareEmoteset != 0) {
                return compareEmoteset;
            }
            return o1.code.compareToIgnoreCase(o2.code);
        }
    }
}

