/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.Chatty;
import chatty.Helper;
import chatty.Logging;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.LinkLabelListener;
import chatty.util.DateTime;
import chatty.util.ElapsedTime;
import chatty.util.LogUtil;
import chatty.util.MiscUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.LogRecord;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ErrorMessage
extends JDialog {
    public static final int CONTINUE = 0;
    public static final int QUIT = 1;
    private static final int ERROR_LIMIT = 20;
    private static final String TOP_MESSAGE = "<html><body width='300px'>An unexpected error has occured.";
    private static final String MESSAGE = "<html><body width='300px'>You can help to fix the error by [url:https://docs.google.com/forms/d/1pCc1xcWHOK1JPetQNc_N3boijnm3srcPH8PcfyVYG_U/viewform reporting it]. Please include a copy of the report message below and a short description of what you were doing when the error occured.<br /><br />Alternatively to the report page you can also send the report via [url:mailto:chattyclient@gmail.com E-Mail]. You can use something like [url:https://pastebin.com Pastebin.com] to send the text as a link.<br /><br />Please also check if there already is an update available for Chatty, since often bugs are fixed in newer versions.";
    private static final String MINIMIZED_MESSAGE = "<html><body width='300px'>An unexpected error has occured. ([local:maximize Show more..])";
    private static final int MINIMIZE_AFTER = 30000;
    private final LinkedList<String> errors = new LinkedList();
    private int errorCount;
    private final GridBagConstraints contentGbc;
    private final LinkLabel topMessage;
    private final LinkLabel message;
    private final LinkLabel minimizedMessage;
    private final JButton continueProgram = new JButton("Continue");
    private final JButton quitProgram = new JButton("Quit Program");
    private final JButton copyText = new JButton("Copy to clipboard");
    private final JTextArea debugMessage = new JTextArea();
    private final Frame parent;
    private final JPanel normal;
    private final JPanel minimized;
    private final Timer minimizeTimer;
    private final ElapsedTime openedET = new ElapsedTime();
    private int result;

    public ErrorMessage(Frame parent, LinkLabelListener linkLabelListener) {
        super(parent);
        this.parent = parent;
        this.setTitle("Error");
        this.setAlwaysOnTop(true);
        this.setAutoRequestFocus(false);
        this.setModal(true);
        this.debugMessage.setLineWrap(false);
        this.debugMessage.setEditable(false);
        this.message = new LinkLabel(MESSAGE, linkLabelListener);
        this.minimizeTimer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorMessage.this.update();
            }
        });
        LinkLabelListener localListener = new LinkLabelListener(){

            @Override
            public void linkClicked(String type, String ref) {
                if (ref.equals("minimize")) {
                    ErrorMessage.this.minimize();
                } else if (ref.equals("maximize")) {
                    ErrorMessage.this.maximize();
                }
            }
        };
        this.topMessage = new LinkLabel(TOP_MESSAGE, localListener);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                ErrorMessage.this.stopTimer();
            }
        });
        this.setLayout(new GridBagLayout());
        this.contentGbc = this.makeGbc(0, 0, 2, 1);
        this.contentGbc.fill = 1;
        this.contentGbc.weightx = 1.0;
        this.contentGbc.weighty = 1.0;
        this.contentGbc.insets = new Insets(0, 0, 0, 0);
        this.minimized = new JPanel();
        this.minimizedMessage = new LinkLabel(MINIMIZED_MESSAGE, localListener);
        this.minimized.add(this.minimizedMessage);
        this.normal = new JPanel(new GridBagLayout());
        ImageIcon icon = new ImageIcon(ErrorMessage.class.getResource("dialog-warning.png"));
        this.setIconImage(icon.getImage());
        GridBagConstraints gbc = this.makeGbc(0, 0, 2, 1);
        gbc.insets.bottom = 0;
        this.normal.add((Component)this.topMessage, gbc);
        gbc = this.makeGbc(0, 1, 2, 1);
        this.normal.add((Component)this.message, gbc);
        gbc = this.makeGbc(1, 2, 1, 1);
        this.copyText.setMargin(new Insets(0, 10, -1, 10));
        gbc.insets = new Insets(5, 0, 0, 10);
        gbc.anchor = 13;
        this.normal.add((Component)this.copyText, gbc);
        gbc = this.makeGbc(0, 3, 2, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JScrollPane scroll = new JScrollPane(this.debugMessage);
        scroll.setPreferredSize(new Dimension(300, 100));
        this.normal.add((Component)scroll, gbc);
        gbc = this.makeGbc(0, 1, 1, 1);
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 0, 10, 0);
        gbc.weightx = 0.5;
        this.add((Component)this.continueProgram, gbc);
        gbc = this.makeGbc(1, 1, 1, 1);
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 8, 10, 0);
        gbc.weightx = 0.5;
        this.add((Component)this.quitProgram, gbc);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ErrorMessage.this.continueProgram) {
                    ErrorMessage.this.close(0);
                } else if (e.getSource() == ErrorMessage.this.quitProgram) {
                    ErrorMessage.this.close(1);
                } else if (e.getSource() == ErrorMessage.this.copyText) {
                    MiscUtil.copyToClipboard(ErrorMessage.this.debugMessage.getText());
                }
            }
        };
        this.continueProgram.addActionListener(actionListener);
        this.quitProgram.addActionListener(actionListener);
        this.copyText.addActionListener(actionListener);
        this.add((Component)this.normal, this.contentGbc);
        this.finishDialog();
    }

    public int show(LogRecord error, LinkedList<LogRecord> previous, int openChans) {
        if (this.errorCount >= 20) {
            this.setTitle(this.errorCount + " Errors (stopped recording)");
        } else {
            this.addError(error, previous, openChans);
        }
        if (!this.isVisible()) {
            this.setFocusableWindowState(false);
            this.maximize();
            this.setLocationRelativeTo(this.parent);
        }
        this.result = 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ErrorMessage.this.setFocusableWindowState(true);
                ErrorMessage.this.debugMessage.scrollRectToVisible(new Rectangle());
            }
        });
        this.openedET.set();
        if (!this.isFocused()) {
            this.stopTimer();
            this.minimizeTimer.restart();
        }
        this.setVisible(true);
        return this.result;
    }

    private void addError(LogRecord error, LinkedList<LogRecord> previous, int openChans) {
        ++this.errorCount;
        String errorText = ErrorMessage.makeErrorText(error, previous);
        this.errors.add(errorText);
        if (this.errorCount == 1) {
            this.setTitle("Error");
            this.debugMessage.setText(String.format(Locale.ROOT, "Error Report // %s / %s / %s / %s / Chans: %d\n\n", DateTime.fullDateTime(), Chatty.chattyVersion(), Helper.systemInfo(), LogUtil.getMemoryUsage(), openChans));
        } else {
            this.setTitle(this.errorCount + " Errors");
        }
        this.debugMessage.append(errorText);
    }

    public static String makeErrorText(LogRecord error, LinkedList<LogRecord> previous) {
        StringBuilder b = new StringBuilder();
        for (LogRecord r : previous) {
            if (r == null) continue;
            b.append(Logging.formatRecordCompact(r));
        }
        b.append(Logging.formatRecordCompact(error));
        b.append("\n\n");
        return b.toString();
    }

    private void finishDialog() {
        this.setMinimumSize(null);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
    }

    private void minimize() {
        this.remove(this.normal);
        this.add((Component)this.minimized, this.contentGbc);
        this.finishDialog();
    }

    private void maximize() {
        this.remove(this.minimized);
        this.add((Component)this.normal, this.contentGbc);
        this.finishDialog();
    }

    private void update() {
        if (this.isVisible()) {
            long leftToMinimize = (30000L - this.openedET.millisElapsed()) / 1000L;
            if (leftToMinimize <= 0L) {
                this.minimize();
                this.stopTimer();
            } else {
                this.topMessage.setText("<html><body width='300px'>An unexpected error has occured. ([local:minimize Minimize dialog] in " + leftToMinimize + "s)");
            }
        }
    }

    private void stopTimer() {
        if (this.minimizeTimer != null) {
            this.minimizeTimer.stop();
            this.topMessage.setText("<html><body width='300px'>An unexpected error has occured. ([local:minimize Minimize dialog])");
        }
    }

    private void close(int action) {
        this.result = action;
        this.errors.clear();
        this.errorCount = 0;
        this.setVisible(false);
    }

    private GridBagConstraints makeGbc(int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(10, 10, 10, 10);
        return gbc;
    }
}

