/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.Helper;
import chatty.gui.LinkListener;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.textpane.LinkController;
import chatty.gui.components.textpane.WrapLabelView;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;

public class ExtendedTextPane
extends JTextPane {
    private static final Logger LOGGER = Logger.getLogger(ExtendedTextPane.class.getName());
    private final StyledDocument doc;
    private static final Matcher urlMatcher = Helper.getUrlPattern().matcher("");
    private static final String srlRegex = "#srl-([a-z0-9]{2,6})";
    private static final Matcher srlMatcher = Pattern.compile("#srl-([a-z0-9]{2,6})").matcher("");
    private static final String SRL_URL = "http://speedrunslive.com/race/?id=";
    private final LinkController linkController;

    public ExtendedTextPane() {
        this.setEditorKit(new MyEditorKit());
        this.linkController = new LinkController();
        this.addMouseListener(this.linkController);
        this.addMouseMotionListener(this.linkController);
        this.doc = this.getStyledDocument();
    }

    public void setLinkListener(LinkListener listener) {
        this.linkController.setLinkListener(listener);
    }

    public void setContextMenuListener(ContextMenuListener listener) {
        this.linkController.setContextMenuListener(listener);
    }

    @Override
    public void setText(String text) {
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException ex) {
            LOGGER.warning("Bad location");
        }
        this.printSpecials(text);
    }

    protected void printSpecials(String text) {
        TreeMap<Integer, Integer> ranges = new TreeMap<Integer, Integer>();
        HashMap<Integer, MutableAttributeSet> rangesStyle = new HashMap<Integer, MutableAttributeSet>();
        this.findLinks(text, ranges, rangesStyle);
        this.findSrl(text, ranges, rangesStyle);
        int lastPrintedPos = 0;
        for (Map.Entry<Integer, Integer> range : ranges.entrySet()) {
            int start = range.getKey();
            int end = range.getValue();
            if (start > lastPrintedPos) {
                this.print(text.substring(lastPrintedPos, start), null);
            }
            this.print(text.substring(start, end + 1), rangesStyle.get(start));
            lastPrintedPos = end + 1;
        }
        if (lastPrintedPos < text.length()) {
            this.print(text.substring(lastPrintedPos), null);
        }
    }

    private void findLinks(String text, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle) {
        urlMatcher.reset(text);
        while (urlMatcher.find()) {
            String foundUrl;
            int start = urlMatcher.start();
            int end = urlMatcher.end() - 1;
            if (this.inRanges(start, ranges) || this.inRanges(end, ranges) || (foundUrl = urlMatcher.group()).contains("..")) continue;
            if (foundUrl.endsWith(")") && !foundUrl.contains("(")) {
                foundUrl = foundUrl.substring(0, foundUrl.length() - 1);
                --end;
            }
            if (!this.checkUrl(foundUrl)) continue;
            ranges.put(start, end);
            if (!foundUrl.startsWith("http")) {
                foundUrl = "http://" + foundUrl;
            }
            rangesStyle.put(start, this.url(foundUrl));
        }
    }

    private void findSrl(String text, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle) {
        srlMatcher.reset(text);
        while (srlMatcher.find()) {
            int start = srlMatcher.start();
            int end = srlMatcher.end() - 1;
            if (this.inRanges(start, ranges) || this.inRanges(end, ranges)) continue;
            String foundSrl = srlMatcher.group();
            String url = SRL_URL + foundSrl;
            ranges.put(start, end);
            rangesStyle.put(start, this.url(url));
        }
    }

    private void print(String text, AttributeSet printStyle) {
        try {
            this.doc.insertString(this.doc.getLength(), text, printStyle);
        }
        catch (BadLocationException e) {
            LOGGER.warning("Bad location");
        }
    }

    private boolean inRanges(int i, Map<Integer, Integer> ranges) {
        for (Map.Entry<Integer, Integer> range : ranges.entrySet()) {
            if (i < range.getKey() || i > range.getValue()) continue;
            return true;
        }
        return false;
    }

    private boolean checkUrl(String uriToCheck) {
        try {
            new URI(uriToCheck);
        }
        catch (URISyntaxException ex) {
            return false;
        }
        return true;
    }

    public MutableAttributeSet url(String url) {
        SimpleAttributeSet urlStyle = new SimpleAttributeSet();
        StyleConstants.setUnderline(urlStyle, true);
        urlStyle.addAttribute(HTML.Attribute.HREF, url);
        return urlStyle;
    }

    private static class MyEditorKit
    extends StyledEditorKit {
        private MyEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return new StyledViewFactory();
        }

        static class StyledViewFactory
        implements ViewFactory {
            StyledViewFactory() {
            }

            @Override
            public View create(Element elem) {
                String kind = elem.getName();
                if (kind != null) {
                    if (kind.equals("content")) {
                        return new WrapLabelView(elem);
                    }
                    if (kind.equals("paragraph")) {
                        return new ParagraphView(elem);
                    }
                    if (kind.equals("section")) {
                        return new BoxView(elem, 1);
                    }
                    if (kind.equals("component")) {
                        return new ComponentView(elem);
                    }
                    if (kind.equals("icon")) {
                        return new IconView(elem);
                    }
                }
                return new LabelView(elem);
            }
        }
    }
}

