/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.ChannelFavorites;
import chatty.Helper;
import chatty.Room;
import chatty.gui.GuiUtil;
import chatty.gui.components.ExtendableDefaultTableHeaderCellRenderer;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.RoomsContextMenu;
import chatty.gui.components.menus.TextSelectionMenu;
import chatty.lang.Language;
import chatty.util.BitEncoder;
import chatty.util.DateTime;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class FavoritesDialog
extends JDialog {
    private final JTable table;
    private final MyTableModel data;
    private final CustomSorter sorter;
    private final ChannelFavorites favorites;
    private final JTextField input = new JTextField(30);
    private final JButton addToFavoritesButton = new JButton(Language.getString("favorites.button.addToFavorites"));
    private final JButton removeFromFavoritesButton = new JButton(Language.getString("favorites.button.removeFromFavorites"));
    private final JButton removeButton = new JButton(Language.getString("favorites.button.remove"));
    private final JButton doneButton = new JButton();
    private final JButton cancelButton = new JButton(Language.getString("dialog.button.cancel"));
    public static final int ACTION_CANCEL = 0;
    public static final int ACTION_DONE = 1;
    public static final int BUTTON_ADD_FAVORITES = 2;
    public static final int BUTTON_REMOVE_FAVORITES = 3;
    public static final int BUTTON_REMOVE = 4;
    private static final int COLUMN_FAV = 0;
    private static final int COLUMN_CHANNEL = 1;
    private static final int COLUMN_AGO = 2;
    private static final int FAV_COLUMN_WIDTH = 50;
    private static final int TIME_COLUMN_WIDTH = 100;
    private int result = -1;
    private final ContextMenuListener contextMenuListener;

    public FavoritesDialog(Window main, ChannelFavorites favorites, ContextMenuListener contextMenuListener) {
        super(main);
        this.setTitle(Language.getString("favorites.title"));
        this.setModal(true);
        this.favorites = favorites;
        this.contextMenuListener = contextMenuListener;
        this.setLayout(new GridBagLayout());
        this.input.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FavoritesDialog.this.channelsChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FavoritesDialog.this.channelsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FavoritesDialog.this.channelsChanged();
            }
        });
        GuiUtil.installLengthLimitDocumentFilter(this.input, 80000, false, new Object[0]);
        TextSelectionMenu.install(this.input);
        this.data = new MyTableModel();
        this.table = new JTable();
        this.table.setModel(this.data);
        TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>(this.table.getModel());
        this.table.setRowSorter(rowSorter);
        this.sorter = new CustomSorter(rowSorter);
        this.setupTable();
        this.input.setToolTipText(Language.getString("favorites.input.tip"));
        GridBagConstraints gbc = this.makeGbc(0, 0, 2, 1);
        gbc.fill = 2;
        this.add((Component)this.input, gbc);
        gbc = this.makeGbc(2, 0, 1, 1);
        GuiUtil.smallButtonInsets(this.addToFavoritesButton);
        this.add((Component)this.addToFavoritesButton, gbc);
        gbc = this.makeGbc(0, 2, 3, 1);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), gbc);
        gbc = this.makeGbc(0, 3, 1, 1);
        gbc.insets = new Insets(2, 5, 5, 5);
        GuiUtil.smallButtonInsets(this.removeFromFavoritesButton);
        this.add((Component)this.removeFromFavoritesButton, gbc);
        gbc = this.makeGbc(1, 3, 1, 1);
        gbc.insets = new Insets(2, 5, 5, 5);
        GuiUtil.smallButtonInsets(this.removeButton);
        this.add((Component)this.removeButton, gbc);
        this.doneButton.setMnemonic(74);
        gbc = this.makeGbc(0, 4, 2, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.doneButton, gbc);
        this.cancelButton.setMnemonic(67);
        gbc = this.makeGbc(2, 4, 1, 1);
        gbc.fill = 2;
        this.add((Component)this.cancelButton, gbc);
        this.removeButton.setToolTipText(Language.getString("favorites.button.remove.tip"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == FavoritesDialog.this.addToFavoritesButton) {
                    FavoritesDialog.this.addToFavorites();
                } else if (e.getSource() == FavoritesDialog.this.removeFromFavoritesButton) {
                    FavoritesDialog.this.removeFromFavorites();
                } else if (e.getSource() == FavoritesDialog.this.removeButton) {
                    FavoritesDialog.this.remove();
                } else if (e.getSource() == FavoritesDialog.this.input) {
                    FavoritesDialog.this.addToFavorites();
                } else if (e.getSource() == FavoritesDialog.this.doneButton) {
                    FavoritesDialog.this.result = 1;
                    FavoritesDialog.this.setVisible(false);
                } else if (e.getSource() == FavoritesDialog.this.cancelButton) {
                    FavoritesDialog.this.result = 0;
                    FavoritesDialog.this.setVisible(false);
                }
            }
        };
        this.addToFavoritesButton.addActionListener(actionListener);
        this.removeFromFavoritesButton.addActionListener(actionListener);
        this.removeButton.addActionListener(actionListener);
        this.input.addActionListener(actionListener);
        this.cancelButton.addActionListener(actionListener);
        this.doneButton.addActionListener(actionListener);
        this.channelsChanged();
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private void addToFavorites() {
        for (String channel : this.getChannels()) {
            this.removeEntry(channel);
            ChannelFavorites.Favorite r = this.favorites.addFavorite(channel);
            this.data.add(r);
        }
    }

    private void removeFromFavorites() {
        for (ChannelFavorites.Favorite f : this.getSelected()) {
            this.data.remove(f);
            ChannelFavorites.Favorite r = this.favorites.removeFavorite(f.room);
            this.data.add(r);
        }
    }

    private void remove() {
        int index = this.table.getSelectedRow();
        for (ChannelFavorites.Favorite f : this.getSelected()) {
            this.data.remove(f);
            this.favorites.remove(f);
        }
        if (this.table.getRowCount() > index) {
            this.table.setRowSelectionInterval(index, index);
        } else if (this.table.getRowCount() > 0) {
            index = this.table.getRowCount() - 1;
            this.table.setRowSelectionInterval(index, index);
        }
    }

    private void removeEntry(String channel) {
        ChannelFavorites.Favorite existing = this.favorites.get(channel);
        if (existing != null) {
            this.data.remove(existing);
        }
    }

    private void setupTable() {
        this.table.setShowGrid(false);
        this.table.setDefaultRenderer(Boolean.class, new FavoriteRenderer());
        this.table.setDefaultRenderer(Long.class, new TimeRenderer());
        this.table.getTableHeader().addMouseListener(this.sorter);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setDefaultRenderer(new MyDefaultTableHeaderCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FavoritesDialog.this.selectionChanged();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FavoritesDialog.this.doneButton.doClick();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                FavoritesDialog.this.openContextMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                FavoritesDialog.this.openContextMenu(e);
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(74, 0), "done");
        this.table.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "done");
        this.table.getActionMap().put("done", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FavoritesDialog.this.doneButton.doClick();
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.table.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FavoritesDialog.this.remove();
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(70, 0), "addFav");
        this.table.getActionMap().put("addFav", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FavoritesDialog.this.addToFavoritesButton.doClick();
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(85, 0), "unFav");
        this.table.getActionMap().put("unFav", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FavoritesDialog.this.removeFromFavoritesButton.doClick();
            }
        });
        TableColumn favColumn = this.table.getColumnModel().getColumn(0);
        favColumn.setMaxWidth(50);
        favColumn.setMinWidth(50);
        TableColumn timeColumn = this.table.getColumnModel().getColumn(2);
        timeColumn.setMaxWidth(100);
        timeColumn.setMinWidth(100);
    }

    public int showDialog(String channelPreset) {
        this.setChannel(channelPreset);
        this.result = -1;
        this.updateEditButtons();
        this.data.setData(this.favorites.getAll());
        this.setVisible(true);
        return this.result;
    }

    public void updateData() {
        if (this.isVisible()) {
            this.data.setData(this.favorites.getAll());
        }
    }

    public void setChannel(String channel) {
        if (channel != null) {
            this.input.setText(channel);
        }
    }

    private void channelsChanged() {
        Set<String> currentChannels = this.getChannels();
        this.doneButton.setEnabled(!currentChannels.isEmpty());
        this.doneButton.setText(Language.getString("favorites.button.joinChannels", currentChannels.size()));
    }

    private void selectionChanged() {
        this.updateChosenFromSelected();
        this.updateEditButtons();
    }

    private void updateChosenFromSelected() {
        String selectedChannels = Helper.buildStreamsString(this.getSelectedChannels());
        this.input.setText(selectedChannels);
    }

    private void updateEditButtons() {
        boolean selected = !this.getSelectedChannels().isEmpty();
        this.removeButton.setEnabled(selected);
        this.removeFromFavoritesButton.setEnabled(selected);
    }

    public Set<String> getSelectedChannels() {
        int[] selected;
        HashSet<String> selectedChannels = new HashSet<String>();
        for (int row : selected = this.table.getSelectedRows()) {
            ChannelFavorites.Favorite favorite = this.data.get(this.table.convertRowIndexToModel(row));
            selectedChannels.add(favorite.room.getChannel());
        }
        return selectedChannels;
    }

    public List<ChannelFavorites.Favorite> getSelected() {
        ArrayList<ChannelFavorites.Favorite> result = new ArrayList<ChannelFavorites.Favorite>();
        for (int row : this.table.getSelectedRows()) {
            result.add(this.data.get(this.table.convertRowIndexToModel(row)));
        }
        return result;
    }

    public Set<String> getChannels() {
        String channels = this.input.getText();
        return Helper.parseChannelsFromString(channels, true);
    }

    private void openContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int clickedRow = this.table.rowAtPoint(e.getPoint());
            if (clickedRow != -1 && !Helper.arrayContainsInt(this.table.getSelectedRows(), clickedRow)) {
                this.table.setRowSelectionInterval(clickedRow, clickedRow);
            }
            if (this.table.getSelectedRow() != -1) {
                ArrayList<Room> selected = new ArrayList<Room>();
                for (ChannelFavorites.Favorite f : this.getSelected()) {
                    selected.add(f.room);
                }
                RoomsContextMenu m = new RoomsContextMenu(selected, this.contextMenuListener);
                m.show(this.table, e.getX(), e.getY());
            }
        }
    }

    public void setSorting(int column) {
        this.sorter.setSorting(column);
    }

    public int getSorting() {
        return this.sorter.getSorting();
    }

    private GridBagConstraints makeGbc(int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(5, 5, 5, 5);
        return gbc;
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private List<ChannelFavorites.Favorite> data = new ArrayList<ChannelFavorites.Favorite>();
        private final String[] columns = new String[]{Language.getString("favorites.column.fav"), Language.getString("favorites.column.channel"), Language.getString("favorites.column.lastJoined")};

        private MyTableModel() {
        }

        public void setData(List<ChannelFavorites.Favorite> newData) {
            this.data = newData;
            this.fireTableDataChanged();
        }

        public ChannelFavorites.Favorite get(int index) {
            return this.data.get(index);
        }

        public void add(ChannelFavorites.Favorite f) {
            this.data.add(f);
            int index = this.data.size() - 1;
            this.fireTableRowsInserted(index, index);
        }

        public void remove(ChannelFavorites.Favorite f) {
            int index = this.data.indexOf(f);
            if (index != -1) {
                this.data.remove(index);
                this.fireTableRowsDeleted(index, index);
            }
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columns[col];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ChannelFavorites.Favorite f = this.data.get(rowIndex);
            if (columnIndex == 0) {
                return f.isFavorite;
            }
            if (columnIndex == 1) {
                return Helper.toStream(f.room.getDisplayName());
            }
            return f.lastJoined;
        }

        public Class getColumnClass(int c) {
            if (this.data.isEmpty()) {
                return Object.class;
            }
            return this.getValueAt(0, c).getClass();
        }
    }

    private final class CustomSorter
    extends MouseAdapter {
        private final BitEncoder encoder = new BitEncoder({0, 1, 2}, {0, 1});
        private int sortCount;
        private int sortedColumn;
        private final TableRowSorter<TableModel> sorter;

        CustomSorter(TableRowSorter<TableModel> sorter) {
            this.sorter = sorter;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int columnIndex = FavoritesDialog.this.table.getColumnModel().getColumnIndexAtX(e.getX());
            this.sortColumn(columnIndex);
        }

        public void sortColumn(int columnIndex) {
            ++this.sortCount;
            if (this.sortedColumn != columnIndex) {
                this.sortCount = 0;
                if (columnIndex == 2) {
                    this.sortCount = 1;
                }
            }
            this.sort(columnIndex, this.sortCount);
        }

        private void sort(int columnIndex, int sortCount) {
            SortOrder order = SortOrder.values()[sortCount % 2];
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
            if (columnIndex != 0) {
                sortKeys.add(new RowSorter.SortKey(0, SortOrder.DESCENDING));
            }
            sortKeys.add(new RowSorter.SortKey(columnIndex, order));
            this.sorter.setSortKeys(sortKeys);
            this.sortCount = sortCount;
            this.sortedColumn = columnIndex;
        }

        public int getSorting() {
            this.encoder.setValue(0, this.sortedColumn);
            this.encoder.setValue(1, this.sortCount % 2);
            return (int)this.encoder.encode();
        }

        public void setSorting(int sorting) {
            this.encoder.decode(sorting);
            this.sort(this.encoder.getValue(0), this.encoder.getValue(1));
        }
    }

    private static class FavoriteRenderer
    extends DefaultTableCellRenderer {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/chatty/gui/star.png"));

        private FavoriteRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    this.setIcon(this.icon);
                } else {
                    this.setIcon(null);
                }
                FavoriteRenderer label = this;
                label.setHorizontalAlignment(0);
            }
        }
    }

    static class TimeRenderer
    extends DefaultTableCellRenderer {
        TimeRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                return;
            }
            long time = (Long)value;
            if (time == -1L) {
                this.setText("-");
            } else {
                this.setText(DateTime.agoText(time));
            }
            TimeRenderer label = this;
            label.setHorizontalAlignment(0);
        }
    }

    private static class MyDefaultTableHeaderCellRenderer
    extends ExtendableDefaultTableHeaderCellRenderer {
        private MyDefaultTableHeaderCellRenderer() {
        }

        @Override
        protected RowSorter.SortKey getSortKey(JTable table, int column) {
            RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
            if (rowSorter == null) {
                return null;
            }
            List<RowSorter.SortKey> sortedColumns = rowSorter.getSortKeys();
            for (RowSorter.SortKey key : sortedColumns) {
                if (key.getColumn() != column) continue;
                return key;
            }
            return null;
        }
    }
}

