/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.Chatty;
import chatty.Helper;
import chatty.User;
import chatty.gui.DockedDialogHelper;
import chatty.gui.DockedDialogManager;
import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.admin.AdminDialog;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.StreamsContextMenu;
import chatty.gui.components.menus.UserContextMenu;
import chatty.gui.components.settings.ListTableModel;
import chatty.gui.laf.LaF;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.Debugging;
import chatty.util.StringUtil;
import chatty.util.api.Follower;
import chatty.util.api.FollowerInfo;
import chatty.util.api.TwitchApi;
import chatty.util.colors.ColorCorrectionNew;
import chatty.util.dnd.DockContent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FollowersDialog
extends JDialog {
    private static final int REFRESH_TIMER = 10000;
    private final JLabel total = new JLabel("Total: 123.456 (+123.456)");
    private final JLabel stats = new JLabel("| Week: 99+ | Day: 99+ | Hour: 23");
    private final JTable table;
    private final ListTableModel<Follower> followers = new MyListTableModel();
    private final JLabel loadInfo = new JLabel();
    private final JButton refreshButton;
    private final JScrollPane accessInfo;
    private final JScrollPane mainTable;
    private final TwitchApi api;
    private final MainGui main;
    private final Type type;
    private final ContextMenuListener contextMenuListener;
    private final DockedDialogHelper helper;
    private final MyRenderer timeRenderer = new MyRenderer(MyRenderer.Type.TIME);
    private final MyRenderer timeRenderer2 = new MyRenderer(MyRenderer.Type.USER_TIME);
    private String stream;
    private FollowerInfo currentInfo;
    private FollowerInfo lastValidInfo;
    private boolean loading;
    private long lastUpdated = -1L;
    private boolean compactMode;
    private boolean showRegistered;
    private TableColumn regColumn;

    public FollowersDialog(Type type, MainGui owner, TwitchApi api, final ContextMenuListener contextMenuListener, DockedDialogManager dockedDialogs) {
        super(owner);
        this.contextMenuListener = contextMenuListener;
        this.type = type;
        this.main = owner;
        this.api = api;
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 1, 1, 17);
        this.total.setToolTipText("Total number of " + (Object)((Object)type));
        mainPanel.add((Component)this.total, gbc);
        gbc = GuiUtil.makeGbc(0, 1, 1, 1, 17);
        gbc.insets = new Insets(0, 6, 3, 5);
        gbc.weightx = 1.0;
        this.stats.setToolTipText((Object)((Object)type) + " in the last 7 days (Week), 24 hours (Day) and Hour (based on the current list)");
        if (type == Type.FOLLOWERS) {
            mainPanel.add((Component)this.stats, gbc);
        }
        gbc = GuiUtil.makeGbc(0, 2, 2, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 4, 5, 4);
        this.table = new JTable(this.followers);
        this.table.setShowGrid(false);
        this.table.setTableHeader(null);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new MyRenderer(MyRenderer.Type.NAME));
        this.table.getColumnModel().getColumn(1).setCellRenderer(this.timeRenderer);
        this.table.getColumnModel().getColumn(2).setCellRenderer(this.timeRenderer2);
        int nameMinWidth = this.table.getFontMetrics(this.table.getFont()).stringWidth("reasonblylong");
        this.table.getColumnModel().getColumn(0).setMinWidth(nameMinWidth);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setFont(this.table.getFont().deriveFont(1));
        this.table.setRowHeight(this.table.getFontMetrics(this.table.getFont()).getHeight() + 2);
        this.mainTable = new JScrollPane(this.table);
        mainPanel.add((Component)this.mainTable, gbc);
        JTextArea accessInfoText = new JTextArea(type == Type.FOLLOWERS ? Language.getString("followersDialog.accessInfo") : Language.getString("subscribersDialog.accessInfo"));
        accessInfoText.setLineWrap(true);
        accessInfoText.setWrapStyleWord(true);
        accessInfoText.setEditable(false);
        this.accessInfo = new JScrollPane(accessInfoText);
        mainPanel.add((Component)this.accessInfo, gbc);
        gbc = GuiUtil.makeGbc(0, 3, 1, 1, 17);
        gbc.insets = new Insets(2, 5, 5, 5);
        mainPanel.add((Component)this.loadInfo, gbc);
        this.refreshButton = new JButton(Language.getString("admin.button.reload"));
        this.refreshButton.setMargin(AdminDialog.SMALL_BUTTON_INSETS);
        this.refreshButton.setIcon(new ImageIcon(AdminDialog.class.getResource("view-refresh.png")));
        this.refreshButton.setMnemonic(82);
        this.refreshButton.addActionListener(e -> this.request(true));
        gbc = GuiUtil.makeGbc(1, 3, 1, 1, 13);
        gbc.insets = new Insets(2, 5, 5, 5);
        mainPanel.add((Component)this.refreshButton, gbc);
        Timer timer = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FollowersDialog.this.request(false);
                FollowersDialog.this.update();
                FollowersDialog.this.table.repaint();
            }
        });
        timer.setRepeats(true);
        timer.start();
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FollowersDialog.this.selectClicked(e);
                FollowersDialog.this.openContextMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                FollowersDialog.this.selectClicked(e);
                FollowersDialog.this.openContextMenu(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int selectedRow;
                if (e.getClickCount() == 2 && (selectedRow = FollowersDialog.this.table.getSelectedRow()) != -1) {
                    Follower follower = (Follower)FollowersDialog.this.followers.get(selectedRow);
                    User user = FollowersDialog.this.main.getUser(Helper.toChannel(FollowersDialog.this.stream), follower.name);
                    contextMenuListener.userMenuItemClicked(new ActionEvent(this, 1001, "userinfo"), user, null, null);
                }
            }
        });
        mainPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FollowersDialog.this.openMainContextMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                FollowersDialog.this.openMainContextMenu(e);
            }
        });
        this.add(mainPanel);
        final DockContent content = dockedDialogs.createContent(mainPanel, type.name, type == Type.FOLLOWERS ? "-followers-" : "-subscribers-");
        this.helper = dockedDialogs.createHelper(new DockedDialogHelper.DockedDialog(){

            @Override
            public void setVisible(boolean visible) {
                FollowersDialog.super.setVisible(visible);
            }

            @Override
            public boolean isVisible() {
                return FollowersDialog.super.isVisible();
            }

            @Override
            public void addComponent(Component comp) {
                FollowersDialog.this.add(comp);
            }

            @Override
            public void removeComponent(Component comp) {
                FollowersDialog.this.remove(comp);
            }

            @Override
            public Window getWindow() {
                return FollowersDialog.this;
            }

            @Override
            public DockContent getContent() {
                return content;
            }
        });
        this.helper.setChannelChangeListener(channel -> {
            if (this.isVisible()) {
                this.showDialog(Helper.toStream(channel));
            }
        });
        this.pack();
        this.setSize(300, 400);
        GuiUtil.installEscapeCloseOperation(this);
        this.updateMain();
    }

    private void updateMain() {
        boolean showTable = this.currentInfo == null || this.currentInfo.total == 0 || this.currentInfo.hasFollowers();
        this.mainTable.setVisible(showTable);
        this.accessInfo.setVisible(!showTable);
    }

    @Override
    public void setVisible(boolean visible) {
        this.helper.setVisible(visible, true);
    }

    @Override
    public boolean isVisible() {
        return this.helper.isVisible();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.helper != null) {
            this.helper.getContent().setLongTitle(title);
        }
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
        this.timeRenderer.setCompactMode(compactMode);
        this.timeRenderer2.setCompactMode(compactMode);
        this.updateColumnsAfterSettingChange();
    }

    public void setShowRegistered(boolean show) {
        this.showRegistered = show;
        if (!show) {
            if (this.regColumn == null) {
                TableColumn column = this.table.getColumnModel().getColumn(2);
                this.table.removeColumn(column);
                this.regColumn = column;
            }
        } else if (this.regColumn != null) {
            this.table.addColumn(this.regColumn);
            this.regColumn = null;
        }
        this.updateColumnsAfterSettingChange();
    }

    private void updateColumnsAfterSettingChange() {
        this.adjustColumnSize();
        if (this.currentInfo != null) {
            FollowerInfo current = this.currentInfo;
            this.setFollowerInfo(new FollowerInfo(Follower.Type.FOLLOWER, this.stream, ""));
            this.setFollowerInfo(current);
        }
    }

    private void selectClicked(MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        if (row != -1 && !this.table.isRowSelected(row)) {
            this.table.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    private void openContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int[] selectedRows;
            HashSet<String> streams = new HashSet<String>();
            for (int selectedRow : selectedRows = this.table.getSelectedRows()) {
                Follower selected = this.followers.get(selectedRow);
                streams.add(StringUtil.toLowerCase(selected.name));
            }
            JPopupMenu m = null;
            if (streams.size() == 1) {
                User user = this.main.getUser(Helper.toChannel(this.stream), (String)streams.iterator().next());
                m = new UserContextMenu(user, null, null, this.contextMenuListener);
            } else if (!streams.isEmpty()) {
                m = new StreamsContextMenu(streams, this.contextMenuListener);
            }
            if (m != null) {
                m.addSeparator();
                ((ContextMenu)m).addCheckboxItem("toggleBoolean_followersCompact", "Compact Mode", this.compactMode);
                ((ContextMenu)m).addCheckboxItem("toggleBoolean_followersReg", "Show Registered", this.showRegistered);
                m.show(this.table, e.getX(), e.getY());
            }
        }
    }

    private void openMainContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            MyContextMenu menu = new MyContextMenu();
            menu.addSeparator();
            this.helper.addToContextMenu(menu);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void adjustColumnSize() {
        this.adjustColumnSize(1);
        if (this.showRegistered) {
            this.adjustColumnSize(2);
        }
    }

    private void adjustColumnSize(int column) {
        int width = 0;
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component comp = this.table.prepareRenderer(renderer, row, column);
            width = Math.max(comp.getPreferredSize().width, width);
        }
        this.setColumnWidth(column, width, width, width);
    }

    private void setColumnWidth(int column, int width, int minwidth, int maxwidth) {
        TableColumn tc = this.table.getColumnModel().getColumn(column);
        tc.setPreferredWidth(width);
        if (maxwidth > 0) {
            tc.setMaxWidth(maxwidth);
        }
        if (minwidth > 0) {
            tc.setMinWidth(minwidth);
        }
    }

    private void request(boolean forceRefresh) {
        if (this.isVisible() && this.stream != null && !this.stream.isEmpty()) {
            this.loading = true;
            if (this.type == Type.FOLLOWERS) {
                this.api.getFollowers(this.stream, forceRefresh);
            } else if (this.type == Type.SUBSCRIBERS) {
                this.api.getSubscribers(this.stream, forceRefresh);
            }
        }
    }

    private void update() {
        if (this.currentInfo != null) {
            if (this.currentInfo.requestError) {
                if (this.lastUpdated != -1L) {
                    this.loadInfo.setText(String.format("%s (%s ago, updated %s ago)", this.currentInfo.requestErrorDescription, DateTime.agoSingleCompact(this.currentInfo.time), DateTime.agoSingleCompact(this.lastUpdated)));
                } else {
                    this.loadInfo.setText(String.format("%s (%s ago)", this.currentInfo.requestErrorDescription, DateTime.agoSingleCompact(this.currentInfo.time)));
                }
            } else {
                this.loadInfo.setText(String.format("Last updated %s ago", DateTime.agoSingleVerbose(this.lastUpdated)));
            }
        }
        if (this.loading) {
            this.loadInfo.setText("Loading..");
        }
        this.updateStats();
        this.updateMain();
    }

    public void showDialog(String stream) {
        this.stream = stream;
        this.helper.setCurrentChannel(stream);
        this.setTitle((Object)((Object)this.type) + " of " + stream + " (100 most recent)");
        if (this.currentInfo == null || !this.currentInfo.stream.equals(stream)) {
            this.followers.clear();
            this.total.setText("Total: -");
            this.stats.setText(null);
            this.currentInfo = null;
            this.lastValidInfo = null;
            this.lastUpdated = -1L;
            this.updateStats();
            this.updateMain();
        }
        this.setVisible(true);
        this.request(false);
        this.update();
    }

    public void setFollowerInfo(FollowerInfo info) {
        if (Debugging.isEnabled("followerTest")) {
            info = this.createTestFollowerInfo();
        }
        if (info.stream.equals(this.stream)) {
            this.loading = false;
            if (!(info.requestError || this.currentInfo != null && this.currentInfo.time == info.time)) {
                this.setNewFollowerInfo(info);
            }
            this.currentInfo = info;
            this.update();
        }
    }

    private void setNewFollowerInfo(FollowerInfo info) {
        this.lastValidInfo = info;
        this.followers.setData(info.followers);
        this.updateTotalLabel(info, this.currentInfo);
        this.lastUpdated = info.time;
        this.adjustColumnSize();
    }

    private void updateTotalLabel(FollowerInfo newInfo, FollowerInfo oldInfo) {
        String points = "";
        if (this.type == Type.SUBSCRIBERS) {
            points = String.format(" (%s Points)", Helper.formatViewerCount(newInfo.totalPoints));
        }
        if (oldInfo != null && newInfo != oldInfo && oldInfo.stream.equals(this.stream) && !oldInfo.requestError) {
            int change = newInfo.total - oldInfo.total;
            String changeString = "";
            if (change < 0) {
                changeString = " (" + String.valueOf(change) + ")";
            } else if (change > 0) {
                changeString = " (+" + change + ")";
            }
            this.total.setText("Total: " + Helper.formatViewerCount(newInfo.total) + changeString + points);
        } else {
            this.total.setText("Total: " + Helper.formatViewerCount(newInfo.total) + points);
        }
    }

    private void updateStats() {
        if (this.lastValidInfo != null) {
            this.stats.setText("| " + Stats.makeFullStats(this.lastValidInfo));
        } else {
            this.stats.setText("| Week: - | Day: - | Hour: -");
        }
    }

    private void saveToFile(boolean onlyName) {
        FollowerInfo info = this.lastValidInfo;
        if (info != null) {
            Path path = Chatty.getPath(Chatty.PathType.EXPORT);
            Path file = path.resolve(StringUtil.toLowerCase(this.type.toString()) + ".txt");
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);){
                    for (Follower f : this.lastValidInfo.followers) {
                        writer.write(f.name);
                        if (!onlyName) {
                            if (f.follow_time != -1L) {
                                writer.write("\t" + DateTime.formatFullDatetime(f.follow_time));
                                writer.write(" (" + DateTime.agoSingleVerbose(f.follow_time) + ")");
                            }
                            if (f.verboseInfo != null) {
                                writer.write("\t" + f.verboseInfo);
                            }
                        }
                        writer.newLine();
                    }
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, ex, "Failed to write file.", 0);
                return;
            }
            JOptionPane.showMessageDialog(this, (Object)((Object)this.type) + " exported to: " + file, "File written.", 1);
        } else {
            JOptionPane.showMessageDialog(this, "No data to write.", "Failed to write file.", 0);
        }
    }

    private FollowerInfo createTestFollowerInfo() {
        ArrayList<Follower> test = new ArrayList<Follower>();
        test.add(FollowersDialog.createTestFollower(this.stream, 30L, 1440L, true));
        test.add(FollowersDialog.createTestFollower(this.stream, 80L, 26088L, true));
        test.add(FollowersDialog.createTestFollower(this.stream, 90L, 1L, true));
        test.add(FollowersDialog.createTestFollower(this.stream, 120L, 10L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 180L, 288L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 680L, 36L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 980L, 120L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 1800L, 19200L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 1900L, 12000L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 2900L, 12000L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 3600L, 7704L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 3600L, 29616L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 3600L, 391L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 7200L, 60L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 10800L, 2952L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 10800L, 120L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 172800L, 24L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 259200L, 5616L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 691200L, 288L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 7776000L, 19200L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 7776000L, 301056L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 15552000L, 21600L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 15552000L, 21600L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 15552000L, 21600L, false));
        test.add(FollowersDialog.createTestFollower(this.stream, 15552000L, 21600L, false));
        return new FollowerInfo(Follower.Type.FOLLOWER, this.stream, test, 1338, -1);
    }

    private static Follower createTestFollower(String name, long timeOffset, long userOffset, boolean newFollower) {
        boolean refollow = ThreadLocalRandom.current().nextInt(20) == 0;
        return new Follower(Follower.Type.FOLLOWER, name, name, System.currentTimeMillis() - timeOffset * 1000L, System.currentTimeMillis() - userOffset * 60L * 60L * 1000L, refollow, newFollower, null, null);
    }

    private class MyListTableModel
    extends ListTableModel<Follower> {
        public MyListTableModel() {
            super(new String[]{"Name", "Followed", "User Created"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.get(rowIndex);
        }
    }

    private static class MyRenderer
    extends DefaultTableCellRenderer {
        private static final Color BG_COLOR_NEW = LaF.isDarkTheme() ? new Color(114, 0, 0) : new Color(255, 245, 210);
        private static final Color BG_COLOR_RECENT;
        private static final Color COLOR_OLDER_THAN_WEEK;
        private static final Color COLOR_OLDER_THAN_DAY;
        private final Type type;
        private boolean compactMode;

        public MyRenderer(Type type) {
            this.type = type;
            this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        }

        public void setCompactMode(boolean compactMode) {
            this.compactMode = compactMode;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setToolTipText("error");
                return this;
            }
            Follower f = (Follower)value;
            if (this.type == Type.NAME) {
                if (f.name.equalsIgnoreCase(f.display_name)) {
                    this.setText(f.display_name);
                    this.setToolTipText(null);
                } else {
                    this.setText(f.display_name + " (" + f.name + ")");
                    this.setToolTipText(f.name);
                }
            } else if (this.type == Type.TIME) {
                if (f.info != null) {
                    this.setText(f.info);
                    this.setToolTipText(f.verboseInfo);
                } else {
                    if (this.compactMode) {
                        this.setText(DateTime.agoSingleCompact(f.follow_time));
                    } else {
                        this.setText(DateTime.agoSingleVerbose(f.follow_time));
                    }
                    this.setToolTipText(DateTime.formatFullDatetime(f.follow_time));
                }
            } else if (this.type == Type.USER_TIME) {
                if (f.user_created_time != -1L) {
                    if (this.compactMode) {
                        this.setText("(" + DateTime.agoSingleCompact(f.user_created_time) + ")");
                    } else {
                        this.setText("(" + DateTime.agoSingleVerbose(f.user_created_time) + ")");
                    }
                    this.setToolTipText("Registered " + DateTime.formatFullDatetime(f.user_created_time));
                } else {
                    this.setText("(n/a)");
                    this.setToolTipText("Time when user registered not available");
                }
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
                long ago = (System.currentTimeMillis() - f.follow_time) / 1000L;
                if (f.newFollower) {
                    this.setBackground(BG_COLOR_NEW);
                } else if (ago < 3600L) {
                    this.setBackground(BG_COLOR_RECENT);
                } else {
                    this.setBackground(table.getBackground());
                }
                if (this.type == Type.TIME) {
                    if (ago > 604800L) {
                        this.setForeground(COLOR_OLDER_THAN_WEEK);
                    } else if (ago > 86400L) {
                        this.setForeground(COLOR_OLDER_THAN_DAY);
                    }
                }
                if (this.type == Type.USER_TIME && f.user_created_time != -1L) {
                    long registeredAgo = (System.currentTimeMillis() - f.user_created_time) / 1000L;
                    if (registeredAgo >= 604800L) {
                        this.setForeground(COLOR_OLDER_THAN_WEEK);
                    } else if (registeredAgo >= 86400L) {
                        this.setForeground(COLOR_OLDER_THAN_DAY);
                    }
                }
                if (this.type == Type.NAME && f.refollow) {
                    this.setForeground(Color.GRAY);
                }
            }
            if (this.type == Type.TIME) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            return this;
        }

        static {
            JTable table = new JTable();
            BG_COLOR_RECENT = ColorCorrectionNew.offset(table.getBackground(), 0.96f);
            COLOR_OLDER_THAN_WEEK = ColorCorrectionNew.offset(table.getForeground(), 0.6f);
            COLOR_OLDER_THAN_DAY = ColorCorrectionNew.offset(table.getForeground(), 0.78f);
        }

        public static enum Type {
            NAME,
            TIME,
            USER_TIME;

        }
    }

    public static enum Type {
        FOLLOWERS("Followers"),
        SUBSCRIBERS("Subscribers");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class MyContextMenu
    extends ContextMenu {
        public MyContextMenu() {
            String saveMenu = "Export list to file";
            this.addItem("saveSimple", "Names only", "Export list to file");
            this.addItem("saveVerbose", "Names and extra info", "Export list to file");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("saveSimple")) {
                FollowersDialog.this.saveToFile(true);
            } else if (e.getActionCommand().equals("saveVerbose")) {
                FollowersDialog.this.saveToFile(false);
            }
            FollowersDialog.this.helper.menuAction(e);
        }
    }

    private static class Stats {
        private static final Map<Integer, String> TIMES = new LinkedHashMap<Integer, String>();
        private static final Map<Integer, String> TIMES2 = new LinkedHashMap<Integer, String>();

        private Stats() {
        }

        private static void add(int seconds, String label) {
            TIMES.put(seconds, label);
        }

        private static void add2(int seconds, String label) {
            TIMES2.put(seconds, label);
        }

        private static String makeFullStats(FollowerInfo info) {
            if (info.requestError) {
                return "";
            }
            StringBuilder b = new StringBuilder();
            List<Follower> followers = info.followers;
            boolean first = true;
            for (Integer time : TIMES2.keySet()) {
                if (!first) {
                    b.append(" | ");
                }
                b.append(Stats.statsForTime(followers, time, TIMES2.get(time)));
                first = false;
            }
            return b.toString();
        }

        private static String statsForTime(List<Follower> followers, int seconds, String label) {
            boolean ok = false;
            for (int i = followers.size() - 1; i >= 0; --i) {
                Follower f = followers.get(i);
                if ((System.currentTimeMillis() - f.follow_time) / 1000L <= (long)seconds) {
                    if (ok) {
                        return label + ": " + (i + 1);
                    }
                    return label + ": " + i + "+";
                }
                ok = true;
            }
            return label + ": 0";
        }

        private static String makeStats(FollowerInfo info) {
            if (info.requestError) {
                return "";
            }
            List<Follower> followers = info.followers;
            for (Integer time : TIMES.keySet()) {
                boolean ok = false;
                for (int i = followers.size() - 1; i > 0; --i) {
                    Follower f = followers.get(i);
                    if ((System.currentTimeMillis() - f.follow_time) / 1000L > (long)time.intValue()) {
                        ok = true;
                        continue;
                    }
                    if (!ok) continue;
                    return TIMES.get(time) + ": " + (i + 1);
                }
            }
            return "";
        }

        static {
            Stats.add(2592000, "This Month");
            Stats.add(604800, "This Week");
            Stats.add(86400, "Today");
            Stats.add(3600, "Last Hour");
            Stats.add(1800, "Last 30 Minutes");
            Stats.add(900, "Last 15 Minutes");
            Stats.add(300, "Last 5 Minutes");
            Stats.add2(604800, "Week");
            Stats.add2(86400, "Day");
            Stats.add2(3600, "Hour");
        }
    }
}

