/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.User;
import chatty.gui.DockStyledTabContainer;
import chatty.gui.DockedDialogHelper;
import chatty.gui.DockedDialogManager;
import chatty.gui.Highlighter;
import chatty.gui.MainGui;
import chatty.gui.StyleServer;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuAdapter;
import chatty.gui.components.menus.ContextMenuHelper;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.HighlightsContextMenu;
import chatty.gui.components.textpane.ChannelTextPane;
import chatty.gui.components.textpane.InfoMessage;
import chatty.gui.components.textpane.MyStyleConstants;
import chatty.gui.components.textpane.UserMessage;
import chatty.util.StringUtil;
import chatty.util.Timestamp;
import chatty.util.api.Emoticons;
import chatty.util.colors.ColorCorrector;
import chatty.util.dnd.DockContent;
import chatty.util.irc.MsgTags;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class HighlightedMessages
extends JDialog {
    private final TextPane messages;
    private final ChannelTextPane.Type type;
    private final DockedDialogHelper helper;
    private final MainGui main;
    private String currentChannel;
    private int currentChannelMessageCount = 0;
    private int displayedCount;
    private int newCount;
    private boolean setChatIconsYet = false;
    private final String title;
    private final String label;
    private final DockStyledTabContainer content;
    private static final int SHOW_LEGACY_INDEX = 0;
    private static final int CHANNEL_LOGO_INDEX = 1;
    private static final int CHANNEL_NAME_INDEX = 2;

    public HighlightedMessages(MainGui owner, final StyleServer styleServer, String title, String shortTitle, String label, ContextMenuListener contextMenuListener, DockedDialogManager dockedDialogs, String settingName) {
        super(owner);
        ChannelTextPane.Type textPaneType;
        this.main = owner;
        this.title = title;
        this.label = label;
        this.updateTitle();
        this.addComponentListener(new MyVisibleListener());
        StyleServer modifiedStyleServer = new StyleServer(){

            @Override
            public Color getColor(String type) {
                if (type.equals("highlight")) {
                    return styleServer.getColor("foreground");
                }
                if (type.equals("highlightBackground")) {
                    return styleServer.getColor("background");
                }
                return styleServer.getColor(type);
            }

            @Override
            public MutableAttributeSet getStyle(String type) {
                if (type.equals("highlight")) {
                    return this.getStyle("standard");
                }
                if (type.equals("paragraph")) {
                    SimpleAttributeSet attr = new SimpleAttributeSet(styleServer.getStyle(type));
                    MyStyleConstants.setHighlightBackground(attr, null);
                    return attr;
                }
                if (type.equals("settings")) {
                    SimpleAttributeSet attr = new SimpleAttributeSet(styleServer.getStyle(type));
                    attr.addAttribute((Object)ChannelTextPane.Setting.SHOW_BANMESSAGES, false);
                    attr.addAttribute((Object)ChannelTextPane.Setting.CHANNEL_LOGO_SIZE, HighlightedMessages.this.channelLogo());
                    attr.addAttribute((Object)ChannelTextPane.Setting.SHOW_CHANNEL_NAME, HighlightedMessages.this.showChannelName());
                    return attr;
                }
                return styleServer.getStyle(type);
            }

            @Override
            public Font getFont(String type) {
                return styleServer.getFont(type);
            }

            @Override
            public Timestamp getTimestampFormat() {
                return styleServer.getTimestampFormat();
            }

            @Override
            public ColorCorrector getColorCorrector() {
                return styleServer.getColorCorrector();
            }
        };
        this.type = textPaneType = settingName.equals("highlightDock") ? ChannelTextPane.Type.HIGHLIGHTS : ChannelTextPane.Type.IGNORED;
        this.messages = new TextPane(owner, modifiedStyleServer, textPaneType, () -> new HighlightsContextMenu(this.isDocked(), this.autoOpenActivity(), this.showLegacy(), this.channelLogo(), this.showChannelName()));
        this.messages.setContextMenuListener(new ContextMenuAdapter(contextMenuListener){

            @Override
            public void menuItemClicked(ActionEvent e) {
                switch (e.getActionCommand()) {
                    case "clearHighlights": {
                        HighlightedMessages.this.clear();
                        break;
                    }
                }
                ContextMenuHelper.handleNumericOption(e.getActionCommand(), "logoSize", size -> HighlightedMessages.this.updateSettings(HighlightedMessages.this.showLegacy(), size, HighlightedMessages.this.showChannelName()));
                ContextMenuHelper.handleNumericOption(e.getActionCommand(), "showChannelName", length -> HighlightedMessages.this.updateSettings(HighlightedMessages.this.showLegacy(), HighlightedMessages.this.channelLogo(), length));
                ContextMenuHelper.handleNumericOption(e.getActionCommand(), "legacyChannelName", on -> HighlightedMessages.this.updateSettings(on, HighlightedMessages.this.channelLogo(), HighlightedMessages.this.showChannelName()));
                HighlightedMessages.this.helper.menuAction(e);
                super.menuItemClicked(e);
            }
        });
        JScrollPane scroll = new JScrollPane(this.messages);
        this.messages.setScrollPane(scroll);
        this.add(scroll);
        this.content = dockedDialogs.createStyledContent(scroll, shortTitle, settingName.equals("highlightDock") ? "-highlight-" : "-ignore-");
        this.helper = dockedDialogs.createHelper(new DockedDialogHelper.DockedDialog(){

            @Override
            public void setVisible(boolean visible) {
                HighlightedMessages.super.setVisible(visible);
            }

            @Override
            public boolean isVisible() {
                return HighlightedMessages.super.isVisible();
            }

            @Override
            public void addComponent(Component comp) {
                HighlightedMessages.this.add(comp);
            }

            @Override
            public void removeComponent(Component comp) {
                HighlightedMessages.this.remove(comp);
            }

            @Override
            public Window getWindow() {
                return HighlightedMessages.this;
            }

            @Override
            public DockContent getContent() {
                return HighlightedMessages.this.content;
            }
        });
        this.setPreferredSize(new Dimension(400, 300));
        this.pack();
    }

    private boolean isDocked() {
        return this.helper.isDocked();
    }

    private boolean autoOpenActivity() {
        return this.helper.autoOpenActivity();
    }

    @Override
    public void setVisible(boolean visible) {
        this.setVisible(visible, true);
    }

    public void setVisible(boolean visible, boolean switchTo) {
        this.helper.setVisible(visible, switchTo);
        if (visible) {
            this.newCount = 0;
        }
    }

    @Override
    public boolean isVisible() {
        return this.helper.isVisible();
    }

    public void addMessage(String channel, UserMessage message) {
        this.messageAdded(channel);
        this.messages.printMessage(message);
    }

    public void addMessage(String channel, User user, String text, boolean action, Emoticons.TagEmotes emotes, int bits, boolean whisper, List<Highlighter.Match> highlightMatches, Object highlightSource, MsgTags tags) {
        this.messageAdded(channel);
        UserMessage message = new UserMessage(user, text, emotes, null, bits, highlightMatches, null, null, tags);
        message.whisper = whisper;
        if (this.messages.type == ChannelTextPane.Type.HIGHLIGHTS) {
            message.highlightSource = highlightSource;
        } else if (this.messages.type == ChannelTextPane.Type.IGNORED) {
            message.ignoreSource = highlightSource;
        }
        this.messages.printMessage(message);
    }

    public void addInfoMessage(String channel, InfoMessage message) {
        this.messageAdded(channel);
        this.messages.printInfoMessage(message);
    }

    public void addInfoMessage(String channel, String text, List<Highlighter.Match> highlightMatches, Object highlightSource, User localUser) {
        this.messageAdded(channel);
        InfoMessage message = InfoMessage.createInfo(text);
        message.highlightMatches = highlightMatches;
        if (this.messages.type == ChannelTextPane.Type.HIGHLIGHTS) {
            message.highlightSource = highlightSource;
        } else if (this.messages.type == ChannelTextPane.Type.IGNORED) {
            message.ignoreSource = highlightSource;
        }
        message.localUser = localUser;
        this.messages.printInfoMessage(message);
    }

    public void addBan(User user, long duration, String reason, String targetMsgId) {
        this.messages.userBanned(user, duration, reason, targetMsgId);
    }

    private void messageAdded(String channel) {
        if (!(this.currentChannel != null && this.currentChannel.equals(channel) && this.currentChannelMessageCount <= 12 || this.showLegacy() <= 0L)) {
            this.messages.printLine(MessageFormat.format(this.label, channel));
            this.currentChannel = channel;
            this.currentChannelMessageCount = 0;
        }
        ++this.currentChannelMessageCount;
        ++this.displayedCount;
        this.updateTitle();
        if (!this.isVisible()) {
            ++this.newCount;
        }
        this.helper.setActivity();
        if (this.helper.isDocked() && !this.content.isContentVisible()) {
            this.content.setNewMessage(true);
        }
    }

    private void updateTitle() {
        if (this.displayedCount > 0) {
            this.setTitle(this.title + " (" + this.displayedCount + ")");
        } else {
            this.setTitle(this.title);
        }
    }

    public void refreshStyles() {
        this.messages.refreshStyles();
        Long bufferSize = (Long)this.main.getSettings().mapGet("bufferSizes", StringUtil.toLowerCase(this.content.getId()));
        this.messages.setBufferSize(bufferSize != null ? bufferSize.intValue() : -1);
    }

    public void clear() {
        this.messages.clear();
        this.currentChannel = null;
        this.currentChannelMessageCount = 0;
        this.displayedCount = 0;
        this.updateTitle();
    }

    public int getDisplayedCount() {
        return this.displayedCount;
    }

    public int getNewCount() {
        return this.newCount;
    }

    private String settingName() {
        switch (this.type) {
            case HIGHLIGHTS: {
                return "highlightDialog";
            }
            case IGNORED: {
                return "ignoreDialog";
            }
        }
        return null;
    }

    private long showLegacy() {
        return this.main.getSettings().listGetLong(this.settingName(), 0, 0L);
    }

    private long channelLogo() {
        return this.main.getSettings().listGetLong(this.settingName(), 1, 22L);
    }

    private long showChannelName() {
        return this.main.getSettings().listGetLong(this.settingName(), 2, 0L);
    }

    private void updateSettings(long legacy, long logoSize, long channelName) {
        ArrayList<Long> settingsValue = new ArrayList<Long>();
        settingsValue.add(legacy);
        settingsValue.add(logoSize);
        settingsValue.add(channelName);
        this.main.getSettings().putList(this.settingName(), settingsValue);
        this.refreshStyles();
    }

    private class MyVisibleListener
    extends ComponentAdapter {
        private MyVisibleListener() {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            HighlightedMessages.this.newCount = 0;
        }
    }

    static class TextPane
    extends ChannelTextPane {
        public TextPane(MainGui main, StyleServer styleServer, ChannelTextPane.Type type, Supplier<ContextMenu> contextMenuCreator) {
            super(main, styleServer, type, true, main.getSettings().getBoolean("chatInsertTop"));
            this.linkController.setContextMenuCreator(contextMenuCreator);
        }

        public void clear() {
            this.setText("");
        }
    }
}

