/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JList;

public class JListActionHelper<T>
implements MouseListener,
KeyListener {
    private final JList<T> list;
    private final JListContextMenuListener<T> listener;
    private final boolean allowClearSelection;

    public JListActionHelper(JList<T> list, JListContextMenuListener<T> listener, boolean allowClearSelection) {
        this.list = list;
        this.listener = listener;
        this.allowClearSelection = allowClearSelection;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.selectClicked(e, true);
        this.checkOpenContextMenu(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkOpenContextMenu(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.otherAction(Action.DOUBLE_CLICK);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void selectClicked(MouseEvent e, boolean onlyOutside) {
        int index = this.list.locationToIndex(e.getPoint());
        Rectangle bounds = this.list.getCellBounds(index, index);
        if (bounds != null && bounds.contains(e.getPoint())) {
            if (!onlyOutside) {
                if (this.list.isSelectedIndex(index)) {
                    this.list.addSelectionInterval(index, index);
                } else {
                    this.list.setSelectedIndex(index);
                }
            }
        } else if (this.allowClearSelection) {
            this.list.clearSelection();
        }
    }

    private void checkOpenContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.selectClicked(e, false);
            this.openContextMenu(e.getPoint());
        }
    }

    private void openContextMenu(Point location) {
        List<T> selected = this.list.getSelectedValuesList();
        this.listener.handleAction(Action.CONTEXT_MENU, location, selected);
    }

    private void otherAction(Action action) {
        this.listener.handleAction(action, this.getSelectedLocation(), this.list.getSelectedValuesList());
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 525) {
            this.openContextMenu(this.getSelectedLocation());
        } else if (e.getKeyCode() == 10) {
            if (e.isControlDown()) {
                this.otherAction(Action.CTRL_ENTER);
            } else {
                this.otherAction(Action.ENTER);
            }
        } else if (e.getKeyCode() == 32) {
            this.otherAction(Action.SPACE);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private Point getSelectedLocation() {
        int selected = this.list.getSelectedIndex();
        Rectangle b = this.list.getCellBounds(selected, selected);
        if (b != null) {
            return new Point(b.x, b.y);
        }
        return new Point(0, 0);
    }

    public static <T> void install(JList<T> list, JListContextMenuListener<T> listener) {
        JListActionHelper<T> helper = new JListActionHelper<T>(list, listener, true);
        list.addMouseListener(helper);
        list.addKeyListener(helper);
    }

    public static <T> void install(JList<T> list, JListContextMenuListener<T> listener, boolean allowClearSelection) {
        JListActionHelper<T> helper = new JListActionHelper<T>(list, listener, allowClearSelection);
        list.addMouseListener(helper);
        list.addKeyListener(helper);
    }

    public static interface JListContextMenuListener<T> {
        public void handleAction(Action var1, Point var2, List<T> var3);
    }

    public static enum Action {
        CONTEXT_MENU,
        ENTER,
        CTRL_ENTER,
        DOUBLE_CLICK,
        SPACE;

    }
}

