/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.Helper;
import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.menus.TextSelectionMenu;
import chatty.lang.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JoinDialog
extends JDialog {
    private final JTextField channels = new JTextField(20);
    private final JButton joinButton = new JButton(Language.getString("join.button.join"));
    private final JButton cancelButton = new JButton(Language.getString("dialog.button.cancel"));
    private final JButton favoritesButton = new JButton(Language.getString("join.button.favoritesHistory"));
    private boolean join = false;

    public JoinDialog(final MainGui owner) {
        super(owner);
        this.setTitle(Language.getString("join.title"));
        this.setResizable(false);
        this.setModal(true);
        this.setLayout(new GridBagLayout());
        this.channels.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JoinDialog.this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JoinDialog.this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JoinDialog.this.changed();
            }
        });
        GuiUtil.installLengthLimitDocumentFilter(this.channels, 80000, false, new Object[0]);
        TextSelectionMenu.install(this.channels);
        GridBagConstraints gbc = this.makeGbc(0, 0, 1, 1);
        JLabel label = new JLabel(Language.getString("join.channel"));
        label.setLabelFor(this.channels);
        this.add((Component)label, gbc);
        gbc = this.makeGbc(1, 0, 2, 1);
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        this.add((Component)this.channels, gbc);
        gbc = this.makeGbc(1, 1, 2, 1);
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 5, 5);
        this.favoritesButton.setPreferredSize(new Dimension(100, 20));
        this.favoritesButton.setMnemonic(70);
        this.add((Component)this.favoritesButton, gbc);
        gbc = this.makeGbc(1, 2, 1, 1);
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 5, 5);
        gbc.weightx = 0.8;
        this.add((Component)this.joinButton, gbc);
        gbc = this.makeGbc(2, 2, 1, 1);
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 5, 5);
        this.add((Component)this.cancelButton, gbc);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == JoinDialog.this.joinButton || e.getSource() == JoinDialog.this.channels) {
                    JoinDialog.this.join = true;
                    JoinDialog.this.setVisible(false);
                } else if (e.getSource() == JoinDialog.this.cancelButton) {
                    JoinDialog.this.setVisible(false);
                } else if (e.getSource() == JoinDialog.this.favoritesButton) {
                    Set<String> selectedFavorites = owner.chooseFavorites(JoinDialog.this, "");
                    JoinDialog.this.channels.setText(Helper.buildStreamsString(selectedFavorites));
                }
            }
        };
        this.joinButton.addActionListener(listener);
        this.cancelButton.addActionListener(listener);
        this.favoritesButton.addActionListener(listener);
        this.channels.addActionListener(listener);
        this.pack();
    }

    public Set<String> showDialog() {
        this.channels.setText("");
        this.join = false;
        this.changed();
        this.channels.requestFocusInWindow();
        this.setVisible(true);
        if (!this.join) {
            this.channels.setText("");
        }
        return this.getChannels();
    }

    private Set<String> getChannels() {
        String chans = this.channels.getText();
        return Helper.parseChannelsFromString(chans, false);
    }

    private void changed() {
        Set<String> chans = this.getChannels();
        boolean empty = chans.isEmpty();
        this.joinButton.setEnabled(!empty);
        this.joinButton.setText(Language.getString("join.button.join", chans.size()));
    }

    private GridBagConstraints makeGbc(int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(3, 3, 3, 3);
        return gbc;
    }
}

