/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.gui.components.LinkLabelListener;
import chatty.gui.laf.LaF;
import chatty.util.colors.HtmlColors;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class LinkLabel
extends JEditorPane {
    private LinkLabelListener listener;
    private Color foreground;

    public LinkLabel(String text, LinkLabelListener listener) {
        this.listener = listener;
        this.setEditable(false);
        this.setOpaque(false);
        this.setContentType("text/html");
        this.setText(text);
        this.setCaretPosition(0);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    LinkLabel.this.linkClicked(e.getDescription());
                }
            }
        });
        this.setStyle();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LinkLabel.this.setCaretPosition(1);
            }
        });
        this.getAccessibleContext().setAccessibleName("Help Text");
        this.getAccessibleContext().setAccessibleDescription("");
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
        this.setStyle();
    }

    private void setStyle() {
        if (this.getDocument() == null || !(this.getDocument() instanceof HTMLDocument)) {
            return;
        }
        JLabel label = new JLabel();
        this.setFont(label.getFont());
        Font font = label.getFont();
        String bold = font.getStyle() == 1 ? "bold" : "normal";
        String color = HtmlColors.getColorString(label.getForeground());
        String linkColor = LaF.getLinkColor();
        String codeColors = "code { background: white; color: black; }";
        if (LaF.isDarkTheme()) {
            codeColors = "code { background: #444444; color: white; }";
        }
        if (this.foreground != null) {
            color = HtmlColors.getColorString(this.foreground);
            linkColor = HtmlColors.getColorString(this.foreground);
        }
        String fontRule = "body { font-family: " + font.getFamily() + ";font-size: " + font.getSize() + ";font-weight: " + bold + ";color: " + color + ";}a {color: " + linkColor + ";}code { font-size: 1em; }" + codeColors;
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(fontRule);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setStyle();
    }

    @Override
    public final void setText(String text) {
        if (text != null) {
            text = text.replaceAll("\\[([^] ]+) ([^]]+)\\]", "<a href=\"$1\">$2</a>");
        }
        super.setText(text);
    }

    public void addRule(String css) {
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(css);
    }

    public void setListener(LinkLabelListener listener) {
        this.listener = listener;
    }

    private void linkClicked(String link) {
        String[] parts = link.split(":", 2);
        if (parts.length == 2 && this.listener != null) {
            this.listener.linkClicked(parts[0], parts[1]);
        }
    }
}

