/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.ChannelFavorites;
import chatty.gui.DockedDialogHelper;
import chatty.gui.DockedDialogManager;
import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.TwitchUrl;
import chatty.gui.components.ChannelInfoDialog;
import chatty.gui.components.LiveStreamListener;
import chatty.gui.components.LiveStreamsList;
import chatty.gui.components.LiveStreamsRemovedList;
import chatty.gui.components.SortedListModel;
import chatty.gui.components.menus.CommandActionEvent;
import chatty.gui.components.menus.ContextMenuAdapter;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.settings.CommandSettings;
import chatty.lang.Language;
import chatty.util.api.StreamInfo;
import chatty.util.commands.CustomCommand;
import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockContentContainer;
import chatty.util.settings.Settings;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class LiveStreamsDialog
extends JFrame {
    private final ChannelInfoDialog channelInfo;
    private final JScrollPane scroll;
    private final LiveStreamsList list;
    private final LiveStreamsRemovedList removedList;
    private final CardLayout cardLayout;
    private String titleSorting = "";
    private String titleCounts = "";
    private boolean liveStreamListSelected = true;
    private final DockedDialogHelper helper;
    private final ContextMenuListener listener;
    private final Settings settings;

    public LiveStreamsDialog(MainGui g, ContextMenuListener listener, ChannelFavorites favs, Settings settings, DockedDialogManager dockedDialogs) {
        this.setTitle("Live Streams");
        this.setPreferredSize(new Dimension(280, 350));
        this.listener = listener;
        this.settings = settings;
        MyContextMenuListener localCml = new MyContextMenuListener();
        LiveStreamListener localLiveStreamListener = new LiveStreamListener(){

            @Override
            public void liveStreamClicked(Collection<StreamInfo> streams) {
                if (streams.isEmpty()) {
                    return;
                }
                LiveStreamsDialog.this.handleStreamsAction(streams, false);
            }
        };
        this.list = new LiveStreamsList(localLiveStreamListener, favs, settings);
        this.list.addContextMenuListener(listener);
        this.list.addContextMenuListener(localCml);
        this.setSorting(Sorting.RECENT, true);
        this.list.addListDataChangedListener(new LiveStreamsList.ListDataChangedListener(){

            @Override
            public void listDataChanged() {
                LiveStreamsDialog.this.listUpdated();
            }

            @Override
            public void itemRemoved(StreamInfo item) {
                LiveStreamsDialog.this.removedList.addStreamInfo(item);
            }

            @Override
            public void itemAdded(StreamInfo item) {
                LiveStreamsDialog.this.removedList.removeStreamInfo(item);
            }
        });
        this.removedList = new LiveStreamsRemovedList(localLiveStreamListener);
        this.removedList.addContextMenuListener(localCml);
        this.removedList.addContextMenuListener(listener);
        this.removedList.addBackButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveStreamsDialog.this.switchList();
            }
        });
        this.channelInfo = new ChannelInfoDialog((Frame)this, null);
        GuiUtil.installEscapeCloseOperation(this.channelInfo);
        this.channelInfo.addContextMenuListener(listener);
        this.cardLayout = new CardLayout();
        JPanel mainPanel = new JPanel(this.cardLayout);
        this.scroll = new JScrollPane(this.list);
        this.scroll.getVerticalScrollBar().setUnitIncrement(20);
        this.scroll.setVerticalScrollBarPolicy(22);
        mainPanel.add(this.scroll);
        mainPanel.add(this.removedList);
        this.add(mainPanel);
        this.pack();
        final DockContentContainer<JPanel> content = new DockContentContainer<JPanel>("Live", mainPanel, dockedDialogs.getDockManager());
        content.setId("-liveStreams-");
        this.helper = dockedDialogs.createHelper(new DockedDialogHelper.DockedDialog(){

            @Override
            public void setVisible(boolean visible) {
                LiveStreamsDialog.super.setVisible(visible);
            }

            @Override
            public boolean isVisible() {
                return LiveStreamsDialog.super.isVisible();
            }

            @Override
            public void addComponent(Component comp) {
                LiveStreamsDialog.this.add(comp);
            }

            @Override
            public void removeComponent(Component comp) {
                LiveStreamsDialog.this.remove(comp);
            }

            @Override
            public Window getWindow() {
                return LiveStreamsDialog.this;
            }

            @Override
            public DockContent getContent() {
                return content;
            }
        });
        this.list.setDockedDialogHelper(this.helper);
    }

    public boolean isDocked() {
        if (this.helper != null) {
            return this.helper.isDocked();
        }
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.helper.setVisible(visible, true);
    }

    @Override
    public boolean isVisible() {
        if (this.helper != null) {
            return this.helper.isVisible();
        }
        return super.isVisible();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.helper != null) {
            this.helper.getContent().setLongTitle(title);
        }
    }

    public void addStream(StreamInfo streamInfo) {
        this.list.addStream(streamInfo);
        this.channelInfo.update(streamInfo);
    }

    public void setSorting(String sorting, boolean favFirst) {
        Sorting s = Sorting.fromKey(sorting);
        if (s != null) {
            this.setSorting(s, favFirst);
        }
    }

    public void setFiltering(boolean favsOnly) {
        this.list.setFiltering(favsOnly);
        this.updateTitle();
    }

    public void setHistoryRange(int range) {
        this.channelInfo.setHistoryRange(range);
    }

    public void setHistoryVerticalZoom(boolean zoom) {
        this.channelInfo.setHistoryVerticalZoom(zoom);
    }

    private void setSorting(Sorting s, boolean favFirst) {
        this.titleSorting = s.getLabel();
        this.updateTitle();
        this.list.setComparator(s, favFirst);
    }

    private void updateTitle() {
        if (this.liveStreamListSelected) {
            int shown = this.list.getModel().getSize();
            int total = ((SortedListModel)this.list.getModel()).getTotalSize();
            this.setTitle(Language.getString("streams.title", shown == total ? Integer.valueOf(shown) : shown + "/" + total, this.titleSorting));
        } else {
            this.setTitle(Language.getString("streams.removed.title"));
        }
    }

    private void listUpdated() {
        this.titleCounts = String.valueOf(this.list.getModel().getSize());
        this.updateTitle();
    }

    private void openChannelInfoDialog(StreamInfo info) {
        if (!this.channelInfo.isVisible()) {
            this.channelInfo.setLocationRelativeTo(this.helper.getContent().getComponent());
        }
        this.channelInfo.set(info);
        this.channelInfo.setVisible(true);
    }

    private void switchList() {
        this.liveStreamListSelected = !this.liveStreamListSelected;
        this.updateTitle();
        this.cardLayout.next(this.helper.getContent().getComponent());
    }

    public void handleStreamsAction(Collection<StreamInfo> streams, boolean external) {
        Function<String, String> makeOpenCommand = url -> "/chain /foreach $fs($1-) > /openUrl " + url + " | /join $replace($1-, ,\\,)";
        switch (OpenAction.fromKey(this.settings.getString("liveStreamsAction"))) {
            case INFO: {
                if (!external) {
                    this.openChannelInfoDialog(streams.iterator().next());
                    break;
                }
                CustomCommand command = CustomCommand.parse("/join $replace($1-, ,\\,)");
                CommandActionEvent e = new CommandActionEvent(new ActionEvent(this, 1001, "command"), command);
                this.listener.streamInfosMenuItemClicked(e, streams);
                break;
            }
            case JOIN: {
                CustomCommand command = CustomCommand.parse("/join $replace($1-, ,\\,)");
                CommandActionEvent e = new CommandActionEvent(new ActionEvent(this, 1001, "command"), command);
                this.listener.streamInfosMenuItemClicked(e, streams);
                break;
            }
            case STREAM: {
                CustomCommand command = CustomCommand.parse(makeOpenCommand.apply(TwitchUrl.makeTwitchStreamUrl("\\$1")));
                CommandActionEvent e = new CommandActionEvent(new ActionEvent(this, 1001, "command"), command);
                this.listener.streamInfosMenuItemClicked(e, streams);
                break;
            }
            case STREAM_POPOUT: {
                CustomCommand command = CustomCommand.parse(makeOpenCommand.apply(TwitchUrl.makeTwitchPlayerUrl("\\$1")));
                CommandActionEvent e = new CommandActionEvent(new ActionEvent(this, 1001, "command"), command);
                this.listener.streamInfosMenuItemClicked(e, streams);
                break;
            }
            case COMMAND: {
                String commandValue = this.settings.getString("liveStreamsCommand");
                CustomCommand customCommand = CustomCommand.parse(commandValue.trim());
                if (customCommand.hasError()) {
                    CommandSettings.showCommandInfoPopup(this.scroll, customCommand);
                    break;
                }
                CommandActionEvent e = new CommandActionEvent(new ActionEvent(this, 1001, "command"), customCommand);
                this.listener.streamInfosMenuItemClicked(e, streams);
            }
        }
    }

    private class MyContextMenuListener
    extends ContextMenuAdapter {
        private MyContextMenuListener() {
        }

        @Override
        public void streamInfosMenuItemClicked(ActionEvent e, Collection<StreamInfo> streams) {
            String cmd = e.getActionCommand();
            if (cmd.equals("openChannelInfo")) {
                LiveStreamsDialog.this.openChannelInfoDialog(streams.iterator().next());
            } else if (cmd.equals("showRemovedList")) {
                LiveStreamsDialog.this.switchList();
            }
            LiveStreamsDialog.this.helper.menuAction(e);
        }
    }

    public static enum Sorting {
        RECENT("recent", new LiveStreamsTimeChangedComparator()),
        UPTIME("uptime", new LiveStreamsUptimeComparator()),
        NAME("name", new LiveStreamsNameComparator()),
        GAME("game", new LiveStreamsGameComparator()),
        VIEWERS("viewers", new LiveStreamsViewersComparator());

        public final String key;
        public final Comparator<StreamInfo> comparator;

        private Sorting(String key, Comparator<StreamInfo> comparator) {
            this.key = key;
            this.comparator = comparator;
        }

        public String getLabel() {
            return Language.getString("streams.sorting." + this.key);
        }

        public String getToolTipText() {
            return Language.getString("streams.sorting." + this.key + ".tip", false);
        }

        public static Sorting fromKey(String key) {
            for (Sorting s : Sorting.values()) {
                if (!s.key.equals(key)) continue;
                return s;
            }
            return null;
        }
    }

    public static enum OpenAction {
        INFO("info"),
        JOIN("join"),
        STREAM("stream"),
        STREAM_POPOUT("streamPopout"),
        COMMAND("command");

        public final String key;

        private OpenAction(String key) {
            this.key = key;
        }

        public String getLabel() {
            return Language.getString("streams.openAction." + this.key);
        }

        public String getToolTipText() {
            return Language.getString("streams.openAction." + this.key + ".tip", false);
        }

        public static OpenAction fromKey(String key) {
            for (OpenAction s : OpenAction.values()) {
                if (!s.key.equals(key)) continue;
                return s;
            }
            return null;
        }
    }

    private static class LiveStreamsViewersComparator
    implements Comparator<StreamInfo> {
        private LiveStreamsViewersComparator() {
        }

        @Override
        public int compare(StreamInfo o1, StreamInfo o2) {
            if (o1.getViewers() > o2.getViewers()) {
                return -1;
            }
            if (o1.getViewers() < o2.getViewers()) {
                return 1;
            }
            return o1.getStream().compareTo(o2.getStream());
        }
    }

    private static class LiveStreamsGameComparator
    implements Comparator<StreamInfo> {
        private LiveStreamsGameComparator() {
        }

        @Override
        public int compare(StreamInfo o1, StreamInfo o2) {
            String game1 = o1.getGame();
            String game2 = o2.getGame();
            if (game1 == null ? game2 == null : game1.equals(game2)) {
                return o1.getStream().compareTo(o2.getStream());
            }
            if (game1 == null) {
                return 1;
            }
            if (game2 == null) {
                return -1;
            }
            return game1.compareTo(game2);
        }
    }

    private static class LiveStreamsTimeChangedComparator
    implements Comparator<StreamInfo> {
        private LiveStreamsTimeChangedComparator() {
        }

        @Override
        public int compare(StreamInfo o1, StreamInfo o2) {
            long time2;
            long time1 = o1.getStatusChangeTimeAgo();
            if (time1 == (time2 = o2.getStatusChangeTimeAgo())) {
                return o1.getStream().compareTo(o2.getStream());
            }
            if (time1 > time2) {
                return 1;
            }
            return -1;
        }
    }

    private static class LiveStreamsUptimeComparator
    implements Comparator<StreamInfo> {
        private LiveStreamsUptimeComparator() {
        }

        @Override
        public int compare(StreamInfo o1, StreamInfo o2) {
            long time2;
            long time1 = o1.getTimeStartedWithPicnicAgo();
            if (time1 == (time2 = o2.getTimeStartedWithPicnicAgo())) {
                return o1.getStream().compareTo(o2.getStream());
            }
            if (time1 > time2) {
                return 1;
            }
            return -1;
        }
    }

    private static class LiveStreamsNameComparator
    implements Comparator<StreamInfo> {
        private LiveStreamsNameComparator() {
        }

        @Override
        public int compare(StreamInfo o1, StreamInfo o2) {
            return o1.getStream().compareTo(o2.getStream());
        }
    }
}

