/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.ChannelFavorites;
import chatty.Helper;
import chatty.gui.DockedDialogHelper;
import chatty.gui.GuiUtil;
import chatty.gui.components.JListActionHelper;
import chatty.gui.components.LiveStreamListener;
import chatty.gui.components.LiveStreamsDialog;
import chatty.gui.components.LiveStreamsTitledBorder;
import chatty.gui.components.SortedListModel;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.StreamInfosContextMenu;
import chatty.util.DateTime;
import chatty.util.ElapsedTime;
import chatty.util.api.StreamInfo;
import chatty.util.settings.Settings;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class LiveStreamsList
extends JList<StreamInfo> {
    private static final Logger LOGGER = Logger.getLogger(LiveStreamsList.class.getName());
    private static final int UPDATE_TIMER_DELAY = 5;
    private static final int CHECK_DELAY = 20;
    private static final int REPAINT_DELAY = 60;
    private final SortedListModel<StreamInfo> data;
    private final MyCellRenderer renderer;
    private final List<ContextMenuListener> contextMenuListeners;
    private final LiveStreamListener liveStreamListener;
    private final Set<String> favs = new HashSet<String>();
    private final Set<String> gameFavs = new HashSet<String>();
    private static final int STREAMINFO_NEW_TIME = 180;
    private ListDataChangedListener listDataChangedListener;
    private JPopupMenu lastContextMenu;
    private LiveStreamsDialog.Sorting currentSorting;
    private boolean favFirst;
    private boolean favsOnly;
    private DockedDialogHelper dockedHelper;
    private final ElapsedTime lastCheckedET = new ElapsedTime();
    private final ElapsedTime lastRepaintedET = new ElapsedTime();
    private final Timer resortTimer;

    public LiveStreamsList(LiveStreamListener liveStreamListener, ChannelFavorites channelFavorites, Settings settings) {
        this.data = new SortedListModel();
        this.setModel(this.data);
        this.renderer = new MyCellRenderer(this.favs, this.gameFavs);
        this.setCellRenderer(this.renderer);
        this.contextMenuListeners = new ArrayList<ContextMenuListener>();
        this.liveStreamListener = liveStreamListener;
        this.addListeners();
        Timer updateTimer = new Timer(5000, e -> this.update());
        updateTimer.setRepeats(true);
        updateTimer.start();
        this.resortTimer = new Timer(50, e -> this.resortTimer());
        ChannelFavorites.ChangeListener favChangeListener = () -> {
            Set<String> favorites = channelFavorites.getFavorites();
            SwingUtilities.invokeLater(() -> {
                this.favs.clear();
                for (String chan : favorites) {
                    this.favs.add(Helper.toStream(chan));
                }
                this.resort();
                this.data.updateFiltering();
            });
        };
        channelFavorites.addChangeListener(favChangeListener);
        favChangeListener.favoritesChanged();
        settings.addSettingChangeListener((setting, type, value) -> {
            if (setting.equals("gameFavorites")) {
                this.updateGameFavs(settings);
            }
            if (setting.equals("liveStreamsChatIcon")) {
                this.renderer.setShowIsOpen((Boolean)value);
                this.repaint();
            }
        });
        this.updateGameFavs(settings);
        this.renderer.setShowIsOpen(settings.getBoolean("liveStreamsChatIcon"));
    }

    public void setDockedDialogHelper(DockedDialogHelper helper) {
        this.dockedHelper = helper;
    }

    private void updateGameFavs(Settings settings) {
        SwingUtilities.invokeLater(() -> {
            this.gameFavs.clear();
            this.gameFavs.addAll(settings.getList("gameFavorites"));
            this.resort();
            this.data.updateFiltering();
        });
    }

    public void addContextMenuListener(ContextMenuListener listener) {
        if (listener != null) {
            this.contextMenuListeners.add(listener);
        }
    }

    public void addStreams(List<StreamInfo> infos) {
        for (StreamInfo info : infos) {
            this.addStream(info);
        }
    }

    public void setComparator(final LiveStreamsDialog.Sorting s, boolean favFirst) {
        Comparator<StreamInfo> comp = s.comparator;
        if (favFirst) {
            comp = new Comparator<StreamInfo>(){

                @Override
                public int compare(StreamInfo o1, StreamInfo o2) {
                    boolean fav2;
                    boolean fav1 = LiveStreamsList.this.favs.contains(o1.stream) || LiveStreamsList.this.gameFavs.contains(o1.getGame());
                    boolean bl = fav2 = LiveStreamsList.this.favs.contains(o2.stream) || LiveStreamsList.this.gameFavs.contains(o2.getGame());
                    if (fav1 && !fav2) {
                        return -1;
                    }
                    if (fav2 && !fav1) {
                        return 1;
                    }
                    return s.comparator.compare(o1, o2);
                }
            };
        }
        this.data.setComparator(comp);
        this.resort();
        this.currentSorting = s;
        this.favFirst = favFirst;
    }

    public void setFiltering(boolean favsOnly) {
        if (favsOnly == this.favsOnly) {
            return;
        }
        this.favsOnly = favsOnly;
        if (favsOnly) {
            this.data.setFilter(item -> this.favs.contains(item.stream) || this.gameFavs.contains(item.getGame()));
        } else {
            this.data.setFilter(null);
        }
    }

    public void addStream(StreamInfo info) {
        if (info.isValidEnough() && info.getOnline()) {
            if (!this.data.contains(info)) {
                this.data.add(info);
            }
            this.itemAdded(info);
        } else if (this.data.contains(info)) {
            this.data.remove(info);
            this.itemRemoved(info);
        }
        this.resort();
        this.listDataChanged();
    }

    private void resort() {
        this.resortTimer.start();
    }

    private void resortTimer() {
        try {
            this.data.resort();
        }
        catch (Exception ex) {
            LOGGER.warning("LiveStreamsList resort: " + ex);
        }
        this.resortTimer.stop();
    }

    public void addListDataChangedListener(ListDataChangedListener listener) {
        this.listDataChangedListener = listener;
    }

    private void checkStreams() {
        if (!this.lastCheckedET.secondsElapsed(20)) {
            return;
        }
        this.lastCheckedET.set();
        HashSet<StreamInfo> toRemove = new HashSet<StreamInfo>();
        for (StreamInfo info : this.data) {
            if (info.isValidEnough() && info.getOnline()) continue;
            toRemove.add(info);
        }
        for (StreamInfo info : toRemove) {
            this.data.remove(info);
            this.itemRemoved(info);
        }
        if (!toRemove.isEmpty()) {
            this.listDataChanged();
        }
    }

    private void checkToClearSelection() {
        if (!(this.isFocusOwner() || this.lastContextMenu != null && this.lastContextMenu.isVisible())) {
            this.clearSelection();
        }
    }

    private void update() {
        this.checkToClearSelection();
        this.checkStreams();
        this.checkToRepaint();
    }

    private void checkToRepaint() {
        if (this.lastRepaintedET.secondsElapsed(60)) {
            this.repaint();
            this.lastRepaintedET.set();
        }
    }

    private void listDataChanged() {
        if (this.listDataChangedListener != null) {
            this.listDataChangedListener.listDataChanged();
        }
    }

    private void itemRemoved(StreamInfo item) {
        if (this.listDataChangedListener != null) {
            this.listDataChangedListener.itemRemoved(item);
        }
    }

    private void itemAdded(StreamInfo item) {
        if (this.listDataChangedListener != null) {
            this.listDataChangedListener.itemAdded(item);
        }
    }

    private void addListeners() {
        ComponentAdapter cl = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LiveStreamsList.this.setFixedCellHeight(10);
                LiveStreamsList.this.setFixedCellHeight(-1);
            }
        };
        this.addComponentListener(cl);
        JListActionHelper.install(this, (a, l, s) -> {
            if (a == JListActionHelper.Action.CONTEXT_MENU) {
                StreamInfosContextMenu m = new StreamInfosContextMenu(s, true, this.favFirst, this.favsOnly, this.dockedHelper.isDocked());
                m.setSorting(this.currentSorting.key);
                for (ContextMenuListener cml : this.contextMenuListeners) {
                    m.addContextMenuListener(cml);
                }
                this.lastContextMenu = m;
                m.show(this, l.x, l.y);
            } else if (a == JListActionHelper.Action.ENTER) {
                ArrayList<String> channels = new ArrayList<String>();
                s.forEach(si -> channels.add(si.stream));
                for (ContextMenuListener cml : this.contextMenuListeners) {
                    cml.streamsMenuItemClicked(new ActionEvent(s, 0, "join"), channels);
                }
            } else if (!(a != JListActionHelper.Action.DOUBLE_CLICK && a != JListActionHelper.Action.SPACE || s == null || s.isEmpty() || this.liveStreamListener == null)) {
                this.liveStreamListener.liveStreamClicked(s);
            }
        });
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    private static class MyCellRenderer
    extends DefaultListCellRenderer {
        private static final Border PADDING = BorderFactory.createEmptyBorder(2, 3, 1, 3);
        private static final Border MARGIN = BorderFactory.createEmptyBorder(4, 3, 1, 3);
        private static final Border TITLE = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY);
        private static final Border TITLE_SELECTED = BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(165, 165, 165));
        private static final Border TITLE_NEW = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK);
        private final ImageIcon favIcon = new ImageIcon(this.getClass().getResource("/chatty/gui/star.png"));
        private final ImageIcon gameFavIcon = new ImageIcon(this.getClass().getResource("/chatty/gui/game.png"));
        private final ImageIcon chatIcon = new ImageIcon(this.getClass().getResource("/chatty/gui/chat.png"));
        private final Map<Integer, ImageIcon> iconCache = new HashMap<Integer, ImageIcon>();
        private final JTextArea area = new JTextArea();
        private final Set<String> favs;
        private final Set<String> gameFavs;
        private boolean showIsOpen;

        public MyCellRenderer(Set<String> favs, Set<String> gameFavs) {
            this.area.setLineWrap(true);
            this.area.setWrapStyleWord(true);
            this.favs = favs;
            this.gameFavs = gameFavs;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            boolean showChatIcon;
            Border titleBaseBorder;
            if (value == null) {
                this.area.setText(null);
                return this.area;
            }
            StreamInfo info = (StreamInfo)value;
            String text = info.getTitle();
            if (!info.getGame().isEmpty()) {
                text = text + "\n(" + info.getGame() + ")";
            }
            this.area.setText(text);
            int width = list.getWidth();
            if (width > 0) {
                this.area.setSize(width, Short.MAX_VALUE);
            }
            String title = info.getTimeStartedWithPicnic() != -1L ? String.format("%s%s (%s | %s)", info.getStreamTypeString(), info.getCapitalizedName(), Helper.formatViewerCount(info.getViewers()), DateTime.agoUptimeCompact(info.getTimeStartedWithPicnic())) : String.format("%s%s (%s)", info.getStreamTypeString(), info.getCapitalizedName(), Helper.formatViewerCount(info.getViewers()));
            Border border = titleBaseBorder = isSelected ? TITLE_SELECTED : TITLE;
            if (info.getStatusChangeTimeAgo() < 180L) {
                titleBaseBorder = TITLE_NEW;
            }
            LiveStreamsTitledBorder titleBorder = new LiveStreamsTitledBorder(titleBaseBorder, title, 2, 2);
            boolean fav = this.favs.contains(info.stream);
            boolean gameFav = this.gameFavs.contains(info.getGame());
            boolean bl = showChatIcon = this.showIsOpen && info.isOpen();
            if (fav || gameFav || showChatIcon) {
                titleBorder.getLabel().setIcon(this.getTitleIcon(fav, gameFav, showChatIcon));
            }
            CompoundBorder innerBorder = BorderFactory.createCompoundBorder(titleBorder, PADDING);
            CompoundBorder border2 = BorderFactory.createCompoundBorder(MARGIN, innerBorder);
            this.area.setBorder(border2);
            if (isSelected) {
                this.area.setBackground(list.getSelectionBackground());
                this.area.setForeground(list.getSelectionForeground());
            } else {
                this.area.setBackground(list.getBackground());
                this.area.setForeground(list.getForeground());
            }
            return this.area;
        }

        private ImageIcon getTitleIcon(boolean fav, boolean gameFav, boolean isOpen) {
            int id = (fav ? 1 : 0) + (gameFav ? 2 : 0) + (isOpen ? 4 : 0);
            ImageIcon icon = this.iconCache.get(id);
            if (icon != null) {
                return icon;
            }
            if (fav) {
                icon = this.combineIcons(icon, this.favIcon);
            }
            if (gameFav) {
                icon = this.combineIcons(icon, this.gameFavIcon);
            }
            if (isOpen) {
                icon = this.combineIcons(icon, this.chatIcon);
            }
            if (icon != null) {
                this.iconCache.put(id, icon);
            }
            return icon;
        }

        private ImageIcon combineIcons(ImageIcon a, ImageIcon b) {
            if (a == null) {
                return b;
            }
            return GuiUtil.combineIcons(a, b, 2);
        }

        public void setShowIsOpen(boolean showIsOpen) {
            this.showIsOpen = showIsOpen;
        }
    }

    public static interface ListDataChangedListener {
        public void listDataChanged();

        public void itemRemoved(StreamInfo var1);

        public void itemAdded(StreamInfo var1);
    }
}

