/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.gui.components.LiveStreamListener;
import chatty.gui.components.SortedListModel;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.StreamInfosContextMenu;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.api.StreamInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class LiveStreamsRemovedList
extends JPanel {
    private final JList<RemovedListItem> list;
    private final JButton button;
    private final LiveStreamListener streamListener;
    private final List<ContextMenuListener> contextMenuListeners;
    private final SortedListModel<RemovedListItem> data;

    public LiveStreamsRemovedList(LiveStreamListener l) {
        this.setLayout(new GridBagLayout());
        this.streamListener = l;
        this.contextMenuListeners = new ArrayList<ContextMenuListener>();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.button = new JButton(Language.getString("streams.removed.button.back"));
        this.add((Component)this.button, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.list = new JList();
        this.data = new SortedListModel();
        this.list.setModel(this.data);
        this.list.addMouseListener(new MyMouseListener());
        this.add((Component)new JScrollPane(this.list), gbc);
    }

    public void addStreamInfo(StreamInfo info) {
        this.data.add(new RemovedListItem(info));
    }

    public void removeStreamInfo(StreamInfo info) {
        this.data.remove(this.getListItem(info));
    }

    public void addContextMenuListener(ContextMenuListener cml) {
        if (cml != null) {
            this.contextMenuListeners.add(cml);
        }
    }

    public void addBackButtonListener(ActionListener listener) {
        this.button.addActionListener(listener);
    }

    private RemovedListItem getListItem(StreamInfo info) {
        for (RemovedListItem item : this.data) {
            if (item.getStreamInfo() != info) continue;
            return item;
        }
        return null;
    }

    private void openContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.selectClicked(e, false);
            List<RemovedListItem> selectedItems = this.list.getSelectedValuesList();
            ArrayList<StreamInfo> selected = new ArrayList<StreamInfo>();
            for (RemovedListItem item : selectedItems) {
                selected.add(item.getStreamInfo());
            }
            StreamInfosContextMenu m = new StreamInfosContextMenu(selected, false, false, false, false);
            for (ContextMenuListener cml : this.contextMenuListeners) {
                m.addContextMenuListener(cml);
            }
            m.show(this.list, e.getX(), e.getY());
        }
    }

    private void selectClicked(MouseEvent e, boolean onlyOutside) {
        int index = this.list.locationToIndex(e.getPoint());
        Rectangle bounds = this.list.getCellBounds(index, index);
        if (bounds != null && bounds.contains(e.getPoint())) {
            if (!onlyOutside) {
                if (this.list.isSelectedIndex(index)) {
                    this.list.addSelectionInterval(index, index);
                } else {
                    this.list.setSelectedIndex(index);
                }
            }
        } else {
            this.list.clearSelection();
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            LiveStreamsRemovedList.this.selectClicked(e, true);
            LiveStreamsRemovedList.this.openContextMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            LiveStreamsRemovedList.this.openContextMenu(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            RemovedListItem item;
            if (e.getClickCount() == 2 && (item = (RemovedListItem)LiveStreamsRemovedList.this.list.getSelectedValue()) != null && LiveStreamsRemovedList.this.streamListener != null) {
                ArrayList<StreamInfo> streams = new ArrayList<StreamInfo>();
                streams.add(item.getStreamInfo());
                LiveStreamsRemovedList.this.streamListener.liveStreamClicked(streams);
            }
        }
    }

    private static class RemovedListItem
    implements Comparable<RemovedListItem> {
        private final StreamInfo info;
        private final long time;

        public RemovedListItem(StreamInfo info) {
            this.info = info;
            this.time = System.currentTimeMillis();
        }

        public String toString() {
            return DateTime.format(this.time) + " " + this.info.getCapitalizedName() + (this.info.getFollowed() ? " (followed)" : "");
        }

        public StreamInfo getStreamInfo() {
            return this.info;
        }

        public long getTime() {
            return this.time;
        }

        @Override
        public int compareTo(RemovedListItem o) {
            if (this.time > o.getTime()) {
                return -1;
            }
            if (this.time == o.getTime()) {
                return this.info.getStream().compareTo(o.getStreamInfo().getStream());
            }
            return 1;
        }
    }
}

