/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.Helper;
import chatty.gui.GuiUtil;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.settings.EditorStringSetting;
import chatty.util.Livestreamer;
import chatty.util.StringUtil;
import chatty.util.settings.Settings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class LivestreamerDialog
extends JDialog {
    private final JButton closeButton = new JButton("Close");
    private final JTabbedPane tabs = new JTabbedPane();
    private final Window parent;
    private final JCheckBox enableContextMenu = new JCheckBox("Enable context menu entry");
    private final JCheckBox openDialog = new JCheckBox("Show dialog when opening stream");
    private final JCheckBox autoCloseDialog = new JCheckBox("Auto close dialog when starting player");
    private final EditorStringSetting qualities;
    private final EditorStringSetting commandDef;
    private final JTextField streamInput = new JTextField(30);
    private final JButton openStreamButton = new JButton("Open Stream");
    private static final String INFO = "Streamlink (a fork of Livestreamer) is an external program you have to install separately that allows you to watch streams of many websites in a player like VLC. [help-livestreamer:top More information..]";
    private static final String BASE_COMMAND_INFO = "<html><body style='width:340px;font-weight:normal;'>Example Usage (setting the window title for VLC):<br /><code>streamlink -p \"'C:\\Program Files (x86)\\VideoLAN\\VLC\\vlc.exe' --meta-title '$stream/$quality'\"</code><br /><br />This should point to the Streamlink executable and can contain parameters that should always be included when you run Streamlink via Chatty.<br /><br />The url and quality are <em>automatically</em> appended when you run Streamlink via Chatty, but you can use them in other parameters via <code>$stream</code>, <code>$url</code> and <code>$quality</code>.</p>";
    private final Settings settings;

    public LivestreamerDialog(Window parent, LinkLabelListener linkLabelListener, final Settings settings) {
        super(parent);
        this.settings = settings;
        this.setTitle("Streamlink");
        this.parent = parent;
        this.setLocationRelativeTo(parent);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.closeButton.setMnemonic(67);
        this.add((Component)this.closeButton, "South");
        JPanel infoPanel = new JPanel(new GridBagLayout());
        LinkLabel info = new LinkLabel(INFO, linkLabelListener);
        info.setPreferredSize(new Dimension(300, 50));
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 2, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        infoPanel.add((Component)info, gbc);
        gbc = GuiUtil.makeGbc(0, 1, 1, 1, 17);
        gbc.insets = new Insets(5, 5, 0, 5);
        infoPanel.add((Component)this.enableContextMenu, gbc);
        gbc = GuiUtil.makeGbc(0, 2, 1, 1, 17);
        gbc.insets = new Insets(0, 15, 0, 5);
        infoPanel.add((Component)this.openDialog, gbc);
        gbc = GuiUtil.makeGbc(0, 3, 1, 1, 17);
        gbc.insets = new Insets(0, 15, 5, 5);
        infoPanel.add((Component)this.autoCloseDialog, gbc);
        gbc = GuiUtil.makeGbc(0, 4, 1, 1, 17);
        gbc.insets = new Insets(5, 5, 0, 5);
        infoPanel.add((Component)new JLabel("Context menu qualities (\"Select\" to select quality):"), gbc);
        gbc = GuiUtil.makeGbc(0, 5, 1, 1, 17);
        gbc.fill = 2;
        gbc.insets = new Insets(4, 5, 5, 30);
        this.qualities = new EditorStringSetting(this, "Context Menu Qualities", 24, false, false, null);
        infoPanel.add((Component)this.qualities, gbc);
        gbc = GuiUtil.makeGbc(0, 6, 1, 1, 17);
        gbc.insets = new Insets(5, 5, 0, 5);
        infoPanel.add((Component)new JLabel("Base command (Streamlink path and parameters):"), gbc);
        gbc = GuiUtil.makeGbc(0, 7, 1, 1, 17);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(4, 5, 4, 30);
        this.commandDef = new EditorStringSetting(this, "Base command (Streamlink path and paramters)", 24, false, false, BASE_COMMAND_INFO);
        infoPanel.add((Component)this.commandDef, gbc);
        gbc = GuiUtil.makeGbc(0, 9, 2, 1, 17);
        gbc.insets = new Insets(5, 5, 0, 5);
        JLabel streamLabel = new JLabel("Enter stream name or URL (or commandline options):");
        streamLabel.setLabelFor(this.streamInput);
        infoPanel.add((Component)streamLabel, gbc);
        gbc = GuiUtil.makeGbc(0, 10, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        infoPanel.add((Component)this.streamInput, gbc);
        gbc = GuiUtil.makeGbc(1, 10, 1, 1);
        GuiUtil.smallButtonInsets(this.openStreamButton);
        gbc.fill = 2;
        infoPanel.add((Component)this.openStreamButton, gbc);
        this.tabs.add("Main", infoPanel);
        ActionListener buttonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == LivestreamerDialog.this.closeButton) {
                    LivestreamerDialog.this.close();
                } else if (e.getSource() == LivestreamerDialog.this.openStreamButton || e.getSource() == LivestreamerDialog.this.streamInput) {
                    String stream = LivestreamerDialog.this.streamInput.getText();
                    if (!stream.isEmpty()) {
                        LivestreamerDialog.this.open(stream, null);
                    }
                } else if (e.getSource() == LivestreamerDialog.this.enableContextMenu) {
                    settings.setBoolean("livestreamer", LivestreamerDialog.this.enableContextMenu.isSelected());
                } else if (e.getSource() == LivestreamerDialog.this.openDialog) {
                    settings.setBoolean("livestreamerShowDialog", LivestreamerDialog.this.openDialog.isSelected());
                } else if (e.getSource() == LivestreamerDialog.this.autoCloseDialog) {
                    settings.setBoolean("livestreamerAutoCloseDialog", LivestreamerDialog.this.autoCloseDialog.isSelected());
                }
            }
        };
        this.streamInput.addActionListener(buttonAction);
        this.openStreamButton.addActionListener(buttonAction);
        this.closeButton.addActionListener(buttonAction);
        this.enableContextMenu.addActionListener(buttonAction);
        this.openDialog.addActionListener(buttonAction);
        this.autoCloseDialog.addActionListener(buttonAction);
        this.commandDef.setChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                settings.setString("livestreamerCommand", LivestreamerDialog.this.commandDef.getSettingValue());
            }
        });
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    public void open(String stream, String quality) {
        if (stream != null) {
            Item existingItem;
            String url = "https://twitch.tv/" + stream;
            if (!Helper.isValidChannel(stream)) {
                url = stream;
            }
            if ((existingItem = this.getExisitingItem(url, quality)) != null) {
                existingItem.start();
                this.tabs.setSelectedComponent(existingItem);
            } else {
                Item newItem = new Item(url, quality, stream);
                this.tabs.add(StringUtil.shortenTo(stream, -20), newItem);
                this.tabs.setSelectedComponent(newItem);
                this.tabs.setToolTipTextAt(this.tabs.getSelectedIndex(), stream);
                newItem.start();
                if (this.getWidth() < this.getPreferredSize().width) {
                    this.setSize(this.getPreferredSize().width, this.getHeight());
                }
            }
        }
        this.loadSettings();
        if (stream == null || quality == null || this.openDialog.isSelected()) {
            if (!this.isVisible()) {
                this.setLocationRelativeTo(this.parent);
            }
            this.setVisible(true);
        }
    }

    public void close() {
        this.dispose();
        this.settings.setString("livestreamerQualities", this.qualities.getSettingValue());
    }

    private Item getExisitingItem(String url, String quality) {
        for (Component o : this.tabs.getComponents()) {
            Item item;
            if (!(o instanceof Item) || (item = (Item)o).running || item.quality == null || !item.quality.equals(quality) || !item.url.equals(url)) continue;
            return item;
        }
        return null;
    }

    private void loadSettings() {
        this.enableContextMenu.setSelected(this.settings.getBoolean("livestreamer"));
        this.qualities.setSettingValue(this.settings.getString("livestreamerQualities"));
        this.commandDef.setSettingValue(this.settings.getString("livestreamerCommand"));
        this.openDialog.setSelected(this.settings.getBoolean("livestreamerShowDialog"));
        this.autoCloseDialog.setSelected(this.settings.getBoolean("livestreamerAutoCloseDialog"));
    }

    private class Item
    extends JPanel
    implements Livestreamer.LivestreamerListener,
    ActionListener {
        private final JButton closeButton = new JButton("Close");
        private final JButton retryButton = new JButton("Retry");
        private final JTextArea messages = new JTextArea();
        private final JLabel info = new JLabel();
        private final String url;
        private final String stream;
        private String quality;
        private boolean running;
        private Livestreamer ls;
        private final ActionListener qualityButtonListener = new QualityButtonListener();
        private final JPanel buttonPanel = new JPanel();

        private Item(String url, String quality, String stream) {
            this.url = url;
            this.quality = quality;
            this.stream = stream;
            if (quality != null) {
                this.info.setText("Selected quality: " + quality);
            }
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.info, gbc);
            gbc = GuiUtil.makeGbc(1, 0, 1, 1);
            GuiUtil.smallButtonInsets(this.retryButton);
            this.add((Component)this.retryButton, gbc);
            gbc = GuiUtil.makeGbc(2, 0, 1, 1);
            GuiUtil.smallButtonInsets(this.closeButton);
            this.add((Component)this.closeButton, gbc);
            gbc = GuiUtil.makeGbc(0, 1, 3, 1);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.messages.setEditable(false);
            this.messages.setLineWrap(true);
            this.messages.setWrapStyleWord(true);
            JScrollPane scroll = new JScrollPane(this.messages);
            scroll.setPreferredSize(new Dimension(300, 150));
            this.add((Component)scroll, gbc);
            gbc = GuiUtil.makeGbc(0, 2, 3, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.buttonPanel, gbc);
            this.closeButton.addActionListener(this);
            this.retryButton.addActionListener(this);
        }

        private void addMessage(String message) {
            if (this.quality == null && message.trim().startsWith("Available streams:")) {
                this.parseQualities(message);
            }
            if (message.trim().startsWith("Starting player") && LivestreamerDialog.this.autoCloseDialog.isSelected()) {
                LivestreamerDialog.this.close();
            }
            Document doc = this.messages.getDocument();
            try {
                doc.insertString(doc.getLength(), Livestreamer.filterToken(message) + "\n", null);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(LivestreamerDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        private void parseQualities(String message) {
            String[] split = (message = message.replaceAll("\\([^)]*\\)", "")).split(":");
            if (split.length == 2) {
                String[] split2 = split[1].split(",");
                this.buttonPanel.removeAll();
                for (String part : split2) {
                    String q = part.trim();
                    JButton button = new JButton(q);
                    button.addActionListener(this.qualityButtonListener);
                    this.buttonPanel.add(button);
                }
                if (this.getWidth() < this.buttonPanel.getPreferredSize().width) {
                    LivestreamerDialog.this.pack();
                }
                this.info.setText("Click button to select quality.");
            }
        }

        public void start() {
            Livestreamer ls;
            if (this.running) {
                return;
            }
            this.setQualityButtonsEnabled(false);
            if (this.quality == null) {
                this.info.setText("No quality selected yet.");
            } else {
                this.info.setText("Selected quality: " + this.quality);
            }
            StringBuilder command = new StringBuilder();
            command.append(this.makeBaseCommand());
            command.append(" ");
            command.append(this.url);
            if (this.quality != null) {
                command.append(" ");
                command.append(this.quality);
            }
            this.ls = ls = new Livestreamer(command.toString(), this);
            ls.start();
        }

        private String makeBaseCommand() {
            String command = LivestreamerDialog.this.settings.getString("livestreamerCommand");
            command = command.replace("$stream", this.stream);
            command = command.replace("$url", this.url);
            if (this.quality != null) {
                command = command.replace("$quality", this.quality);
            }
            return command;
        }

        private void setRunning(boolean running) {
            if (running) {
                this.closeButton.setText("End process");
            } else {
                this.closeButton.setText("Close");
            }
            this.retryButton.setEnabled(!running);
            this.setQualityButtonsEnabled(!running);
            this.running = running;
            if (!running && this.quality != null && !LivestreamerDialog.this.isVisible()) {
                LivestreamerDialog.this.tabs.remove(this);
            }
        }

        @Override
        public void processStarted(final String command) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Item.this.addMessage("COMMAND: " + command);
                    Item.this.setRunning(true);
                }
            });
        }

        @Override
        public void message(final String message) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Item.this.addMessage(message.replace("[cli][info] ", ""));
                }
            });
        }

        @Override
        public void processFinished(int exitValue) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Item.this.addMessage("PROCESS ENDED.");
                    Item.this.setRunning(false);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.closeButton) {
                if (this.running) {
                    this.ls.kill();
                } else {
                    LivestreamerDialog.this.tabs.remove(this);
                }
            } else if (e.getSource() == this.retryButton && !this.running) {
                this.start();
            }
        }

        private void setQualityButtonsEnabled(boolean enabled) {
            for (Component c : this.buttonPanel.getComponents()) {
                c.setEnabled(enabled);
            }
        }

        private class QualityButtonListener
        implements ActionListener {
            private QualityButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Item.this.quality = e.getActionCommand();
                Item.this.start();
            }
        }
    }
}

