/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.gui.DockStyledTabContainer;
import chatty.gui.DockedDialogHelper;
import chatty.gui.DockedDialogManager;
import chatty.gui.MainGui;
import chatty.util.DateTime;
import chatty.util.api.eventsub.payloads.ModActionPayload;
import chatty.util.dnd.DockContent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class ModerationLog
extends JDialog {
    private static final int MAX_NUMBER_LINES = 100;
    private final JTextArea log;
    private final JScrollPane scroll;
    private final DockedDialogHelper helper;
    private final Map<String, List<String>> cache = new HashMap<String, List<String>>();
    private String currentChannel;
    private String currentLoadedChannel;
    private final Set<String> unread = new HashSet<String>();

    public ModerationLog(MainGui owner, DockedDialogManager dockedDialogs) {
        super(owner);
        this.log = ModerationLog.createLogArea();
        this.scroll = new JScrollPane(this.log);
        this.scroll.setPreferredSize(new Dimension(300, 200));
        this.add((Component)this.scroll, "Center");
        final DockStyledTabContainer<JComponent> content = dockedDialogs.createStyledContent(this.scroll, "Mod Actions", "-modlog-");
        this.helper = dockedDialogs.createHelper(new DockedDialogHelper.DockedDialog(){

            @Override
            public void setVisible(boolean visible) {
                ModerationLog.super.setVisible(visible);
            }

            @Override
            public boolean isVisible() {
                return ModerationLog.super.isVisible();
            }

            @Override
            public void addComponent(Component comp) {
                ModerationLog.this.add(comp, "Center");
            }

            @Override
            public void removeComponent(Component comp) {
                ModerationLog.this.remove(comp);
            }

            @Override
            public Window getWindow() {
                return ModerationLog.this;
            }

            @Override
            public DockContent getContent() {
                return content;
            }
        });
        this.helper.installContextMenu(this.log);
        this.setTitle("Moderator Actions");
        this.pack();
    }

    @Override
    public void setVisible(boolean visible) {
        this.helper.setVisible(visible, true);
    }

    @Override
    public boolean isVisible() {
        return this.helper.isVisible();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.helper != null) {
            this.helper.getContent().setLongTitle(title);
        }
    }

    private static JTextArea createLogArea() {
        DefaultCaret caret = new DefaultCaret();
        caret.setUpdatePolicy(1);
        JTextArea text = new JTextArea();
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setEditable(false);
        text.setCaret(caret);
        text.setBorder(BorderFactory.createEmptyBorder(1, 2, 3, 2));
        return text;
    }

    public void setChannel(String channel) {
        if (this.helper.isContentVisible()) {
            this.unread.remove(channel);
        }
        if (channel != null && !channel.equals(this.currentChannel)) {
            if (this.unread.contains(channel)) {
                this.helper.setNewMessage();
            } else {
                this.helper.resetNewMessage();
            }
            this.currentChannel = channel;
            this.setTitle("Moderation Actions (" + channel + ")");
            if (this.isVisible()) {
                this.setDataToCurrent();
            }
        }
    }

    private void setDataToCurrent() {
        if (this.currentChannel != null && !this.currentChannel.equals(this.currentLoadedChannel)) {
            this.currentLoadedChannel = this.currentChannel;
            List<String> cached = this.cache.get(this.currentChannel);
            if (cached != null) {
                StringBuilder b = new StringBuilder();
                String linebreak = "";
                for (String line : cached) {
                    b.append(linebreak);
                    b.append(line);
                    linebreak = "\n";
                }
                this.log.setText(b.toString());
                this.scrollDown();
            } else {
                this.log.setText(null);
            }
        }
    }

    public void add(ModActionPayload data) {
        if (data.stream == null) {
            return;
        }
        String channel = data.stream;
        String line = String.format("[%s]%s <%s> %s", DateTime.currentTime(), data.isShared() ? String.format("[%s]", data.getSourceChannel()) : "", data.created_by, data.getPseudoCommandString());
        if (channel.equals(this.currentLoadedChannel)) {
            this.printLine(this.log, line);
            this.helper.setNewMessage();
        }
        if (!this.helper.isContentVisible()) {
            this.unread.add(channel);
        }
        if (!this.cache.containsKey(channel)) {
            this.cache.put(channel, new ArrayList());
        }
        this.cache.get(channel).add(line);
        if (this.cache.get(channel).size() > 100) {
            this.cache.get(channel).remove(0);
        }
    }

    private void printLine(JTextArea text, String line) {
        try {
            boolean scrollDown;
            Document doc = text.getDocument();
            String linebreak = doc.getLength() > 0 ? "\n" : "";
            doc.insertString(doc.getLength(), linebreak + line, null);
            JScrollBar bar = this.scroll.getVerticalScrollBar();
            boolean bl = scrollDown = bar.getValue() > bar.getMaximum() - bar.getVisibleAmount() - 4;
            if (scrollDown) {
                this.scrollDown();
            }
            this.clearSomeChat(doc);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void scrollDown() {
        this.scroll.validate();
        this.scroll.getVerticalScrollBar().setValue(this.scroll.getVerticalScrollBar().getMaximum());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModerationLog.this.scroll.getVerticalScrollBar().setValue(ModerationLog.this.scroll.getVerticalScrollBar().getMaximum());
            }
        });
    }

    public void clearSomeChat(Document doc) {
        int count = doc.getDefaultRootElement().getElementCount();
        if (count > 100) {
            this.removeFirstLines(doc, 10);
        }
    }

    private void removeFirstLines(Document doc, int amount) {
        if (amount < 1) {
            amount = 1;
        }
        Element firstToRemove = doc.getDefaultRootElement().getElement(0);
        Element lastToRemove = doc.getDefaultRootElement().getElement(amount - 1);
        int startOffset = firstToRemove.getStartOffset();
        int endOffset = lastToRemove.getEndOffset();
        try {
            doc.remove(startOffset, endOffset);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void showDialog() {
        this.setVisible(true);
        this.setDataToCurrent();
    }
}

