/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.ChannelState;
import chatty.gui.GuiUtil;
import chatty.gui.components.settings.PresetsComboSetting;
import chatty.util.DateTime;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ModerationPanel
extends JPanel {
    private final JCheckBox subonlyCheckbox = new JCheckBox("Subscribers-Only Chat");
    private final JCheckBox emoteonlyCheckbox = new JCheckBox("Emotes-Only Chat");
    private final JCheckBox followeronlyCheckbox = new JCheckBox("Followers-Only Chat");
    private final JCheckBox slowmodeCheckbox = new JCheckBox("Slow Mode");
    private final JCheckBox uniquechatCheckbox = new JCheckBox("Unique Chat");
    private final PresetsComboSetting<Long> followeronlyDuration;
    private final PresetsComboSetting<Long> slowmodeDuration;
    private boolean updating;
    private final Set<Consumer<String>> commandListeners = new HashSet<Consumer<String>>();

    public ModerationPanel(Window parent, Settings settings) {
        this.followeronlyDuration = new PresetsComboSetting<Long>(parent, settings, "followeronlyDurations", s -> DateTime.parseDurationSeconds(s), v -> DateTime.duration(v * 1000L, DateTime.Formatting.NO_ZERO_VALUES, DateTime.Formatting.VERBOSE), null, null, false);
        this.followeronlyDuration.init();
        this.slowmodeDuration = new PresetsComboSetting<Long>(parent, settings, "slowmodeDurations", s -> DateTime.parseDurationSeconds(s), v -> DateTime.duration(v * 1000L, DateTime.Formatting.NO_ZERO_VALUES, DateTime.Formatting.VERBOSE), null, null, false);
        this.slowmodeDuration.init();
        this.setLayout(new GridBagLayout());
        JPanel modesPanel = new JPanel(new GridBagLayout());
        modesPanel.setBorder(BorderFactory.createTitledBorder("Channel Modes"));
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 10, 1, 1, 17);
        modesPanel.add((Component)this.subonlyCheckbox, gbc);
        gbc = GuiUtil.makeGbc(0, 11, 1, 1, 17);
        modesPanel.add((Component)this.emoteonlyCheckbox, gbc);
        gbc = GuiUtil.makeGbc(0, 12, 1, 1, 17);
        modesPanel.add((Component)this.uniquechatCheckbox, gbc);
        gbc = GuiUtil.makeGbc(0, 13, 1, 1, 17);
        modesPanel.add((Component)this.followeronlyCheckbox, gbc);
        gbc = GuiUtil.makeGbc(1, 13, 1, 1, 17);
        modesPanel.add(this.followeronlyDuration, gbc);
        gbc = GuiUtil.makeGbc(0, 14, 1, 1, 17);
        modesPanel.add((Component)this.slowmodeCheckbox, gbc);
        gbc = GuiUtil.makeGbc(1, 14, 1, 1, 17);
        modesPanel.add(this.slowmodeDuration, gbc);
        gbc = GuiUtil.makeGbc(0, 0, 1, 1);
        this.add((Component)modesPanel, gbc);
        this.addListener(c -> this.subonlyCheckbox.isSelected() ? "/subscribers" : "/subscribersOff", this.subonlyCheckbox);
        this.addListener(c -> this.emoteonlyCheckbox.isSelected() ? "/emoteonly" : "/emoteonlyOff", this.emoteonlyCheckbox);
        this.addListener(c -> this.uniquechatCheckbox.isSelected() ? "/uniquechat" : "/uniquechatOff", this.uniquechatCheckbox);
        this.addListener(c -> {
            if (this.followeronlyCheckbox.isSelected()) {
                long duration = this.followeronlyDuration.getSelectedValue() / 60L;
                if (duration > 0L) {
                    return "/followers " + duration + "m";
                }
                return "/followers";
            }
            if (c == this.followeronlyCheckbox) {
                return "/followersOff";
            }
            return null;
        }, this.followeronlyCheckbox, this.followeronlyDuration);
        this.addListener(c -> {
            if (this.slowmodeCheckbox.isSelected()) {
                long duration = this.slowmodeDuration.getSelectedValue();
                return "/slow " + duration;
            }
            if (c == this.slowmodeCheckbox) {
                return "/slowOff";
            }
            return null;
        }, this.slowmodeCheckbox, this.slowmodeDuration);
    }

    public void addCommandListener(Consumer<String> listener) {
        if (listener != null) {
            this.commandListeners.add(listener);
        }
    }

    private void addListener(Function<JComponent, String> getCommand, JComponent ... components) {
        for (JComponent c : components) {
            if (c instanceof JCheckBox) {
                ((JCheckBox)c).addItemListener(e -> {
                    if (!this.updating) {
                        this.sendCommand((String)getCommand.apply(c));
                    }
                });
                continue;
            }
            if (!(c instanceof PresetsComboSetting)) continue;
            ((PresetsComboSetting)c).addChangeListener(e -> {
                if (!this.updating) {
                    this.sendCommand((String)getCommand.apply(c));
                }
            });
        }
    }

    private void sendCommand(String command) {
        if (command == null) {
            return;
        }
        for (Consumer<String> listener : this.commandListeners) {
            listener.accept(command);
        }
    }

    public void updateState(ChannelState state) {
        this.updating = true;
        this.subonlyCheckbox.setSelected(state.subMode());
        this.emoteonlyCheckbox.setSelected(state.emoteOnly());
        this.uniquechatCheckbox.setSelected(state.r9kMode());
        this.followeronlyCheckbox.setSelected(state.followersOnly() > -1);
        if (state.followersOnly() > -1) {
            this.followeronlyDuration.setSelectedValue((long)state.followersOnly() * 60L);
        }
        this.slowmodeCheckbox.setSelected(state.slowMode() > 0);
        if (state.slowMode() > 0) {
            this.slowmodeDuration.setSelectedValue(Long.valueOf(state.slowMode()));
        }
        this.updating = false;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            Settings settings = new Settings("", null);
            settings.addString("slowmodeDurations", "1\n2\n3");
            settings.addString("followeronlyDurations", "1\n2\n3");
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(3);
            ModerationPanel panel = new ModerationPanel(frame, settings);
            panel.addCommandListener(s -> System.out.println((String)s));
            frame.add(panel);
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            Timer timer = new Timer(1000, e -> {
                ChannelState state = new ChannelState("test");
                state.setSubMode(true);
                state.setSlowMode(10);
                panel.updateState(state);
            });
            timer.setRepeats(false);
            timer.start();
        });
    }
}

