/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.Channel;
import chatty.lang.Language;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;

public class SearchDialog
extends JDialog {
    private static final Color COLOR_NORMAL = new JLabel().getBackground();
    private static final Color COLOR_NO_RESULT = new Color(255, 165, 80);
    private static final int NO_RESULT_COLOR_TIME = 300;
    private final Timer timer;
    private final JTextField searchText = new JTextField(20);
    private final JButton searchButton = new JButton(Language.getString("searchDialog.button.search"));
    private Channel chan;
    private static final Map<Window, SearchDialog> created = new HashMap<Window, SearchDialog>();

    public static void showSearchDialog(Channel channel, MainGui g, Window owner) {
        SearchDialog dialog = created.get(owner);
        if (dialog == null) {
            dialog = new SearchDialog(g, owner);
            dialog.setLocationRelativeTo(owner);
            GuiUtil.installEscapeCloseOperation(dialog);
            created.put(owner, dialog);
        }
        dialog.setChannel(channel);
        dialog.setVisible(true);
        dialog.pack();
    }

    private SearchDialog(final MainGui g, Window owner) {
        super(owner);
        this.setTitle(Language.getString("searchDialog.title"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        this.add((Component)this.searchText, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        GuiUtil.smallButtonInsets(this.searchButton);
        this.searchButton.setFocusable(false);
        this.add((Component)this.searchButton, gbc);
        this.timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.searchText.setBackground(COLOR_NORMAL);
            }
        });
        this.timer.setRepeats(false);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!g.search(SearchDialog.this.chan, SearchDialog.this.searchText.getText())) {
                    SearchDialog.this.searchText.setBackground(COLOR_NO_RESULT);
                    SearchDialog.this.timer.restart();
                }
            }
        };
        this.searchText.addActionListener(listener);
        this.searchButton.addActionListener(listener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                g.resetSearch(SearchDialog.this.chan);
                SearchDialog.this.searchText.setText(null);
                SearchDialog.this.searchText.setBackground(COLOR_NORMAL);
            }
        });
        this.pack();
    }

    public void setChannel(Channel chan) {
        this.chan = chan;
    }
}

