/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.Room;
import chatty.User;
import chatty.gui.GuiUtil;
import chatty.gui.components.JListActionHelper;
import chatty.lang.Language;
import chatty.util.StringUtil;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class SelectReplyMessage {
    private static final String SETTING = "mentionReplyRestricted";
    private static final SelectReplyMessageResult DONT_SEND_RESULT = new SelectReplyMessageResult(SelectReplyMessageResult.Action.DONT_SEND);
    private static final SelectReplyMessageResult SEND_NORMALLY_RESULT = new SelectReplyMessageResult(SelectReplyMessageResult.Action.SEND_NORMALLY);
    public static Settings settings;

    public static SelectReplyMessageResult show(User user) {
        Dialog dialog = new Dialog(user);
        return dialog.select();
    }

    public static void main(String[] args) {
        User user = new User("sbc", Room.EMPTY);
        user.addMessage("abc", true, "1");
        user.addMessage("abc2", true, "2");
        user.addMessage("abc2", true, null);
        for (int i = 0; i < 30; ++i) {
            user.addMessage("blah" + i, false, i + "msg-id");
        }
        System.out.println(SelectReplyMessage.show(user));
        System.exit(0);
    }

    public static class SelectReplyMessageResult {
        public final String atMsgId;
        public final String atMsg;
        public final Action action;

        public SelectReplyMessageResult(String atMsgId, String atMsg) {
            this.atMsgId = atMsgId;
            this.atMsg = atMsg;
            this.action = Action.REPLY;
        }

        public SelectReplyMessageResult(Action action) {
            this.atMsgId = null;
            this.atMsg = null;
            this.action = action;
        }

        public static enum Action {
            REPLY,
            SEND_NORMALLY,
            DONT_SEND;

        }
    }

    private static class Dialog
    extends JDialog {
        private final JList<User.TextMessage> list;
        private SelectReplyMessageResult result = SelectReplyMessage.access$100();

        private Dialog(User user) {
            super(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow());
            this.setTitle("Send as a reply to a message of " + user);
            this.setLayout(new GridBagLayout());
            this.setResizable(false);
            ArrayList<User.TextMessage> msgs = new ArrayList<User.TextMessage>();
            for (User.Message msg : user.getMessages()) {
                if (!(msg instanceof User.TextMessage)) continue;
                User.TextMessage m = (User.TextMessage)msg;
                if (StringUtil.isNullOrEmpty(m.id)) continue;
                msgs.add(m);
            }
            this.list = new JList<User.TextMessage>(msgs.toArray(new User.TextMessage[msgs.size()]));
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (value != null) {
                        User.TextMessage msg = (User.TextMessage)value;
                        this.setText(msg.text);
                    }
                    return this;
                }
            });
            this.list.setFixedCellWidth(400);
            this.list.setVisibleRowCount(14);
            this.list.setSelectionMode(0);
            JListActionHelper.install(this.list, (action, location, selected) -> {
                if (action == JListActionHelper.Action.ENTER || action == JListActionHelper.Action.DOUBLE_CLICK) {
                    this.confirm();
                } else if (action == JListActionHelper.Action.CTRL_ENTER) {
                    this.result = SEND_NORMALLY_RESULT;
                    this.setVisible(false);
                }
            }, false);
            JButton ok = new JButton("Send reply");
            ok.addActionListener(e -> this.confirm());
            JButton decline = new JButton("Send normally");
            decline.addActionListener(e -> {
                this.result = SEND_NORMALLY_RESULT;
                this.setVisible(false);
            });
            if (settings != null) {
                JCheckBox restrictSetting = new JCheckBox("Only show when message starts with @@<username>");
                restrictSetting.setSelected(settings.getBoolean(SelectReplyMessage.SETTING));
                restrictSetting.addItemListener(e -> settings.setBoolean(SelectReplyMessage.SETTING, restrictSetting.isSelected()));
                this.add((Component)restrictSetting, GuiUtil.makeGbc(0, 2, 3, 1, 17));
            }
            JButton cancel = new JButton(Language.getString("dialog.button.cancel"));
            cancel.setToolTipText("Don't send message at all");
            cancel.addActionListener(e -> {
                this.result = DONT_SEND_RESULT;
                this.setVisible(false);
            });
            this.add((Component)new JScrollPane(this.list), GuiUtil.makeGbc(0, 0, 3, 1));
            this.add((Component)new JLabel("<html><body style='width:380'>Tip: Press <kbd>Enter</kbd> to send reply, <kbd>Ctrl+Enter</kbd> to send normally, <kbd>ESC</kbd> to cancel"), GuiUtil.makeGbc(0, 3, 3, 1, 17));
            GridBagConstraints gbc = GuiUtil.makeGbc(0, 4, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.add((Component)ok, gbc);
            gbc = GuiUtil.makeGbc(1, 4, 1, 1);
            gbc.fill = 2;
            this.add((Component)decline, gbc);
            gbc = GuiUtil.makeGbc(2, 4, 1, 1);
            gbc.fill = 2;
            this.add((Component)cancel, gbc);
            this.pack();
            this.setModal(true);
            GuiUtil.installEscapeCloseOperation(this);
        }

        private void confirm() {
            User.TextMessage selected = this.list.getSelectedValue();
            if (selected != null) {
                this.result = new SelectReplyMessageResult(selected.id, selected.text);
            }
            this.setVisible(false);
        }

        public SelectReplyMessageResult select() {
            if (this.list.getModel().getSize() == 0) {
                return SEND_NORMALLY_RESULT;
            }
            this.list.setSelectedIndex(this.list.getModel().getSize() - 1);
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
            this.setLocationRelativeTo(this.getParent());
            this.setVisible(true);
            return this.result;
        }
    }
}

