/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.util.Debugging;
import chatty.util.ElapsedTime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class SimplePopup {
    private static final Border POPUP_BORDER_ERROR = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.RED), BorderFactory.createEmptyBorder(5, 5, 5, 5));
    private static final Border POPUP_BORDER_REGULAR = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5));
    private final Component owner;
    private final SimplePopupListener listener;
    private Popup popup;
    private Timer timer;
    private final ElapsedTime shownTime;
    private String text;
    private int position;
    private BorderStyle borderStyle;
    private int showDuration;
    private AncestorListener visibilityListener;

    public SimplePopup(Component owner, SimplePopupListener listener) {
        this.owner = owner;
        this.listener = listener;
        this.shownTime = new ElapsedTime();
    }

    public void showPopup(String text) {
        this.showPopup(text, -1, 2000, BorderStyle.ERROR);
    }

    private void addVisibilityListener() {
        if (this.visibilityListener == null && this.owner instanceof JComponent) {
            this.visibilityListener = new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    SimplePopup.this.reshow();
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    SimplePopup.this.tempHide();
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            };
            ((JComponent)this.owner).addAncestorListener(this.visibilityListener);
        }
    }

    private void removeVisibilityListener() {
        if (this.visibilityListener != null && this.owner instanceof JComponent) {
            ((JComponent)this.owner).removeAncestorListener(this.visibilityListener);
            this.visibilityListener = null;
        }
    }

    public void showPopup(String text, int position, int duration, BorderStyle borderStyle) {
        if (this.owner == null || !this.owner.isShowing()) {
            return;
        }
        this.showDuration = duration;
        this.hideNow();
        this.text = text;
        this.position = position;
        this.borderStyle = borderStyle;
        JLabel label = new JLabel(text);
        label.setOpaque(false);
        label.setBorder(borderStyle == BorderStyle.REGULAR ? POPUP_BORDER_REGULAR : POPUP_BORDER_ERROR);
        label.addMouseMotionListener(new MouseAdapter(){
            private int movedCount;

            @Override
            public void mouseMoved(MouseEvent e) {
                ++this.movedCount;
                if (this.movedCount > 1) {
                    SimplePopup.this.hidePopup();
                    if (SimplePopup.this.listener != null) {
                        SimplePopup.this.listener.popupHidden();
                    }
                }
            }
        });
        Dimension labelSize = label.getPreferredSize();
        Point location = this.owner.getLocationOnScreen();
        if (this.owner instanceof JTextComponent) {
            try {
                JTextComponent textComponent = (JTextComponent)this.owner;
                if (position == -1) {
                    position = textComponent.getCaretPosition();
                }
                location = textComponent.modelToView(position).getLocation();
                SwingUtilities.convertPointToScreen(location, textComponent);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.popup = PopupFactory.getSharedInstance().getPopup(this.owner, label, location.x, location.y - labelSize.height - 5);
        this.popup.show();
        this.shownTime.setSync();
        this.addVisibilityListener();
        this.createTimer(this.showDuration);
        this.timer.start();
    }

    private void createTimer(int duration) {
        this.timer = new Timer(duration, e -> {
            this.hidePopup();
            if (this.listener != null) {
                this.listener.popupHidden();
            }
        });
        this.timer.setRepeats(false);
    }

    public void update() {
        if (this.popup != null) {
            this.showDuration = (int)((long)this.showDuration - this.shownTime.millisElapsedSync());
            if (this.showDuration > 0) {
                this.showPopup(this.text, this.position, this.showDuration, this.borderStyle);
            }
        }
    }

    private void hidePopup() {
        Debugging.edtLoud();
        this.hideNow();
        this.showDuration = 0;
        this.removeVisibilityListener();
    }

    private void tempHide() {
        this.hideNow();
        this.showDuration = (int)((long)this.showDuration - this.shownTime.millisElapsedSync());
    }

    private void reshow() {
        if (this.popup == null && this.showDuration > 500) {
            this.showPopup(this.text, this.position, this.showDuration, this.borderStyle);
        } else {
            this.removeVisibilityListener();
        }
    }

    private void hideNow() {
        if (this.popup != null) {
            this.popup.hide();
            this.timer.stop();
            this.popup = null;
        }
    }

    public static interface SimplePopupListener {
        public void popupHidden();
    }

    public static enum BorderStyle {
        REGULAR,
        ERROR;

    }
}

