/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.util.CombinedIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractListModel;

public class SortedListModel<E>
extends AbstractListModel<E>
implements Iterable<E> {
    private final ArrayList<E> data = new ArrayList();
    private Comparator<? super E> comparator = null;
    private Predicate<E> filter;
    private final List<E> removedByFilter = new ArrayList();

    public void setComparator(Comparator<? super E> c) {
        this.comparator = c;
    }

    public void setFilter(Predicate<E> filter) {
        this.filter = filter;
        this.updateFiltering();
    }

    public void updateFiltering() {
        if (this.filter == null) {
            this.removedByFilter.forEach(item -> this.addInternal(item));
            this.removedByFilter.clear();
        } else {
            List<E> toAdd = this.filterList(this.removedByFilter, true);
            this.removedByFilter.removeAll(toAdd);
            List<E> toRemove = this.filterList(this.data, false);
            for (E item2 : toRemove) {
                this.removeInternal(item2);
            }
            this.removedByFilter.addAll(toRemove);
            for (E item2 : toAdd) {
                this.addInternal(item2);
            }
        }
    }

    private List<E> filterList(List<E> list, boolean testValue) {
        ArrayList<E> result = new ArrayList<E>();
        for (E item : list) {
            if (this.filter.test(item) != testValue) continue;
            result.add(item);
        }
        return result;
    }

    public void resort() {
        if (this.comparator != null) {
            Collections.sort(this.data, this.comparator);
            super.fireContentsChanged(this, 0, this.data.size());
        }
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    public int getTotalSize() {
        return this.data.size() + this.removedByFilter.size();
    }

    @Override
    public E getElementAt(int index) {
        return this.data.get(index);
    }

    public void add(E item) {
        if (this.filter != null && !this.filter.test(item)) {
            this.removedByFilter.add(item);
        } else {
            this.addInternal(item);
        }
    }

    private void addInternal(E item) {
        int insertionPoint = this.findInsertionPoint(item);
        this.data.add(insertionPoint, item);
        super.fireIntervalAdded(this, insertionPoint, insertionPoint);
    }

    public boolean contains(E item) {
        return this.data.contains(item) || this.removedByFilter.contains(item);
    }

    public void remove(E item) {
        this.removedByFilter.remove(item);
        this.removeInternal(item);
    }

    private void removeInternal(E item) {
        int index = this.data.indexOf(item);
        if (index == -1) {
            return;
        }
        this.data.remove(index);
        super.fireIntervalRemoved(this, index, index);
    }

    private int findInsertionPoint(E item) {
        int insertionPoint = Collections.binarySearch(this.data, item, this.comparator);
        if (insertionPoint < 0) {
            insertionPoint = -(insertionPoint + 1);
        }
        return insertionPoint;
    }

    public void clear() {
        if (!this.data.isEmpty()) {
            super.fireIntervalRemoved(this, 0, this.data.size() - 1);
            this.data.clear();
        }
        this.removedByFilter.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return new CombinedIterator<E>(this.data, this.removedByFilter);
    }
}

