/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.User;
import chatty.gui.DockStyledTabContainer;
import chatty.gui.DockedDialogHelper;
import chatty.gui.DockedDialogManager;
import chatty.gui.MainGui;
import chatty.gui.StyleManager;
import chatty.gui.StyleServer;
import chatty.gui.components.menus.ContextMenuAdapter;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.StreamChatContextMenu;
import chatty.gui.components.textpane.ChannelTextPane;
import chatty.gui.components.textpane.Message;
import chatty.util.Timestamp;
import chatty.util.colors.ColorCorrector;
import chatty.util.dnd.DockContent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class StreamChat
extends JDialog {
    private final DockedDialogHelper helper;
    private final DockStyledTabContainer content;
    private final ChannelTextPane textPane;
    private final ContextMenuListener contextMenuListener;

    public StreamChat(final MainGui g, final StyleManager styles, ContextMenuListener contextMenuListener, boolean startAtBottom, DockedDialogManager dockedDialogs) {
        super(g);
        this.contextMenuListener = contextMenuListener;
        this.setTitle("Stream Chat");
        StyleServer modifiedStyleServer = new StyleServer(){

            @Override
            public Color getColor(String type) {
                return styles.getColor(type);
            }

            @Override
            public MutableAttributeSet getStyle(String type) {
                if (type.equals("settings")) {
                    SimpleAttributeSet attr = new SimpleAttributeSet(styles.getStyle(type));
                    int channelLogoSize = -1;
                    try {
                        channelLogoSize = Integer.parseInt(g.getSettings().getString("streamChatLogos"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    attr.addAttribute((Object)ChannelTextPane.Setting.CHANNEL_LOGO_SIZE, channelLogoSize);
                    return attr;
                }
                return styles.getStyle(type);
            }

            @Override
            public Font getFont(String type) {
                return styles.getFont(type);
            }

            @Override
            public Timestamp getTimestampFormat() {
                return styles.getTimestampFormat();
            }

            @Override
            public ColorCorrector getColorCorrector() {
                return styles.getColorCorrector();
            }
        };
        this.textPane = new TextPane(g, modifiedStyleServer, startAtBottom);
        this.textPane.setContextMenuListener(new ContextMenuAdapter(contextMenuListener){

            @Override
            public void menuItemClicked(ActionEvent e) {
                if (e.getActionCommand().equals("clearHighlights")) {
                    StreamChat.this.textPane.clearAll();
                }
                StreamChat.this.helper.menuAction(e);
                super.menuItemClicked(e);
            }
        });
        JScrollPane scroll = new JScrollPane(this.textPane);
        scroll.setVerticalScrollBarPolicy(22);
        this.textPane.setScrollPane(scroll);
        this.add((Component)scroll, "Center");
        this.content = dockedDialogs.createStyledContent(scroll, "Stream Chat", "-streamChat-");
        this.helper = dockedDialogs.createHelper(new DockedDialogHelper.DockedDialog(){

            @Override
            public void setVisible(boolean visible) {
                StreamChat.super.setVisible(visible);
            }

            @Override
            public boolean isVisible() {
                return StreamChat.super.isVisible();
            }

            @Override
            public void addComponent(Component comp) {
                StreamChat.this.add(comp, "Center");
            }

            @Override
            public void removeComponent(Component comp) {
                StreamChat.this.remove(comp);
            }

            @Override
            public Window getWindow() {
                return StreamChat.this;
            }

            @Override
            public DockContent getContent() {
                return StreamChat.this.content;
            }
        });
        this.setSize(400, 200);
    }

    @Override
    public void setVisible(boolean visible) {
        this.helper.setVisible(visible, true);
    }

    @Override
    public boolean isVisible() {
        return this.helper.isVisible();
    }

    public void printMessage(Message message) {
        this.textPane.printMessage(message);
        if (this.helper.isDocked() && !this.content.isContentVisible()) {
            this.content.setNewMessage(true);
        }
    }

    public void userBanned(User user, long duration, String reason, String id) {
        this.textPane.userBanned(user, duration, reason, id);
    }

    public void setMessageTimeout(int seconds) {
        this.textPane.setMessageTimeout(seconds);
    }

    public void refreshStyles() {
        this.textPane.refreshStyles();
    }

    public void clear() {
        this.textPane.clearAll();
    }

    class TextPane
    extends ChannelTextPane {
        public TextPane(MainGui main, StyleServer styleServer, boolean startAtBottom) {
            super(main, styleServer, ChannelTextPane.Type.STREAM_CHAT, startAtBottom, main.getSettings().getBoolean("chatInsertTop"));
            this.linkController.setContextMenuCreator(() -> new StreamChatContextMenu(StreamChat.this.helper.isDocked()));
        }
    }
}

