/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.gui.MainGui;
import chatty.gui.components.LinkLabel;
import chatty.lang.Language;
import chatty.util.api.TokenInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class TokenDialog
extends JDialog {
    private static final ImageIcon OK_IMAGE = new ImageIcon(TokenDialog.class.getResource("ok.png"));
    private static final ImageIcon NO_IMAGE = new ImageIcon(TokenDialog.class.getResource("no.png"));
    private final JLabel nameLabel = new JLabel(Language.getString("login.accountName"));
    private final JLabel name = new JLabel("<no account>");
    private final LinkLabel accessLabel;
    private final JPanel access;
    private final Map<String, JLabel> accessScopes = new HashMap<String, JLabel>();
    private final JButton deleteToken = new JButton(Language.getString("login.button.removeLogin"));
    private final JButton requestToken = new JButton(Language.getString("login.button.requestLogin"));
    private final JButton verifyToken = new JButton(Language.getString("login.button.verifyLogin"));
    private final LinkLabel foreignTokenInfo;
    private final LinkLabel otherInfo;
    private final JButton done = new JButton(Language.getString("dialog.button.close"));
    private String currentUsername = "";
    private String currentToken = "";

    public TokenDialog(MainGui owner) {
        super(owner, Language.getString("login.title"), true);
        this.setResizable(false);
        this.setLayout(new GridBagLayout());
        this.accessLabel = new LinkLabel("Access: [help:login (help)]", owner.getLinkLabelListener());
        this.foreignTokenInfo = new LinkLabel("<html><body>Login data set externally with -token parameter.", owner.getLinkLabelListener());
        this.foreignTokenInfo.setVisible(false);
        this.otherInfo = new LinkLabel("<html><body>To add or reduce access remove login and request again.", owner.getLinkLabelListener());
        this.add((Component)this.nameLabel, this.makeGridBagConstraints(0, 0, 1, 1, 17));
        this.add((Component)this.name, this.makeGridBagConstraints(0, 1, 2, 1, 10, new Insets(0, 5, 5, 5)));
        this.add((Component)this.accessLabel, this.makeGridBagConstraints(0, 2, 1, 1, 17));
        this.access = new JPanel();
        this.access.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.anchor = 17;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        Insets categoryInsets = new Insets(0, 5, 5, 5);
        Insets scopeInsets = new Insets(0, 5, 0, 5);
        for (TokenInfo.ScopeCategory scopeCat : TokenInfo.ScopeCategory.values()) {
            JLabel label = new JLabel(scopeCat.label);
            gbc2.insets = categoryInsets;
            this.access.add((Component)label, gbc2);
            ++gbc2.gridy;
            for (TokenInfo.Scope scope : scopeCat.scopes) {
                label = new JLabel(scope.label);
                label.setToolTipText(scope.description);
                this.accessScopes.put(scope.scope, label);
                ++gbc2.gridy;
                gbc2.insets = scopeInsets;
                this.access.add((Component)label, gbc2);
            }
            gbc2.gridy = 0;
            ++gbc2.gridx;
        }
        GridBagConstraints gbc = this.makeGridBagConstraints(0, 3, 2, 1, 10, new Insets(0, 5, 5, 5));
        this.add((Component)this.access, gbc);
        gbc = this.makeGridBagConstraints(0, 4, 2, 1, 17);
        this.add((Component)this.otherInfo, gbc);
        gbc = this.makeGridBagConstraints(0, 6, 2, 1, 17);
        this.add((Component)this.foreignTokenInfo, gbc);
        this.deleteToken.setToolTipText(Language.getString("login.button.removeLogin.tip"));
        gbc = this.makeGridBagConstraints(0, 7, 1, 1, 17);
        gbc.fill = 2;
        this.add((Component)this.deleteToken, gbc);
        gbc = this.makeGridBagConstraints(0, 7, 2, 1, 10);
        this.add((Component)this.requestToken, gbc);
        gbc = this.makeGridBagConstraints(1, 7, 1, 1, 17);
        gbc.fill = 2;
        this.add((Component)this.verifyToken, gbc);
        gbc = this.makeGridBagConstraints(0, 8, 2, 1, 13);
        gbc.fill = 2;
        this.add((Component)this.done, gbc);
        ActionListener actionListener = owner.getActionListener();
        this.requestToken.addActionListener(actionListener);
        this.deleteToken.addActionListener(actionListener);
        this.verifyToken.addActionListener(actionListener);
        this.done.addActionListener(actionListener);
        this.pack();
    }

    public JButton getRequestTokenButton() {
        return this.requestToken;
    }

    public JButton getDeleteTokenButton() {
        return this.deleteToken;
    }

    public JButton getVerifyTokenButton() {
        return this.verifyToken;
    }

    public JButton getDoneButton() {
        return this.done;
    }

    public void update() {
        boolean empty = this.currentUsername.isEmpty() || this.currentToken.isEmpty();
        this.deleteToken.setVisible(!empty);
        this.requestToken.setVisible(empty);
        this.verifyToken.setVisible(!empty);
        this.otherInfo.setVisible(!empty);
        this.pack();
    }

    public void update(String username, String currentToken) {
        this.currentUsername = username;
        this.currentToken = currentToken;
        if (this.currentUsername.isEmpty() || currentToken.isEmpty()) {
            this.name.setText(Language.getString("login.createLogin"));
        } else {
            this.name.setText(this.currentUsername);
        }
        this.update();
    }

    public void updateAccess(Collection<String> scopes) {
        boolean empty = this.currentUsername.isEmpty() || this.currentToken.isEmpty();
        this.access.setVisible(!empty);
        this.accessLabel.setVisible(!empty);
        for (TokenInfo.Scope s : TokenInfo.Scope.values()) {
            JLabel label = this.accessScopes.get(s.scope);
            boolean enabled = scopes.contains(s.scope);
            if (enabled) {
                label.setIcon(OK_IMAGE);
                continue;
            }
            label.setIcon(NO_IMAGE);
        }
        this.update();
    }

    public void verifyingToken() {
        this.verifyToken.setEnabled(false);
    }

    public void tokenVerified(boolean valid, String result) {
        if (this.isVisible()) {
            JOptionPane.showMessageDialog(this, result);
        }
        this.verifyToken.setEnabled(true);
        this.update();
    }

    public void setForeignToken(boolean foreign) {
        this.foreignTokenInfo.setVisible(foreign);
        this.pack();
    }

    private GridBagConstraints makeGridBagConstraints(int x, int y, int w, int h, int anchor, Insets insets) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = w;
        constraints.gridheight = h;
        constraints.insets = insets;
        constraints.anchor = anchor;
        return constraints;
    }

    private GridBagConstraints makeGridBagConstraints(int x, int y, int w, int h, int anchor) {
        return this.makeGridBagConstraints(x, y, w, h, anchor, new Insets(5, 5, 5, 5));
    }
}

