/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.gui.MainGui;
import chatty.gui.UrlOpener;
import chatty.gui.components.LinkLabel;
import chatty.lang.Language;
import chatty.util.MiscUtil;
import chatty.util.api.TokenInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TokenGetDialog
extends JDialog
implements ItemListener,
ActionListener {
    private final JTextField urlField = new JTextField(20);
    private final LinkLabel status;
    private final JButton copyUrl = new JButton(Language.getString("openUrl.button.copy"));
    private final JButton openUrl = new JButton(Language.getString("openUrl.button.open", 1));
    private final JButton close = new JButton(Language.getString("dialog.button.close"));
    private final Map<TokenInfo.Scope, JCheckBox> checkboxes = new HashMap<TokenInfo.Scope, JCheckBox>();
    private String currentUrl = "https://id.twitch.tv/oauth2/authorize?response_type=token&client_id=spyiu9jqdnfjtwv6l1xjk5zgt8qb91l&redirect_uri=http://127.0.0.1:61324/token/&force_verify=true&scope=";

    public TokenGetDialog(MainGui owner) {
        super(owner, "Get login data", true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(owner.getWindowListener());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = this.makeGridBagConstraints(0, 0, 2, 1, 10);
        gbc.insets = new Insets(5, 5, 10, 5);
        this.add((Component)new LinkLabel("<html><body style='width:300px;'>" + Language.getString("login.getTokenInfo"), owner.getLinkLabelListener()), gbc);
        JPanel permissions = new JPanel(new GridBagLayout());
        permissions.setBorder(BorderFactory.createTitledBorder(Language.getString("login.tokenPermissions")));
        int x = 0;
        int y = 0;
        for (TokenInfo.ScopeCategory cat : TokenInfo.ScopeCategory.values()) {
            JLabel categoryLabel = new JLabel(cat.label);
            gbc = this.makeGridBagConstraints(x, y, 1, 1, 17);
            permissions.add((Component)categoryLabel, gbc);
            ++y;
            for (TokenInfo.Scope scope : cat.scopes) {
                JCheckBox checkbox = new JCheckBox(scope.label);
                checkbox.setToolTipText(scope.description);
                checkbox.setSelected(true);
                checkbox.addItemListener(e -> this.updateUrl());
                if (scope == TokenInfo.Scope.CHAT_EDIT || scope == TokenInfo.Scope.CHAT_READ) {
                    checkbox.setEnabled(false);
                }
                gbc = this.makeGridBagConstraints(x, y, 1, 1, 17);
                gbc.insets = new Insets(0, 5, 0, 5);
                this.checkboxes.put(scope, checkbox);
                permissions.add((Component)checkbox, gbc);
                ++y;
            }
            ++x;
            y = 0;
        }
        y = 10;
        gbc = this.makeGridBagConstraints(0, 1, 2, 1, 17);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)permissions, gbc);
        gbc = this.makeGridBagConstraints(0, y + 1, 2, 1, 10);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 5, 10, 5);
        this.urlField.setEditable(false);
        this.urlField.setToolTipText(Language.getString("login.tokenUrlInfo"));
        this.add((Component)this.urlField, gbc);
        gbc = this.makeGridBagConstraints(0, y + 2, 1, 1, 13);
        gbc.insets = new Insets(0, 5, 10, 5);
        gbc.fill = 2;
        gbc.weightx = 0.5;
        this.add((Component)this.copyUrl, gbc);
        gbc = this.makeGridBagConstraints(1, y + 2, 1, 1, 13);
        gbc.insets = new Insets(0, 0, 10, 5);
        gbc.fill = 2;
        gbc.weightx = 0.5;
        this.add((Component)this.openUrl, gbc);
        this.status = new LinkLabel("", owner.getLinkLabelListener());
        this.add((Component)this.status, this.makeGridBagConstraints(0, y + 3, 2, 1, 10));
        gbc = this.makeGridBagConstraints(0, y + 4, 2, 1, 13);
        gbc.fill = 2;
        this.add((Component)this.close, gbc);
        this.openUrl.addActionListener(this);
        this.copyUrl.addActionListener(this);
        this.close.addActionListener(owner.getActionListener());
        this.reset();
        this.updateUrl();
        this.pack();
    }

    public JButton getCloseButton() {
        return this.close;
    }

    public final void reset() {
        this.openUrl.setEnabled(false);
        this.copyUrl.setEnabled(false);
        this.urlField.setEnabled(false);
        this.setStatus("Please wait..");
    }

    public void ready() {
        this.openUrl.setEnabled(true);
        this.copyUrl.setEnabled(true);
        this.urlField.setEnabled(true);
        this.setStatus("Ready.");
    }

    public void error(String errorMessage) {
        this.openUrl.setEnabled(true);
        this.copyUrl.setEnabled(true);
        this.urlField.setEnabled(true);
        this.setStatus("Error: " + errorMessage + "<br />Read the [help-guide2: help] on how to proceed.");
    }

    public void tokenReceived() {
        this.setStatus("Token received.. completing..");
    }

    private void setStatus(String text) {
        this.status.setText("<html><body style='width:250px;text-align:center'>" + text);
        this.pack();
    }

    private GridBagConstraints makeGridBagConstraints(int x, int y, int w, int h, int anchor) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = w;
        constraints.gridheight = h;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.anchor = anchor;
        return constraints;
    }

    private void updateUrl() {
        String url;
        String scopes = "";
        ArrayList<String> sortedScopes = new ArrayList<String>();
        for (Map.Entry<TokenInfo.Scope, JCheckBox> entry : this.checkboxes.entrySet()) {
            JCheckBox checkbox = entry.getValue();
            if (!checkbox.isSelected()) continue;
            sortedScopes.add(entry.getKey().scope);
        }
        Collections.sort(sortedScopes);
        for (String scope : sortedScopes) {
            scopes = scopes + "+" + scope;
        }
        if (!scopes.isEmpty()) {
            scopes = scopes.substring(1);
        }
        this.currentUrl = url = "https://id.twitch.tv/oauth2/authorize?response_type=token&client_id=spyiu9jqdnfjtwv6l1xjk5zgt8qb91l&redirect_uri=http://127.0.0.1:61324/token/&force_verify=true&scope=" + scopes;
        this.urlField.setText(url);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateUrl();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.openUrl) {
            UrlOpener.openUrlPrompt(this, this.currentUrl);
        } else if (e.getSource() == this.copyUrl) {
            MiscUtil.copyToClipboard(this.currentUrl);
        }
    }
}

