/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.Helper;
import chatty.User;
import chatty.gui.UserListener;
import chatty.gui.UserlistModel;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.UserContextMenu;
import chatty.util.settings.Settings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class UserList
extends JList<User> {
    private final UserlistModel<User> data = new UserlistModel();
    private final ContextMenuListener contextMenuListener;
    private final UserListener userListener;
    private long displayNamesMode = 1L;

    public UserList(ContextMenuListener contextMenuListener, UserListener userListener, final Settings settings) {
        this.setModel(this.data);
        this.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Color userColor;
                if (value == null) {
                    this.setText("");
                    this.setToolTipText("error");
                    return this;
                }
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                User user = (User)value;
                this.setText(Helper.makeDisplayNick(user, UserList.this.displayNamesMode));
                if (!isSelected && settings.getBoolean("displayColoredNamesInUserlist") && (userColor = user.getDisplayColor2()) != null) {
                    this.setForeground(userColor);
                }
                return this;
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserList.this.userSelected(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                UserList.this.openContextMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                UserList.this.openContextMenu(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.contextMenuListener = contextMenuListener;
        this.userListener = userListener;
    }

    public void setDisplayNamesMode(long mode) {
        this.displayNamesMode = mode;
        this.data.update();
    }

    public void addUser(User user) {
        this.data.add(user);
    }

    public void removeUser(User user) {
        this.data.remove(user);
    }

    public void updateUser(User user) {
        this.data.remove(user);
        this.data.add(user);
    }

    public void resort() {
        this.data.sort();
    }

    public void clearUsers() {
        this.data.clear();
    }

    public int getNumUsers() {
        return this.data.getSize();
    }

    public ArrayList<User> getData() {
        return this.data.getData();
    }

    private void openContextMenu(MouseEvent e) {
        User user;
        if (e.isPopupTrigger() && (user = this.getUser(e)) != null) {
            UserContextMenu m = new UserContextMenu(user, null, null, this.contextMenuListener);
            m.show(this, e.getX(), e.getY());
        }
    }

    private User getUser(MouseEvent e) {
        int index = this.locationToIndex(e.getPoint());
        Rectangle bounds = this.getCellBounds(index, index);
        if (bounds != null && bounds.contains(e.getPoint())) {
            this.setSelectedIndex(index);
            return (User)this.getSelectedValue();
        }
        return null;
    }

    private void userSelected(MouseEvent e) {
        User user = this.getUser(e);
        if (user != null) {
            this.userListener.userClicked(user, null, null, e);
        }
    }
}

