/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.Helper;
import chatty.gui.components.ViewerHistoryListener;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.HistoryContextMenu;
import chatty.gui.laf.LaF;
import chatty.lang.Language;
import chatty.util.api.StreamInfo;
import chatty.util.api.StreamInfoHistoryItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ViewerHistory
extends JComponent {
    private static final Logger LOGGER = Logger.getLogger(ViewerHistory.class.getName());
    private static final float ONE_HOUR = 3600000.0f;
    private static final int POINT_SIZE = 5;
    private static final Color FIRST_COLOR = new Color(20, 180, 62);
    private static final Color SECOND_COLOR = new Color(0, 0, 220);
    private static final Color SECOND_COLOR_DARK = new Color(160, 160, 255);
    private static final Color OFFLINE_COLOR = new Color(255, 140, 140);
    private static final Color HOVER_COLOR = Color.WHITE;
    private static final int HOVER_RADIUS = 18;
    private Font font = new Font("Dialog", 0, 12);
    private static final int MARGIN = 8;
    private static final int CONSIDERED_AS_NOW = 200000;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
    private Color foreground_color = Color.BLACK;
    private Color background_color = new Color(250, 250, 250);
    private LinkedHashMap<Long, StreamInfoHistoryItem> history;
    private int maxValue;
    private int minValue;
    private long startTime;
    private long endTime;
    private long duration;
    private long currentRange = 0L;
    private long fixedStartTime = 0L;
    private long fixedEndTime = 0L;
    private final Map<String, Long> fixedStartTimes = new HashMap<String, Long>();
    private final Map<String, Long> fixedEndTimes = new HashMap<String, Long>();
    private String currentStream = null;
    private LinkedHashMap<Point, Long> locations = new LinkedHashMap();
    private LinkedHashMap<Long, Color> colors = new LinkedHashMap();
    private final HistoryContextMenu contextMenu = new HistoryContextMenu();
    private boolean mouseEntered = false;
    private boolean showInfo = true;
    private long hoverEntry = -1L;
    private boolean fixedHoverEntry = false;
    private boolean verticalZoom = false;
    private ViewerHistoryListener listener;

    public ViewerHistory() {
        MyMouseListener mouseListener = new MyMouseListener();
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.setOpaque(false);
    }

    public void setListener(ViewerHistoryListener listener) {
        this.listener = listener;
    }

    private boolean isShowingInfo() {
        if (this.showInfo) {
            return true;
        }
        return this.mouseEntered;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.locations.clear();
        g.setColor(this.foreground_color);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fontMetrics = g.getFontMetrics(this.font);
        int fontHeight = fontMetrics.getHeight();
        g.setFont(this.font);
        int topTextY = fontMetrics.getAscent();
        int vMargin = fontHeight + 8;
        int hMargin = 8;
        double width = this.getWidth() - hMargin * 2;
        double height = this.getHeight() - vMargin * 2;
        boolean drawLowerLine = height > (double)(-vMargin);
        int nowTextX = 0;
        if (this.history != null && this.hoverEntry == -1L) {
            Integer viewers = this.history.get(this.endTime).getViewers();
            long ago = System.currentTimeMillis() - this.endTime;
            String text = ago > 200000L ? Language.getString("channelInfo.viewers.latest", Helper.formatViewerCount(viewers)) : Language.getString("channelInfo.viewers.now", Helper.formatViewerCount(viewers));
            if (viewers == -1) {
                text = Language.getString("channelInfo.streamOffline");
            }
            nowTextX = this.getWidth() - fontMetrics.stringWidth(text);
            g.drawString(text, nowTextX, topTextY);
        }
        if (this.history == null || this.history.size() < 2) {
            String text = Language.getString("channelInfo.viewers.noHistory");
            int textWidth = fontMetrics.stringWidth(text);
            int y = this.getHeight() / 2 + fontMetrics.getDescent();
            int x = (this.getWidth() - textWidth) / 2;
            boolean drawInfoText = false;
            if (this.history != null && y < topTextY + fontHeight + 4 && x + textWidth + 7 > nowTextX) {
                if (drawLowerLine || nowTextX > textWidth + 5) {
                    y = drawLowerLine ? this.getHeight() - 2 : topTextY;
                    x = 0;
                    drawInfoText = true;
                }
            } else {
                drawInfoText = true;
            }
            if (drawInfoText) {
                g.drawString(text, x, y);
            }
            return;
        }
        String maxValueText = Language.getString("channelInfo.viewers.max", Helper.formatViewerCount(this.maxValue));
        int maxValueEnd = fontMetrics.stringWidth(maxValueText);
        boolean displayMaxValue = true;
        if (this.hoverEntry != -1L) {
            int x;
            Integer viewers = this.history.get(this.hoverEntry).getViewers();
            Date d = new Date(this.hoverEntry);
            String text = Language.getString("channelInfo.viewers.hover", Helper.formatViewerCount(viewers)) + " (" + sdf.format(d) + ")";
            if (viewers == -1) {
                text = Language.getString("channelInfo.streamOffline") + " (" + sdf.format(d) + ")";
            }
            if (maxValueEnd > (x = this.getWidth() - fontMetrics.stringWidth(text))) {
                displayMaxValue = false;
            }
            g.drawString(text, x, topTextY);
        }
        String minText = Language.getString("channelInfo.viewers.min", Helper.formatViewerCount(this.minValue));
        int minTextWidth = fontMetrics.stringWidth(minText);
        if (drawLowerLine) {
            String timeText = this.makeTimesText(this.startTime, this.endTime);
            int timeTextWidth = fontMetrics.stringWidth(timeText);
            int textX = this.getWidth() - timeTextWidth;
            g.drawString(timeText, textX, this.getHeight() - 1);
            if (this.minValue >= 1000 && (double)(timeTextWidth + minTextWidth) > width) {
                minText = Language.getString("channelInfo.viewers.min", this.minValue / 1000) + "k";
            }
        }
        if (this.isShowingInfo()) {
            if (displayMaxValue) {
                g.drawString(maxValueText, 0, topTextY);
            }
            if (drawLowerLine) {
                g.drawString(minText, 0, this.getHeight() - 1);
            } else if (maxValueEnd + minTextWidth + 29 < nowTextX) {
                g.drawString(minText, maxValueEnd + 10, topTextY);
            }
        }
        if (height < 5.0) {
            return;
        }
        int range = this.maxValue - this.minValue;
        if (!this.verticalZoom) {
            range = this.maxValue;
        }
        if (range == 0) {
            range = 1;
        }
        double pixelPerViewer = height / (double)range;
        double pixelPerTime = width / (double)this.duration;
        int prevX = -1;
        int prevY = -1;
        StreamInfoHistoryItem prevItem = null;
        for (Map.Entry<Long, StreamInfoHistoryItem> entry : this.history.entrySet()) {
            long time = entry.getKey();
            if (time < this.startTime || time > this.endTime) continue;
            long offsetTime = time - this.startTime;
            int viewers = entry.getValue().getViewers();
            if (viewers == -1) {
                viewers = 0;
            }
            int x = (int)((double)hMargin + (double)offsetTime * pixelPerTime);
            int y = !this.verticalZoom ? (int)((double)(-vMargin + this.getHeight()) - (double)viewers * pixelPerViewer) : (int)((double)(-vMargin + this.getHeight()) - (double)(viewers - this.minValue) * pixelPerViewer);
            if (prevX != -1) {
                if (entry.getValue().getStreamType() != StreamInfo.StreamType.LIVE && prevItem != null && prevItem.getStreamType() != StreamInfo.StreamType.LIVE) {
                    g.setColor(Color.LIGHT_GRAY);
                } else {
                    g.setColor(this.foreground_color);
                }
                g.drawLine(x, y, prevX, prevY);
            }
            prevX = x;
            prevY = y;
            prevItem = entry.getValue();
            this.locations.put(new Point(x, y), time);
        }
        prevItem = null;
        for (Point point : this.locations.keySet()) {
            int x = point.x;
            int y = point.y;
            long seconds = this.locations.get(point);
            StreamInfoHistoryItem historyObject = this.history.get(seconds);
            if (seconds == this.hoverEntry) {
                g.setColor(HOVER_COLOR);
            } else if (!historyObject.isOnline()) {
                g.setColor(OFFLINE_COLOR);
            } else {
                g.setColor(this.colors.get(seconds));
            }
            int pointSize = 5;
            g.fillOval(x - pointSize / 2, y - pointSize / 2, pointSize, pointSize);
            prevItem = historyObject;
        }
    }

    private String makeTimesText(long startTime, long endTime) {
        String startTimeText = this.makeTimeText(startTime, this.fixedStartTime);
        String endTimeText = this.makeTimeText(endTime, this.fixedEndTime);
        String text = startTimeText + " - " + endTimeText;
        if (this.fixedStartTime <= 0L && this.currentRange > 0L) {
            text = text + " (" + this.duration(this.currentRange) + "h)";
        }
        return text;
    }

    private String makeTimeText(long time, long fixedTime) {
        Date date = new Date(time);
        if (time == fixedTime) {
            return "|" + sdf.format(date) + "|";
        }
        return sdf.format(date);
    }

    private long getStartAt(long range) {
        if (this.fixedStartTime > 0L) {
            return this.fixedStartTime;
        }
        if (range <= 0L) {
            return 0L;
        }
        long end = -1L;
        Iterator<Long> iterator = this.history.keySet().iterator();
        while (iterator.hasNext()) {
            long time;
            end = time = iterator.next().longValue();
        }
        long startAt = end - range;
        if (startAt < 0L) {
            startAt = 0L;
        }
        return startAt;
    }

    private long getEndAt() {
        if (this.fixedEndTime > 0L && this.fixedEndTime > this.fixedStartTime) {
            return this.fixedEndTime;
        }
        return -1L;
    }

    private void updateVars() {
        long startAt = this.getStartAt(this.currentRange);
        long endAt = this.getEndAt();
        int max = 0;
        int min = -1;
        long start = -1L;
        long end = -1L;
        for (Long time : this.history.keySet()) {
            if (time < startAt || endAt > startAt && time > endAt) continue;
            if (start == -1L) {
                start = time;
            }
            end = time;
            StreamInfoHistoryItem historyObj = this.history.get(time);
            int viewerCount = historyObj.getViewers();
            if (viewerCount < min || min == -1) {
                min = viewerCount;
            }
            if (viewerCount == -1) {
                min = 0;
            }
            if (viewerCount <= max) continue;
            max = viewerCount;
        }
        this.maxValue = max;
        this.minValue = min;
        this.startTime = start;
        this.endTime = end;
        this.duration = end - start;
    }

    private void makeColors() {
        this.colors.clear();
        Iterator<Map.Entry<Long, StreamInfoHistoryItem>> it = this.history.entrySet().iterator();
        String prevStatus = null;
        Color currentColor = FIRST_COLOR;
        while (it.hasNext()) {
            Map.Entry<Long, StreamInfoHistoryItem> entry = it.next();
            long time = entry.getKey();
            StreamInfoHistoryItem item = entry.getValue();
            String newStatus = item.getStatusAndGame();
            if (prevStatus != null && newStatus != null && !prevStatus.equals(newStatus)) {
                currentColor = currentColor == FIRST_COLOR ? (!LaF.isDarkTheme() ? SECOND_COLOR : SECOND_COLOR_DARK) : FIRST_COLOR;
            }
            this.colors.put(time, currentColor);
            if (newStatus == null) continue;
            prevStatus = newStatus;
        }
    }

    public void setHistory(String stream, LinkedHashMap<Long, StreamInfoHistoryItem> newHistory) {
        this.manageChannelSpecificVars(stream);
        this.history = newHistory;
        if (this.history != null && !this.history.isEmpty()) {
            this.updateVars();
            this.checkVars();
            this.makeColors();
        } else {
            this.history = null;
        }
        this.repaint();
    }

    private void manageChannelSpecificVars(String stream) {
        if (!stream.equals(this.currentStream)) {
            if (this.hoverEntry > 0L && this.listener != null) {
                this.listener.noItemSelected();
            }
            this.hoverEntry = -1L;
            this.fixedHoverEntry = false;
            this.fixedStartTimes.put(this.currentStream, this.fixedStartTime);
            this.fixedEndTimes.put(this.currentStream, this.fixedEndTime);
            this.currentStream = stream;
            this.fixedStartTime = 0L;
            this.fixedEndTime = 0L;
            if (this.fixedStartTimes.containsKey(stream)) {
                this.fixedStartTime = this.fixedStartTimes.get(stream);
            }
            if (this.fixedEndTimes.containsKey(stream)) {
                this.fixedEndTime = this.fixedEndTimes.get(stream);
            }
        }
    }

    private void checkVars() {
        if (this.startTime == -1L || this.endTime == -1L) {
            this.fixedStartTime = 0L;
            this.fixedEndTime = 0L;
            this.updateVars();
        }
    }

    public void setForegroundColor(Color color) {
        this.foreground_color = color;
        this.repaint();
    }

    public void setBaseFont(Font newFont) {
        this.font = newFont.deriveFont(0);
        this.repaint();
    }

    public void setRange(int minutes) {
        this.contextMenu.setRange(minutes);
        this.currentRange = minutes * 60 * 1000;
        this.fixedStartTime = -1L;
        this.fixedEndTime = -1L;
        if (this.history != null) {
            this.updateVars();
        }
        this.repaint();
    }

    public void setVerticalZoom(boolean zoom) {
        this.contextMenu.setZoom(zoom);
        this.verticalZoom = zoom;
        this.repaint();
    }

    public void setDocked(boolean docked) {
        this.contextMenu.setDocked(docked);
    }

    public void addContextMenuListener(ContextMenuListener l) {
        this.contextMenu.addContextMenuListener(l);
    }

    public void setFixedStartAt(long startAt) {
        if (startAt == this.endTime) {
            return;
        }
        if (this.fixedStartTime > 0L && startAt > 0L) {
            this.fixedEndTime = startAt;
        } else {
            this.fixedStartTime = startAt;
            this.fixedEndTime = startAt;
        }
        if (this.history != null) {
            this.updateVars();
        }
        this.repaint();
    }

    private String duration(long time) {
        float hours = (float)time / 3600000.0f;
        if (hours < 1.0f) {
            return String.format("%.1f", Float.valueOf(hours));
        }
        return String.valueOf((int)hours);
    }

    private void openContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.contextMenu.show(this, e.getX(), e.getY());
        }
    }

    private long findHoverEntry(Point p) {
        double smallestDistance = 18.0;
        long foundHoverEntry = -1L;
        for (Point point : this.locations.keySet()) {
            double distance = p.distance(point);
            if (!(distance < 18.0) || !(distance < smallestDistance)) continue;
            foundHoverEntry = this.locations.get(point);
            smallestDistance = distance;
        }
        return foundHoverEntry;
    }

    private void updateHoverEntry(Point p) {
        long hoverEntryBefore = this.hoverEntry;
        this.hoverEntry = this.findHoverEntry(p);
        if (this.hoverEntry != hoverEntryBefore) {
            this.repaint();
            if (this.listener != null) {
                if (this.hoverEntry == -1L) {
                    this.listener.noItemSelected();
                } else {
                    StreamInfoHistoryItem item = this.history.get(this.hoverEntry);
                    if (item == null) {
                        LOGGER.warning("Hovered Entry " + this.hoverEntry + " was null");
                        this.hoverEntry = -1L;
                    } else {
                        this.listener.itemSelected(item);
                    }
                }
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (e.getClickCount() == 2) {
                    ViewerHistory.this.fixedHoverEntry = false;
                    ViewerHistory.this.setFixedStartAt(ViewerHistory.this.hoverEntry);
                } else {
                    long actualHoverEntry = ViewerHistory.this.findHoverEntry(e.getPoint());
                    ViewerHistory.this.fixedHoverEntry = actualHoverEntry != -1L;
                    if (ViewerHistory.this.hoverEntry != actualHoverEntry) {
                        ViewerHistory.this.updateHoverEntry(e.getPoint());
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ViewerHistory.this.mouseEntered = true;
            ViewerHistory.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ViewerHistory.this.mouseEntered = false;
            if (ViewerHistory.this.fixedHoverEntry) {
                return;
            }
            if (ViewerHistory.this.hoverEntry > 0L && ViewerHistory.this.listener != null) {
                ViewerHistory.this.listener.noItemSelected();
            }
            ViewerHistory.this.hoverEntry = -1L;
            ViewerHistory.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ViewerHistory.this.openContextMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ViewerHistory.this.openContextMenu(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!ViewerHistory.this.fixedHoverEntry) {
                ViewerHistory.this.updateHoverEntry(e.getPoint());
            }
        }
    }

    private static class HistoryTest {
        public long currentTime = 1L;
        public LinkedHashMap<Long, StreamInfoHistoryItem> history = new LinkedHashMap();
        public long startTime;
        public long picnicStartTime;

        private HistoryTest() {
        }

        public void add(String title, String game, int viewers, StreamInfo.StreamType streamType) {
            this.history.put(this.currentTime, new StreamInfoHistoryItem(this.currentTime, viewers, title, game, streamType, this.startTime, this.picnicStartTime));
            this.currentTime += 120000L;
        }
    }
}

