/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.admin;

import chatty.Helper;
import chatty.gui.DockedDialogHelper;
import chatty.gui.DockedDialogManager;
import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.admin.BlockedTermsPanel;
import chatty.gui.components.admin.CommercialPanel;
import chatty.gui.components.admin.StatusPanel;
import chatty.gui.laf.LaF;
import chatty.lang.Language;
import chatty.util.api.ChannelStatus;
import chatty.util.api.TwitchApi;
import chatty.util.dnd.DockContent;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AdminDialog
extends JDialog {
    private static final String EDITOR_TEXT = "[help-admin:status Help]";
    private static final String EDITOR_TEXT_NO_ACCESS = "Required access not available. [help-admin:access More information..]";
    private static final String COMMERCIALS_TEXT = "[help-admin:commercials Help]";
    private static final String COMMERCIALS_TEXT_NO_ACCESS = "No Commercial Access available. [help-admin:access More information..]";
    private static final String BLOCKED_TERMS_TEXT = "[help-admin: Help]";
    private static final String BLOCKED_TERMS_TEXT_NO_ACCESS = "Required access not available. [help-admin:access More information..]";
    private static final Color LABEL_INVISIBLE = new Color(0, 0, 0, 0);
    private static final Color LABEL_VISIBLE = new Color(120, 150, 150);
    public static final Insets SMALL_BUTTON_INSETS = LaF.defaultButtonInsets() ? null : new Insets(-1, 15, -1, 15);
    private static final int UPDATE_DELAY = 4000;
    private final MainGui main;
    private final TwitchApi api;
    private final ActionListener actionListener = new MyActionListener();
    private final StatusPanel statusPanel;
    private final CommercialPanel commercialPanel;
    private final BlockedTermsPanel blockedTermsPanel;
    private final JTabbedPane tabs;
    private final JButton close = new JButton(Language.getString("dialog.button.close"));
    private final LinkLabel infoText;
    private String currentChannel;
    private boolean commercialAccess;
    private boolean editorAccess;
    private boolean blockedTermsAccess;
    private final DockContent content;
    protected final DockedDialogHelper helper;

    public AdminDialog(MainGui main, TwitchApi api, DockedDialogManager dockedDialogs) {
        super(main);
        this.setTitle("Channel Admin - No Channel");
        this.main = main;
        this.api = api;
        this.addWindowListener(new WindowClosingListener());
        this.setDefaultCloseOperation(0);
        this.infoText = new LinkLabel("Test", main.getLinkLabelListener());
        this.statusPanel = new StatusPanel(this, main, api);
        this.commercialPanel = new CommercialPanel(main);
        this.blockedTermsPanel = new BlockedTermsPanel(this, api);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.tabs = new JTabbedPane();
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AdminDialog.this.updateInfoText();
                if (AdminDialog.this.currentChannel != null) {
                    AdminDialog.this.changeChannel(AdminDialog.this.currentChannel);
                }
            }
        });
        JScrollPane statusScroll = new JScrollPane(this.statusPanel);
        this.tabs.addTab(Language.getString("admin.tab.status"), statusScroll);
        this.tabs.addTab(Language.getString("admin.tab.commercial"), this.commercialPanel);
        this.tabs.addTab("Blocked Terms", this.blockedTermsPanel);
        GridBagConstraints gbc = AdminDialog.makeGbc(0, 0, 2, 1);
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        mainPanel.add((Component)this.tabs, gbc);
        gbc = AdminDialog.makeGbc(0, 1, 1, 1);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        mainPanel.add((Component)this.infoText, gbc);
        gbc = AdminDialog.makeGbc(1, 1, 1, 1);
        gbc.anchor = 13;
        this.close.setMnemonic(67);
        mainPanel.add((Component)this.close, gbc);
        this.add((Component)mainPanel, "Center");
        this.close.addActionListener(this.actionListener);
        this.finishDialog();
        this.startUpdateTimer();
        GuiUtil.installEscapeCloseOperation(this);
        this.content = dockedDialogs.createContent(mainPanel, "Admin", "-admin-");
        this.helper = dockedDialogs.createHelper(new DockedDialogHelper.DockedDialog(){

            @Override
            public void setVisible(boolean visible) {
                AdminDialog.super.setVisible(visible);
            }

            @Override
            public boolean isVisible() {
                return AdminDialog.super.isVisible();
            }

            @Override
            public void addComponent(Component comp) {
                AdminDialog.this.add(comp, "Center");
            }

            @Override
            public void removeComponent(Component comp) {
                AdminDialog.this.remove(comp);
            }

            @Override
            public Window getWindow() {
                return AdminDialog.this;
            }

            @Override
            public DockContent getContent() {
                return AdminDialog.this.content;
            }

            @Override
            public void dockedChanged() {
                AdminDialog.this.updateTabTitle();
            }
        });
        this.helper.setChannelChangeListener(channel -> {
            if (this.isVisible()) {
                this.setChannel(Helper.toStream(channel));
            }
        });
        this.helper.installContextMenu(this.tabs);
        this.helper.installContextMenu(mainPanel);
        this.helper.installContextMenu(this.infoText);
    }

    @Override
    public boolean isVisible() {
        if (this.helper != null) {
            return this.helper.isVisible();
        }
        return super.isVisible();
    }

    private void startUpdateTimer() {
        Timer timer = new Timer(4000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminDialog.this.update();
            }
        });
        timer.start();
    }

    private void finishDialog() {
        this.pack();
    }

    private void update() {
        if (this.isVisible()) {
            this.statusPanel.update();
            this.commercialPanel.update();
            this.blockedTermsPanel.update();
        }
        this.commercialPanel.checkScheduled();
    }

    private void updateInfoText() {
        if (this.tabs.getSelectedIndex() == 0) {
            if (this.editorAccess) {
                this.infoText.setText(EDITOR_TEXT);
            } else {
                this.infoText.setText("Required access not available. [help-admin:access More information..]");
            }
        } else if (this.tabs.getSelectedIndex() == 1) {
            if (this.commercialAccess) {
                this.infoText.setText(COMMERCIALS_TEXT);
            } else {
                this.infoText.setText(COMMERCIALS_TEXT_NO_ACCESS);
            }
        } else if (this.blockedTermsAccess) {
            this.infoText.setText(BLOCKED_TERMS_TEXT);
        } else {
            this.infoText.setText("Required access not available. [help-admin:access More information..]");
        }
    }

    public void updateAccess(boolean editor, boolean edit_broadcast, boolean commercials, boolean blockedTerms) {
        this.editorAccess = editor && edit_broadcast;
        this.commercialAccess = commercials;
        this.blockedTermsAccess = blockedTerms;
        this.updateInfoText();
    }

    public void open(String channel) {
        if (channel == null || channel.isEmpty()) {
            JOptionPane.showMessageDialog(this.main, "No channel specified. Can't open admin dialog.");
            return;
        }
        this.statusPanel.dialogOpened();
        this.setChannel(channel);
        this.setVisible(true);
    }

    public void commercialHotkey(int length) {
        this.commercialPanel.commercialHotkey(length);
    }

    public boolean isCommercialsTabVisible() {
        return this.isVisible() && this.tabs.getSelectedIndex() == 1;
    }

    private void setChannel(String channel) {
        if (channel != null && !channel.equals(this.currentChannel) && this.commercialPanel.confirmChannelChange(channel)) {
            this.changeChannel(channel);
        }
        if (channel == null || !channel.isEmpty()) {
            // empty if block
        }
        this.setTitle(Language.getString("admin.title", this.currentChannel));
        this.updateTabTitle();
    }

    private void updateTabTitle() {
        if (this.helper.isDocked()) {
            this.tabs.setTitleAt(0, this.currentChannel + ": " + Language.getString("admin.tab.status"));
        } else {
            this.tabs.setTitleAt(0, Language.getString("admin.tab.status"));
        }
    }

    private void changeChannel(String channel) {
        this.currentChannel = channel;
        this.helper.setCurrentChannel(channel);
        this.commercialPanel.changeChannel(channel);
        if (this.tabs.getSelectedIndex() == 0) {
            this.statusPanel.changeChannel(channel);
        }
        if (this.tabs.getSelectedIndex() == 2) {
            this.blockedTermsPanel.changeStream(channel);
        }
        this.update();
    }

    protected static void hideableLabel(JLabel label, String text) {
        if (text.isEmpty()) {
            label.setForeground(LABEL_INVISIBLE);
        } else {
            label.setForeground(LABEL_VISIBLE);
            label.setText(text);
        }
    }

    protected static GridBagConstraints makeGbc(int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weighty = 0.0;
        return gbc;
    }

    private void close() {
        this.commercialPanel.saveSettings();
        if (this.commercialPanel.checkOnClose()) {
            this.helper.setVisible(false, false);
        }
    }

    @Override
    public void setVisible(boolean state) {
        if (state) {
            this.helper.setVisible(true, true);
        } else {
            this.close();
        }
    }

    public void channelStatusReceived(ChannelStatus status, TwitchApi.RequestResultCode result) {
        this.statusPanel.channelStatusReceived(status, result);
    }

    public void setPutResult(TwitchApi.RequestResultCode result, String error) {
        this.statusPanel.setPutResult(result, error);
    }

    public void commercialResult(String stream, String text, TwitchApi.RequestResultCode result) {
        this.commercialPanel.commercialResult(stream, text, result);
    }

    public void updateCommercialDelaySettings(boolean enabled, long length) {
        this.commercialPanel.updateCommercialDelaySettings(enabled, length);
    }

    public void setStatusHistorySorting(String string) {
        this.statusPanel.setStatusHistorySorting(string);
    }

    public String getStatusHistorySorting() {
        return this.statusPanel.getStatusHistorySorting();
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AdminDialog.this.close) {
                AdminDialog.this.close();
            }
        }
    }

    private class WindowClosingListener
    extends WindowAdapter {
        private WindowClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            AdminDialog.this.close();
        }
    }
}

