/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.admin;

import chatty.gui.GuiUtil;
import chatty.gui.components.admin.AdminDialog;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.ListTableModel;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.api.BlockedTermsManager;
import chatty.util.api.TwitchApi;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;

public class BlockedTermsPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(BlockedTermsPanel.class.getName());
    private static final int BULK_EDIT_DELAY = 500;
    private final JLabel statusLabel;
    private final JButton refreshButton;
    private final JTable table;
    private final Model data;
    private final JTextField input;
    private final JButton addButton;
    private final JCheckBox filterEnabled;
    private final TwitchApi api;
    private String currentStream;
    private BlockedTermsManager.BlockedTerms currentTerms;
    private boolean loading;
    private final Map<String, Boolean> edited = new HashMap<String, Boolean>();
    private final TableRowSorter sorter;

    public BlockedTermsPanel(AdminDialog dialog, TwitchApi api) {
        this.api = api;
        this.setLayout(new GridBagLayout());
        this.data = new Model(new String[]{"Text", "Created", "Expires"});
        this.table = new JTable();
        this.table.setModel(this.data);
        this.table.setFillsViewportHeight(true);
        this.table.getColumnModel().getColumn(1).setCellRenderer(new CreatedRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new ExpiresRenderer());
        this.sorter = new TableRowSorter<Model>(this.data);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.DESCENDING));
        this.sorter.setSortKeys(sortKeys);
        this.table.setRowSorter(this.sorter);
        this.table.setTransferHandler(new MyTransferHandler());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumnModel().getColumn(1).setMaxWidth(GuiUtil.getTableColumnHeaderWidth(this.table, 1) * 2);
        this.table.getColumnModel().getColumn(2).setMaxWidth(GuiUtil.getTableColumnHeaderWidth(this.table, 2) * 2);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!e.isControlDown() && !e.isShiftDown() && BlockedTermsPanel.this.table.getSelectedRowCount() < 2) {
                    int row = BlockedTermsPanel.this.table.rowAtPoint(e.getPoint());
                    if (row != -1) {
                        BlockedTermsPanel.this.setRowSelected(row);
                    } else if (BlockedTermsPanel.this.table.getRowCount() > 0) {
                        BlockedTermsPanel.this.setRowSelected(BlockedTermsPanel.this.table.getRowCount() - 1);
                    }
                }
                BlockedTermsPanel.this.popupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BlockedTermsPanel.this.popupMenu(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    BlockedTermsPanel.this.editEntry();
                }
            }
        });
        this.table.setSelectionMode(2);
        this.table.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "removeItems");
        this.table.getActionMap().put("removeItems", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlockedTermsPanel.this.deleteEntries();
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "editItem");
        this.table.getActionMap().put("editItem", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlockedTermsPanel.this.editEntry();
            }
        });
        this.statusLabel = new JLabel();
        this.refreshButton = new JButton(Language.getString("admin.button.reload"));
        this.refreshButton.setMargin(AdminDialog.SMALL_BUTTON_INSETS);
        this.refreshButton.setIcon(new ImageIcon(AdminDialog.class.getResource("view-refresh.png")));
        this.refreshButton.setMnemonic(82);
        this.refreshButton.addActionListener(e -> this.refreshData());
        this.filterEnabled = new JCheckBox("Filter");
        this.filterEnabled.addItemListener(e -> this.updateFilter());
        this.input = new JTextField();
        this.input.addActionListener(e -> this.addInputEntry());
        GuiUtil.addChangeListener(this.input.getDocument(), e -> this.updateFilter());
        this.addButton = new JButton("Add");
        this.addButton.setMargin(AdminDialog.SMALL_BUTTON_INSETS);
        this.addButton.addActionListener(e -> this.addInputEntry());
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 1, 1);
        this.add((Component)this.refreshButton, gbc);
        gbc = GuiUtil.makeGbc(1, 0, 1, 1, 17);
        this.add((Component)this.statusLabel, gbc);
        gbc = GuiUtil.makeGbc(2, 0, 1, 1, 17);
        this.add((Component)this.filterEnabled, gbc);
        gbc = GuiUtil.makeGbc(0, 1, 2, 1, 17);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.input, gbc);
        gbc = GuiUtil.makeGbc(2, 1, 1, 1, 17);
        gbc.fill = 2;
        this.add((Component)this.addButton, gbc);
        gbc = GuiUtil.makeGbc(0, 2, 3, 1);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)new JScrollPane(this.table), gbc);
    }

    private void updateFilter() {
        this.addButton.setEnabled(!this.input.getText().isEmpty());
        if (this.filterEnabled.isSelected()) {
            this.filter(this.input.getText());
        } else {
            this.resetFilter();
        }
    }

    private void addInputEntry() {
        this.addEntry(this.input.getText());
    }

    private void addEntry(String text) {
        if (!text.isEmpty()) {
            this.api.addBlockedTerm(this.currentStream, text, term -> SwingUtilities.invokeLater(() -> {
                if (term == null) {
                    this.statusLabel.setText("An error occured adding term");
                } else if (term.streamLogin.equals(this.currentStream)) {
                    this.data.add(term);
                    if (term.text.equals(this.input.getText())) {
                        this.input.setText(null);
                    }
                    this.setEdited(true);
                }
            }));
        }
    }

    private void editEntry() {
        int selected = this.table.getSelectedRow();
        if (selected != -1) {
            BlockedTermsManager.BlockedTerm selectedTerm = (BlockedTermsManager.BlockedTerm)this.data.get(this.table.convertRowIndexToModel(selected));
            Editor editor = new Editor(SwingUtilities.getWindowAncestor(this));
            String result = editor.showDialog("Edit (Removes the term and adds the edited one)", selectedTerm.text, null);
            if (result != null && !result.equals(selectedTerm.text)) {
                this.api.removeBlockedTerm(selectedTerm, removed -> SwingUtilities.invokeLater(() -> {
                    if (removed == null) {
                        this.statusLabel.setText("An error occured removing term");
                    } else if (removed.streamLogin.equals(this.currentStream)) {
                        this.data.remove(removed);
                        this.addEntry(result);
                        this.setEdited(true);
                    }
                }));
            }
        }
    }

    private void deleteEntries() {
        final ArrayList<BlockedTermsManager.BlockedTerm> toDelete = new ArrayList<BlockedTermsManager.BlockedTerm>();
        int[] selected = this.table.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            BlockedTermsManager.BlockedTerm term = (BlockedTermsManager.BlockedTerm)this.data.get(this.table.convertRowIndexToModel(selected[i]));
            toDelete.add(term);
        }
        if (toDelete.size() == 1 || JOptionPane.showConfirmDialog(this.table, "Delete " + toDelete.size() + " items?", "Delete items", 2) == 0) {
            Thread thread = new Thread("deleteTerms"){

                @Override
                public void run() {
                    for (BlockedTermsManager.BlockedTerm term : toDelete) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(500L);
                            SwingUtilities.invokeLater(() -> BlockedTermsPanel.this.api.removeBlockedTerm(term, removed -> SwingUtilities.invokeLater(() -> {
                                if (removed == null) {
                                    BlockedTermsPanel.this.statusLabel.setText("An error occured removing item");
                                } else if (removed.streamLogin.equals(BlockedTermsPanel.this.currentStream)) {
                                    BlockedTermsPanel.this.data.remove(removed);
                                    BlockedTermsPanel.this.setEdited(true);
                                }
                            })));
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(BlockedTermsPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            };
            thread.start();
        }
    }

    private void importData(String preset) {
        Editor editor = new Editor(SwingUtilities.getWindowAncestor(this));
        editor.setAllowLinebreaks(true);
        String result = editor.showDialog("Import entries (one entry per line)", preset, "Can also copy&paste in table to trigger export/import.");
        if (result != null) {
            final String[] split = result.split("\n");
            Thread thread = new Thread("importTerms"){

                @Override
                public void run() {
                    for (String item : split) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(500L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(BlockedTermsPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        SwingUtilities.invokeLater(() -> BlockedTermsPanel.this.addEntry(item));
                    }
                }
            };
            thread.start();
        }
    }

    public void resetFilter() {
        this.sorter.setRowFilter(null);
    }

    public void filter(final String text) {
        if (text.isEmpty()) {
            this.resetFilter();
        } else {
            this.sorter.setRowFilter(new RowFilter<Model, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends Model, ? extends Integer> entry) {
                    Model model = entry.getModel();
                    BlockedTermsManager.BlockedTerm term = (BlockedTermsManager.BlockedTerm)model.get(entry.getIdentifier());
                    return term.text.contains(text);
                }
            });
        }
    }

    public void changeStream(String stream) {
        if (stream != null && !stream.equals(this.currentStream)) {
            this.currentStream = stream;
            if (this.isEdited()) {
                this.refreshData();
            } else {
                this.loadData();
            }
        }
    }

    private void setEdited(boolean newValue) {
        this.edited.put(this.currentStream, newValue);
    }

    private boolean isEdited() {
        return this.edited.containsKey(this.currentStream) && this.edited.get(this.currentStream) != false;
    }

    private void setData(BlockedTermsManager.BlockedTerms terms) {
        SwingUtilities.invokeLater(() -> {
            this.loading = false;
            if (terms.streamName != null && terms.streamName.equals(this.currentStream)) {
                this.currentTerms = terms;
                this.data.setData(terms.data);
                this.update();
            }
        });
    }

    private void loadData() {
        this.loading = true;
        this.update();
        this.api.getBlockedTerms(this.currentStream, false, t -> this.setData((BlockedTermsManager.BlockedTerms)t));
    }

    private void refreshData() {
        this.loading = true;
        this.update();
        this.api.getBlockedTerms(this.currentStream, true, t -> {
            this.setEdited(false);
            this.setData((BlockedTermsManager.BlockedTerms)t);
        });
    }

    public void update() {
        if (this.currentTerms != null) {
            if (this.currentTerms.hasError()) {
                this.statusLabel.setText(this.currentTerms.error);
            } else {
                this.statusLabel.setText(Language.getString("admin.termsLoaded", this.data.getRowCount(), DateTime.duration(System.currentTimeMillis() - this.currentTerms.createdAt, 1, 0, new DateTime.Formatting[0])));
                if (this.currentTerms.data.size() == 1000) {
                    this.statusLabel.setText(this.statusLabel.getText() + " (request limit reached)");
                }
            }
        }
        this.refreshButton.setEnabled(!this.loading);
        this.table.repaint();
    }

    private void popupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            ContextMenu menu = new ContextMenu(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    switch (e.getActionCommand()) {
                        case "edit": {
                            BlockedTermsPanel.this.editEntry();
                            break;
                        }
                        case "delete": {
                            BlockedTermsPanel.this.deleteEntries();
                            break;
                        }
                        case "import": {
                            BlockedTermsPanel.this.importData("");
                        }
                    }
                }
            };
            menu.addItem("edit", "Edit");
            menu.addItem("delete", "Delete");
            menu.addSeparator();
            menu.addItem("import", "Import");
            menu.show(this.table, e.getX(), e.getY());
        }
    }

    private void setRowSelected(int viewIndex) {
        this.table.getSelectionModel().setSelectionInterval(viewIndex, viewIndex);
        this.scrollToRow(viewIndex);
    }

    private void scrollToRow(int index) {
        if (index != -1) {
            this.scrollRectToVisible(this.table.getCellRect(index, 0, true));
        }
    }

    private static class Model
    extends ListTableModel<BlockedTermsManager.BlockedTerm> {
        Model(String[] columns) {
            super(columns);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            BlockedTermsManager.BlockedTerm entry = (BlockedTermsManager.BlockedTerm)this.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return entry.text;
                }
                case 1: {
                    if (entry.expiresAt != -1L) {
                        return entry.updatedAt;
                    }
                    return entry.createdAt;
                }
                case 2: {
                    return entry.expiresAt;
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 1: 
                case 2: {
                    return Long.class;
                }
            }
            return String.class;
        }
    }

    private static class CreatedRenderer
    extends DefaultTableCellRenderer {
        private CreatedRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                return;
            }
            Long lastActivity = (Long)value;
            this.setText(DateTime.agoSingleCompact(lastActivity) + " ago");
            CreatedRenderer label = this;
            label.setHorizontalAlignment(0);
            label.setToolTipText("Created or updated at " + DateTime.formatFullDatetime(lastActivity));
        }
    }

    private static class ExpiresRenderer
    extends DefaultTableCellRenderer {
        private ExpiresRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                return;
            }
            Long lastActivity = (Long)value;
            if (lastActivity <= 0L) {
                this.setText("");
            } else {
                this.setText(DateTime.duration(lastActivity - System.currentTimeMillis(), 0, 1, 0, new DateTime.Formatting[0]));
                ExpiresRenderer label = this;
                label.setHorizontalAlignment(0);
                label.setToolTipText("Expires at " + DateTime.formatFullDatetime(lastActivity));
            }
        }
    }

    private class MyTransferHandler
    extends TransferHandler {
        private MyTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTable) {
                JTable table = (JTable)c;
                StringBuilder b = new StringBuilder();
                int[] selected = table.getSelectedRows();
                for (int row = 0; row < selected.length; ++row) {
                    Object obj = table.getValueAt(selected[row], 0);
                    b.append(String.valueOf(obj)).append("\n");
                }
                b.deleteCharAt(b.length() - 1);
                return new StringSelection(b.toString());
            }
            return null;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            try {
                String data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                BlockedTermsPanel.this.importData(data);
                return true;
            }
            catch (UnsupportedFlavorException | IOException ex) {
                LOGGER.warning("Error importing table data: " + ex);
                return false;
            }
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }
}

