/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.admin;

import chatty.gui.MainGui;
import chatty.gui.components.WrapLayout;
import chatty.gui.components.admin.AdminDialog;
import chatty.gui.components.settings.DurationSetting;
import chatty.util.DateTime;
import chatty.util.ElapsedTime;
import chatty.util.api.TwitchApi;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class CommercialPanel
extends JPanel {
    private static final int COMMERCIAL_RUN_ATTEMPT_DELAY = 5000;
    private final Map<String, Long> lastCommercial = new HashMap<String, Long>();
    private static final int[] commercialButtonsDef = new int[]{30, 60, 90, 120, 150, 180};
    private final Map<Integer, JToggleButton> commercialButtons = new LinkedHashMap<Integer, JToggleButton>();
    private final JLabel commercialResult;
    private final JLabel lastCommercialInfo = new JLabel("");
    private final JCheckBox useCommercialDelay = new JCheckBox("Use delay: ");
    private final JCheckBox repeatCommercial = new JCheckBox("Repeat");
    private final DurationSetting commercialDelay = new DurationSetting(3, true);
    private final MainGui main;
    private String currentChannel;
    private long lastCommercialRun;
    private long scheduledCommercialTime;
    private int scheduledCommercialLength;
    private long lastCommercialRunAttempt;
    private final ElapsedTime lastCommercialRunAttemptError = new ElapsedTime();

    public CommercialPanel(MainGui main) {
        this.main = main;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = AdminDialog.makeGbc(1, 1, 4, 1);
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.createCommercialButtons(), gbc);
        gbc = AdminDialog.makeGbc(1, 2, 1, 1);
        gbc.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.useCommercialDelay, gbc);
        gbc = AdminDialog.makeGbc(2, 2, 1, 1);
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.anchor = 17;
        this.commercialDelay.setMinimumSize(this.commercialDelay.getPreferredSize());
        this.add((Component)this.commercialDelay, gbc);
        gbc = AdminDialog.makeGbc(3, 2, 1, 1);
        gbc.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.repeatCommercial, gbc);
        gbc = AdminDialog.makeGbc(4, 2, 1, 1);
        gbc.insets = new Insets(0, 10, 5, 5);
        this.add((Component)this.lastCommercialInfo, gbc);
        this.commercialResult = new JLabel("...");
        gbc = AdminDialog.makeGbc(1, 3, 4, 1);
        gbc.insets = new Insets(3, 5, 15, 5);
        this.add((Component)this.commercialResult, gbc);
        this.setCommercialResult("");
    }

    public boolean checkOnClose() {
        if (this.scheduledCommercialTime != 0L) {
            int result = this.confirmContinueScheduledOnClose();
            if (result == -1) {
                return false;
            }
            if (result == 1) {
                this.clearScheduledCommercial();
            }
        }
        return true;
    }

    public void update() {
        if (this.isVisible()) {
            if (this.lastCommercialRun > 0L) {
                long ago = System.currentTimeMillis() - this.lastCommercialRun;
                this.lastCommercialInfo.setText("Last run: " + DateTime.duration(ago, 1, 0, new DateTime.Formatting[0]) + " ago");
                this.lastCommercialInfo.setToolTipText("Last run: " + DateTime.formatFullDatetime(this.lastCommercialRun));
            }
            if (this.lastCommercialRunAttemptError.isSetAndSecondsElapsed(10)) {
                this.commercialResult(this.currentChannel, "Running commercial may have failed.", TwitchApi.RequestResultCode.UNKNOWN);
            }
        }
    }

    public void checkScheduled() {
        if (this.scheduledCommercialTime > 0L) {
            long timeLeft = this.scheduledCommercialTime - System.currentTimeMillis();
            if (timeLeft <= 0L) {
                this.runCommercialNow(this.scheduledCommercialLength);
            } else if (System.currentTimeMillis() - this.lastCommercialRunAttempt > 5000L) {
                this.setCommercialResult(String.format("Commercial (%ds) scheduled to run in %s", this.scheduledCommercialLength, DateTime.duration(timeLeft, 2, 0, new DateTime.Formatting[0])));
            }
        }
    }

    protected void saveSettings() {
        boolean enabled = this.useCommercialDelay.isSelected();
        long length = this.commercialDelay.getSettingValue();
        this.main.saveCommercialDelaySettings(enabled, length);
    }

    public void updateCommercialDelaySettings(boolean enabled, long length) {
        this.useCommercialDelay.setSelected(enabled);
        this.commercialDelay.setSettingValue(length);
    }

    public void commercialHotkey(int length) {
        if (this.commercialButtons.containsKey(length)) {
            this.commercialButtons.get(length).doClick();
        } else {
            this.commercialButtons.get(30).doClick();
        }
    }

    public void changeChannel(String channel) {
        if (channel.equals(this.currentChannel)) {
            return;
        }
        this.currentChannel = channel;
        Long lastCommercialTemp = this.lastCommercial.get(channel);
        if (lastCommercialTemp != null) {
            this.lastCommercialRun = lastCommercialTemp;
        } else {
            this.lastCommercialRun = 0L;
            this.lastCommercialInfo.setText(null);
        }
        this.clearScheduledCommercial();
        this.setCommercialResult("");
    }

    private JPanel createCommercialButtons() {
        NoneSelectedButtonGroup g = new NoneSelectedButtonGroup();
        JPanel panel = new JPanel();
        panel.setLayout(new WrapLayout(0));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommercialPanel.this.commercialButtonClicked(e.getActionCommand());
            }
        };
        for (int i : commercialButtonsDef) {
            JToggleButton b = new JToggleButton(i + "s");
            b.setActionCommand(String.valueOf(i));
            g.add(b);
            this.commercialButtons.put(i, b);
            panel.add(b);
            b.addActionListener(listener);
        }
        return panel;
    }

    private void commercialButtonClicked(String command) {
        int length = Integer.parseInt(command);
        JToggleButton button = this.commercialButtons.get(length);
        if (button.isSelected()) {
            if (this.scheduledCommercialTime == 0L) {
                this.runCommercial(length);
            } else {
                this.scheduledCommercialLength = length;
                this.update();
            }
        } else {
            this.scheduledCommercialTime = 0L;
            this.setCommercialResult("Canceled scheduled commercial.");
        }
    }

    private void clearCommercialButtonsSelection() {
        for (JToggleButton b : this.commercialButtons.values()) {
            b.setSelected(false);
        }
    }

    private void runCommercial(int length) {
        this.saveSettings();
        if (this.useCommercialDelay.isSelected()) {
            this.scheduleCommercial(length);
        } else {
            this.runCommercialNow(length);
        }
    }

    private void scheduleCommercial(int length) {
        Long delay = this.commercialDelay.getSettingValue();
        if (delay == null) {
            this.setCommercialResult("Invalid delay specified.");
            this.clearCommercialButtonsSelection();
        } else {
            this.scheduledCommercialTime = System.currentTimeMillis() + delay * 1000L;
            this.scheduledCommercialLength = length;
            this.update();
        }
    }

    private void runCommercialNow(int length) {
        this.lastCommercialRunAttempt = System.currentTimeMillis();
        if (this.repeatCommercial.isSelected()) {
            this.scheduleCommercial(length);
        } else {
            this.clearScheduledCommercial();
        }
        this.main.runCommercial(this.currentChannel, length);
        this.setLoadingCommercial(true);
        this.lastCommercialRunAttemptError.set();
    }

    private void clearScheduledCommercial() {
        this.clearCommercialButtonsSelection();
        this.scheduledCommercialTime = 0L;
        this.setCommercialResult("");
    }

    private void setLoadingCommercial(boolean loading) {
        for (JToggleButton b : this.commercialButtons.values()) {
            b.setEnabled(!loading);
        }
        if (loading) {
            this.setCommercialResult("Trying to run commercial..");
        }
    }

    private void setCommercialResult(String result) {
        AdminDialog.hideableLabel(this.commercialResult, result);
    }

    public boolean confirmChannelChange(String channel) {
        if (this.scheduledCommercialTime == 0L) {
            return true;
        }
        String message = "<html><body style='width:240'>There is currently a commercial scheduled on '" + this.currentChannel + "'. Changing channel to '" + channel + "' will cancel that.<br /><br />You can set the channel to not change automatically in the Admin Panel context menu.";
        Object[] options = new String[]{"Change channel", "Don't change"};
        int result = JOptionPane.showOptionDialog(this.main, message, "Changing channel will cancel commercial", 0, 2, null, options, options[1]);
        return result == 0;
    }

    public void commercialResult(String stream, String resultText, TwitchApi.RequestResultCode result) {
        this.setCommercialResult(DateTime.currentTime() + " " + resultText);
        this.lastCommercialRunAttempt = System.currentTimeMillis();
        this.lastCommercialRunAttemptError.reset();
        this.setLoadingCommercial(false);
        if (result == TwitchApi.RequestResultCode.RUNNING_COMMERCIAL) {
            this.lastCommercial.put(stream, System.currentTimeMillis());
            if (stream != null && stream.equals(this.currentChannel)) {
                this.lastCommercialRun = System.currentTimeMillis();
            }
        }
    }

    private int confirmContinueScheduledOnClose() {
        String message = "<html><body style='width:240'>There is currently a commercial scheduled to be run. It can also be run if you close this. What do you want to do?";
        Object[] options = new String[]{"Run on schedule", "Cancel commercial"};
        int result = JOptionPane.showOptionDialog(this.main, message, "Closing Admin Dialog while commercial is scheduled", 0, 3, null, options, options[0]);
        return result;
    }

    public static class NoneSelectedButtonGroup
    extends ButtonGroup {
        @Override
        public void setSelected(ButtonModel model, boolean selected) {
            if (selected) {
                super.setSelected(model, selected);
            } else {
                this.clearSelection();
            }
        }
    }
}

