/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.admin;

import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.lang.Language;
import chatty.util.StringUtil;
import chatty.util.api.ResultManager;
import chatty.util.api.StreamCategory;
import chatty.util.api.TwitchApi;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectGameDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(SelectGameDialog.class.getName());
    private static final String INFO = "<html><body style='width:280px'>" + Language.getString("admin.game.info");
    private static final StreamCategory SEPARATOR = new StreamCategory("", "");
    private final MainGui main;
    private final TwitchApi api;
    private final JButton ok = new JButton(Language.getString("dialog.button.ok"));
    private final JButton cancel = new JButton(Language.getString("dialog.button.cancel"));
    private final JButton searchButton = new JButton(SelectGameDialog.s("button.search"));
    private final JButton addToFavoritesButton = new JButton(SelectGameDialog.s("button.favorite"));
    private final JButton removeFromFavoritesButton = new JButton(SelectGameDialog.s("button.unfavorite"));
    private final JButton clearSearchButton = new JButton(SelectGameDialog.s("button.clearSearch"));
    private final JLabel searchResultInfo = new JLabel();
    private final JTextField gameInput = new JTextField(30);
    private final JList<StreamCategory> list = new JList();
    private final DefaultListModel<StreamCategory> listData = new DefaultListModel();
    private final Set<StreamCategory> favorites = new TreeSet<StreamCategory>();
    private final Set<StreamCategory> searchResult = new TreeSet<StreamCategory>();
    private StreamCategory presetCategory;
    private boolean save;

    private static String s(String key) {
        return Language.getString("admin.game." + key);
    }

    public SelectGameDialog(MainGui main, TwitchApi api) {
        super(main, "Select game", true);
        this.setResizable(true);
        this.main = main;
        this.api = api;
        this.setLayout(new GridBagLayout());
        this.list.setModel(this.listData);
        this.list.setVisibleRowCount(12);
        this.list.setCellRenderer(new ListRenderer());
        DoneAction doneAction = new DoneAction();
        this.list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "useSelectedGame");
        this.list.getActionMap().put("useSelectedGame", doneAction);
        this.list.getInputMap().put(KeyStroke.getKeyStroke(70, 0), "toggleFavorite");
        this.list.getActionMap().put("toggleFavorite", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectGameDialog.this.toggleFavorite();
            }
        });
        GridBagConstraints gbc = this.makeGbc(0, 0, 4, 1);
        this.add((Component)new JLabel(INFO), gbc);
        gbc = this.makeGbc(0, 1, 2, 1);
        gbc.fill = 2;
        gbc.weightx = 0.5;
        this.add((Component)this.gameInput, gbc);
        GuiUtil.smallButtonInsets(this.searchButton);
        gbc = this.makeGbc(2, 1, 1, 1);
        gbc.fill = 2;
        this.add((Component)this.searchButton, gbc);
        gbc = this.makeGbc(0, 2, 3, 1);
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.searchResultInfo, gbc);
        gbc = this.makeGbc(2, 2, 1, 1);
        GuiUtil.smallButtonInsets(this.clearSearchButton);
        gbc.fill = 2;
        gbc.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.clearSearchButton, gbc);
        gbc = this.makeGbc(0, 3, 4, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JScrollPane(this.list), gbc);
        GuiUtil.smallButtonInsets(this.addToFavoritesButton);
        gbc = this.makeGbc(0, 4, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 0.5;
        this.add((Component)this.addToFavoritesButton, gbc);
        GuiUtil.smallButtonInsets(this.removeFromFavoritesButton);
        gbc = this.makeGbc(1, 4, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 0.5;
        this.add((Component)this.removeFromFavoritesButton, gbc);
        this.ok.setMnemonic(10);
        gbc = this.makeGbc(0, 6, 2, 1);
        gbc.weightx = 0.5;
        gbc.fill = 2;
        this.add((Component)this.ok, gbc);
        this.cancel.setMnemonic(67);
        gbc = this.makeGbc(2, 6, 1, 1);
        gbc.fill = 2;
        this.add((Component)this.cancel, gbc);
        MyActionListener actionListener = new MyActionListener();
        this.searchButton.addActionListener(actionListener);
        this.gameInput.addActionListener(actionListener);
        this.ok.addActionListener(actionListener);
        this.cancel.addActionListener(actionListener);
        this.list.addListSelectionListener(new MyListSelectionListener());
        this.list.addMouseListener(new ListClickListener());
        this.addToFavoritesButton.addActionListener(actionListener);
        this.removeFromFavoritesButton.addActionListener(actionListener);
        this.clearSearchButton.addActionListener(actionListener);
        this.gameInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SelectGameDialog.this.updateButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SelectGameDialog.this.updateButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SelectGameDialog.this.updateButtons();
            }
        });
        this.updateButtons();
        this.pack();
        this.setMinimumSize(this.getSize());
        api.subscribe(ResultManager.Type.CATEGORY_RESULT, categories -> SwingUtilities.invokeLater(() -> {
            this.loadFavorites();
            HashMap<StreamCategory, StreamCategory> replace = new HashMap<StreamCategory, StreamCategory>();
            for (StreamCategory streamCategory : this.favorites) {
                for (StreamCategory updatedCategory : categories) {
                    if (!streamCategory.hasId()) {
                        if (!streamCategory.nameMatches(updatedCategory)) continue;
                        replace.put(streamCategory, updatedCategory);
                        continue;
                    }
                    if (!streamCategory.id.equals(updatedCategory.id) || streamCategory.name.equals(updatedCategory.name)) continue;
                    replace.put(streamCategory, updatedCategory);
                }
            }
            for (Map.Entry entry : replace.entrySet()) {
                LOGGER.info(String.format("Game favorites: Updating %s to %s", ((StreamCategory)entry.getKey()).toStringVerbose(), ((StreamCategory)entry.getValue()).toStringVerbose()));
                this.favorites.remove(entry.getKey());
                this.favorites.add((StreamCategory)entry.getValue());
            }
            if (!replace.isEmpty()) {
                this.saveFavorites();
                this.update();
            }
        }));
    }

    public StreamCategory open(StreamCategory gamePreset) {
        this.presetCategory = gamePreset;
        this.loadFavorites();
        this.list.setSelectedValue(gamePreset, true);
        this.save = false;
        this.setVisible(true);
        if (this.save) {
            return this.list.getSelectedValue();
        }
        return null;
    }

    private void useGameAndClose() {
        this.save = true;
        this.setVisible(false);
    }

    private void update() {
        this.listData.clear();
        if (this.presetCategory != null && !this.presetCategory.isEmpty() && !this.favorites.contains(this.presetCategory)) {
            this.searchResult.add(this.presetCategory);
        }
        for (StreamCategory game : this.searchResult) {
            this.listData.addElement(game);
        }
        if (!this.searchResult.isEmpty() && !this.favorites.isEmpty()) {
            this.listData.addElement(SEPARATOR);
        }
        for (StreamCategory game : this.favorites) {
            this.listData.addElement(game);
        }
        this.searchResultInfo.setText(Language.getString("admin.game.listInfo", this.searchResult.size(), this.favorites.size()));
        this.list.setSelectedValue(this.gameInput.getText(), false);
    }

    private void doSearch() {
        String searchString = this.gameInput.getText().trim();
        if (searchString.isEmpty()) {
            return;
        }
        this.api.performGameSearch(searchString, r -> SwingUtilities.invokeLater(() -> {
            this.searchResult.clear();
            this.searchResult.addAll(r);
            this.update();
        }));
        this.searchResultInfo.setText(SelectGameDialog.s("searching"));
    }

    private void addToFavorites() {
        for (StreamCategory game : this.list.getSelectedValuesList()) {
            if (game.equals(SEPARATOR)) continue;
            this.favorites.add(game);
        }
        this.saveFavorites();
        this.update();
    }

    private void removeFromFavorites() {
        for (StreamCategory game : this.list.getSelectedValuesList()) {
            this.favorites.remove(game);
        }
        this.saveFavorites();
        this.update();
    }

    private void toggleFavorite() {
        for (StreamCategory game : this.list.getSelectedValuesList()) {
            if (this.favorites.contains(game) || game.equals(SEPARATOR)) {
                this.favorites.remove(game);
                continue;
            }
            this.favorites.add(game);
        }
        this.saveFavorites();
        this.update();
    }

    public static Collection<List> favoritesToSettings(Collection<StreamCategory> favorites) {
        ArrayList<List> result = new ArrayList<List>();
        for (StreamCategory category : favorites) {
            if (StringUtil.isNullOrEmpty(category.name)) continue;
            ArrayList<String> item = new ArrayList<String>();
            item.add(category.id);
            item.add(category.name);
            result.add(item);
        }
        return result;
    }

    public static Collection<String> favoritesToSettingsOld(Collection<StreamCategory> favorites) {
        ArrayList<String> result = new ArrayList<String>();
        for (StreamCategory category : favorites) {
            if (StringUtil.isNullOrEmpty(category.name)) continue;
            result.add(category.name);
        }
        return result;
    }

    public static Collection<StreamCategory> settingsToFavorites(List<List> favorites) {
        ArrayList<StreamCategory> result = new ArrayList<StreamCategory>();
        for (List item : favorites) {
            if (item == null || item.size() != 2) continue;
            String id = (String)item.get(0);
            String name = (String)item.get(1);
            result.add(new StreamCategory(id, name));
        }
        return result;
    }

    public static Collection<StreamCategory> settingsToFavoritesOld(List<String> favorites) {
        ArrayList<StreamCategory> result = new ArrayList<StreamCategory>();
        for (String item : favorites) {
            result.add(new StreamCategory(null, item));
        }
        return result;
    }

    private void saveFavorites() {
        this.main.setGameFavorites(this.favorites);
    }

    private void loadFavorites() {
        this.favorites.clear();
        this.favorites.addAll(this.main.getGameFavorites());
        this.update();
    }

    private void updateButtons() {
        boolean favoriteSelected = false;
        boolean nonFavoriteSelected = false;
        for (StreamCategory game : this.list.getSelectedValuesList()) {
            if (game.equals(SEPARATOR)) continue;
            if (this.favorites.contains(game)) {
                favoriteSelected = true;
                continue;
            }
            nonFavoriteSelected = true;
        }
        this.addToFavoritesButton.setEnabled(nonFavoriteSelected);
        this.removeFromFavoritesButton.setEnabled(favoriteSelected);
        this.searchButton.setEnabled(!this.gameInput.getText().isEmpty());
        this.ok.setEnabled(this.list.getSelectedValue() != null && this.list.getSelectedValue() != SEPARATOR);
    }

    private GridBagConstraints makeGbc(int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(4, 4, 4, 4);
        return gbc;
    }

    private class ListRenderer
    extends DefaultListCellRenderer {
        private final ImageIcon icon = new ImageIcon(MainGui.class.getResource("star.png"));
        private final Border seperatorBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY);

        private ListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return label;
            }
            if (value.equals(SEPARATOR)) {
                label.setText(null);
                label.setBorder(this.seperatorBorder);
            }
            if (SelectGameDialog.this.favorites.contains((StreamCategory)value)) {
                label.setIcon(this.icon);
            }
            return label;
        }
    }

    private class DoneAction
    extends AbstractAction {
        private DoneAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectGameDialog.this.useGameAndClose();
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SelectGameDialog.this.gameInput || e.getSource() == SelectGameDialog.this.searchButton) {
                SelectGameDialog.this.doSearch();
            }
            if (e.getSource() == SelectGameDialog.this.ok) {
                SelectGameDialog.this.useGameAndClose();
            }
            if (e.getSource() == SelectGameDialog.this.cancel) {
                SelectGameDialog.this.save = false;
                SelectGameDialog.this.setVisible(false);
            }
            if (e.getSource() == SelectGameDialog.this.addToFavoritesButton) {
                SelectGameDialog.this.addToFavorites();
            }
            if (e.getSource() == SelectGameDialog.this.removeFromFavoritesButton) {
                SelectGameDialog.this.removeFromFavorites();
            }
            if (e.getSource() == SelectGameDialog.this.clearSearchButton) {
                SelectGameDialog.this.searchResult.clear();
                SelectGameDialog.this.update();
            }
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SelectGameDialog.this.updateButtons();
        }
    }

    private class ListClickListener
    extends MouseAdapter {
        private ListClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                SelectGameDialog.this.useGameAndClose();
            }
        }
    }
}

