/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.admin;

import chatty.lang.Language;
import chatty.util.api.StreamLabels;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;

public class SelectLabelsDialog
extends JDialog {
    private final JButton ok = new JButton(Language.getString("dialog.button.save"));
    private final JButton cancel = new JButton(Language.getString("dialog.button.cancel"));
    private final Map<StreamLabels.StreamLabel, JCheckBox> checkboxes = new HashMap<StreamLabels.StreamLabel, JCheckBox>();
    private final List<StreamLabels.StreamLabel> preset = new ArrayList<StreamLabels.StreamLabel>();
    private boolean save;

    public SelectLabelsDialog(Frame owner) {
        super(owner, Language.getString("admin.labels.title"), true);
        GridBagConstraints gbc;
        this.ok.addActionListener(e -> {
            this.save = true;
            this.dispose();
        });
        this.cancel.addActionListener(e -> this.dispose());
        this.setLayout(new GridBagLayout());
        int y = 0;
        for (StreamLabels.StreamLabel label : StreamLabels.getAvailableLabels()) {
            JCheckBox checkbox = new JCheckBox(label.getDisplayName());
            checkbox.addItemListener(e -> this.updateOkButton());
            checkbox.setEnabled(label.isEditable());
            if (label.getDescription() != null) {
                checkbox.setToolTipText(label.getDescription());
            }
            this.checkboxes.put(label, checkbox);
            gbc = this.makeGbc(0, y, 2, 1);
            gbc.anchor = 17;
            this.add((Component)checkbox, gbc);
            ++y;
        }
        this.ok.setMnemonic(83);
        gbc = this.makeGbc(0, y, 1, 1);
        gbc.weightx = 0.5;
        gbc.fill = 2;
        this.add((Component)this.ok, gbc);
        this.cancel.setMnemonic(67);
        gbc = this.makeGbc(1, y, 1, 1);
        gbc.fill = 2;
        this.add((Component)this.cancel, gbc);
        this.pack();
    }

    public List<StreamLabels.StreamLabel> open(List<StreamLabels.StreamLabel> preset) {
        this.preset.clear();
        this.preset.addAll(preset);
        this.setCurrent(preset);
        this.save = false;
        this.setVisible(true);
        if (this.save) {
            return this.getCurrent();
        }
        return null;
    }

    private void setCurrent(List<StreamLabels.StreamLabel> preset) {
        for (Map.Entry<StreamLabels.StreamLabel, JCheckBox> entry : this.checkboxes.entrySet()) {
            entry.getValue().setSelected(preset.contains(entry.getKey()));
        }
    }

    private List<StreamLabels.StreamLabel> getCurrent() {
        ArrayList<StreamLabels.StreamLabel> labels = new ArrayList<StreamLabels.StreamLabel>();
        for (Map.Entry<StreamLabels.StreamLabel, JCheckBox> entry : this.checkboxes.entrySet()) {
            StreamLabels.StreamLabel label = entry.getKey();
            JCheckBox checkbox = entry.getValue();
            if (!checkbox.isSelected()) continue;
            labels.add(label);
        }
        return labels;
    }

    private void updateOkButton() {
        this.ok.setEnabled(!this.preset.equals(this.getCurrent()));
    }

    private GridBagConstraints makeGbc(int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(4, 6, 4, 6);
        return gbc;
    }
}

