/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.admin;

import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.lang.Language;
import chatty.util.StringUtil;
import chatty.util.api.ChannelStatus;
import chatty.util.api.TwitchApi;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectTagsDialog
extends JDialog {
    private static final String INFO = "<html><body style='width:340px'>" + Language.getString("admin.tags.info");
    private static final ImageIcon ADD_ICON = new ImageIcon(SelectTagsDialog.class.getResource("list-add.png"));
    private static final ImageIcon REMOVE_ICON = new ImageIcon(SelectTagsDialog.class.getResource("list-remove.png"));
    private static final ImageIcon SORT_ICON = new ImageIcon(SelectTagsDialog.class.getResource("sort.png"));
    private static final ImageIcon EDIT_ICON = new ImageIcon(SelectTagsDialog.class.getResource("edit.png"));
    private static final ImageIcon WARNING_ICON = new ImageIcon(SelectTagsDialog.class.getResource("warning.png"));
    private final MainGui main;
    private final JButton ok = new JButton(Language.getString("dialog.button.save"));
    private final JButton cancel = new JButton(Language.getString("dialog.button.cancel"));
    private final JButton addCurrent = new JButton("Add");
    private final JButton clearFilterButton = new JButton(Language.getString("admin.tags.button.clearFilter"));
    private final JButton addToFavoritesButton = new JButton(Language.getString("admin.tags.button.favorite"));
    private final JButton removeFromFavoritesButton = new JButton(Language.getString("admin.tags.button.unfavorite"));
    private final JLabel listInfo = new JLabel();
    private final JTextField input = new JTextField();
    private final MyList list = new MyList();
    private final DefaultListModel<ChannelStatus.StreamTag> listData = new DefaultListModel();
    private final JPanel currentPanel = new JPanel();
    private final JButton addButton = new JButton(Language.getString("admin.tags.button.addSelected"));
    private static final int MAX_TAGS = 10;
    private static final int MAX_TAG_LENGTH = 25;
    private final Set<ChannelStatus.StreamTag> favorites = new TreeSet<ChannelStatus.StreamTag>();
    private ChannelStatus.StreamTag selected;
    private final List<ChannelStatus.StreamTag> current = new ArrayList<ChannelStatus.StreamTag>();
    private final List<ChannelStatus.StreamTag> preset = new ArrayList<ChannelStatus.StreamTag>();
    private String loadingAllTagsInfo;
    private boolean save;

    public SelectTagsDialog(MainGui main, TwitchApi api) {
        super(main, Language.getString("admin.tags.title", 10), true);
        this.setResizable(false);
        this.setLayout(new GridBagLayout());
        this.main = main;
        this.list.setModel(this.listData);
        this.list.setCellRenderer(new ListRenderer());
        this.list.setFixedCellWidth(200);
        this.list.setVisibleRowCount(14);
        this.listData.addElement(new ChannelStatus.StreamTag("dummy"));
        this.list.initCellHeight();
        this.list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "useSelectedGame");
        this.list.getActionMap().put("useSelectedGame", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectTagsDialog.this.addSelected();
            }
        });
        this.list.getInputMap().put(KeyStroke.getKeyStroke(70, 512), "toggleFavorite");
        this.list.getActionMap().put("toggleFavorite", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectTagsDialog.this.toggleFavorite();
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SelectTagsDialog.this.openListContextMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SelectTagsDialog.this.openListContextMenu(e);
            }
        });
        GridBagConstraints gbc = this.makeGbc(0, 0, 5, 1);
        this.add((Component)new JLabel(INFO), gbc);
        gbc = this.makeGbc(0, 1, 2, 1);
        gbc.fill = 2;
        GuiUtil.installLengthLimitDocumentFilter(this.input, 25, false, new Object[0]);
        this.add((Component)this.input, gbc);
        gbc = this.makeGbc(2, 1, 1, 1);
        this.add((Component)GuiUtil.createInputLenghtLabel(this.input, 25), gbc);
        gbc = this.makeGbc(3, 1, 1, 1);
        GuiUtil.smallButtonInsets(this.addCurrent);
        gbc.fill = 2;
        this.add((Component)this.addCurrent, gbc);
        gbc = this.makeGbc(4, 1, 1, 1);
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        GuiUtil.smallButtonInsets(this.clearFilterButton);
        this.add((Component)this.clearFilterButton, gbc);
        gbc = this.makeGbc(0, 2, 3, 1);
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 4, 5, 4);
        gbc.fill = 2;
        this.add((Component)this.listInfo, gbc);
        gbc = this.makeGbc(0, 4, 2, 2);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        JScrollPane listScroll = new JScrollPane(this.list);
        listScroll.setVerticalScrollBarPolicy(22);
        this.add((Component)listScroll, gbc);
        gbc = this.makeGbc(2, 5, 3, 1);
        gbc.fill = 2;
        gbc.anchor = 11;
        this.currentPanel.setLayout(new GridBagLayout());
        this.add((Component)this.currentPanel, gbc);
        gbc = this.makeGbc(0, 6, 1, 1);
        GuiUtil.smallButtonInsets(this.addToFavoritesButton);
        this.addToFavoritesButton.setMnemonic(70);
        gbc.fill = 2;
        gbc.weightx = 0.5;
        this.add((Component)this.addToFavoritesButton, gbc);
        GuiUtil.smallButtonInsets(this.removeFromFavoritesButton);
        this.addToFavoritesButton.setMnemonic(70);
        gbc = this.makeGbc(1, 6, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 0.5;
        this.add((Component)this.removeFromFavoritesButton, gbc);
        this.ok.setMnemonic(83);
        gbc = this.makeGbc(0, 8, 3, 1);
        gbc.weightx = 0.5;
        gbc.fill = 2;
        this.add((Component)this.ok, gbc);
        this.cancel.setMnemonic(67);
        gbc = this.makeGbc(3, 8, 2, 1);
        gbc.fill = 2;
        this.add((Component)this.cancel, gbc);
        MyActionListener actionListener = new MyActionListener();
        this.clearFilterButton.addActionListener(actionListener);
        this.input.addActionListener(actionListener);
        this.ok.addActionListener(actionListener);
        this.cancel.addActionListener(actionListener);
        this.list.addListSelectionListener(new MyListSelectionListener());
        this.list.addMouseListener(new ListClickListener());
        this.addToFavoritesButton.addActionListener(actionListener);
        this.removeFromFavoritesButton.addActionListener(actionListener);
        GuiUtil.addChangeListener(this.input.getDocument(), e -> this.updateList());
        GuiUtil.smallButtonInsets(this.addButton);
        this.addButton.addActionListener(e -> this.addSelected());
        this.addButton.setIcon(ADD_ICON);
        this.addCurrent.setIcon(ADD_ICON);
        this.input.addActionListener(e -> this.addFromInput());
        this.addCurrent.addActionListener(e -> this.addFromInput());
        this.updateFavoriteButtons();
        this.pack();
    }

    public List<ChannelStatus.StreamTag> open(List<ChannelStatus.StreamTag> preset) {
        this.preset.clear();
        this.preset.addAll(preset);
        this.setCurrent(preset);
        this.loadFavorites();
        this.updateList();
        this.save = false;
        this.setVisible(true);
        if (this.save) {
            return this.current;
        }
        return null;
    }

    private void useCurrentTagsAndClose() {
        this.save = true;
        this.setVisible(false);
    }

    private void setCurrent(List<ChannelStatus.StreamTag> data) {
        this.current.clear();
        this.current.addAll(data);
        this.updateCurrent();
    }

    private void updateCurrent() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 5, 2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        this.currentPanel.removeAll();
        gbc.insets = new Insets(2, 2, 2, 2);
        int minWidth = -1;
        for (int i = 0; i < 10; ++i) {
            ChannelStatus.StreamTag tag = this.current.size() > i ? this.current.get(i) : new ChannelStatus.StreamTag("");
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.anchor = 10;
            JLabel label = new JLabel(tag.toString().isEmpty() ? "empty" : tag.toString());
            label.setEnabled(tag.isValid());
            if (SelectTagsDialog.hasSpecialCharacters(tag.getName())) {
                label.setIcon(WARNING_ICON);
                label.setHorizontalTextPosition(2);
                label.setToolTipText("Tag may not work since it appears to contain special characters.");
            }
            this.currentPanel.add((Component)label, gbc);
            gbc.gridx = 1;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.currentPanel.add((Component)this.createRemoveTagButton(tag), gbc);
            gbc.gridx = 2;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.currentPanel.add((Component)this.createEditButton(tag), gbc);
            gbc.gridx = 3;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.currentPanel.add((Component)this.createMoveButton(tag), gbc);
            if (minWidth != -1) continue;
            minWidth = label.getFontMetrics(label.getFont()).stringWidth(String.join((CharSequence)"", Collections.nCopies(25, "A")));
        }
        gbc.insets = new Insets(5, 2, 2, 2);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.ipadx = minWidth - this.addButton.getPreferredSize().width;
        gbc.anchor = 10;
        this.currentPanel.add((Component)this.addButton, gbc);
        this.currentPanel.invalidate();
        this.pack();
        this.repaint();
        this.updateAddButton();
        this.updateOkButton();
    }

    private JButton createRemoveTagButton(ChannelStatus.StreamTag tag) {
        JButton removeButton = new JButton();
        this.configureButton(removeButton, REMOVE_ICON);
        removeButton.setToolTipText(Language.getString("admin.tags.button.remove.tip", tag.toString()));
        removeButton.addActionListener(e -> {
            this.current.remove(tag);
            this.updateCurrent();
        });
        removeButton.setEnabled(tag.isValid());
        return removeButton;
    }

    private JButton createMoveButton(ChannelStatus.StreamTag tag) {
        JButton button = new JButton();
        this.configureButton(button, SORT_ICON);
        button.addActionListener(e -> this.showMoveMenu(tag, button));
        button.setToolTipText(Language.getString("admin.tags.button.move.tip", tag.toString()));
        button.setEnabled(tag.isValid());
        return button;
    }

    private void showMoveMenu(final ChannelStatus.StreamTag tag, JButton button) {
        JPopupMenu menu = new JPopupMenu();
        for (int i = 0; i < 10; ++i) {
            if (this.current.size() > i) {
                ChannelStatus.StreamTag t = this.current.get(i);
                final int index = i;
                menu.add(new AbstractAction(Language.getString("admin.tags.button.move.item", t.toString())){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectTagsDialog.this.current.remove(tag);
                        SelectTagsDialog.this.current.add(index, tag);
                        SelectTagsDialog.this.updateCurrent();
                    }
                });
                continue;
            }
            AbstractAction emptyAction = new AbstractAction("empty"){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
            emptyAction.setEnabled(false);
            menu.add(emptyAction);
        }
        menu.show(button, 0, button.getHeight());
    }

    private JButton createEditButton(ChannelStatus.StreamTag tag) {
        JButton button = new JButton();
        this.configureButton(button, EDIT_ICON);
        button.addActionListener(e -> {
            String result = StringUtil.removeWhitespace(SelectTagsDialog.showTagEditDialog(this, tag));
            if (!StringUtil.isNullOrEmpty(result)) {
                int index = this.current.indexOf(tag);
                this.current.remove(tag);
                this.current.add(index, new ChannelStatus.StreamTag(result));
                this.updateCurrent();
            }
        });
        button.setToolTipText(Language.getString("admin.tags.button.edit.tip", tag.toString()));
        button.setEnabled(tag.isValid());
        return button;
    }

    private static String showTagEditDialog(Window parent, ChannelStatus.StreamTag tag) {
        JDialog dialog = new JDialog(parent);
        dialog.setTitle(Language.getString("admin.tags.button.edit.tip", tag.toString()));
        dialog.setLayout(new GridBagLayout());
        dialog.setModal(true);
        dialog.setResizable(false);
        JTextField input = new JTextField(25);
        input.setText(tag.getName());
        GuiUtil.installLengthLimitDocumentFilter(input, 25, false, new Object[0]);
        dialog.add((Component)input, GuiUtil.makeGbc(0, 0, 2, 1));
        dialog.add((Component)GuiUtil.createInputLenghtLabel(input, 25), GuiUtil.makeGbc(2, 0, 1, 1));
        JButton ok = new JButton(Language.getString("dialog.button.ok"));
        ok.setActionCommand("");
        JButton cancel = new JButton(Language.getString("dialog.button.cancel"));
        ok.addActionListener(a -> {
            dialog.dispose();
            ok.setActionCommand("save");
        });
        input.addActionListener(a -> {
            dialog.dispose();
            ok.setActionCommand("save");
        });
        cancel.addActionListener(a -> dialog.dispose());
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 1, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        dialog.add((Component)ok, gbc);
        dialog.add((Component)cancel, GuiUtil.makeGbc(1, 1, 1, 1));
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (ok.getActionCommand().equals("save")) {
            return input.getText();
        }
        return null;
    }

    private void configureButton(JButton button, ImageIcon icon) {
        button.setIcon(icon);
        GuiUtil.smallButtonInsetsSquare(button);
        button.setSize(10, 10);
    }

    private void addFromInput() {
        String name = this.input.getText();
        ChannelStatus.StreamTag tag = this.getCurrent(name);
        if (tag != null) {
            int index = this.current.indexOf(tag);
            this.current.remove(tag);
            this.current.add(index, new ChannelStatus.StreamTag(name));
        } else {
            this.current.add(new ChannelStatus.StreamTag(name));
        }
        this.updateCurrent();
        this.input.setText("");
    }

    private ChannelStatus.StreamTag getCurrent(String name) {
        name = StringUtil.toLowerCase(name);
        for (ChannelStatus.StreamTag t : this.current) {
            if (!StringUtil.toLowerCase(t.getName()).equals(name)) continue;
            return t;
        }
        return null;
    }

    private void addSelected() {
        for (ChannelStatus.StreamTag tag : this.list.getSelectedValuesList()) {
            if (this.canAddTag(tag)) {
                this.current.add(tag);
            } else {
                this.current.remove(tag);
            }
            this.updateCurrent();
        }
    }

    private boolean canAddSomething() {
        for (ChannelStatus.StreamTag c : this.list.getSelectedValuesList()) {
            if (!this.canAddTag(c)) continue;
            return true;
        }
        return false;
    }

    private boolean canAddTag(ChannelStatus.StreamTag c) {
        return c != null && c != ChannelStatus.StreamTag.EMPTY && this.current.size() < 10 && !this.current.contains(c);
    }

    private void updateAddButton() {
        this.addButton.setEnabled(this.canAddSomething());
    }

    private void setSelected(ChannelStatus.StreamTag c) {
        this.selected = c == null ? null : c;
        this.updateAddButton();
    }

    private static boolean hasSpecialCharacters(String text) {
        for (int codepoint : text.codePoints().toArray()) {
            if (Character.isAlphabetic(codepoint) || Character.isDigit(codepoint)) continue;
            return true;
        }
        return false;
    }

    private void updateList() {
        this.addCurrent.setEnabled(new ChannelStatus.StreamTag(this.input.getText()).isValid());
        this.clearFilterButton.setEnabled(!this.input.getText().isEmpty());
        this.listData.clear();
        String search = this.input.getText();
        if (search == null || search.trim().isEmpty()) {
            search = "";
        }
        search = search.toLowerCase();
        int addedCount = 0;
        ChannelStatus.StreamTag inputTag = null;
        for (ChannelStatus.StreamTag c : this.current) {
            if (c.getDisplayName().toLowerCase().contains(search)) {
                this.listData.addElement(c);
                ++addedCount;
            }
            if (!c.getName().toLowerCase().equals(search)) continue;
            inputTag = c;
        }
        if (inputTag == null && (inputTag = new ChannelStatus.StreamTag(this.input.getText())).isValid()) {
            this.listData.addElement(inputTag);
        }
        this.setSelected(inputTag);
        if (!this.listData.isEmpty() && !this.favorites.isEmpty()) {
            this.listData.addElement(ChannelStatus.StreamTag.EMPTY);
        }
        int addedCountFavs = 0;
        for (ChannelStatus.StreamTag c : this.favorites) {
            if (!c.getDisplayName().toLowerCase().contains(search)) continue;
            this.listData.addElement(c);
            ++addedCountFavs;
        }
        this.listInfo.setText(Language.getString("admin.tags.listInfo", addedCount, this.current.size(), addedCountFavs, this.favorites.size()) + (this.loadingAllTagsInfo != null ? " (" + this.loadingAllTagsInfo + ")" : ""));
        this.list.setSelectedValue(this.selected, false);
        this.pack();
    }

    private void addToFavorites() {
        for (ChannelStatus.StreamTag tag : this.list.getSelectedValuesList()) {
            if (!tag.isValid()) continue;
            this.favorites.add(tag);
        }
        this.saveFavorites();
        this.updateList();
    }

    private void removeFromFavorites() {
        for (ChannelStatus.StreamTag tag : this.list.getSelectedValuesList()) {
            this.favorites.remove(tag);
        }
        this.saveFavorites();
        this.updateList();
    }

    private void toggleFavorite() {
        for (ChannelStatus.StreamTag tag : this.list.getSelectedValuesList()) {
            if (this.favorites.contains(tag) || !tag.isValid()) {
                this.favorites.remove(tag);
                continue;
            }
            this.favorites.add(tag);
        }
        this.saveFavorites();
        this.updateList();
    }

    private void saveFavorites() {
        HashMap<String, String> favs = new HashMap<String, String>();
        for (ChannelStatus.StreamTag c : this.favorites) {
            favs.put(c.getName(), "");
        }
        this.main.setStreamTagFavorites(favs);
    }

    private void loadFavorites() {
        this.favorites.clear();
        Map<String, String> favs = this.main.getStreamTagFavorites();
        for (String name : favs.keySet()) {
            String legacyName = favs.get(name);
            if (!legacyName.isEmpty()) {
                name = StringUtil.removeWhitespace(legacyName);
            }
            this.favorites.add(new ChannelStatus.StreamTag(name));
        }
    }

    private void updateFavoriteButtons() {
        boolean favoriteSelected = false;
        boolean nonFavoriteSelected = false;
        for (ChannelStatus.StreamTag c : this.list.getSelectedValuesList()) {
            if (!c.isValid()) continue;
            if (this.favorites.contains(c)) {
                favoriteSelected = true;
                continue;
            }
            nonFavoriteSelected = true;
        }
        this.addToFavoritesButton.setEnabled(nonFavoriteSelected);
        this.removeFromFavoritesButton.setEnabled(favoriteSelected);
    }

    private void updateOkButton() {
        this.ok.setEnabled(!this.preset.equals(this.current));
    }

    private GridBagConstraints makeGbc(int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(4, 4, 4, 4);
        return gbc;
    }

    private void updateGameFromSelection() {
        ChannelStatus.StreamTag selected = (ChannelStatus.StreamTag)this.list.getSelectedValue();
        if (selected != null) {
            this.setSelected(selected);
        }
    }

    private void itemSelected() {
        this.updateGameFromSelection();
    }

    private void openListContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.selectClicked(e, false);
            final List listSelected = this.list.getSelectedValuesList();
            JPopupMenu menu = new JPopupMenu();
            menu.add(new AbstractAction(Language.getString("admin.tags.cm.replaceAll")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectTagsDialog.this.setCurrent(listSelected);
                    SelectTagsDialog.this.updateCurrent();
                }
            });
            if (listSelected.size() == 1 && !this.current.isEmpty() && !this.current.contains(this.list.getSelectedValue())) {
                menu.addSeparator();
                for (final ChannelStatus.StreamTag c : this.current) {
                    menu.add(new AbstractAction(Language.getString("admin.tags.cm.replace", c)){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ChannelStatus.StreamTag replaceWith = (ChannelStatus.StreamTag)SelectTagsDialog.this.list.getSelectedValue();
                            SelectTagsDialog.this.current.replaceAll(item -> {
                                if (item.equals(c)) {
                                    return replaceWith;
                                }
                                return item;
                            });
                            SelectTagsDialog.this.updateCurrent();
                        }
                    });
                }
            }
            menu.show(this.list, e.getX(), e.getY());
        }
    }

    private void selectClicked(MouseEvent e, boolean onlyOutside) {
        int index = this.list.locationToIndex(e.getPoint());
        Rectangle bounds = this.list.getCellBounds(index, index);
        if (bounds != null && bounds.contains(e.getPoint())) {
            if (!onlyOutside) {
                if (this.list.isSelectedIndex(index)) {
                    this.list.addSelectionInterval(index, index);
                } else {
                    this.list.setSelectedIndex(index);
                }
            }
        } else {
            this.list.clearSelection();
        }
    }

    private static class MyList
    extends JList<ChannelStatus.StreamTag> {
        private int cellHeight = 16;

        private MyList() {
        }

        public void initCellHeight() {
            Rectangle r = this.getCellBounds(0, 0);
            if (r != null) {
                this.cellHeight = r.height;
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Insets insets = this.getInsets();
            int dx = insets.left + insets.right;
            int dy = insets.top + insets.bottom;
            int visibleRowCount = this.getVisibleRowCount();
            int fixedCellWidth = this.getFixedCellWidth();
            int width = fixedCellWidth + dx;
            int height = this.cellHeight * visibleRowCount + dy;
            return new Dimension(width, height);
        }
    }

    private class ListRenderer
    extends DefaultListCellRenderer {
        private final ImageIcon icon = new ImageIcon(MainGui.class.getResource("star.png"));
        private final Border seperatorBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY);

        private ListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return label;
            }
            ChannelStatus.StreamTag tag = (ChannelStatus.StreamTag)value;
            String text = tag.toString();
            if (text == null || text.isEmpty()) {
                label.setText(null);
                label.setBorder(this.seperatorBorder);
            }
            if (SelectTagsDialog.this.favorites.contains(tag)) {
                label.setIcon(this.icon);
            }
            if (SelectTagsDialog.this.current.contains(tag)) {
                label.setEnabled(false);
            }
            return label;
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SelectTagsDialog.this.ok) {
                SelectTagsDialog.this.useCurrentTagsAndClose();
            }
            if (e.getSource() == SelectTagsDialog.this.cancel) {
                SelectTagsDialog.this.save = false;
                SelectTagsDialog.this.setVisible(false);
            }
            if (e.getSource() == SelectTagsDialog.this.addToFavoritesButton) {
                SelectTagsDialog.this.addToFavorites();
            }
            if (e.getSource() == SelectTagsDialog.this.removeFromFavoritesButton) {
                SelectTagsDialog.this.removeFromFavorites();
            }
            if (e.getSource() == SelectTagsDialog.this.clearFilterButton) {
                SelectTagsDialog.this.input.setText(null);
            }
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SelectTagsDialog.this.itemSelected();
            SelectTagsDialog.this.updateFavoriteButtons();
        }
    }

    private class ListClickListener
    extends MouseAdapter {
        private ListClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SelectTagsDialog.this.itemSelected();
            if (e.getClickCount() == 2) {
                SelectTagsDialog.this.addSelected();
            }
        }
    }
}

