/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.admin;

import chatty.gui.components.admin.StatusHistoryEntry;
import chatty.util.StringUtil;
import chatty.util.api.ChannelStatus;
import chatty.util.api.StreamCategory;
import chatty.util.api.StreamLabels;
import chatty.util.settings.Settings;
import chatty.util.settings.SettingsListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class StatusHistory
implements SettingsListener {
    private static final Logger LOGGER = Logger.getLogger(StatusHistory.class.getName());
    private static final int DAY = 86400000;
    private static final int MAX_LOADING_ERRORS = 2;
    private final Map<StatusHistoryEntry, StatusHistoryEntry> entries = new HashMap<StatusHistoryEntry, StatusHistoryEntry>();
    private final Settings settings;

    public StatusHistory(Settings settings) {
        this.settings = settings;
        this.loadFromSettings();
        this.removeOld();
    }

    private synchronized void removeOld() {
        if (!this.settings.getBoolean("statusHistoryClear")) {
            return;
        }
        long days = this.settings.getLong("statusHistoryKeepDays");
        long keepAfter = System.currentTimeMillis() - days * 86400000L;
        Iterator<Map.Entry<StatusHistoryEntry, StatusHistoryEntry>> it = this.entries.entrySet().iterator();
        int countRemoved = 0;
        while (it.hasNext()) {
            Map.Entry<StatusHistoryEntry, StatusHistoryEntry> entry = it.next();
            if (entry.getValue().favorite || entry.getValue().lastActivity >= keepAfter) continue;
            it.remove();
            ++countRemoved;
        }
        if (countRemoved > 0) {
            LOGGER.info("StatusPresets: Removed " + countRemoved + " old entries.");
        }
    }

    public synchronized StatusHistoryEntry get(String title, StreamCategory game, List<ChannelStatus.StreamTag> tags, List<StreamLabels.StreamLabel> labels) {
        StatusHistoryEntry entry = new StatusHistoryEntry(title, game, tags, labels);
        return this.entries.get(entry);
    }

    public synchronized boolean isFavorite(String title, StreamCategory game, List<ChannelStatus.StreamTag> tags, List<StreamLabels.StreamLabel> labels) {
        StatusHistoryEntry entry = this.get(title, game, tags, labels);
        return entry != null ? entry.favorite : false;
    }

    private void put(StatusHistoryEntry entry) {
        this.entries.put(entry, entry);
    }

    public synchronized StatusHistoryEntry add(String title, StreamCategory game, List<ChannelStatus.StreamTag> tags, List<StreamLabels.StreamLabel> labels, long lastSet, int timesUsed) {
        StatusHistoryEntry entry = new StatusHistoryEntry(title, game, tags, labels, lastSet, timesUsed, false);
        this.put(entry);
        return entry;
    }

    public synchronized void remove(String title, StreamCategory game, List<ChannelStatus.StreamTag> tags, List<StreamLabels.StreamLabel> labels) {
        StatusHistoryEntry entry = new StatusHistoryEntry(title, game, tags, labels);
        this.entries.remove(entry);
    }

    public synchronized void remove(StatusHistoryEntry entry) {
        this.entries.remove(entry);
    }

    public synchronized StatusHistoryEntry addUsed(String title, StreamCategory game, List<ChannelStatus.StreamTag> tags, List<StreamLabels.StreamLabel> labels) {
        StatusHistoryEntry entry = new StatusHistoryEntry(title, game, tags, labels, System.currentTimeMillis(), 1, false);
        StatusHistoryEntry present = this.entries.get(entry);
        if (present != null) {
            entry = present.increaseUsed();
        }
        this.put(entry);
        return entry;
    }

    public synchronized StatusHistoryEntry addFavorite(String title, StreamCategory game, List<ChannelStatus.StreamTag> tags, List<StreamLabels.StreamLabel> labels) {
        return this.setFavorite(title, game, tags, labels, true);
    }

    public synchronized void removeFavorite(String title, StreamCategory game, List<ChannelStatus.StreamTag> tags, List<StreamLabels.StreamLabel> labels) {
        this.setFavorite(title, game, tags, labels, false);
    }

    public synchronized StatusHistoryEntry setFavorite(String title, StreamCategory game, List<ChannelStatus.StreamTag> tags, List<StreamLabels.StreamLabel> labels, boolean favorite) {
        StatusHistoryEntry entry = new StatusHistoryEntry(title, game, tags, labels, System.currentTimeMillis(), 0, favorite);
        return this.setFavorite(entry, favorite);
    }

    public synchronized StatusHistoryEntry setFavorite(StatusHistoryEntry entry, boolean favorite) {
        StatusHistoryEntry present = this.entries.get(entry);
        if (present != null) {
            entry = present;
        }
        if (entry.favorite != favorite) {
            entry = entry.setFavorite(favorite);
        }
        this.put(entry);
        return entry;
    }

    public synchronized void updateStreamTagName(ChannelStatus.StreamTag c) {
        HashSet<StatusHistoryEntry> modifiedValues = new HashSet<StatusHistoryEntry>();
        for (StatusHistoryEntry entry : this.entries.values()) {
            StatusHistoryEntry modified = entry.updateTagName(c);
            if (modified == entry) continue;
            modifiedValues.add(modified);
        }
        modifiedValues.stream().forEach(e -> this.entries.put((StatusHistoryEntry)e, (StatusHistoryEntry)e));
    }

    public synchronized void updateCategory(StreamCategory category) {
        HashMap<StatusHistoryEntry, StatusHistoryEntry> modifiedValues = new HashMap<StatusHistoryEntry, StatusHistoryEntry>();
        for (StatusHistoryEntry entry : this.entries.values()) {
            StatusHistoryEntry modified = entry.updateCategory(category);
            if (modified == entry) continue;
            modifiedValues.put(entry, modified);
            LOGGER.info(String.format("Status presets: Updating '%s' (%s to %s)", entry, entry.game.toStringVerbose(), modified.game.toStringVerbose()));
        }
        modifiedValues.entrySet().stream().forEach(e -> {
            this.entries.remove(e.getKey());
            this.entries.put((StatusHistoryEntry)e.getValue(), (StatusHistoryEntry)e.getValue());
        });
    }

    public synchronized List<StatusHistoryEntry> getEntries() {
        return new ArrayList<StatusHistoryEntry>(this.entries.values());
    }

    private synchronized void saveToSettings() {
        ArrayList<List> entriesToSave = new ArrayList<List>();
        for (StatusHistoryEntry entry : this.entries.values()) {
            entriesToSave.add(this.entryToList(entry));
        }
        this.settings.putList("statusPresets", entriesToSave);
    }

    private synchronized void loadFromSettings() {
        List entriesToLoad = this.settings.getList("statusPresets");
        this.entries.clear();
        int count = 0;
        int errorCount = 0;
        for (List entryToLoad : entriesToLoad) {
            StatusHistoryEntry entry = this.listToEntry(entryToLoad);
            if (entry != null) {
                this.entries.put(entry, entry);
                ++count;
                continue;
            }
            if (errorCount < 2) {
                LOGGER.warning("StatusPresets: Couldn't load entry " + entryToLoad);
            }
            ++errorCount;
        }
        if (errorCount > 2) {
            LOGGER.warning("StatusPresets: " + (errorCount - 2) + " more errors.");
        }
        LOGGER.info("StatusPresets: Loaded " + count + "/" + entriesToLoad.size() + " entries.");
    }

    private List entryToList(StatusHistoryEntry entry) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(entry.title);
        list.add(entry.game.name);
        list.add(entry.lastActivity);
        list.add(entry.timesUsed);
        list.add(entry.favorite);
        list.add(new ArrayList());
        ArrayList clist = new ArrayList();
        if (entry.tags != null && !entry.tags.isEmpty()) {
            for (ChannelStatus.StreamTag c : entry.tags) {
                ArrayList<String> cdata = new ArrayList<String>();
                cdata.add("");
                cdata.add(c.getName());
                clist.add(cdata);
            }
        }
        list.add(clist);
        list.add(entry.game.id);
        ArrayList<String> labels = new ArrayList<String>();
        if (entry.labels != null && !entry.labels.isEmpty()) {
            for (StreamLabels.StreamLabel label : entry.labels) {
                labels.add(label.getId());
            }
        }
        list.add(labels);
        return list;
    }

    private StatusHistoryEntry listToEntry(List list) {
        try {
            String title = (String)list.get(0);
            String gameName = (String)list.get(1);
            Number lastSet = (Number)list.get(2);
            Number timesUsed = (Number)list.get(3);
            Boolean favorite = (Boolean)list.get(4);
            ArrayList<ChannelStatus.StreamTag> tags = new ArrayList<ChannelStatus.StreamTag>();
            ArrayList<StreamLabels.StreamLabel> labels = new ArrayList<StreamLabels.StreamLabel>();
            String gameId = null;
            if (list.size() > 6 && list.get(6) instanceof List) {
                List clist = (List)list.get(6);
                for (Object obj : clist) {
                    List cdata = (List)obj;
                    String tagId = (String)cdata.get(0);
                    String tagName = (String)cdata.get(1);
                    tags.add(new ChannelStatus.StreamTag(StringUtil.removeWhitespace(tagName)));
                }
            }
            if (list.size() > 7) {
                gameId = (String)list.get(7);
            }
            if (list.size() > 8) {
                for (Object obj : (List)list.get(8)) {
                    labels.add(new StreamLabels.StreamLabel((String)obj));
                }
            }
            if (title == null || gameName == null) {
                return null;
            }
            return new StatusHistoryEntry(title, new StreamCategory(gameId, gameName), tags, labels, lastSet.longValue(), timesUsed.intValue(), favorite);
        }
        catch (ClassCastException | IndexOutOfBoundsException ex) {
            return null;
        }
    }

    @Override
    public void aboutToSaveSettings(Settings settings) {
        this.saveToSettings();
    }
}

