/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.admin;

import chatty.gui.GuiUtil;
import chatty.gui.components.admin.StatusHistory;
import chatty.gui.components.admin.StatusHistoryEntry;
import chatty.gui.components.admin.StatusHistoryTable;
import chatty.gui.components.menus.ContextMenu;
import chatty.lang.Language;
import chatty.util.api.StreamCategory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StatusHistoryDialog
extends JDialog {
    private static final String INFO_TEXT = "<html><body style='width: 240px;text-align:center;'>" + Language.getString("admin.presets.info");
    private final StatusHistory history;
    private final JButton useTitleButton = new JButton(Language.getString("admin.presets.button.useTitleOnly"));
    private final JButton useAllButton = new JButton(Language.getString("admin.presets.button.useStatus"));
    private final JButton cancelButton = new JButton(Language.getString("dialog.button.cancel"));
    private final StatusHistoryTable table;
    private final JCheckBox filterCurrentGame = new JCheckBox(Language.getString("admin.presets.setting.currentGame"));
    private final JCheckBox filterFavorites = new JCheckBox(Language.getString("admin.presets.setting.favorites"));
    private StreamCategory currentGame;
    private CloseAction closeAction;

    public StatusHistoryDialog(Dialog parent, StatusHistory history) {
        super(parent);
        this.setTitle("Status History");
        this.setModal(true);
        this.setLayout(new GridBagLayout());
        this.table = new StatusHistoryTable(new TableContextMenu());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StatusHistoryDialog.this.updateButtons();
            }
        });
        this.updateButtons();
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StatusHistoryDialog.this.table.getSelectedColumn() == 0 && StatusHistoryDialog.this.table.rowAtPoint(e.getPoint()) != -1) {
                    StatusHistoryDialog.this.toggleFavoriteOnSelected();
                } else if (e.getClickCount() == 2 && StatusHistoryDialog.this.table.getSelectedColumn() != 0) {
                    StatusHistoryDialog.this.useStatus();
                }
            }
        });
        this.addShortcuts();
        this.history = history;
        GridBagConstraints gbc = this.makeGbc(0, 0, 5, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), gbc);
        JPanel filterSelectionButtons = new JPanel();
        filterSelectionButtons.setBorder(BorderFactory.createTitledBorder(Language.getString("admin.presets.showOnly")));
        FilterAction filterListener = new FilterAction();
        this.filterCurrentGame.addActionListener(filterListener);
        this.filterFavorites.addActionListener(filterListener);
        this.filterCurrentGame.setMnemonic(71);
        this.filterFavorites.setMnemonic(70);
        filterSelectionButtons.add(this.filterCurrentGame);
        filterSelectionButtons.add(this.filterFavorites);
        gbc = this.makeGbc(2, 1, 3, 3);
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.fill = 2;
        this.add((Component)filterSelectionButtons, gbc);
        gbc = this.makeGbc(0, 1, 2, 2);
        this.add((Component)new JLabel(INFO_TEXT), gbc);
        this.useAllButton.setMnemonic(85);
        gbc = this.makeGbc(0, 4, 2, 1);
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.useAllButton, gbc);
        this.useTitleButton.setMnemonic(84);
        gbc = this.makeGbc(2, 4, 2, 1);
        gbc.fill = 2;
        gbc.weightx = 0.2;
        gbc.insets = new Insets(5, 5, 5, 4);
        this.add((Component)this.useTitleButton, gbc);
        this.cancelButton.setMnemonic(67);
        gbc = this.makeGbc(4, 4, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 0.1;
        this.add((Component)this.cancelButton, gbc);
        ButtonAction buttonActionListener = new ButtonAction();
        this.useTitleButton.addActionListener(buttonActionListener);
        this.useAllButton.addActionListener(buttonActionListener);
        this.cancelButton.addActionListener(buttonActionListener);
        this.pack();
        this.setMinimumSize(new Dimension(this.getPreferredSize().width, 200));
        this.setSize(new Dimension(870, 400));
        GuiUtil.installEscapeCloseOperation(this);
    }

    private void addShortcuts() {
        this.table.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "removeItem");
        this.table.getActionMap().put("removeItem", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusHistoryDialog.this.removeSelected();
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(70, 0), "toggleFavorite");
        this.table.getActionMap().put("toggleFavorite", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusHistoryDialog.this.toggleFavoriteOnSelected();
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "useStatus");
        this.table.getActionMap().put("useStatus", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusHistoryDialog.this.useStatus();
            }
        });
    }

    public StatusHistoryEntry showDialog(StreamCategory currentGame) {
        this.currentGame = currentGame;
        this.table.requestFocusInWindow();
        this.setTitle(Language.getString("admin.presets.title", currentGame));
        this.updateFilter();
        this.table.setData(this.history.getEntries());
        this.closeAction = CloseAction.CANCEL;
        this.setVisible(true);
        StatusHistoryEntry selected = this.table.getSelectedEntry();
        if (selected != null && null != this.closeAction) {
            switch (this.closeAction) {
                case USE_TITLE: {
                    return new StatusHistoryEntry(selected.title, null, null, null, -1L, -1, false);
                }
                case USE_GAME: {
                    return new StatusHistoryEntry(null, selected.game, null, null, -1L, -1, false);
                }
                case USE_TAGS: {
                    return new StatusHistoryEntry(null, null, selected.tags, null, -1L, -1, false);
                }
                case USE_GAME_TAGS: {
                    return new StatusHistoryEntry(null, selected.game, selected.tags, null, -1L, -1, false);
                }
                case USE_LABELS: {
                    return new StatusHistoryEntry(null, null, null, selected.labels, -1L, -1, false);
                }
                case USE_ALL: {
                    return selected;
                }
            }
        }
        return null;
    }

    public String getSortOrder() {
        return GuiUtil.getSortingFromTable(this.table);
    }

    public void setSortOrder(String sorting) {
        GuiUtil.setSortingForTable(this.table, sorting);
    }

    private void removeSelected() {
        StatusHistoryEntry selected = this.table.getSelectedEntry();
        if (selected != null) {
            this.table.removeEntry(selected);
            this.history.remove(selected);
        }
    }

    private void toggleFavoriteOnSelected() {
        StatusHistoryEntry selected = this.table.getSelectedEntry();
        if (selected != null) {
            StatusHistoryEntry modified = this.history.setFavorite(selected, !selected.favorite);
            this.table.updateEntry(modified);
        }
    }

    private void updateFilter() {
        StreamCategory game = null;
        boolean favorites = this.filterFavorites.isSelected();
        if (this.filterCurrentGame.isSelected()) {
            game = this.currentGame;
        }
        this.table.filter(game, favorites);
    }

    private boolean somethingSelected() {
        return this.table.getSelectedRowCount() > 0;
    }

    private void updateButtons() {
        boolean enabled = this.somethingSelected();
        this.useAllButton.setEnabled(enabled);
        this.useTitleButton.setEnabled(enabled);
    }

    private GridBagConstraints makeGbc(int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(5, 5, 5, 5);
        return gbc;
    }

    private void useStatus() {
        this.closeAction = CloseAction.USE_ALL;
        this.setVisible(false);
    }

    private void useTitle() {
        this.closeAction = CloseAction.USE_TITLE;
        this.setVisible(false);
    }

    private void useGame() {
        this.closeAction = CloseAction.USE_GAME;
        this.setVisible(false);
    }

    private void useTags() {
        this.closeAction = CloseAction.USE_TAGS;
        this.setVisible(false);
    }

    private void useGameAndTags() {
        this.closeAction = CloseAction.USE_GAME_TAGS;
        this.setVisible(false);
    }

    private void useLabels() {
        this.closeAction = CloseAction.USE_LABELS;
        this.setVisible(false);
    }

    private class TableContextMenu
    extends ContextMenu {
        TableContextMenu() {
            this.addItem("toggleFavorite", Language.getString("admin.presets.cm.toggleFavorite"));
            this.addItem("remove", Language.getString("admin.presets.cm.remove"));
            this.addSeparator();
            this.addItem("useAll", Language.getString("admin.presets.cm.useStatus"));
            this.addSeparator();
            this.addItem("useTitle", Language.getString("admin.presets.cm.useTitleOnly"));
            this.addItem("useGame", Language.getString("admin.presets.cm.useGameOnly"));
            this.addItem("useTags", Language.getString("admin.presets.cm.useTagsOnly"));
            this.addItem("useLabels", Language.getString("admin.presets.cm.useLabelsOnly"));
            this.addSeparator();
            this.addItem("useGameTags", Language.getString("admin.presets.cm.useGameTagsOnly"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand()) {
                case "remove": {
                    StatusHistoryDialog.this.removeSelected();
                    break;
                }
                case "toggleFavorite": {
                    StatusHistoryDialog.this.toggleFavoriteOnSelected();
                    break;
                }
                case "useAll": {
                    StatusHistoryDialog.this.useStatus();
                    break;
                }
                case "useTitle": {
                    StatusHistoryDialog.this.useTitle();
                    break;
                }
                case "useGameTags": {
                    StatusHistoryDialog.this.useGameAndTags();
                    break;
                }
                case "useGame": {
                    StatusHistoryDialog.this.useGame();
                    break;
                }
                case "useTags": {
                    StatusHistoryDialog.this.useTags();
                    break;
                }
                case "useLabels": {
                    StatusHistoryDialog.this.useLabels();
                    break;
                }
            }
        }
    }

    private class FilterAction
    implements ActionListener {
        private FilterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatusHistoryDialog.this.updateFilter();
        }
    }

    private class ButtonAction
    implements ActionListener {
        private ButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == StatusHistoryDialog.this.useAllButton) {
                StatusHistoryDialog.this.useStatus();
            } else if (e.getSource() == StatusHistoryDialog.this.useTitleButton) {
                StatusHistoryDialog.this.useTitle();
            } else {
                StatusHistoryDialog.this.setVisible(false);
            }
        }
    }

    private static enum CloseAction {
        CANCEL,
        USE_ALL,
        USE_TITLE,
        USE_GAME,
        USE_TAGS,
        USE_GAME_TAGS,
        USE_LABELS;

    }
}

