/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.admin;

import chatty.util.api.ChannelStatus;
import chatty.util.api.StreamCategory;
import chatty.util.api.StreamLabels;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StatusHistoryEntry {
    public final String title;
    public final StreamCategory game;
    public final List<ChannelStatus.StreamTag> tags;
    public final List<StreamLabels.StreamLabel> labels;
    public final long lastActivity;
    public final int timesUsed;
    public final boolean favorite;

    public StatusHistoryEntry(String title, StreamCategory game, List<ChannelStatus.StreamTag> tags, List<StreamLabels.StreamLabel> labels, long lastSet, int timesUsed, boolean favorite) {
        this.title = title;
        this.game = game;
        this.lastActivity = lastSet;
        this.timesUsed = timesUsed;
        this.favorite = favorite;
        this.tags = tags == null ? null : new ArrayList<ChannelStatus.StreamTag>(tags);
        this.labels = labels == null ? null : new ArrayList<StreamLabels.StreamLabel>(labels);
    }

    public StatusHistoryEntry(String title, StreamCategory game, List<ChannelStatus.StreamTag> tags, List<StreamLabels.StreamLabel> labels) {
        this(title, game, tags, labels, -1L, -1, false);
    }

    public StatusHistoryEntry increaseUsed() {
        return new StatusHistoryEntry(this.title, this.game, this.tags, this.labels, System.currentTimeMillis(), this.timesUsed + 1, this.favorite);
    }

    public StatusHistoryEntry setFavorite(boolean favorite) {
        return new StatusHistoryEntry(this.title, this.game, this.tags, this.labels, this.lastActivity, this.timesUsed, favorite);
    }

    public StatusHistoryEntry updateTagName(ChannelStatus.StreamTag o) {
        if (this.tags != null) {
            for (ChannelStatus.StreamTag tag : this.tags) {
                if (!tag.equals(o) || Objects.equals(o.getDisplayName(), tag.getDisplayName())) continue;
                ArrayList<ChannelStatus.StreamTag> newTags = new ArrayList<ChannelStatus.StreamTag>(this.tags);
                newTags.replaceAll(e -> {
                    if (o.equals(e)) {
                        return o;
                    }
                    return e;
                });
                return new StatusHistoryEntry(this.title, this.game, newTags, this.labels, this.lastActivity, this.timesUsed, this.favorite);
            }
        }
        return this;
    }

    public StatusHistoryEntry updateCategory(StreamCategory updatedCategory) {
        if (this.game == null || updatedCategory == null) {
            return this;
        }
        if (!this.game.hasId() && updatedCategory.nameMatches(this.game)) {
            return new StatusHistoryEntry(this.title, updatedCategory, this.tags, this.labels, this.lastActivity, this.timesUsed, this.favorite);
        }
        if (this.game.hasId() && updatedCategory.id.equals(this.game.id) && !updatedCategory.name.equals(this.game.name)) {
            return new StatusHistoryEntry(this.title, updatedCategory, this.tags, this.labels, this.lastActivity, this.timesUsed, this.favorite);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatusHistoryEntry other = (StatusHistoryEntry)obj;
        if (!Objects.equals(this.title, other.title)) {
            return false;
        }
        if (!Objects.equals(this.game, other.game)) {
            return false;
        }
        if (!Objects.equals(this.tags, other.tags)) {
            return false;
        }
        return Objects.equals(this.labels, other.labels);
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.title);
        hash = 59 * hash + Objects.hashCode(this.game);
        hash = 59 * hash + Objects.hashCode(this.tags);
        hash = 59 * hash + Objects.hashCode(this.labels);
        return hash;
    }

    public String toString() {
        return this.title + " " + this.game + " " + this.lastActivity + " " + this.timesUsed + " " + this.favorite + " " + this.tags + " " + this.labels;
    }
}

