/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.admin;

import chatty.gui.components.admin.StatusHistoryEntry;
import chatty.gui.components.settings.ListTableModel;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.StringUtil;
import chatty.util.api.StreamCategory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class StatusHistoryTable
extends JTable {
    private final Model data = new Model(new String[]{Language.getString("admin.presets.column.fav"), Language.getString("admin.presets.column.title"), Language.getString("admin.presets.column.game"), Language.getString("admin.presets.column.tags"), Language.getString("admin.presets.column.labels"), Language.getString("admin.presets.column.lastActivity"), Language.getString("admin.presets.column.usage")});
    private static final int FAV_COLUMN = 0;
    private static final int TITLE_COLUMN = 1;
    private static final int GAME_COLUMN = 2;
    private static final int TAGS_COLUMN = 3;
    private static final int LABELS_COLUMN = 4;
    private static final int ACTIVITY_COLUMN = 5;
    private static final int USAGE_COLUMN = 6;
    private final TableRowSorter sorter;
    private final JPopupMenu contextMenu;

    public StatusHistoryTable(JPopupMenu contextMenu) {
        this.setModel(this.data);
        this.getTableHeader().setReorderingAllowed(false);
        this.setFillsViewportHeight(true);
        this.sorter = new TableRowSorter<Model>(this.data);
        this.contextMenu = contextMenu;
        this.setRowSorter(this.sorter);
        TableColumn tc = this.getColumnModel().getColumn(1);
        tc.setCellRenderer(new LineWrapCellRenderer(true));
        TableColumn tc2 = this.getColumnModel().getColumn(3);
        tc2.setCellRenderer(new LineWrapCellRenderer(true));
        TableColumn tc3 = this.getColumnModel().getColumn(4);
        tc3.setCellRenderer(new LineWrapCellRenderer(true));
        this.setGridColor(new Color(200, 200, 200));
        this.getColumnModel().getColumn(5).setCellRenderer(new LastActivityRenderer());
        this.getColumnModel().getColumn(0).setCellRenderer(new FavoriteRenderer());
        this.setColumnWidth(0, 30, 30, 30);
        this.setColumnWidth(1, 200, 0, 0);
        this.setColumnWidth(2, 120, 0, 0);
        this.setColumnWidth(3, 140, 0, 0);
        this.setColumnWidth(4, 140, 0, 0);
        this.setColumnWidth(5, 100, 100, 100);
        this.setColumnWidth(6, 50, 50, 50);
        this.setSelectionMode(0);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(5, SortOrder.DESCENDING));
        this.sorter.setSortKeys(sortKeys);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = StatusHistoryTable.this.rowAtPoint(e.getPoint());
                if (row != -1) {
                    StatusHistoryTable.this.setRowSelected(row);
                } else if (StatusHistoryTable.this.getRowCount() > 0) {
                    StatusHistoryTable.this.setRowSelected(StatusHistoryTable.this.getRowCount() - 1);
                }
                StatusHistoryTable.this.popupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                StatusHistoryTable.this.popupMenu(e);
            }
        });
    }

    private void popupMenu(MouseEvent e) {
        if (e.isPopupTrigger() && this.contextMenu != null) {
            this.contextMenu.show(this, e.getX(), e.getY());
        }
    }

    private void setColumnWidth(int column, int width, int minwidth, int maxwidth) {
        TableColumn tc = this.getColumnModel().getColumn(column);
        tc.setPreferredWidth(width);
        if (maxwidth > 0) {
            tc.setMaxWidth(maxwidth);
        }
        if (minwidth > 0) {
            tc.setMinWidth(minwidth);
        }
    }

    public void resetFilter() {
        this.sorter.setRowFilter(null);
    }

    public void filter(final StreamCategory game, final boolean favorites) {
        if (game == null && !favorites) {
            this.resetFilter();
        } else {
            this.sorter.setRowFilter(new RowFilter<Model, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends Model, ? extends Integer> entry) {
                    Model model = entry.getModel();
                    StatusHistoryEntry e = (StatusHistoryEntry)model.get(entry.getIdentifier());
                    if (game != null && !game.equals(e.game)) {
                        return false;
                    }
                    return !favorites || e.favorite;
                }
            });
        }
    }

    public void setData(List<StatusHistoryEntry> newData) {
        this.data.setData(newData);
    }

    public StatusHistoryEntry getSelectedEntry() {
        int modelIndex = this.indexToModel(this.getSelectedRow());
        if (modelIndex == -1) {
            return null;
        }
        return (StatusHistoryEntry)this.data.get(modelIndex);
    }

    public void removeEntry(StatusHistoryEntry entry) {
        int indexToRemove = this.data.indexOf(entry);
        if (indexToRemove != -1) {
            int viewIndex = this.indexToView(indexToRemove);
            this.data.remove(indexToRemove);
            if (this.getRowCount() > viewIndex) {
                this.setRowSelected(viewIndex);
            } else if (viewIndex - 1 >= 0 && this.getRowCount() > viewIndex - 1) {
                this.setRowSelected(viewIndex - 1);
            }
        }
    }

    private void setRowSelected(int viewIndex) {
        this.getSelectionModel().setSelectionInterval(viewIndex, viewIndex);
        this.scrollToRow(viewIndex);
    }

    private void scrollToRow(int index) {
        if (index != -1) {
            this.scrollRectToVisible(this.getCellRect(index, 0, true));
        }
    }

    public void updateEntry(StatusHistoryEntry entry) {
        this.data.update(entry);
    }

    private int indexToModel(int index) {
        if (index == -1) {
            return -1;
        }
        return this.convertRowIndexToModel(index);
    }

    private int indexToView(int index) {
        return this.convertRowIndexToView(index);
    }

    private static class Model
    extends ListTableModel<StatusHistoryEntry> {
        Model(String[] columns) {
            super(columns);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            StatusHistoryEntry entry = (StatusHistoryEntry)this.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return entry.favorite;
                }
                case 1: {
                    return entry.title;
                }
                case 2: {
                    return entry.game.name;
                }
                case 3: {
                    return StringUtil.join(entry.tags, ", ");
                }
                case 4: {
                    return StringUtil.join(entry.labels, ", ");
                }
                case 5: {
                    return entry.lastActivity;
                }
                case 6: {
                    return entry.timesUsed;
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 5) {
                return Long.class;
            }
            if (columnIndex == 6) {
                return Integer.class;
            }
            return String.class;
        }
    }

    private static class LineWrapCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        LineWrapCellRenderer(boolean wordWrap) {
            this.setWrapStyleWord(wordWrap);
            this.setLineWrap(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            int cWidth = table.getTableHeader().getColumnModel().getColumn(column).getWidth();
            this.setSize(new Dimension(cWidth, 1000));
            int height = this.getPreferredSize().height;
            if (table.getRowHeight(row) < height) {
                table.setRowHeight(row, height);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }

    private static class LastActivityRenderer
    extends DefaultTableCellRenderer {
        private LastActivityRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                return;
            }
            Long lastActivity = (Long)value;
            this.setText(DateTime.agoText(lastActivity));
            LastActivityRenderer label = this;
            label.setHorizontalAlignment(0);
        }
    }

    private static class FavoriteRenderer
    extends DefaultTableCellRenderer {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/chatty/gui/star.png"));

        private FavoriteRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    this.setIcon(this.icon);
                } else {
                    this.setIcon(null);
                }
                FavoriteRenderer label = this;
                label.setHorizontalAlignment(0);
            }
        }
    }
}

