/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.admin;

import chatty.Helper;
import chatty.Room;
import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.admin.AdminDialog;
import chatty.gui.components.admin.SelectGameDialog;
import chatty.gui.components.admin.SelectLabelsDialog;
import chatty.gui.components.admin.SelectTagsDialog;
import chatty.gui.components.admin.StatusHistoryDialog;
import chatty.gui.components.admin.StatusHistoryEntry;
import chatty.gui.components.menus.CommandActionEvent;
import chatty.gui.components.menus.CommandMenuItems;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.TextSelectionMenu;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.StringUtil;
import chatty.util.api.ChannelStatus;
import chatty.util.api.ResultManager;
import chatty.util.api.StreamCategory;
import chatty.util.api.StreamLabels;
import chatty.util.api.TwitchApi;
import chatty.util.commands.Parameters;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StatusPanel
extends JPanel
implements Scrollable {
    private static final int PUT_RESULT_DELAY = 5000;
    private final JTextArea status = new JTextArea();
    private final JTextField game = new JTextField(20);
    private final JTextArea streamTags = new JTextArea();
    private final JTextArea streamLabels = new JTextArea();
    private final JButton update = new JButton(Language.getString("admin.button.update"));
    private final JLabel updated = new JLabel("No info loaded");
    private final JLabel putResult = new JLabel("...");
    private final JButton selectGame = new JButton(Language.getString("admin.button.selectGame"));
    private final JButton removeGame = new JButton(Language.getString("admin.button.removeGame"));
    private final JButton selectTags = new JButton(Language.getString("admin.button.selectTags"));
    private final JButton removeTags = new JButton(Language.getString("admin.button.removeTags"));
    private final JButton selectLabels = new JButton(Language.getString("admin.button.selectLabels"));
    private final JButton removeLabels = new JButton(Language.getString("admin.button.removeLabels"));
    private final JButton reloadButton = new JButton(Language.getString("admin.button.reload"));
    private final JButton historyButton = new JButton(Language.getString("admin.button.presets"));
    private final JButton addToHistoryButton = new JButton(Language.getString("admin.button.fav"));
    private final SelectGameDialog selectGameDialog;
    private final SelectTagsDialog selectTagsDialog;
    private final StatusHistoryDialog statusHistoryDialog;
    private final AdminDialog parent;
    private final MainGui main;
    private final TwitchApi api;
    private String currentChannel;
    private boolean statusEdited;
    private final List<ChannelStatus.StreamTag> currentStreamTags = new ArrayList<ChannelStatus.StreamTag>();
    private final List<StreamLabels.StreamLabel> currentStreamLabels = new ArrayList<StreamLabels.StreamLabel>();
    private StreamCategory currentStreamCategory = StreamCategory.EMPTY;
    private long infoLastLoaded;
    private final Map<String, CacheItem> cache = new HashMap<String, CacheItem>();
    private boolean loading;
    private boolean loadingStatus;
    private String statusLoadError;
    private String statusPutResult;
    private long lastPutResult = -1L;
    private ChannelStatus channelStatusToCheck;
    private boolean updateStatusAfterLoad = false;

    public StatusPanel(AdminDialog parent, final MainGui main, TwitchApi api) {
        this.parent = parent;
        this.main = main;
        this.api = api;
        this.selectGameDialog = new SelectGameDialog(main, api);
        this.selectTagsDialog = new SelectTagsDialog(main, api);
        this.statusHistoryDialog = new StatusHistoryDialog((Dialog)parent, main.getStatusHistory());
        this.setLayout(new GridBagLayout());
        JPanel presetPanel = new JPanel();
        presetPanel.setLayout(new GridBagLayout());
        this.historyButton.setMargin(AdminDialog.SMALL_BUTTON_INSETS);
        this.historyButton.setToolTipText("Open status presets containing favorites and status history");
        this.historyButton.setMnemonic(80);
        GridBagConstraints gbc = AdminDialog.makeGbc(2, 0, 1, 1);
        gbc.insets = new Insets(5, 5, 5, -1);
        gbc.anchor = 13;
        presetPanel.add((Component)this.historyButton, gbc);
        this.addToHistoryButton.setMargin(AdminDialog.SMALL_BUTTON_INSETS);
        this.addToHistoryButton.setToolTipText("Add current status to favorites");
        this.addToHistoryButton.setMnemonic(70);
        gbc = AdminDialog.makeGbc(3, 0, 1, 1);
        gbc.insets = new Insets(5, 0, 5, 5);
        gbc.anchor = 13;
        presetPanel.add((Component)this.addToHistoryButton, gbc);
        this.updated.setHorizontalAlignment(0);
        gbc = AdminDialog.makeGbc(1, 0, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(5, 10, 5, 5);
        presetPanel.add((Component)this.updated, gbc);
        this.reloadButton.setMargin(AdminDialog.SMALL_BUTTON_INSETS);
        this.reloadButton.setIcon(new ImageIcon(AdminDialog.class.getResource("view-refresh.png")));
        this.reloadButton.setMnemonic(82);
        gbc = AdminDialog.makeGbc(0, 0, 1, 1);
        gbc.anchor = 13;
        presetPanel.add((Component)this.reloadButton, gbc);
        gbc = AdminDialog.makeGbc(0, 1, 3, 1);
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)presetPanel, gbc);
        this.status.setLineWrap(true);
        this.status.setWrapStyleWord(true);
        this.status.setBorder(BorderFactory.createCompoundBorder(this.game.getBorder(), BorderFactory.createEmptyBorder(2, 3, 3, 2)));
        this.status.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                StatusPanel.this.statusEdited();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                StatusPanel.this.statusEdited();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                StatusPanel.this.statusEdited();
            }
        });
        GuiUtil.resetFocusTraversalKeys(this.status);
        this.status.getAccessibleContext().setAccessibleName(Language.getString("admin.input.title"));
        GuiUtil.installLengthLimitDocumentFilter(this.status, 500, false, new Object[0]);
        gbc = AdminDialog.makeGbc(0, 2, 3, 1);
        gbc.fill = 2;
        this.add((Component)this.status, gbc);
        this.game.getAccessibleContext().setAccessibleName(Language.getString("admin.input.game"));
        this.game.setEditable(false);
        gbc = AdminDialog.makeGbc(0, 3, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.game, gbc);
        this.selectGame.setMargin(AdminDialog.SMALL_BUTTON_INSETS);
        this.selectGame.setMnemonic(71);
        gbc = AdminDialog.makeGbc(1, 3, 1, 1);
        gbc.fill = 2;
        this.add((Component)this.selectGame, gbc);
        this.removeGame.setMargin(AdminDialog.SMALL_BUTTON_INSETS);
        this.removeGame.getAccessibleContext().setAccessibleName(Language.getString("admin.button.removeGame2"));
        gbc = AdminDialog.makeGbc(2, 3, 1, 1);
        gbc.fill = 2;
        this.add((Component)this.removeGame, gbc);
        this.streamTags.getAccessibleContext().setAccessibleName(Language.getString("admin.input.tags"));
        this.streamTags.setEditable(false);
        this.streamTags.setBackground(this.game.getBackground());
        this.streamTags.setBorder(this.game.getBorder());
        this.streamTags.setLineWrap(true);
        this.streamTags.setWrapStyleWord(true);
        gbc = AdminDialog.makeGbc(0, 4, 1, 1);
        gbc.fill = 2;
        this.add((Component)this.streamTags, gbc);
        this.selectTags.setMargin(AdminDialog.SMALL_BUTTON_INSETS);
        gbc = AdminDialog.makeGbc(1, 4, 1, 1);
        gbc.anchor = 11;
        gbc.fill = 2;
        this.add((Component)this.selectTags, gbc);
        this.removeTags.setMargin(AdminDialog.SMALL_BUTTON_INSETS);
        this.removeTags.getAccessibleContext().setAccessibleName(Language.getString("admin.button.removeTags2"));
        gbc = AdminDialog.makeGbc(2, 4, 1, 1);
        gbc.anchor = 11;
        gbc.fill = 2;
        this.add((Component)this.removeTags, gbc);
        this.streamLabels.getAccessibleContext().setAccessibleName(Language.getString("admin.input.labels"));
        this.streamLabels.setEditable(false);
        this.streamLabels.setBackground(this.game.getBackground());
        this.streamLabels.setBorder(this.game.getBorder());
        this.streamLabels.setLineWrap(true);
        this.streamLabels.setWrapStyleWord(true);
        gbc = AdminDialog.makeGbc(0, 5, 1, 1);
        gbc.fill = 2;
        this.add((Component)this.streamLabels, gbc);
        this.selectLabels.setMargin(AdminDialog.SMALL_BUTTON_INSETS);
        gbc = AdminDialog.makeGbc(1, 5, 1, 1);
        gbc.anchor = 11;
        gbc.fill = 2;
        this.add((Component)this.selectLabels, gbc);
        this.removeLabels.setMargin(AdminDialog.SMALL_BUTTON_INSETS);
        this.removeLabels.getAccessibleContext().setAccessibleName(Language.getString("admin.button.removeLabels2"));
        gbc = AdminDialog.makeGbc(2, 5, 1, 1);
        gbc.anchor = 11;
        gbc.fill = 2;
        this.add((Component)this.removeLabels, gbc);
        gbc = AdminDialog.makeGbc(0, 6, 3, 1);
        gbc.fill = 2;
        this.update.setMnemonic(85);
        this.update.setToolTipText(Language.getString("admin.button.update.tip"));
        this.add((Component)this.update, gbc);
        gbc = AdminDialog.makeGbc(0, 7, 3, 1);
        this.add((Component)this.putResult, gbc);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == StatusPanel.this.update) {
                    if (StatusPanel.this.currentChannel != null && !StatusPanel.this.currentChannel.isEmpty()) {
                        StatusPanel.this.loadingStatus = true;
                        StatusPanel.this.setLoading(true);
                        ChannelStatus putStatus = ChannelStatus.createPut(StatusPanel.this.currentChannel, StatusPanel.this.status.getText(), StatusPanel.this.currentStreamCategory, StatusPanel.this.currentStreamTags, StatusPanel.this.currentStreamLabels);
                        StatusPanel.this.channelStatusToCheck = putStatus;
                        main.putChannelInfo(putStatus);
                        StatusPanel.this.addCurrentToHistory();
                    }
                } else if (e.getSource() == StatusPanel.this.reloadButton) {
                    StatusPanel.this.getChannelInfo();
                } else if (e.getSource() == StatusPanel.this.selectGame) {
                    StatusPanel.this.selectGameDialog.setLocationRelativeTo(StatusPanel.this);
                    StreamCategory result = StatusPanel.this.selectGameDialog.open(StatusPanel.this.currentStreamCategory);
                    if (result != null) {
                        StatusPanel.this.currentStreamCategory = result;
                        StatusPanel.this.game.setText(result.name);
                        StatusPanel.this.statusEdited();
                    }
                } else if (e.getSource() == StatusPanel.this.removeGame) {
                    StatusPanel.this.currentStreamCategory = StreamCategory.EMPTY;
                    StatusPanel.this.game.setText("");
                    StatusPanel.this.statusEdited();
                } else if (e.getSource() == StatusPanel.this.selectTags) {
                    StatusPanel.this.selectTagsDialog.setLocationRelativeTo(StatusPanel.this);
                    List<ChannelStatus.StreamTag> result = StatusPanel.this.selectTagsDialog.open(StatusPanel.this.currentStreamTags);
                    if (result != null) {
                        StatusPanel.this.setTags(result);
                        StatusPanel.this.statusEdited();
                    }
                } else if (e.getSource() == StatusPanel.this.removeTags) {
                    StatusPanel.this.setTags(null);
                    StatusPanel.this.statusEdited();
                } else if (e.getSource() == StatusPanel.this.selectLabels) {
                    SelectLabelsDialog dialog = new SelectLabelsDialog(main);
                    dialog.setLocationRelativeTo(StatusPanel.this);
                    List<StreamLabels.StreamLabel> result = dialog.open(StatusPanel.this.currentStreamLabels);
                    if (result != null) {
                        StatusPanel.this.setLabels(result);
                        StatusPanel.this.statusEdited();
                    }
                } else if (e.getSource() == StatusPanel.this.removeLabels) {
                    StatusPanel.this.setLabels(StreamLabels.copyAutoLabelsOnly(StatusPanel.this.currentStreamLabels));
                } else if (e.getSource() == StatusPanel.this.historyButton) {
                    StatusPanel.this.statusHistoryDialog.setLocationRelativeTo(StatusPanel.this);
                    StatusHistoryEntry result = StatusPanel.this.statusHistoryDialog.showDialog(StatusPanel.this.currentStreamCategory);
                    if (result != null) {
                        if (result.title != null) {
                            StatusPanel.this.status.setText(result.title);
                        }
                        if (result.game != null) {
                            StatusPanel.this.currentStreamCategory = result.game;
                            StatusPanel.this.game.setText(result.game.name);
                        }
                        if (result.tags != null) {
                            StatusPanel.this.setTags(result.tags);
                        }
                        if (result.labels != null) {
                            StatusPanel.this.setLabels(result.labels);
                        }
                    }
                } else if (e.getSource() == StatusPanel.this.addToHistoryButton) {
                    StatusPanel.this.addCurrentToFavorites();
                }
            }
        };
        this.reloadButton.addActionListener(actionListener);
        this.selectGame.addActionListener(actionListener);
        this.removeGame.addActionListener(actionListener);
        this.selectTags.addActionListener(actionListener);
        this.removeTags.addActionListener(actionListener);
        this.selectLabels.addActionListener(actionListener);
        this.removeLabels.addActionListener(actionListener);
        this.historyButton.addActionListener(actionListener);
        this.addToHistoryButton.addActionListener(actionListener);
        this.update.addActionListener(actionListener);
        this.addContextMenu(this);
        this.addContextMenu(this.update);
        this.addContextMenu(this.game);
        this.addContextMenu(this.streamTags);
        TextSelectionMenu.install(this.status);
        api.subscribe(ResultManager.Type.CATEGORY_RESULT, categories -> SwingUtilities.invokeLater(() -> {
            if (categories != null) {
                for (StreamCategory category : categories) {
                    main.getStatusHistory().updateCategory(category);
                }
                if (!this.currentStreamCategory.hasId()) {
                    for (StreamCategory category : categories) {
                        if (!this.currentStreamCategory.nameMatches(category)) continue;
                        this.currentStreamCategory = category;
                    }
                }
            }
        }));
    }

    private void addContextMenu(JComponent comp) {
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.openContextMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.openContextMenu(e);
            }

            private void openContextMenu(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    final Parameters params = Parameters.create("");
                    params.put("title", StatusPanel.this.status.getText());
                    params.put("game", StatusPanel.this.game.getText());
                    params.put("tag-ids", StringUtil.join(StatusPanel.this.currentStreamTags, ",", o -> ((ChannelStatus.StreamTag)o).getName()));
                    params.put("tag-names", StringUtil.join(StatusPanel.this.currentStreamTags, ",", o -> ((ChannelStatus.StreamTag)o).getDisplayName()));
                    final Room room = Room.createRegular(Helper.toChannel(StatusPanel.this.currentChannel));
                    ContextMenu m = new ContextMenu(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (e instanceof CommandActionEvent) {
                                CommandActionEvent c = (CommandActionEvent)e;
                                StatusPanel.this.main.anonCustomCommand(room, c.getCommand(), params);
                                StatusPanel.this.addCurrentToHistory();
                            }
                            ((StatusPanel)StatusPanel.this).parent.helper.menuAction(e);
                        }
                    };
                    CommandMenuItems.addCommands(CommandMenuItems.MenuType.ADMIN, m, params);
                    m.addSeparator();
                    ((StatusPanel)StatusPanel.this).parent.helper.addToContextMenu(m);
                    m.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                }
            }
        });
    }

    public void changeChannel(String channel) {
        if (channel.equals(this.currentChannel)) {
            return;
        }
        this.saveToCache();
        this.currentChannel = channel;
        if (this.loadFromCache()) {
            this.setLoading(false);
        } else {
            this.status.setText("");
            this.game.setText("");
            this.setTags(null);
            this.setLabels(null);
            this.getChannelInfo();
        }
        this.setPutResult("");
    }

    private void setTags(Collection<ChannelStatus.StreamTag> tags) {
        this.currentStreamTags.clear();
        if (tags == null) {
            this.streamTags.setText(null);
        } else {
            for (ChannelStatus.StreamTag t : tags) {
                if (t == null || !t.isValid()) continue;
                this.currentStreamTags.add(t);
            }
            this.streamTags.setText(StringUtil.join(this.currentStreamTags, ", "));
        }
    }

    private void setLabels(Collection<StreamLabels.StreamLabel> labels) {
        this.currentStreamLabels.clear();
        if (labels == null) {
            this.streamLabels.setText(null);
        } else {
            this.currentStreamLabels.addAll(labels);
            StringBuilder b = new StringBuilder();
            for (StreamLabels.StreamLabel label : labels) {
                if (b.length() != 0) {
                    b.append(", ");
                }
                b.append(label.getId());
                if (label.isEditable()) continue;
                b.append(" (auto)");
            }
            this.streamLabels.setText(b.toString());
        }
    }

    public void channelStatusReceived(ChannelStatus channelStatus, TwitchApi.RequestResultCode result) {
        if (channelStatus.channelLogin.equals(this.currentChannel)) {
            if (this.channelStatusToCheck != null && this.channelStatusToCheck.channelLogin.equals(this.currentChannel)) {
                String difference = this.channelStatusToCheck.getStatusDifference(channelStatus);
                if (!difference.isEmpty()) {
                    JOptionPane.showMessageDialog(this, String.format("Stream Status may not have been updated, possibly due to an invalid title (e.g. swear words) or tags (setting no tags at all may not work). You can use the reload button to load the current Status, overwriting what you changed.\n\nNot updated: %s\n\n[Current Status]\nTitle: '%s'\nCategory: '%s'\nTags: %s\nLabels: %s", difference, channelStatus.title, channelStatus.category, channelStatus.tags, channelStatus.labels), "Update failed", 2);
                } else {
                    this.setLabels(channelStatus.labels);
                }
            }
            this.channelStatusToCheck = null;
            if (result == TwitchApi.RequestResultCode.SUCCESS) {
                if (this.updateStatusAfterLoad) {
                    this.status.setText(channelStatus.title);
                    this.currentStreamCategory = channelStatus.category;
                    this.game.setText(channelStatus.category.name);
                    this.setTags(channelStatus.tags);
                    this.setLabels(channelStatus.labels);
                }
            } else {
                this.infoLastLoaded = -1L;
                this.statusLoadError = result == TwitchApi.RequestResultCode.NOT_FOUND ? "Channel not found" : "";
            }
            this.updateStatusAfterLoad = false;
            this.loadingStatus = false;
            this.checkLoadingDone();
        }
    }

    public void setPutResult(TwitchApi.RequestResultCode result, String error) {
        if (result == TwitchApi.RequestResultCode.SUCCESS) {
            this.statusPutResult = Language.getString("admin.infoUpdated");
            this.checkChannelStatus();
        } else {
            if (result == TwitchApi.RequestResultCode.ACCESS_DENIED) {
                this.statusPutResult = "Update: Access denied/Failed";
                int over = this.status.getText().length() - 140;
                if (over > 0) {
                    this.statusPutResult = "Update: Failed (Title " + over + " characters too long?)";
                }
                this.updated.setText("Error: Access denied");
            } else if (result == TwitchApi.RequestResultCode.FAILED) {
                String errorText = "Error: Unknown error";
                if (!StringUtil.isNullOrEmpty(error)) {
                    errorText = "Error: " + error;
                }
                this.statusPutResult = errorText;
                this.updated.setText(errorText);
            } else if (result == TwitchApi.RequestResultCode.NOT_FOUND) {
                this.statusPutResult = "Update: Channel not found.";
                this.updated.setText("Error: Channel not found.");
            } else if (result == TwitchApi.RequestResultCode.INVALID_STREAM_STATUS) {
                this.statusPutResult = "Update: Invalid title/game (possibly bad language)";
                this.updated.setText("Error: Invalid title/game");
            }
            this.channelStatusToCheck = null;
        }
        this.lastPutResult = System.currentTimeMillis();
        this.loadingStatus = false;
        this.checkLoadingDone();
    }

    protected void setPutResult(String result) {
        AdminDialog.hideableLabel(this.putResult, result);
    }

    protected void dialogOpened() {
        this.setPutResult("");
    }

    private void getChannelInfo() {
        this.loadingStatus = true;
        this.statusLoadError = null;
        this.updateStatusAfterLoad = true;
        this.setLoading(true);
        this.api.getChannelStatus(this.currentChannel);
    }

    private void checkChannelStatus() {
        if (this.channelStatusToCheck != null) {
            this.api.getChannelStatus(this.currentChannel);
        }
    }

    private void checkLoadingDone() {
        if (!this.loadingStatus) {
            this.statusEdited = false;
            this.updated.setText(Language.getString("admin.infoLoaded.now"));
            if (this.statusPutResult != null) {
                this.setPutResult(this.statusPutResult);
                this.statusPutResult = null;
            }
            if (this.statusLoadError != null) {
                this.infoLastLoaded = -1L;
                String error = StatusPanel.getError(this.statusLoadError);
                if (error.isEmpty()) {
                    error = "Unkonwn Error";
                }
                this.updated.setText("Loading failed: " + error);
                this.statusLoadError = null;
            } else {
                this.infoLastLoaded = System.currentTimeMillis();
            }
            this.setLoading(false);
        }
    }

    private static String getError(String message) {
        if (message != null && !message.isEmpty()) {
            return message;
        }
        return "";
    }

    private void setLoading(boolean loading) {
        if (loading) {
            this.updated.setText(Language.getString("admin.loading"));
            this.lastPutResult = -1L;
        }
        this.update.setEnabled(!loading);
        this.selectGame.setEnabled(!loading);
        this.removeGame.setEnabled(!loading);
        this.selectTags.setEnabled(!loading);
        this.removeTags.setEnabled(!loading);
        this.selectLabels.setEnabled(!loading);
        this.removeLabels.setEnabled(!loading);
        this.reloadButton.setEnabled(!loading);
        this.historyButton.setEnabled(!loading);
        this.addToHistoryButton.setEnabled(!loading);
        this.loading = loading;
    }

    public void update() {
        long ago;
        if (!this.loading && this.infoLastLoaded > 0L) {
            long timePassed = System.currentTimeMillis() - this.infoLastLoaded;
            if (this.statusEdited) {
                this.updated.setText(Language.getString("admin.infoLoaded.edited", DateTime.duration(timePassed, 1, 0, new DateTime.Formatting[0])));
            } else {
                this.updated.setText(Language.getString("admin.infoLoaded", DateTime.duration(timePassed, 1, 0, new DateTime.Formatting[0])));
            }
        }
        if (this.loading && this.lastPutResult > 0L && (ago = System.currentTimeMillis() - this.lastPutResult) > 5000L) {
            this.setLoading(false);
        }
    }

    private void statusEdited() {
        this.statusEdited = true;
    }

    public String getStatusHistorySorting() {
        return this.statusHistoryDialog.getSortOrder();
    }

    public void setStatusHistorySorting(String order) {
        this.statusHistoryDialog.setSortOrder(order);
    }

    private void addCurrentToHistory() {
        String currentTitle = this.status.getText().trim();
        if (this.main.getSaveStatusHistorySetting() || this.main.getStatusHistory().isFavorite(currentTitle, this.currentStreamCategory, this.currentStreamTags, this.currentStreamLabels)) {
            this.main.getStatusHistory().addUsed(currentTitle, this.currentStreamCategory, this.currentStreamTags, StreamLabels.copyEditableLabelsOnly(this.currentStreamLabels));
        }
    }

    private void addCurrentToFavorites() {
        this.main.getStatusHistory().addFavorite(this.status.getText().trim(), this.currentStreamCategory, this.currentStreamTags, StreamLabels.copyEditableLabelsOnly(this.currentStreamLabels));
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private void saveToCache() {
        if (!this.loading && !StringUtil.isNullOrEmpty(this.currentChannel)) {
            this.cache.put(this.currentChannel, new CacheItem(this.currentChannel, this.status.getText(), this.currentStreamCategory, this.currentStreamTags, this.currentStreamLabels, this.statusEdited, this.infoLastLoaded));
        }
    }

    private boolean loadFromCache() {
        CacheItem item;
        if (!StringUtil.isNullOrEmpty(this.currentChannel) && (item = this.cache.get(this.currentChannel)) != null) {
            this.status.setText(item.title);
            this.currentStreamCategory = item.category;
            this.game.setText(item.category.name);
            this.setTags(item.tags);
            this.setLabels(item.labels);
            this.statusEdited = item.statusEdited;
            this.infoLastLoaded = item.lastLoaded;
            return true;
        }
        return false;
    }

    private static class CacheItem {
        public final String channel;
        public final String title;
        public final StreamCategory category;
        public final List<ChannelStatus.StreamTag> tags;
        public final List<StreamLabels.StreamLabel> labels;
        public final boolean statusEdited;
        public final long lastLoaded;

        public CacheItem(String channel, String title, StreamCategory category, List<ChannelStatus.StreamTag> tags, List<StreamLabels.StreamLabel> labels, boolean statusEdited, long lastLoaded) {
            this.channel = channel;
            this.title = title;
            this.category = category;
            this.tags = new ArrayList<ChannelStatus.StreamTag>(tags);
            this.labels = new ArrayList<StreamLabels.StreamLabel>(labels);
            this.statusEdited = statusEdited;
            this.lastLoaded = lastLoaded;
        }
    }
}

