/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.completion;

import chatty.gui.components.completion.AutoCompletionServer;
import chatty.gui.components.completion.AutoCompletionWindow;
import chatty.util.Debugging;
import chatty.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public class AutoCompletion {
    private static final Logger LOGGER = Logger.getLogger(AutoCompletion.class.getName());
    private static final Pattern WORD = Pattern.compile("[^\\s,.:;\\-@#~!\"'$\u00a7%&\\/]+");
    private final JTextComponent textField;
    private final AutoCompletionWindow w;
    private final CaretListener caretListener;
    private AutoCompletionServer server;
    private boolean isEnabled = true;
    private boolean showPopup = true;
    private boolean completeToCommonPrefix = true;
    private boolean appendSpace = false;
    private boolean inCompletion = false;
    private String autoSetText;
    private String prevText;
    private int startPos;
    private int endPos;
    private int initialStartPos;
    private String prefix;
    private String word;
    private String type;
    private AutoCompletionServer.CompletionItems results;
    private String resultsWord;
    private String resultsPrefix;
    private int resultIndex = -1;
    private boolean prefixRemoved;
    private String commonPrefix;
    private boolean firstResult;
    private int preCaretPos;
    private String preText;

    public AutoCompletion(JTextComponent textField) {
        this.textField = textField;
        this.w = new AutoCompletionWindow(textField, (clickedIndex, e) -> {
            if (e.isShiftDown()) {
                if (this.resultIndex != -1) {
                    this.startPos = textField.getCaretPosition();
                }
                this.insertWord((int)clickedIndex, this.appendSpace, true);
                ++this.startPos;
            } else {
                this.insertWord((int)clickedIndex, this.appendSpace, false);
                if (!SwingUtilities.isMiddleMouseButton(e)) {
                    this.end();
                }
            }
            this.resultIndex = clickedIndex;
            this.updatePopup(false);
        });
        this.caretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoCompletion.this.updateState();
                    }
                });
            }
        };
        textField.addCaretListener(this.caretListener);
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void setShowPopup(boolean show) {
        this.showPopup = show;
    }

    public void setFont(Font font) {
        this.w.setFont(font);
    }

    public void setForegroundColor(Color color) {
        this.w.setForegroundColor(color);
    }

    public void setBackgroundColor(Color color) {
        this.w.setBackgroundColor(color);
    }

    public void setHighlightColor(Color color) {
        this.w.setHighlightColor(color);
    }

    public void setMaxResultsShown(int max) {
        this.w.setMaxResultsShown(max);
    }

    public void setCellSize(int width, int height) {
        this.w.setCellSize(width, height);
    }

    public void setAppendSpace(boolean append) {
        this.appendSpace = append;
    }

    public void setCompleteToCommonPrefix(boolean common) {
        this.completeToCommonPrefix = common;
    }

    public boolean getCompleteToCommonPrefix() {
        return this.completeToCommonPrefix;
    }

    public void setCompletionServer(AutoCompletionServer server) {
        this.server = server;
    }

    public boolean inCompletion() {
        return this.inCompletion;
    }

    public void cleanUp() {
        this.textField.removeCaretListener(this.caretListener);
        this.w.cleanUp();
    }

    private void updateState() {
        this.w.updateHelp(this.resultIndex);
        String text = this.textField.getText();
        int caretPos = this.textField.getCaretPosition();
        Debugging.println("completion", "[Update] %d %s", caretPos, text);
        if (text.equals(this.autoSetText) && caretPos == this.endPos) {
            return;
        }
        boolean movedAfter = text.equals(this.autoSetText) && caretPos != this.endPos;
        this.autoSetText = null;
        this.startPos = -1;
        this.endPos = -1;
        this.word = "";
        this.prefix = "";
        Matcher m = WORD.matcher(text);
        while (m.find()) {
            if (m.start() >= caretPos || m.end() < caretPos) continue;
            this.startPos = m.start();
            this.endPos = m.end();
            this.word = m.group();
            this.prefix = text.substring(0, this.startPos);
        }
        Debugging.println("completion", "[Updated] Prefix: '%s' Word: '%s' Caret: %d", this.prefix, this.word, caretPos);
        if (this.startPos == -1 || this.endPos == -1 || movedAfter) {
            this.end();
        } else {
            if (this.resultIndex != -1 || this.startPos != this.initialStartPos) {
                this.end();
            }
            this.checkAutostart();
            this.updateSearch();
        }
        this.prevText = text;
    }

    private void checkAutostart() {
        if (!this.inCompletion && this.showPopup && this.endPos == this.textField.getCaretPosition() && !this.textField.getText().equals(this.prevText) && this.server.isAutostartPrefix(this.prefix)) {
            Debugging.println("completion", "AUTOSTART", new Object[0]);
            this.start("auto");
        }
    }

    public void manual(int step, String type) {
        Debugging.println("completion", "[Manual] Step: %d Type: %s InCompletion: %s", step, type, this.inCompletion);
        if (this.inCompletion) {
            this.complete(step);
        } else {
            this.start(type);
            if (step != 0) {
                this.complete(step);
            }
        }
    }

    private void start(String type) {
        if (!this.isEnabled) {
            return;
        }
        if (this.word == null || this.word.isEmpty()) {
            return;
        }
        Debugging.println("completion", "START", new Object[0]);
        this.type = type;
        this.inCompletion = true;
        this.prefixRemoved = false;
        this.resultsWord = null;
        this.resultsPrefix = null;
        this.initialStartPos = this.startPos;
        this.firstResult = true;
        this.updateSearch();
    }

    private void end() {
        Debugging.println("completion", "END", new Object[0]);
        this.inCompletion = false;
        this.w.close();
        this.autoSetText = null;
    }

    private void updateSearch() {
        if (!this.inCompletion) {
            return;
        }
        if (this.word.isEmpty()) {
            return;
        }
        if (this.word.equals(this.resultsWord) && this.prefix.equals(this.resultsPrefix)) {
            return;
        }
        this.results = this.server.getCompletionItems(this.type, this.prefix, this.word);
        if (this.results.isEmpty() && this.firstResult) {
            this.end();
        }
        if (this.completeToCommonPrefix && this.results.items.size() > 1 && this.showPopup) {
            this.commonPrefix = AutoCompletion.findPrefixCommonToAll(this.results.items);
            if (this.commonPrefix.length() - this.word.length() == 0 && this.w.isShowing()) {
                this.commonPrefix = "";
            }
        } else {
            this.commonPrefix = "";
        }
        this.resultsWord = this.word;
        this.resultsPrefix = this.prefix;
        this.resultIndex = -1;
        this.firstResult = false;
        this.showPopup();
    }

    private void showPopup() {
        if (this.showPopup && !this.results.items.isEmpty()) {
            this.w.init(this.results, this.commonPrefix, this.startPos);
            this.w.show(-1, true);
        } else {
            this.w.close();
        }
    }

    private void updatePopup(boolean scroll) {
        if (this.showPopup && this.inCompletion) {
            this.w.show(this.resultIndex, scroll);
        } else {
            this.w.close();
        }
    }

    private void complete(int step) {
        if (!this.inCompletion || this.results == null || this.results.items.isEmpty() || step == 0) {
            return;
        }
        if (this.resultIndex == -1) {
            this.preText = this.textField.getText();
            this.preCaretPos = this.textField.getCaretPosition();
        }
        if (this.resultIndex == -1 && !this.commonPrefix.isEmpty()) {
            this.insertWord(this.commonPrefix, false, false);
            this.commonPrefix = "";
        } else {
            this.resultIndex += step;
            if (this.resultIndex >= this.results.items.size()) {
                this.resultIndex = 0;
            } else if (this.resultIndex < 0) {
                this.resultIndex = this.results.items.size() - 1;
            }
            if (this.resultIndex >= this.results.items.size()) {
                return;
            }
            if (this.resultIndex < 0) {
                this.resultIndex = 0;
            }
            this.updatePopup(true);
            this.insertWord(this.resultIndex, this.appendSpace, false);
        }
    }

    private void insertWord(int index, boolean appendSpace, boolean ensureSpace) {
        if (this.results.items.size() <= index) {
            return;
        }
        String item = this.results.items.get(index).getCode();
        this.insertWord(item, appendSpace, ensureSpace);
    }

    private void insertWord(String item, boolean appendSpace, boolean ensureSpace) {
        try {
            int newEnd;
            this.removePrefix();
            if (appendSpace) {
                item = item + " ";
            }
            String text = this.textField.getText();
            if (ensureSpace && this.startPos > 0 && text.charAt(this.startPos - 1) != ' ') {
                item = " " + item;
            }
            String newText = text.substring(0, this.startPos) + item + text.substring(this.endPos);
            this.textField.setText(newText);
            this.autoSetText = newText;
            this.endPos = newEnd = this.startPos + item.length();
            this.textField.setCaretPosition(newEnd);
        }
        catch (Exception ex) {
            LOGGER.warning("Exception in insertWord: " + ex);
        }
    }

    private void removePrefix() {
        if (this.results.prefixToRemove == null || this.results.prefixToRemove.isEmpty()) {
            return;
        }
        if (this.prefix.endsWith(this.results.prefixToRemove) && !this.prefixRemoved) {
            this.startPos -= this.results.prefixToRemove.length();
            this.prefixRemoved = true;
        }
    }

    public void cancel() {
        if (this.inCompletion && this.resultIndex > -1) {
            this.resultIndex = -1;
            this.prefixRemoved = false;
            this.updatePopup(true);
            this.textField.setText(this.preText);
            this.textField.setCaretPosition(this.preCaretPos);
        }
    }

    private static String findPrefixCommonToAll(List<AutoCompletionServer.CompletionItem> input) {
        String result = null;
        for (AutoCompletionServer.CompletionItem item : input) {
            if (result == null) {
                result = item.getCode();
                continue;
            }
            if (StringUtil.toLowerCase(item.getCode()).startsWith(StringUtil.toLowerCase(result)) || !(result = AutoCompletion.findCommonPrefix(item.getCode(), result)).isEmpty()) continue;
            return result;
        }
        return result;
    }

    private static String findCommonPrefix(String a, String b) {
        int minLength = Math.min(a.length(), b.length());
        for (int i = 0; i < minLength; ++i) {
            if (StringUtil.toLowerCase(a).charAt(i) == StringUtil.toLowerCase(b).charAt(i)) continue;
            return a.substring(0, i);
        }
        return a.substring(0, minLength);
    }
}

