/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.completion;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public interface AutoCompletionServer {
    public CompletionItems getCompletionItems(String var1, String var2, String var3);

    public boolean isAutostartPrefix(String var1);

    public static class CompletionItem
    implements Comparable<CompletionItem> {
        private final String code;
        private final String info;

        public CompletionItem(String code, String info) {
            this.code = code;
            this.info = info;
        }

        public String getCode() {
            return this.code;
        }

        public String getInfo() {
            return this.info;
        }

        public boolean hasInfo() {
            return this.info != null && !this.info.isEmpty();
        }

        public ImageIcon getImage(Component c) {
            return null;
        }

        public String toString() {
            return this.code;
        }

        @Override
        public int compareTo(CompletionItem o) {
            return this.code.compareToIgnoreCase(o.code);
        }
    }

    public static class CompletionItems {
        public final List<CompletionItem> items;
        public final String prefixToRemove;

        public CompletionItems(List<CompletionItem> items, String prefixToRemove) {
            this.items = items;
            this.prefixToRemove = prefixToRemove;
        }

        public static CompletionItems createFromStrings(List<String> items, String prefixToRemove) {
            return CompletionItems.createFromStrings(items, prefixToRemove, null);
        }

        public static CompletionItems createFromStrings(List<String> items, String prefixToRemove, Map<String, String> info) {
            ArrayList<CompletionItem> result = new ArrayList<CompletionItem>();
            for (String item : items) {
                result.add(new CompletionItem(item, info != null ? info.get(item) : null));
            }
            return new CompletionItems(result, prefixToRemove);
        }

        public CompletionItems() {
            this.items = new ArrayList<CompletionItem>();
            this.prefixToRemove = "";
        }

        public void append(CompletionItems other) {
            this.items.addAll(other.items);
        }

        public boolean isEmpty() {
            return this.items == null || this.items.isEmpty();
        }
    }
}

