/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.completion;

import chatty.Helper;
import chatty.gui.components.completion.AutoCompletionServer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class AutoCompletionWindow {
    private boolean show;
    private int maxResultsShown = 5;
    private Color foregroundColor = Color.BLACK;
    private Color backgroundColor = new Color(230, 230, 230);
    private final ComponentListener componentListener;
    private final FocusListener focusListener;
    private Window containingWindow;
    private JWindow infoWindow;
    private JList<AutoCompletionServer.CompletionItem> list;
    private final MyListModel<AutoCompletionServer.CompletionItem> listData = new MyListModel();
    private final JLabel countLabel = new JLabel();
    private final JLabel helpLabel = new JLabel();
    private JScrollPane infoScroll;
    private final MyRenderer listRenderer = new MyRenderer();
    private int startPos;
    private final JTextComponent textField;
    private final BiConsumer<Integer, MouseEvent> clickListener;
    private int cellHeight = 40;
    private int cellWidth = 300;

    public AutoCompletionWindow(JTextComponent textField, BiConsumer<Integer, MouseEvent> clickListener) {
        this.clickListener = clickListener;
        this.textField = textField;
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                AutoCompletionWindow.this.reshow();
            }

            @Override
            public void focusLost(FocusEvent e) {
                AutoCompletionWindow.this.hide();
            }
        };
        textField.addFocusListener(this.focusListener);
        this.componentListener = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                AutoCompletionWindow.this.reposition();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                AutoCompletionWindow.this.infoWindow.setVisible(false);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                AutoCompletionWindow.this.infoWindow.setVisible(false);
            }
        };
    }

    public void setFont(Font font) {
        this.listRenderer.setFont(font);
        this.countLabel.setFont(font);
        this.helpLabel.setFont(font.deriveFont((float)((double)font.getSize() * 0.8)));
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
        this.listRenderer.setForeground(color);
        this.countLabel.setForeground(color);
        this.helpLabel.setForeground(color);
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        if (this.infoWindow != null) {
            this.list.setBackground(color);
            this.infoWindow.getContentPane().setBackground(color);
        }
    }

    public void setHighlightColor(Color color) {
        this.listRenderer.setHighlightBackground(color);
    }

    public void setMaxResultsShown(int max) {
        this.maxResultsShown = max;
    }

    public void setCellSize(int width, int height) {
        this.cellWidth = width;
        this.cellHeight = height;
    }

    protected void init(AutoCompletionServer.CompletionItems results, String commonPrefix, int startPos) {
        this.startPos = startPos;
        if (this.infoWindow == null || !this.infoWindow.isVisible()) {
            this.createInfoWindow();
        }
        this.listRenderer.setCommonPrefix(commonPrefix);
        this.listData.setData(results.items);
    }

    protected void show(int index, boolean scroll) {
        this.show = true;
        if (this.infoWindow == null) {
            return;
        }
        this.setCompletionInfoIndex(index, this.listData.getSize(), this.maxResultsShown, scroll);
        this.updateHelp(index);
        if (!this.infoWindow.isVisible()) {
            this.updateWindowSettings();
            SwingUtilities.invokeLater(() -> this.setWindowPosition(this.startPos));
        }
    }

    protected boolean isShowing() {
        return this.infoWindow != null && this.infoWindow.isVisible();
    }

    private void reposition() {
        if (this.infoWindow != null && this.infoWindow.isVisible()) {
            this.setWindowPosition(this.startPos);
        }
    }

    private void setWindowPosition(int index) {
        Rectangle r;
        this.list.setVisibleRowCount(this.maxResultsShown);
        try {
            r = this.textField.modelToView(index);
        }
        catch (BadLocationException ex) {
            System.out.println("null lol");
            return;
        }
        if (r == null) {
            return;
        }
        Point location = new Point(r.x, r.y);
        this.infoScroll.setVerticalScrollBarPolicy(22);
        this.infoWindow.pack();
        location.x -= 4;
        if (location.x + this.infoWindow.getWidth() > this.textField.getWidth()) {
            location.x = this.textField.getWidth() - this.infoWindow.getWidth();
        } else if (location.x < 8) {
            location.x = 8;
        }
        location.y -= this.infoWindow.getHeight();
        SwingUtilities.convertPointToScreen(location, this.textField);
        this.infoWindow.setLocation(location);
        this.infoWindow.setVisible(true);
    }

    private void reshow() {
        if (this.infoWindow != null && !this.infoWindow.isVisible() && this.show) {
            this.infoWindow.setVisible(true);
        }
    }

    private void hide() {
        if (this.infoWindow != null && this.infoWindow.isVisible()) {
            this.infoWindow.setVisible(false);
        }
    }

    protected void close() {
        this.show = false;
        this.hide();
    }

    public void cleanUp() {
        if (this.containingWindow != null) {
            this.containingWindow.removeComponentListener(this.componentListener);
        }
        this.textField.removeFocusListener(this.focusListener);
        if (this.infoWindow != null) {
            this.infoWindow.dispose();
            this.infoWindow = null;
        }
    }

    protected void updateHelp(int resultIndex) {
        if (LocalDateTime.now().get(ChronoField.MINUTE_OF_HOUR) > 50) {
            this.helpLabel.setText("Shift-click to insert several results");
        } else if (resultIndex == -1) {
            this.helpLabel.setText("Use TAB or mouse to select");
        } else {
            this.helpLabel.setText("Continue typing to close");
        }
    }

    private void setCompletionInfoIndex(int index, int size, int shownCount, boolean scroll) {
        String count = index == -1 ? (shownCount > 0 ? "(" + size + ")" : String.valueOf(size)) : (shownCount > 0 ? String.format("(%d/%d)", index + 1, size) : String.format("%d/%d", index + 1, size));
        this.countLabel.setText(count);
        if (scroll) {
            if (index == -1) {
                this.list.removeSelectionInterval(0, this.listData.getSize());
                this.list.ensureIndexIsVisible(0);
            } else if (shownCount > 0) {
                this.list.setSelectedIndex(index);
                int top = (shownCount - 1) / 2;
                int bottom = (shownCount - 1) / 2 + (shownCount - 1) % 2;
                int from = Math.max(index - top, 0);
                int to = Math.min(index + bottom, size - 1);
                this.list.scrollRectToVisible(this.list.getCellBounds(from, to));
            }
        } else if (index == -1) {
            this.list.removeSelectionInterval(0, this.listData.getSize());
        } else if (shownCount > 0) {
            this.list.setSelectedIndex(index);
        }
    }

    private void updateWindowSettings() {
        this.list.setFixedCellWidth(this.cellWidth);
        this.list.setFixedCellHeight(this.cellHeight);
        this.listRenderer.setCellHeight(this.cellHeight);
        this.listRenderer.setMinIconWidth(this.cellHeight);
    }

    private void createInfoWindow() {
        if (this.infoWindow != null) {
            return;
        }
        this.infoWindow = new JWindow(SwingUtilities.getWindowAncestor(this.textField));
        this.infoWindow.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel contentPane = (JPanel)this.infoWindow.getContentPane();
        contentPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        contentPane.setBackground(this.backgroundColor);
        this.list = new MyList<AutoCompletionServer.CompletionItem>();
        this.list.setFixedCellHeight(this.cellHeight);
        this.list.setModel(this.listData);
        this.list.setCellRenderer(this.listRenderer);
        this.list.setFocusable(false);
        this.list.setBackground(this.backgroundColor);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = AutoCompletionWindow.this.list.locationToIndex(e.getPoint());
                if (index != -1 && AutoCompletionWindow.this.list.getCellBounds(index, index).contains(e.getPoint())) {
                    AutoCompletionWindow.this.clickListener.accept(index, e);
                }
            }
        });
        this.infoScroll = new JScrollPane(this.list);
        this.infoScroll.getVerticalScrollBar().setUnitIncrement(5);
        this.infoScroll.setHorizontalScrollBarPolicy(31);
        this.infoScroll.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        contentPane.add((Component)this.infoScroll, gbc);
        gbc.fill = 2;
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.anchor = 16;
        this.helpLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.infoWindow.getContentPane().add((Component)this.helpLabel, gbc);
        this.countLabel.setHorizontalAlignment(4);
        this.countLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        gbc.gridy = 1;
        gbc.gridx = 1;
        this.infoWindow.getContentPane().add((Component)this.countLabel, gbc);
        this.containingWindow = SwingUtilities.getWindowAncestor(this.textField);
        if (this.containingWindow != null) {
            this.containingWindow.addComponentListener(this.componentListener);
        }
        this.textField.addComponentListener(this.componentListener);
    }

    private static class MyListModel<T>
    extends AbstractListModel<T> {
        private final List<T> data = new ArrayList<T>();

        private MyListModel() {
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public T getElementAt(int index) {
            return this.data.get(index);
        }

        public void clear() {
            int size = this.data.size();
            if (size > 0) {
                this.data.clear();
                this.fireIntervalRemoved(this, 0, size - 1);
            }
        }

        public void setData(Collection<T> data) {
            this.clear();
            this.data.addAll(data);
            this.fireIntervalAdded(this, 0, data.size() - 1);
        }
    }

    private static class MyRenderer
    implements ListCellRenderer {
        private final JPanel panel = new JPanel();
        private final MyIcon icon = new MyIcon();
        private final JLabel text = new JLabel();
        private Color highlightBackground = Color.LIGHT_GRAY;
        private String commonPrefix = "";

        public MyRenderer() {
            this.panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 11;
            this.panel.add((Component)this.icon, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 0, 0);
            gbc.anchor = 17;
            this.panel.add((Component)this.text, gbc);
            this.panel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                this.icon.setIcon(null);
                this.text.setText(null);
                return this.panel;
            }
            AutoCompletionServer.CompletionItem item = (AutoCompletionServer.CompletionItem)value;
            if (!this.commonPrefix.isEmpty()) {
                if (item.hasInfo()) {
                    this.text.setText(String.format("<html><body><u>%s</u>%s&nbsp;<span style='font-size:0.8em;'>(%s)</span>", MyRenderer.enc(this.commonPrefix), MyRenderer.enc(item.getCode().substring(this.commonPrefix.length())), MyRenderer.enc(item.getInfo())));
                } else {
                    this.text.setText(String.format("<html><body><u>%s</u>%s", MyRenderer.enc(this.commonPrefix), MyRenderer.enc(item.getCode().substring(this.commonPrefix.length()))));
                }
            } else if (item.hasInfo()) {
                this.text.setText(String.format("<html><body>%s&nbsp;<span style='font-size:0.8em;'>(%s)</span>", MyRenderer.enc(item.getCode()), MyRenderer.enc(item.getInfo())));
            } else {
                this.text.setText(item.getCode());
            }
            this.panel.getAccessibleContext().setAccessibleName(item.getCode());
            this.panel.getAccessibleContext().setAccessibleDescription(item.getInfo());
            ImageIcon image = item.getImage(list);
            this.icon.setIcon(image);
            if (image != null) {
                image.setImageObserver(list);
            }
            if (isSelected) {
                this.panel.setBackground(this.highlightBackground);
            } else {
                this.panel.setBackground(null);
            }
            return this.panel;
        }

        private static String enc(String input) {
            return Helper.htmlspecialchars_encode(input).replace(" ", "&nbsp;");
        }

        public void setFont(Font font) {
            this.text.setFont(font);
        }

        public void setForeground(Color color) {
            this.text.setForeground(color);
        }

        public void setHighlightBackground(Color color) {
            this.highlightBackground = color;
        }

        public void setCellHeight(int height) {
            this.icon.setCellHeight(height);
        }

        public void setMinIconWidth(int width) {
            this.icon.setMinWidth(width);
        }

        public void setCommonPrefix(String prefix) {
            this.commonPrefix = prefix == null ? "" : prefix;
        }
    }

    private static class MyList<T>
    extends JList<T> {
        private MyList() {
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
            if (!this.isShowing()) {
                return false;
            }
            return super.imageUpdate(img, infoflags, x, y, w, h);
        }
    }

    private static class MyIcon
    extends JPanel {
        private final JLabel label = new JLabel();
        private ImageIcon icon;
        private int cellHeight = 40;
        private int minWidth = 40;

        private MyIcon() {
        }

        public void setIcon(ImageIcon icon) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 10;
            this.setLayout(new GridBagLayout());
            this.icon = icon;
            this.label.setIcon(icon);
            this.setBackground(null);
            this.add((Component)this.label, gbc);
        }

        public void setCellHeight(int height) {
            this.cellHeight = height;
        }

        public void setMinWidth(int width) {
            this.minWidth = width;
        }

        @Override
        public Dimension getMinimumSize() {
            if (this.icon != null && this.icon.getIconWidth() < this.minWidth) {
                return new Dimension(this.minWidth, this.cellHeight);
            }
            return super.getMinimumSize();
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.icon != null && this.icon.getIconWidth() < this.minWidth) {
                return new Dimension(this.minWidth, this.cellHeight);
            }
            return super.getPreferredSize();
        }
    }
}

