/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.eventlog;

import chatty.gui.components.eventlog.Event;
import chatty.gui.components.eventlog.EventLog;
import chatty.lang.Language;
import chatty.util.DateTime;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class EventList
extends JList<Event> {
    private final MyListModel data;
    private final EventLog main;

    public EventList(EventLog main) {
        this.setCellRenderer(new MyCellRenderer(main));
        this.data = new MyListModel();
        this.main = main;
        this.setModel(this.data);
        ComponentAdapter cl = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                EventList.this.fixLayout();
            }
        };
        this.addComponentListener(cl);
        Timer timer = new Timer(30000, e -> this.repaint());
        timer.setRepeats(true);
        timer.start();
    }

    public void fixLayout() {
        this.setFixedCellHeight(10);
        this.setFixedCellHeight(-1);
    }

    public int getNewEvents() {
        int count = 0;
        for (Event event : this.data.items) {
            if (event.id == null || this.main.isReadEvent(event.id)) continue;
            ++count;
        }
        return count;
    }

    public Set<String> getEventIds() {
        HashSet<String> result = new HashSet<String>();
        for (Event event : this.data.items) {
            if (event.id == null) continue;
            result.add(event.id);
        }
        return result;
    }

    public void addEvent(Event event) {
        this.data.add(event);
        if (this.data.getSize() == 1) {
            SwingUtilities.invokeLater(() -> this.fixLayout());
        }
    }

    public void removeEvent(Event event) {
        this.data.remove(event);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    private static class MyCellRenderer
    extends DefaultListCellRenderer {
        private final JTextArea area;
        private final JPanel panel;
        private final JLabel title = new JLabel();
        private final JLabel time = new JLabel();
        private final EventLog main;

        public MyCellRenderer(EventLog main) {
            this.main = main;
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.area = new JTextArea();
            this.area.setLineWrap(true);
            this.area.setWrapStyleWord(true);
            this.area.setOpaque(false);
            this.time.setFont(this.time.getFont().deriveFont(0));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(4, 5, 1, 5);
            gbc.gridwidth = 1;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            this.panel.add((Component)this.title, gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 13;
            this.panel.add((Component)this.time, gbc);
            gbc.insets = new Insets(1, 5, 6, 5);
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 2;
            this.panel.add((Component)this.area, gbc);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color background;
            Color foreground;
            if (value == null) {
                this.title.setText(null);
                this.area.setText(null);
                this.time.setText(null);
                return this.panel;
            }
            Event event = (Event)value;
            if (event.id != null && !this.main.isReadEvent(event.id)) {
                this.title.setText(String.format("(%s) %s", Language.getString("eventLog.new"), event.title));
                this.title.setText("(New) " + event.title);
            } else {
                this.title.setText(event.title);
            }
            this.area.setText(event.text);
            this.time.setText(DateTime.agoSingleCompactAboveMinute(event.createdAt));
            int width = list.getWidth();
            if (width > 0) {
                this.panel.setSize(width, Short.MAX_VALUE);
            }
            if (isSelected) {
                foreground = list.getSelectionForeground();
                background = list.getSelectionBackground();
            } else if (event.foreground != null && event.background != null) {
                foreground = event.foreground;
                background = event.background;
            } else {
                foreground = list.getForeground();
                background = list.getBackground();
            }
            this.time.setForeground(foreground);
            this.title.setForeground(foreground);
            this.area.setForeground(foreground);
            this.panel.setBackground(background);
            return this.panel;
        }
    }

    private static class MyListModel
    extends AbstractListModel<Event> {
        private static final int MAX_ENTRIES = 50;
        private final List<Event> items = new ArrayList<Event>();

        private MyListModel() {
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public Event getElementAt(int index) {
            return this.items.get(index);
        }

        public void add(Event event) {
            if (this.getIndexOf(event) != -1) {
                return;
            }
            this.items.add(0, event);
            super.fireIntervalAdded(this, 0, 0);
            if (this.items.size() > 50) {
                int removeIndex = this.items.size() - 1;
                this.items.remove(removeIndex);
                super.fireIntervalRemoved(this, removeIndex, removeIndex);
            }
        }

        public void remove(Event event) {
            int index = this.getIndexOf(event);
            if (index != -1) {
                this.items.remove(index);
                super.fireIntervalRemoved(this, index, index);
            }
        }

        private int getIndexOf(Event event) {
            for (int i = 0; i < this.items.size(); ++i) {
                Event e = this.items.get(i);
                if (e.id == null || !e.id.equals(event.id)) continue;
                return i;
            }
            return -1;
        }
    }
}

