/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.eventlog;

import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.eventlog.Event;
import chatty.gui.components.eventlog.EventList;
import chatty.lang.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class EventLog
extends JDialog {
    private final MainGui g;
    private final EventList notificationList;
    private final EventList systemList;
    private final JTabbedPane tabs;
    private final JButton systemMarkRead;
    private final Set<String> sessionReadEvents = new HashSet<String>();
    private static EventLog main;

    public EventLog(MainGui g) {
        super(g);
        this.setTitle(Language.getString("eventLog.title"));
        this.g = g;
        this.setDefaultCloseOperation(2);
        this.notificationList = new EventList(this);
        this.systemList = new EventList(this);
        this.setLayout(new BorderLayout());
        JScrollPane scroll1 = new JScrollPane(this.notificationList);
        scroll1.setVerticalScrollBarPolicy(22);
        JScrollPane scroll2 = new JScrollPane(this.systemList);
        scroll2.setVerticalScrollBarPolicy(22);
        this.tabs = new JTabbedPane();
        JPanel systemPanel = new JPanel();
        systemPanel.setLayout(new BorderLayout());
        this.systemMarkRead = new JButton(Language.getString("eventLog.button.markAllAsRead"));
        this.systemMarkRead.setToolTipText(Language.getString("eventLog.button.markAllAsRead.tip"));
        systemPanel.add((Component)this.systemMarkRead, "South");
        systemPanel.add((Component)scroll2, "Center");
        this.tabs.addTab("Chatty Info", systemPanel);
        this.systemMarkRead.addActionListener(e -> {
            if (g.getSettings().getList("readEvents").isEmpty() && this.sessionReadEvents.isEmpty()) {
                JOptionPane.showMessageDialog(this, Language.getString("eventLog.firstMarkReadNote"));
            }
            for (String id : this.systemList.getEventIds()) {
                if (id.startsWith("session.")) {
                    this.sessionReadEvents.add(id);
                    continue;
                }
                g.getSettings().setAdd("readEvents", id);
            }
            this.updateEventState();
        });
        this.add((Component)this.tabs, "Center");
        this.setSize(460, 400);
    }

    @Override
    public void setVisible(boolean visible) {
        this.setLocationRelativeTo(this.g);
        super.setVisible(visible);
        if (visible) {
            this.updateEventState();
            SwingUtilities.invokeLater(() -> {
                this.systemList.fixLayout();
                this.notificationList.fixLayout();
            });
        }
    }

    public void setTab(int tab) {
    }

    protected boolean isReadEvent(String id) {
        return id != null && (this.g.getSettings().listContains("readEvents", id) || this.sessionReadEvents.contains(id));
    }

    private void updateEventState() {
        this.systemList.repaint();
        int count = this.getNewSystemEvents();
        this.g.setSystemEventCount(count);
        this.systemMarkRead.setEnabled(count > 0);
    }

    public int getNewSystemEvents() {
        return this.systemList.getNewEvents();
    }

    public void add(Event event) {
        if (event.type != Event.Type.NOTIFICATION) {
            this.systemList.addEvent(event);
            this.updateEventState();
        }
    }

    public void remove(Event event) {
        if (event.type != Event.Type.NOTIFICATION) {
            this.systemList.removeEvent(event);
            this.updateEventState();
        }
    }

    public static void addSystemEvent(String id, Object ... arguments) {
        String stringId = id;
        if (id.startsWith("session.")) {
            stringId = id.substring("session.".length());
        }
        String title = Language.getString("eventLog.entry." + stringId + ".title");
        String text = Language.getString("eventLog.entry." + stringId + ".text");
        String origText = Language.getBundleForLanguage("en").getString("eventLog.entry." + stringId + ".text");
        if (arguments.length > 0) {
            text = MessageFormat.format(text, arguments);
            origText = MessageFormat.format(origText, arguments);
        }
        if (!origText.equals(text)) {
            text = text + "\n[English Original: " + origText + "]";
        }
        EventLog.addSystemEvent(id, title, text);
    }

    public static void addSystemEvent(String id, String title, String text) {
        GuiUtil.edt(() -> {
            if (main != null) {
                main.add(new Event(Event.Type.SYSTEM, id, title, text, null, null));
            }
        });
    }

    public static void removeSystemEvent(String id) {
        GuiUtil.edt(() -> {
            if (main != null) {
                main.remove(new Event(Event.Type.SYSTEM, id, null, null, null, null));
            }
        });
    }

    public static void setMain(EventLog main) {
        EventLog.main = main;
    }
}

