/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.help;

import chatty.Chatty;
import chatty.gui.UrlOpener;
import chatty.util.UrlRequest;
import chatty.util.WrapHistory;
import chatty.util.api.CachedManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;

public class About
extends JFrame
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(About.class.getName());
    private static final String BASE_HELP_URL = "https://chatty.github.io/help/";
    private static final String DEFAULT_PAGE = "help.html";
    private final JButton historyBackButton;
    private final JButton historyForwardButton;
    private final JTextField currentLocation;
    private final JTextPane textPane = new JTextPane();
    private final JScrollBar scrollbar;
    private String referenceAfterLoad;
    private int scrollPositionAfterLoad;
    private String currentPage = "";
    private final WrapHistory<HistoryItem> history = new WrapHistory(20);
    private String patreonHtml;

    public About() {
        this.setTitle("About/Help - Chatty");
        JScrollPane scroll = new JScrollPane(this.textPane);
        scroll.getVerticalScrollBar().setUnitIncrement(40);
        this.scrollbar = scroll.getVerticalScrollBar();
        this.textPane.setEditable(false);
        this.textPane.setBackground(Color.WHITE);
        ((DefaultCaret)this.textPane.getCaret()).setUpdatePolicy(1);
        this.textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String url = e.getURL().toString();
                    String protocol = e.getURL().getProtocol();
                    if (protocol.equals("http") || protocol.equals("https") || protocol.equals("mailto")) {
                        UrlOpener.openUrlPrompt(About.this, url, true);
                    } else if (protocol.equals("file") || protocol.equals("jar")) {
                        String path = e.getURL().getFile();
                        String file = path.substring(path.lastIndexOf("/") + 1);
                        About.this.open(file, e.getURL().getRef());
                    } else {
                        About.this.jumpTo(e.getURL().getRef());
                    }
                }
            }
        });
        this.textPane.addPropertyChangeListener("page", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                About.this.pageLoaded();
            }
        });
        ActionListener buttonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryItem cameFrom = (HistoryItem)About.this.history.current();
                HistoryItem item = null;
                if (e.getActionCommand().equals("historyBack")) {
                    item = (HistoryItem)About.this.history.backward();
                } else if (e.getActionCommand().equals("historyForward")) {
                    item = (HistoryItem)About.this.history.forward();
                } else if (e.getActionCommand().equals("home")) {
                    About.this.open(null, null);
                } else if (e.getActionCommand().equals("up")) {
                    About.this.open(About.this.currentPage, "");
                } else if (e.getActionCommand().equals("web")) {
                    String url = About.BASE_HELP_URL + About.this.currentLocation.getText();
                    UrlOpener.openUrlPrompt(About.this, url, true);
                }
                if (item != null) {
                    About.this.open(item.page, item.ref, item.scrollPosition, cameFrom);
                }
            }
        };
        JToolBar toolbar = new JToolBar();
        this.historyBackButton = this.makeButton("go-previous.png", "historyBack", "Go back");
        this.historyBackButton.addActionListener(buttonAction);
        this.historyForwardButton = this.makeButton("go-next.png", "historyForward", "Go forward");
        this.historyForwardButton.addActionListener(buttonAction);
        JButton homeButton = this.makeButton("go-home.png", "home", "Main Help Page");
        homeButton.addActionListener(buttonAction);
        JButton upButton = this.makeButton("go-up.png", "up", "Scroll To Top");
        upButton.addActionListener(buttonAction);
        JButton webButton = this.makeButton("go-web.png", "web", "Open in online help");
        webButton.addActionListener(buttonAction);
        this.currentLocation = new JTextField(20);
        this.currentLocation.setEditable(false);
        JPanel currentLocationPanel = new JPanel(new BorderLayout());
        currentLocationPanel.setBorder(BorderFactory.createEmptyBorder(4, 5, 5, 5));
        currentLocationPanel.setOpaque(false);
        currentLocationPanel.add(this.currentLocation);
        toolbar.setFloatable(false);
        toolbar.add(this.historyBackButton);
        toolbar.add(this.historyForwardButton);
        toolbar.add(homeButton);
        toolbar.add(upButton);
        toolbar.addSeparator();
        toolbar.add(currentLocationPanel);
        toolbar.add(webButton);
        toolbar.setMargin(new Insets(5, 3, 2, 3));
        this.add((Component)toolbar, "First");
        this.updateHistoryButtons();
        this.add(scroll);
        scroll.setPreferredSize(new Dimension(680, 500));
        this.open(null, null);
        JButton button = new JButton("Close");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                About.this.setVisible(false);
            }
        });
        this.add((Component)button, "South");
        this.pack();
        CachedManager m = new CachedManager(Chatty.getPathCreate(Chatty.PathType.CACHE).resolve("patreon").toString(), 259200L, "Patreon"){

            @Override
            public boolean handleData(String data) {
                if (data != null) {
                    About.this.patreonHtml = data;
                    return true;
                }
                return false;
            }
        };
        if (!m.load()) {
            UrlRequest request = new UrlRequest("https://tduva.com/res/patrons");
            request.async((result, responseCode) -> {
                if (responseCode == 200 && result != null) {
                    m.dataReceived(result, false);
                }
            });
        }
    }

    private JButton makeButton(String image, String action, String tooltip) {
        JButton button = new JButton();
        button.setActionCommand(action);
        button.setIcon(new ImageIcon(About.class.getResource(image)));
        button.setToolTipText(tooltip);
        return button;
    }

    private void loadPage(String page) {
        try {
            this.textPane.setPage(this.getClass().getResource(page));
            this.currentPage = page;
        }
        catch (IOException ex) {
            LOGGER.warning("Invalid page: " + page + " (" + ex.getLocalizedMessage() + ")");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public final void open(String page, String ref) {
        this.open(page, ref, -1, null);
    }

    private void open(String page, String ref, int scrollPosition, HistoryItem cameFrom) {
        if (ref == null) {
            ref = "";
        }
        ref = ref.replace(" ", "_");
        if (page == null) {
            page = DEFAULT_PAGE;
        }
        if (cameFrom != null) {
            cameFrom.setScrollPosition(this.scrollbar.getValue());
        } else if (this.history.current() != null) {
            this.history.current().setScrollPosition(this.scrollbar.getValue());
        }
        if (this.currentPage != null && this.currentPage.equals(page)) {
            this.jumpTo(ref);
            if (scrollPosition != -1) {
                this.scrollbar.setValue(scrollPosition);
            }
        } else {
            this.referenceAfterLoad = ref;
            this.scrollPositionAfterLoad = scrollPosition;
        }
        this.loadPage(page);
        HistoryItem location = new HistoryItem(page, ref);
        this.history.addIfNew(location);
        this.updateHistoryButtons();
        this.currentLocation.setText(location.toString());
    }

    private void updateHistoryButtons() {
        this.historyForwardButton.setEnabled(this.history.hasNext());
        this.historyBackButton.setEnabled(this.history.hasPrevious());
    }

    private void jumpTo(String ref) {
        if (ref.isEmpty()) {
            this.textPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        } else {
            this.textPane.scrollToReference(ref);
        }
    }

    private void pageLoaded() {
        HTMLDocument doc = (HTMLDocument)this.textPane.getDocument();
        Element patreonElement = doc.getElement("patreon");
        if (patreonElement != null) {
            try {
                doc.setInnerHTML(patreonElement, this.patreonHtml);
            }
            catch (Exception ex) {
                LOGGER.warning("Error changing HTML: " + ex);
            }
        }
        if (this.scrollPositionAfterLoad != -1) {
            this.scrollbar.setValue(this.scrollPositionAfterLoad);
            this.scrollPositionAfterLoad = -1;
        } else if (this.referenceAfterLoad != null) {
            this.jumpTo(this.referenceAfterLoad);
            this.referenceAfterLoad = null;
        }
    }

    private void reload() {
        Document doc = this.textPane.getDocument();
        doc.putProperty("stream", null);
        this.scrollPositionAfterLoad = this.scrollbar.getValue();
        this.loadPage(this.currentPage);
    }

    private static class HistoryItem {
        private final String page;
        private final String ref;
        private int scrollPosition = -1;

        HistoryItem(String page, String ref) {
            this.page = page;
            this.ref = ref;
        }

        public void setScrollPosition(int position) {
            this.scrollPosition = position;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof HistoryItem) {
                HistoryItem obj2 = (HistoryItem)obj;
                return this.page.equals(obj2.page) && this.ref.equals(obj2.ref);
            }
            return false;
        }

        public String toString() {
            if (this.ref.isEmpty()) {
                return this.page;
            }
            return this.page + "#" + this.ref;
        }
    }
}

