/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.Helper;
import chatty.gui.components.Channel;
import chatty.gui.components.menus.CommandMenuItems;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuHelper;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.lang.Language;
import chatty.util.commands.Parameters;
import java.awt.event.ActionEvent;

public class ChannelContextMenu
extends ContextMenu {
    private static final String MISC_MENU = Language.getString("channelCm.menu.misc");
    private final ContextMenuListener listener;
    private final Channel channel;

    public ChannelContextMenu(ContextMenuListener listener, Channel channel) {
        this.listener = listener;
        this.channel = channel;
        Parameters parameters = Helper.createRoomParameters(channel.getRoom());
        this.addItem("channelInfo", Language.getString("menubar.dialog.channelInfo"));
        this.addItem("channelAdmin", Language.getString("menubar.dialog.channelAdmin"));
        this.addSeparator();
        ContextMenuHelper.addStreamsOptions(this, 1, false, parameters);
        this.addSeparator();
        this.addItem("raidchannel", Language.getString("channelCm.raidChannel"), MISC_MENU);
        this.addSeparator(MISC_MENU);
        this.addItem("copy", Language.getString("channelCm.copyStreamname"), MISC_MENU);
        this.addSeparator(MISC_MENU);
        this.addItem("srcOpen", Language.getString("channelCm.speedruncom"), MISC_MENU);
        this.addSeparator();
        this.addItem("closeChannel", Language.getString("channelCm.closeChannel"));
        CommandMenuItems.addCommands(CommandMenuItems.MenuType.CHANNEL, this, parameters);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener != null) {
            this.listener.channelMenuItemClicked(e, this.channel);
        }
    }
}

