/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.gui.components.settings.CommandSettings;
import chatty.util.StringUtil;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class CommandMenuItem {
    private static final Logger LOGGER = Logger.getLogger(CommandMenuItem.class.getName());
    private static final AtomicLong NEXT_ID = new AtomicLong();
    private final String id = "command" + NEXT_ID.getAndIncrement();
    private final String label;
    private final CustomCommand labelCommand;
    private final CustomCommand command;
    private final String parent;
    private final int pos;
    private final String key;
    private final List<CustomCommand> restrictionCommands;
    private final int lineNumber;

    public CommandMenuItem(String label, CustomCommand command, String parent, int pos, String key, Collection<CustomCommand> restrictionCommands, int lineNumber) {
        this.label = label;
        this.labelCommand = label != null ? CustomCommand.parse(label) : null;
        this.command = command;
        this.parent = parent;
        this.pos = pos;
        this.key = key;
        this.restrictionCommands = restrictionCommands != null ? new ArrayList<CustomCommand>(restrictionCommands) : new ArrayList();
        this.lineNumber = lineNumber;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabel(Parameters parameters) {
        if (!this.checkRestrictions(parameters)) {
            return "";
        }
        if (parameters != null && this.labelCommand != null && parameters.hasKey("menuCommandLabels")) {
            return this.getLabelCommandResult(this.labelCommand, parameters);
        }
        return this.label;
    }

    public boolean checkRestrictions(Parameters parameters) {
        if (parameters != null && !parameters.hasKey("menu-test") && parameters.hasKey("menuRestrictions") && this.restrictionCommands != null) {
            for (CustomCommand cc : this.restrictionCommands) {
                String result = this.getLabelCommandResult(cc, parameters);
                if (!StringUtil.isNullOrEmpty(result)) continue;
                return false;
            }
        }
        return true;
    }

    private String getLabelCommandResult(CustomCommand cc, Parameters parameters) {
        if (cc.hasError()) {
            LOGGER.info("Parse error: " + cc.getSingleLineError());
            return "Parse error (see debug log)";
        }
        return cc.replace(parameters);
    }

    public boolean hasValidLabelCommand() {
        return this.labelCommand != null && !this.labelCommand.hasError();
    }

    public CustomCommand getLabelCommand() {
        return this.labelCommand;
    }

    public boolean hasRestrictionCommands() {
        return this.restrictionCommands != null && !this.restrictionCommands.isEmpty();
    }

    public List<CustomCommand> getRestrictionCommands() {
        return this.restrictionCommands;
    }

    public CustomCommand getCommand() {
        return this.command;
    }

    public String getParent() {
        return this.parent;
    }

    public int getPos() {
        return this.pos;
    }

    public String getKey() {
        return this.key;
    }

    public boolean hasKey() {
        return this.key != null && !this.key.isEmpty();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getTooltipHtml() {
        if (this.getCommand() == null) {
            if (this.hasRestrictionCommands()) {
                return String.format("<html><body>Restrictions:<br /><code>%s</code>", CommandSettings.formatCommandInfo(StringUtil.join(this.getRestrictionCommands(), "\n")));
            }
            return "";
        }
        if (this.hasRestrictionCommands()) {
            return String.format("<html><body><code>%s</code><br /><br />Restrictions:<br /><code>%s</code><br />", CommandSettings.formatCommandInfo(StringUtil.shortenTo(this.getCommand().getRaw(), 100)), CommandSettings.formatCommandInfo(StringUtil.join(this.getRestrictionCommands(), "\n")));
        }
        return String.format("<html><body><code>%s</code>", CommandSettings.formatCommandInfo(StringUtil.shortenTo(this.getCommand().getRaw(), 100)));
    }

    public String toString() {
        return "[" + this.parent + "," + this.pos + "," + this.key + "," + this.restrictionCommands + "," + this.lineNumber + "] " + this.label + "=" + this.command;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandMenuItem other = (CommandMenuItem)obj;
        if (this.pos != other.pos) {
            return false;
        }
        if (this.lineNumber != other.lineNumber) {
            return false;
        }
        if (!Objects.equals(this.label, other.label)) {
            return false;
        }
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (!Objects.equals(this.key, other.key)) {
            return false;
        }
        if (!Objects.equals(this.command, other.command)) {
            return false;
        }
        return Objects.equals(this.restrictionCommands, other.restrictionCommands);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.label);
        hash = 71 * hash + Objects.hashCode(this.command);
        hash = 71 * hash + Objects.hashCode(this.parent);
        hash = 71 * hash + this.pos;
        hash = 71 * hash + Objects.hashCode(this.key);
        hash = 71 * hash + Objects.hashCode(this.restrictionCommands);
        hash = 71 * hash + this.lineNumber;
        return hash;
    }
}

