/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.Helper;
import chatty.gui.components.menus.CommandMenuItem;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuHelper;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.CustomCommands;
import chatty.util.commands.Parameters;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandMenuItems {
    private static final Logger LOGGER = Logger.getLogger(CommandMenuItems.class.getName());
    private static final Map<MenuType, List<CommandMenuItem>> commands = new HashMap<MenuType, List<CommandMenuItem>>();
    public static CustomCommands customCommands;
    private static final Pattern RESTRICTION_PATTERN;
    private static final String POS_KEY_PATTERN = "(?:\\{(\\d+)\\})?(?:\\[([^]]*)\\])?";
    private static final Pattern SUBMENU_PATTERN;
    private static final Pattern SEPARTOR_PATTERN;
    private static final Pattern PATTERN;
    public static final String CUSTOM_COMMANDS_SUBMENU = "More..";
    private static final Pattern PATTERN_COMPACT;

    public static void setCommands(MenuType type, String data) {
        List<CommandMenuItem> parsed = CommandMenuItems.parse(data);
        commands.put(type, parsed);
    }

    public static void addCommands(MenuType type, ContextMenu menu, Parameters baseParameters) {
        List<CommandMenuItem> c = commands.get((Object)type);
        if (c != null) {
            for (CommandMenuItem item : c) {
                menu.addCommandItem(item, CommandMenuItems.getMenuParameters(item, baseParameters));
            }
        }
        menu.removeEmpty();
    }

    public static Parameters getMenuParameters(CommandMenuItem item, Parameters baseParameters) {
        Parameters parameters = null;
        if (ContextMenuHelper.settings != null && (ContextMenuHelper.settings.getBoolean("menuCommandLabels") || ContextMenuHelper.settings.getBoolean("menuRestrictions"))) {
            parameters = baseParameters != null ? baseParameters.copy() : Parameters.create("");
            parameters.putObject("settings", ContextMenuHelper.settings);
            if (ContextMenuHelper.settings.getBoolean("menuCommandLabels")) {
                parameters.put("menuCommandLabels", "1");
            }
            if (ContextMenuHelper.settings.getBoolean("menuRestrictions")) {
                parameters.put("menuRestrictions", "1");
            }
            if (item.hasValidLabelCommand() && customCommands != null) {
                customCommands.addCustomIdentifierParametersForCommand(item.getLabelCommand(), parameters);
            }
            if (item.hasRestrictionCommands() && customCommands != null) {
                for (CustomCommand cc : item.getRestrictionCommands()) {
                    if (cc.hasError()) continue;
                    customCommands.addCustomIdentifierParametersForCommand(cc, parameters);
                }
            }
        }
        return parameters;
    }

    public static List<CommandMenuItem> parse(String input) {
        LinkedList<CommandMenuItem> result = new LinkedList<CommandMenuItem>();
        if (input == null || input.isEmpty()) {
            return result;
        }
        String[] lines = input.split("\n");
        String submenuName = null;
        HashMap<String, CustomCommand> currentRestrictions = new HashMap<String, CustomCommand>();
        int lineNumber = 1;
        for (String line : lines) {
            if (!CommandMenuItems.parseRestriction(line, currentRestrictions)) {
                CommandMenuItem submenu = CommandMenuItems.parseSubmenu(line, lineNumber, currentRestrictions.values());
                if (submenu != null) {
                    submenuName = submenu.getLabel();
                    result.add(submenu);
                    currentRestrictions.remove(null);
                } else {
                    CommandMenuItem separator = CommandMenuItems.parseSeparator(line, lineNumber, submenuName, currentRestrictions.values());
                    if (separator != null) {
                        result.add(separator);
                        currentRestrictions.remove(null);
                    } else {
                        CommandMenuItem item = CommandMenuItems.parseCommand(line, lineNumber, submenuName, currentRestrictions.values());
                        if (item != null) {
                            result.add(item);
                            currentRestrictions.remove(null);
                        } else {
                            result.addAll(CommandMenuItems.addCustomCommands(line, lineNumber, submenuName, currentRestrictions.values()));
                            currentRestrictions.remove(null);
                        }
                    }
                }
            }
            ++lineNumber;
        }
        return result;
    }

    private static boolean parseRestriction(String line, Map<String, CustomCommand> currentRestrictions) {
        Matcher m = RESTRICTION_PATTERN.matcher(line = line.trim());
        if (m.matches()) {
            String restriction = m.group("restriction");
            String id = m.group("id");
            String idEnd = m.group("idEnd");
            if (restriction != null) {
                currentRestrictions.put(id, CustomCommand.parse(restriction));
            } else {
                currentRestrictions.remove(idEnd);
            }
            return true;
        }
        return false;
    }

    private static CommandMenuItem parseSubmenu(String line, int lineNumber, Collection<CustomCommand> restrictions) {
        Matcher m = SUBMENU_PATTERN.matcher(line = line.trim());
        if (m.matches()) {
            String name = m.group(1).trim();
            int pos = m.group(2) == null ? -1 : Integer.parseInt(m.group(2));
            String key = m.group(3);
            return new CommandMenuItem(name, null, null, pos, key, restrictions, lineNumber);
        }
        return null;
    }

    private static CommandMenuItem parseSeparator(String line, int lineNumber, String currentSubmenu, Collection<CustomCommand> restrictions) {
        Matcher m = SEPARTOR_PATTERN.matcher(line = line.trim());
        if (m.matches()) {
            String submenu = m.group(1) != null ? currentSubmenu : null;
            int pos = m.group(2) == null ? -1 : Integer.parseInt(m.group(2));
            return new CommandMenuItem(null, null, submenu, pos, null, restrictions, lineNumber);
        }
        return null;
    }

    public static void main(String[] args) {
        List<CommandMenuItem> items = CommandMenuItems.parse("/slap\n[Joshimuz]\n FAQ=FAQ: http://blahblah\nMessage=/openUrl http://twitch.tv/inbox/compose?target=$$1");
        for (CommandMenuItem item : items) {
            System.out.println(item);
        }
        System.out.println(true);
    }

    private static CommandMenuItem parseCommand(String line, int lineNumber, String currentSubmenu, Collection<CustomCommand> restrictions) {
        Matcher m = PATTERN.matcher(line);
        if (!m.matches()) {
            return null;
        }
        String label = m.group(1).trim();
        int pos = m.group(2) == null ? -1 : Integer.parseInt(m.group(2));
        String key = m.group(3);
        String command = m.group(4).trim();
        if (!label.startsWith(".")) {
            currentSubmenu = null;
        } else {
            label = label.substring(1).trim();
        }
        return CommandMenuItems.makeItem(label, command, currentSubmenu, pos, key, restrictions, lineNumber);
    }

    public static List<CommandMenuItem> addCustomCommands(String line, int lineNumber, String parent, Collection<CustomCommand> restrictions) {
        LinkedList<CommandMenuItem> result = new LinkedList<CommandMenuItem>();
        if (!line.startsWith(".")) {
            parent = null;
        } else {
            line = line.substring(1);
        }
        Matcher matcher = PATTERN_COMPACT.matcher(line);
        boolean sep = false;
        while (matcher.find()) {
            CommandMenuItem item;
            String match = matcher.group();
            if (match.equals("|")) {
                sep = true;
                continue;
            }
            String submenu = parent;
            int pos = matcher.group(5) == null ? -1 : Integer.parseInt(matcher.group(5));
            String key = matcher.group(6);
            if (match.startsWith("//")) {
                submenu = CUSTOM_COMMANDS_SUBMENU;
            }
            if (matcher.group(2) != null) {
                String number = matcher.group(2);
                String factor = matcher.group(3);
                item = CommandMenuItems.createTimeoutItem(number, factor, submenu, pos, key, restrictions, lineNumber);
            } else {
                String command = matcher.group(4);
                item = CommandMenuItems.createItem(command, submenu, pos, key, restrictions, lineNumber);
            }
            if (sep) {
                result.add(CommandMenuItems.makeItem(null, null, submenu, -1, null, restrictions, lineNumber));
                sep = false;
            }
            result.add(item);
        }
        return result;
    }

    private static CommandMenuItem createItem(String command, String subMenu, int pos, String key, Collection<CustomCommand> restrictions, int lineNumber) {
        String label = Helper.replaceUnderscoreWithSpace(command);
        return CommandMenuItems.makeItem(label, "/" + command + " $1-", subMenu, pos, key, restrictions, lineNumber);
    }

    private static CommandMenuItem createTimeoutItem(String number, String factor, String subMenu, int pos, String key, Collection<CustomCommand> restrictions, int lineNumber) {
        String label;
        int time = Integer.parseInt(number);
        if (!factor.isEmpty()) {
            time *= CommandMenuItems.getFactor(factor);
            label = number + factor;
        } else {
            label = CommandMenuItems.timeFormat(time);
        }
        String command = "/timeout $1 " + time + " $2-";
        return CommandMenuItems.makeItem(label, command, subMenu, pos, key, restrictions, lineNumber);
    }

    private static int getFactor(String factorString) {
        switch (factorString) {
            case "s": {
                return 1;
            }
            case "m": {
                return 60;
            }
            case "h": {
                return 3600;
            }
            case "d": {
                return 86400;
            }
        }
        return 1;
    }

    private static String timeFormat(int seconds) {
        if (seconds < 60) {
            return seconds + "s";
        }
        if (seconds < 3600) {
            int minutes = seconds / 60;
            return String.format("%dm", minutes);
        }
        if (seconds < 172801) {
            return String.format("%dh", seconds / 3600);
        }
        return String.format("%dd", seconds / 86400);
    }

    private static CommandMenuItem makeItem(String label, String command, String submenu, int pos, String key, Collection<CustomCommand> restrictions, int lineNumber) {
        if (command == null) {
            return new CommandMenuItem(null, null, submenu, pos, key, restrictions, lineNumber);
        }
        CustomCommand parsedCommand = CustomCommand.parse(command.trim());
        return new CommandMenuItem(label, parsedCommand, submenu, pos, key, restrictions, lineNumber);
    }

    static {
        RESTRICTION_PATTERN = Pattern.compile("\\[(?<id>\\S+)? (?<restriction>.+) \\]|\\[/(?<idEnd>\\S+)\\]");
        SUBMENU_PATTERN = Pattern.compile("@([^\\[{]+)(?:\\{(\\d+)\\})?(?:\\[([^]]*)\\])?");
        SEPARTOR_PATTERN = Pattern.compile("(\\.)?-(?:\\{(\\d+)\\})?(?:\\[([^]]*)\\])?");
        PATTERN = Pattern.compile("([^\\[{=]+)(?:\\{(\\d+)\\})?(?:\\[([^]]*)\\])?=(.+)");
        PATTERN_COMPACT = Pattern.compile("(\\|)|(?:(?:([0-9]+)([smhd]?)|/?/?([^\\[{,\\s]+))(?:\\{(\\d+)\\})?(?:\\[([^,\\s]+)\\])?)");
    }

    public static enum MenuType {
        USER,
        CHANNEL,
        STREAMS,
        TEXT,
        ADMIN;

    }
}

