/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.gui.components.menus.CommandActionEvent;
import chatty.gui.components.menus.CommandMenuItem;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public abstract class ContextMenu
extends JPopupMenu
implements ActionListener {
    private final ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ContextMenu.this.actionPerformed(ContextMenu.this.getCommandActionEvent(e));
        }
    };
    private final Map<String, JMenu> subMenus = new HashMap<String, JMenu>();
    private final Set<ContextMenuListener> listeners = new HashSet<ContextMenuListener>();
    private final Map<String, CustomCommand> commands = new HashMap<String, CustomCommand>();
    private final Map<String, ButtonGroup> buttonGroups = new HashMap<String, ButtonGroup>();
    private final Map<String, JMenuItem> items = new HashMap<String, JMenuItem>();

    private JMenuItem makeItem(String action, String text, ImageIcon icon) {
        JMenuItem item = new JMenuItem(text);
        item.setActionCommand(action);
        item.addActionListener(this.listener);
        if (icon != null) {
            item.setIcon(icon);
        }
        return item;
    }

    private JMenuItem makeCheckboxItem(String action, String text, boolean selected) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(text, selected);
        item.setActionCommand(action);
        item.addActionListener(this.listener);
        return item;
    }

    private JMenuItem makeRadioItem(String action, String text, String group) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(text);
        item.setActionCommand(action);
        item.addActionListener(this.listener);
        if (!this.buttonGroups.containsKey(group)) {
            this.buttonGroups.put(group, new ButtonGroup());
        }
        this.buttonGroups.get(group).add(item);
        return item;
    }

    protected JMenuItem addItem(String action, String text, int pos, String parent, ImageIcon icon) {
        if (parent != null) {
            JMenuItem item = this.makeItem(action, text, icon);
            if (pos > -1) {
                this.getSubmenu(parent).insert(item, pos);
            } else {
                this.getSubmenu(parent).add(item);
            }
            this.items.put(action, item);
            return item;
        }
        JMenuItem item = this.makeItem(action, text, icon);
        if (pos > -1) {
            this.insert(item, pos);
        } else {
            this.add(item);
        }
        this.items.put(action, item);
        return item;
    }

    public JMenuItem addItem(String action, String text) {
        return this.addItem(action, text, -1, null, null);
    }

    public JMenuItem addItem(String action, String text, ImageIcon icon) {
        return this.addItem(action, text, -1, null, icon);
    }

    public JMenuItem addItem(String action, String text, String parent) {
        return this.addItem(action, text, -1, parent, null);
    }

    public JMenuItem addItem(String action, String text, String parent, ImageIcon icon) {
        return this.addItem(action, text, -1, parent, icon);
    }

    public JMenuItem addCommandItem(CommandMenuItem item, Parameters parameters) {
        if (item.getCommand() == null && item.getLabel() == null) {
            if (item.checkRestrictions(parameters)) {
                this.addSeparator(item.getPos(), item.getParent());
            } else {
                this.addItem("dummy" + item.getId(), "", item.getPos(), item.getParent(), null);
            }
        } else {
            if (item.getCommand() == null) {
                JMenu menu = this.getSubmenu(item.getLabel(), item.getLabel(parameters), item.getPos());
                menu.setToolTipText(item.getTooltipHtml());
                this.addKey(item, menu);
                return menu;
            }
            this.commands.put(item.getId(), item.getCommand());
            JMenuItem mItem = this.addItem(item.getId(), item.getLabel(parameters), item.getPos(), item.getParent(), null);
            mItem.setToolTipText(item.getTooltipHtml());
            this.addKey(item, mItem);
            return mItem;
        }
        return null;
    }

    private void addKey(CommandMenuItem item, JMenuItem mItem) {
        if (item.hasKey()) {
            mItem.setMnemonic(KeyEvent.getExtendedKeyCodeForChar(item.getKey().toLowerCase().charAt(0)));
        }
    }

    private ActionEvent getCommandActionEvent(ActionEvent e) {
        CustomCommand command = this.commands.get(e.getActionCommand());
        if (command != null) {
            return new CommandActionEvent(e, command);
        }
        return e;
    }

    public void addCheckboxItem(String action, String text, boolean selected) {
        this.items.put(action, this.add(this.makeCheckboxItem(action, text, selected)));
    }

    public void addCheckboxItem(String action, String text, String parent, boolean selected) {
        if (parent != null) {
            JMenuItem item = this.makeCheckboxItem(action, text, selected);
            this.getSubmenu(parent).add(item);
            this.items.put(action, item);
        } else {
            this.addCheckboxItem(action, text, selected);
        }
    }

    public void addRadioItem(String action, String text, String group) {
        this.items.put(action, this.add(this.makeRadioItem(action, text, group)));
    }

    public void addRadioItem(String action, String text, String group, String parent) {
        if (parent != null) {
            JMenuItem item = this.makeRadioItem(action, text, group);
            this.getSubmenu(parent).add(item);
            this.items.put(action, item);
        } else {
            this.addRadioItem(action, text, group);
        }
    }

    protected void addSeparator(int pos, String parent) {
        if (parent != null && this.isSubmenu(parent)) {
            if (pos > -1) {
                this.getSubmenu(parent).insertSeparator(pos);
            } else {
                this.getSubmenu(parent).addSeparator();
            }
        } else if (pos > -1) {
            this.insert(new JPopupMenu.Separator(), pos);
        } else {
            this.addSeparator();
        }
    }

    public void addSeparator(String parent) {
        this.addSeparator(-1, parent);
    }

    public void addContextMenuListener(ContextMenuListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    protected Set<ContextMenuListener> getContextMenuListeners() {
        return this.listeners;
    }

    private boolean isSubmenu(String name) {
        return this.subMenus.containsKey(name);
    }

    public void registerSubmenu(JMenu menu) {
        this.subMenus.put(menu.getText(), menu);
    }

    private JMenu getSubmenu(String name, int pos) {
        return this.getSubmenu(name, name, pos);
    }

    private JMenu getSubmenu(String key, String name, int pos) {
        if (this.subMenus.get(key) == null) {
            JMenu menu = new JMenu(name);
            if (pos > -1) {
                this.insert(menu, pos);
            } else {
                this.add(menu);
            }
            this.subMenus.put(key, menu);
        }
        return this.subMenus.get(key);
    }

    private JMenu getSubmenu(String name) {
        return this.getSubmenu(name, -1);
    }

    protected void setSubMenuIcon(String name, ImageIcon icon) {
        this.getSubmenu(name, -1).setIcon(icon);
    }

    public JMenuItem getItem(String action) {
        return this.items.get(action);
    }

    public void removeEmpty() {
        for (JMenuItem item : this.items.values()) {
            if (!item.getText().isEmpty()) continue;
            this.remove(item);
            for (JMenu menu : this.subMenus.values()) {
                menu.remove(item);
            }
        }
        for (JMenu menu : this.subMenus.values()) {
            if (!menu.getText().isEmpty()) continue;
            this.remove(menu);
        }
    }
}

