/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.menus;

import chatty.gui.components.help.About;
import chatty.gui.components.menus.CommandMenuItems;
import chatty.gui.components.menus.ContextMenu;
import chatty.lang.Language;
import chatty.util.commands.Parameters;
import chatty.util.settings.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;

public class ContextMenuHelper {
    protected static final ImageIcon ICON_SPACING = new ImageIcon(ContextMenuHelper.class.getResource("transparent-10x1.png"));
    protected static final ImageIcon ICON_WEB = new ImageIcon(About.class.getResource("go-web.png"));
    protected static final ImageIcon ICON_IMAGE = new ImageIcon(ContextMenuHelper.class.getResource("image-icon.png"));
    protected static final ImageIcon ICON_COMMANDLINE = new ImageIcon(ContextMenuHelper.class.getResource("commandline.png"));
    protected static final ImageIcon ICON_COPY = new ImageIcon(ContextMenuHelper.class.getResource("edit-copy.png"));
    public static boolean enableLivestreamer = true;
    public static String livestreamerQualities = "";
    public static Settings settings;
    private static final Pattern LIVESTREAMER_PATTERN;

    protected static void addStreamsOptions(ContextMenu m, int numStreams, Parameters parameters) {
        ContextMenuHelper.addStreamsOptions(m, numStreams, true, parameters);
    }

    protected static void addStreamsOptions(ContextMenu m, int numStreams, boolean join, Parameters parameters) {
        String streamSubmenu = "Twitch Stream";
        String miscSubmenu = Language.getString("channelCm.menu.misc");
        m.setSubMenuIcon(streamSubmenu, ICON_SPACING);
        m.addItem("stream", "Normal", streamSubmenu);
        m.addItem("streamPopout", "Popout", streamSubmenu);
        m.addItem("streamChat", "Chat", streamSubmenu);
        m.addSeparator(streamSubmenu);
        m.addItem("streamsMultitwitchtv", "Multitwitch.tv", streamSubmenu);
        m.addItem("streamsSpeedruntv", "Speedrun.tv", streamSubmenu);
        m.addItem("streamsKadgar", "Kadgar.net", streamSubmenu);
        ContextMenuHelper.addLivestreamerOptions(m);
        if (join) {
            m.addSeparator();
            m.addItem("join", Language.getString("channelCm.join", numStreams));
            m.addSeparator();
            m.addItem("raidchannel", Language.getString("channelCm.raidChannel"), miscSubmenu);
            m.addSeparator(miscSubmenu);
            m.addItem("copy", Language.getString("channelCm.copyStreamname"), miscSubmenu);
            m.addSeparator(miscSubmenu);
            m.addItem("favoriteChannel", Language.getString("channelCm.favorite"), miscSubmenu);
            m.addItem("unfavoriteChannel", Language.getString("channelCm.unfavorite"), miscSubmenu);
        }
        CommandMenuItems.addCommands(CommandMenuItems.MenuType.STREAMS, m, parameters);
    }

    public static void addLivestreamerOptions(ContextMenu m) {
        if (enableLivestreamer) {
            String livestreamerMenu = "Streamlink";
            m.setSubMenuIcon(livestreamerMenu, ICON_COMMANDLINE);
            List<Quality> qualities = ContextMenuHelper.parseLivestreamerQualities(livestreamerQualities);
            for (Quality q : qualities) {
                if (q == null) {
                    m.addSeparator(livestreamerMenu);
                    continue;
                }
                m.addItem("livestreamerQ" + q.qualities, q.displayName, livestreamerMenu);
            }
        }
    }

    static List<Quality> parseLivestreamerQualities(String input) {
        ArrayList<Quality> result = new ArrayList<Quality>();
        Matcher matcher = LIVESTREAMER_PATTERN.matcher(input);
        boolean sep = false;
        while (matcher.find()) {
            if (matcher.group().equals("|")) {
                sep = true;
                continue;
            }
            if (sep) {
                result.add(null);
            }
            String match = matcher.group("qualities") != null ? matcher.group("qualities") : matcher.group();
            String displayName = matcher.group("name") != null ? matcher.group("name").replace(":", "") : match;
            result.add(new Quality(displayName, match));
            sep = false;
        }
        return result;
    }

    public static void addIgnore(ContextMenu m, String name, String submenu, boolean whisper) {
        if (settings != null) {
            String item;
            String setting = whisper ? "ignoredUsersWhisper" : "ignoredUsers";
            String label = whisper ? "(whisper)" : "(chat)";
            String string = item = whisper ? "Whisper" : "";
            if (settings.listContains(setting, name)) {
                m.addItem("unignore" + item, "Unignore " + label, submenu);
            } else {
                m.addItem("ignore" + item, "Ignore " + label, submenu);
            }
        }
    }

    public static void addNumericOptions(ContextMenu menu, String submenu, String actionPrefix, long currentValue, Map<Long, String> options) {
        if (!options.containsKey(currentValue)) {
            String action = actionPrefix + currentValue;
            menu.addRadioItem(action, String.valueOf(currentValue), submenu, submenu);
            menu.getItem(action).setSelected(true);
        }
        for (Map.Entry<Long, String> entry : options.entrySet()) {
            String action = actionPrefix + entry.getKey();
            menu.addRadioItem(action, entry.getValue(), submenu, submenu);
            if (entry.getKey() != currentValue) continue;
            menu.getItem(action).setSelected(true);
        }
    }

    public static void handleNumericOption(String receivedAction, String actionPrefix, Consumer<Long> handler) {
        if (receivedAction.startsWith(actionPrefix)) {
            long value = Long.parseLong(receivedAction.substring(actionPrefix.length()));
            handler.accept(value);
        }
    }

    static {
        LIVESTREAMER_PATTERN = Pattern.compile("(\\|)|(?:\\{(?<name>[^:}]+:)?(?<qualities>.+?)\\})|(?<basic>[^,\\s]+)");
    }

    static class Quality {
        String displayName;
        String qualities;

        Quality(String displayName, String qualities) {
            this.displayName = displayName;
            this.qualities = qualities;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Quality other = (Quality)obj;
            if (!Objects.equals(this.displayName, other.displayName)) {
                return false;
            }
            return Objects.equals(this.qualities, other.qualities);
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + Objects.hashCode(this.displayName);
            hash = 83 * hash + Objects.hashCode(this.qualities);
            return hash;
        }
    }
}

